# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

import uuid
from msrest.pipeline import ClientRawResponse

from .. import models


class JobOperations(object):
    """JobOperations operations.

    You should not instantiate directly this class, but create a Client instance that will create it for you and attach it as attribute.

    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    :ivar api_version: Client API Version. Constant value: "2019-08-01.10.0".
    """

    models = models

    def __init__(self, client, config, serializer, deserializer):

        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self.api_version = "2019-08-01.10.0"

        self.config = config

    def get_all_lifetime_statistics(
            self, job_get_all_lifetime_statistics_options=None, custom_headers=None, raw=False, **operation_config):
        """Gets lifetime summary statistics for all of the Jobs in the specified
        Account.

        Statistics are aggregated across all Jobs that have ever existed in the
        Account, from Account creation to the last update time of the
        statistics. The statistics may not be immediately available. The Batch
        service performs periodic roll-up of statistics. The typical delay is
        about 30 minutes.

        :param job_get_all_lifetime_statistics_options: Additional parameters
         for the operation
        :type job_get_all_lifetime_statistics_options:
         ~azure.batch.models.JobGetAllLifetimeStatisticsOptions
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: JobStatistics or ClientRawResponse if raw=true
        :rtype: ~azure.batch.models.JobStatistics or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`BatchErrorException<azure.batch.models.BatchErrorException>`
        """
        timeout = None
        if job_get_all_lifetime_statistics_options is not None:
            timeout = job_get_all_lifetime_statistics_options.timeout
        client_request_id = None
        if job_get_all_lifetime_statistics_options is not None:
            client_request_id = job_get_all_lifetime_statistics_options.client_request_id
        return_client_request_id = None
        if job_get_all_lifetime_statistics_options is not None:
            return_client_request_id = job_get_all_lifetime_statistics_options.return_client_request_id
        ocp_date = None
        if job_get_all_lifetime_statistics_options is not None:
            ocp_date = job_get_all_lifetime_statistics_options.ocp_date

        # Construct URL
        url = self.get_all_lifetime_statistics.metadata['url']
        path_format_arguments = {
            'batchUrl': self._serialize.url("self.config.batch_url", self.config.batch_url, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self.config.generate_client_request_id:
            header_parameters['client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
        if client_request_id is not None:
            header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
        if return_client_request_id is not None:
            header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
        if ocp_date is not None:
            header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.BatchErrorException(self._deserialize, response)

        header_dict = {}
        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('JobStatistics', response)
            header_dict = {
                'client-request-id': 'str',
                'request-id': 'str',
                'ETag': 'str',
                'Last-Modified': 'rfc-1123',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized
    get_all_lifetime_statistics.metadata = {'url': '/lifetimejobstats'}

    def delete(
            self, job_id, job_delete_options=None, custom_headers=None, raw=False, **operation_config):
        """Deletes a Job.

        Deleting a Job also deletes all Tasks that are part of that Job, and
        all Job statistics. This also overrides the retention period for Task
        data; that is, if the Job contains Tasks which are still retained on
        Compute Nodes, the Batch services deletes those Tasks' working
        directories and all their contents.  When a Delete Job request is
        received, the Batch service sets the Job to the deleting state. All
        update operations on a Job that is in deleting state will fail with
        status code 409 (Conflict), with additional information indicating that
        the Job is being deleted.

        :param job_id: The ID of the Job to delete.
        :type job_id: str
        :param job_delete_options: Additional parameters for the operation
        :type job_delete_options: ~azure.batch.models.JobDeleteOptions
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: None or ClientRawResponse if raw=true
        :rtype: None or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`BatchErrorException<azure.batch.models.BatchErrorException>`
        """
        timeout = None
        if job_delete_options is not None:
            timeout = job_delete_options.timeout
        client_request_id = None
        if job_delete_options is not None:
            client_request_id = job_delete_options.client_request_id
        return_client_request_id = None
        if job_delete_options is not None:
            return_client_request_id = job_delete_options.return_client_request_id
        ocp_date = None
        if job_delete_options is not None:
            ocp_date = job_delete_options.ocp_date
        if_match = None
        if job_delete_options is not None:
            if_match = job_delete_options.if_match
        if_none_match = None
        if job_delete_options is not None:
            if_none_match = job_delete_options.if_none_match
        if_modified_since = None
        if job_delete_options is not None:
            if_modified_since = job_delete_options.if_modified_since
        if_unmodified_since = None
        if job_delete_options is not None:
            if_unmodified_since = job_delete_options.if_unmodified_since

        # Construct URL
        url = self.delete.metadata['url']
        path_format_arguments = {
            'batchUrl': self._serialize.url("self.config.batch_url", self.config.batch_url, 'str', skip_quote=True),
            'jobId': self._serialize.url("job_id", job_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

        # Construct headers
        header_parameters = {}
        if self.config.generate_client_request_id:
            header_parameters['client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
        if client_request_id is not None:
            header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
        if return_client_request_id is not None:
            header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
        if ocp_date is not None:
            header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')
        if if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')
        if if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", if_none_match, 'str')
        if if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", if_modified_since, 'rfc-1123')
        if if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", if_unmodified_since, 'rfc-1123')

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [202]:
            raise models.BatchErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            client_raw_response.add_headers({
                'client-request-id': 'str',
                'request-id': 'str',
            })
            return client_raw_response
    delete.metadata = {'url': '/jobs/{jobId}'}

    def get(
            self, job_id, job_get_options=None, custom_headers=None, raw=False, **operation_config):
        """Gets information about the specified Job.

        :param job_id: The ID of the Job.
        :type job_id: str
        :param job_get_options: Additional parameters for the operation
        :type job_get_options: ~azure.batch.models.JobGetOptions
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: CloudJob or ClientRawResponse if raw=true
        :rtype: ~azure.batch.models.CloudJob or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`BatchErrorException<azure.batch.models.BatchErrorException>`
        """
        select = None
        if job_get_options is not None:
            select = job_get_options.select
        expand = None
        if job_get_options is not None:
            expand = job_get_options.expand
        timeout = None
        if job_get_options is not None:
            timeout = job_get_options.timeout
        client_request_id = None
        if job_get_options is not None:
            client_request_id = job_get_options.client_request_id
        return_client_request_id = None
        if job_get_options is not None:
            return_client_request_id = job_get_options.return_client_request_id
        ocp_date = None
        if job_get_options is not None:
            ocp_date = job_get_options.ocp_date
        if_match = None
        if job_get_options is not None:
            if_match = job_get_options.if_match
        if_none_match = None
        if job_get_options is not None:
            if_none_match = job_get_options.if_none_match
        if_modified_since = None
        if job_get_options is not None:
            if_modified_since = job_get_options.if_modified_since
        if_unmodified_since = None
        if job_get_options is not None:
            if_unmodified_since = job_get_options.if_unmodified_since

        # Construct URL
        url = self.get.metadata['url']
        path_format_arguments = {
            'batchUrl': self._serialize.url("self.config.batch_url", self.config.batch_url, 'str', skip_quote=True),
            'jobId': self._serialize.url("job_id", job_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
        if select is not None:
            query_parameters['$select'] = self._serialize.query("select", select, 'str')
        if expand is not None:
            query_parameters['$expand'] = self._serialize.query("expand", expand, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self.config.generate_client_request_id:
            header_parameters['client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
        if client_request_id is not None:
            header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
        if return_client_request_id is not None:
            header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
        if ocp_date is not None:
            header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')
        if if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')
        if if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", if_none_match, 'str')
        if if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", if_modified_since, 'rfc-1123')
        if if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", if_unmodified_since, 'rfc-1123')

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.BatchErrorException(self._deserialize, response)

        header_dict = {}
        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('CloudJob', response)
            header_dict = {
                'client-request-id': 'str',
                'request-id': 'str',
                'ETag': 'str',
                'Last-Modified': 'rfc-1123',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized
    get.metadata = {'url': '/jobs/{jobId}'}

    def patch(
            self, job_id, job_patch_parameter, job_patch_options=None, custom_headers=None, raw=False, **operation_config):
        """Updates the properties of the specified Job.

        This replaces only the Job properties specified in the request. For
        example, if the Job has constraints, and a request does not specify the
        constraints element, then the Job keeps the existing constraints.

        :param job_id: The ID of the Job whose properties you want to update.
        :type job_id: str
        :param job_patch_parameter: The parameters for the request.
        :type job_patch_parameter: ~azure.batch.models.JobPatchParameter
        :param job_patch_options: Additional parameters for the operation
        :type job_patch_options: ~azure.batch.models.JobPatchOptions
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: None or ClientRawResponse if raw=true
        :rtype: None or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`BatchErrorException<azure.batch.models.BatchErrorException>`
        """
        timeout = None
        if job_patch_options is not None:
            timeout = job_patch_options.timeout
        client_request_id = None
        if job_patch_options is not None:
            client_request_id = job_patch_options.client_request_id
        return_client_request_id = None
        if job_patch_options is not None:
            return_client_request_id = job_patch_options.return_client_request_id
        ocp_date = None
        if job_patch_options is not None:
            ocp_date = job_patch_options.ocp_date
        if_match = None
        if job_patch_options is not None:
            if_match = job_patch_options.if_match
        if_none_match = None
        if job_patch_options is not None:
            if_none_match = job_patch_options.if_none_match
        if_modified_since = None
        if job_patch_options is not None:
            if_modified_since = job_patch_options.if_modified_since
        if_unmodified_since = None
        if job_patch_options is not None:
            if_unmodified_since = job_patch_options.if_unmodified_since

        # Construct URL
        url = self.patch.metadata['url']
        path_format_arguments = {
            'batchUrl': self._serialize.url("self.config.batch_url", self.config.batch_url, 'str', skip_quote=True),
            'jobId': self._serialize.url("job_id", job_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; odata=minimalmetadata; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
        if client_request_id is not None:
            header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
        if return_client_request_id is not None:
            header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
        if ocp_date is not None:
            header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')
        if if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')
        if if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", if_none_match, 'str')
        if if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", if_modified_since, 'rfc-1123')
        if if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", if_unmodified_since, 'rfc-1123')

        # Construct body
        body_content = self._serialize.body(job_patch_parameter, 'JobPatchParameter')

        # Construct and send request
        request = self._client.patch(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.BatchErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            client_raw_response.add_headers({
                'client-request-id': 'str',
                'request-id': 'str',
                'ETag': 'str',
                'Last-Modified': 'rfc-1123',
                'DataServiceId': 'str',
            })
            return client_raw_response
    patch.metadata = {'url': '/jobs/{jobId}'}

    def update(
            self, job_id, job_update_parameter, job_update_options=None, custom_headers=None, raw=False, **operation_config):
        """Updates the properties of the specified Job.

        This fully replaces all the updatable properties of the Job. For
        example, if the Job has constraints associated with it and if
        constraints is not specified with this request, then the Batch service
        will remove the existing constraints.

        :param job_id: The ID of the Job whose properties you want to update.
        :type job_id: str
        :param job_update_parameter: The parameters for the request.
        :type job_update_parameter: ~azure.batch.models.JobUpdateParameter
        :param job_update_options: Additional parameters for the operation
        :type job_update_options: ~azure.batch.models.JobUpdateOptions
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: None or ClientRawResponse if raw=true
        :rtype: None or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`BatchErrorException<azure.batch.models.BatchErrorException>`
        """
        timeout = None
        if job_update_options is not None:
            timeout = job_update_options.timeout
        client_request_id = None
        if job_update_options is not None:
            client_request_id = job_update_options.client_request_id
        return_client_request_id = None
        if job_update_options is not None:
            return_client_request_id = job_update_options.return_client_request_id
        ocp_date = None
        if job_update_options is not None:
            ocp_date = job_update_options.ocp_date
        if_match = None
        if job_update_options is not None:
            if_match = job_update_options.if_match
        if_none_match = None
        if job_update_options is not None:
            if_none_match = job_update_options.if_none_match
        if_modified_since = None
        if job_update_options is not None:
            if_modified_since = job_update_options.if_modified_since
        if_unmodified_since = None
        if job_update_options is not None:
            if_unmodified_since = job_update_options.if_unmodified_since

        # Construct URL
        url = self.update.metadata['url']
        path_format_arguments = {
            'batchUrl': self._serialize.url("self.config.batch_url", self.config.batch_url, 'str', skip_quote=True),
            'jobId': self._serialize.url("job_id", job_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; odata=minimalmetadata; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
        if client_request_id is not None:
            header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
        if return_client_request_id is not None:
            header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
        if ocp_date is not None:
            header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')
        if if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')
        if if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", if_none_match, 'str')
        if if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", if_modified_since, 'rfc-1123')
        if if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", if_unmodified_since, 'rfc-1123')

        # Construct body
        body_content = self._serialize.body(job_update_parameter, 'JobUpdateParameter')

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.BatchErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            client_raw_response.add_headers({
                'client-request-id': 'str',
                'request-id': 'str',
                'ETag': 'str',
                'Last-Modified': 'rfc-1123',
                'DataServiceId': 'str',
            })
            return client_raw_response
    update.metadata = {'url': '/jobs/{jobId}'}

    def disable(
            self, job_id, disable_tasks, job_disable_options=None, custom_headers=None, raw=False, **operation_config):
        """Disables the specified Job, preventing new Tasks from running.

        The Batch Service immediately moves the Job to the disabling state.
        Batch then uses the disableTasks parameter to determine what to do with
        the currently running Tasks of the Job. The Job remains in the
        disabling state until the disable operation is completed and all Tasks
        have been dealt with according to the disableTasks option; the Job then
        moves to the disabled state. No new Tasks are started under the Job
        until it moves back to active state. If you try to disable a Job that
        is in any state other than active, disabling, or disabled, the request
        fails with status code 409.

        :param job_id: The ID of the Job to disable.
        :type job_id: str
        :param disable_tasks: What to do with active Tasks associated with the
         Job. Possible values include: 'requeue', 'terminate', 'wait'
        :type disable_tasks: str or ~azure.batch.models.DisableJobOption
        :param job_disable_options: Additional parameters for the operation
        :type job_disable_options: ~azure.batch.models.JobDisableOptions
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: None or ClientRawResponse if raw=true
        :rtype: None or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`BatchErrorException<azure.batch.models.BatchErrorException>`
        """
        timeout = None
        if job_disable_options is not None:
            timeout = job_disable_options.timeout
        client_request_id = None
        if job_disable_options is not None:
            client_request_id = job_disable_options.client_request_id
        return_client_request_id = None
        if job_disable_options is not None:
            return_client_request_id = job_disable_options.return_client_request_id
        ocp_date = None
        if job_disable_options is not None:
            ocp_date = job_disable_options.ocp_date
        if_match = None
        if job_disable_options is not None:
            if_match = job_disable_options.if_match
        if_none_match = None
        if job_disable_options is not None:
            if_none_match = job_disable_options.if_none_match
        if_modified_since = None
        if job_disable_options is not None:
            if_modified_since = job_disable_options.if_modified_since
        if_unmodified_since = None
        if job_disable_options is not None:
            if_unmodified_since = job_disable_options.if_unmodified_since
        job_disable_parameter = models.JobDisableParameter(disable_tasks=disable_tasks)

        # Construct URL
        url = self.disable.metadata['url']
        path_format_arguments = {
            'batchUrl': self._serialize.url("self.config.batch_url", self.config.batch_url, 'str', skip_quote=True),
            'jobId': self._serialize.url("job_id", job_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; odata=minimalmetadata; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
        if client_request_id is not None:
            header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
        if return_client_request_id is not None:
            header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
        if ocp_date is not None:
            header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')
        if if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')
        if if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", if_none_match, 'str')
        if if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", if_modified_since, 'rfc-1123')
        if if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", if_unmodified_since, 'rfc-1123')

        # Construct body
        body_content = self._serialize.body(job_disable_parameter, 'JobDisableParameter')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [202]:
            raise models.BatchErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            client_raw_response.add_headers({
                'client-request-id': 'str',
                'request-id': 'str',
                'ETag': 'str',
                'Last-Modified': 'rfc-1123',
                'DataServiceId': 'str',
            })
            return client_raw_response
    disable.metadata = {'url': '/jobs/{jobId}/disable'}

    def enable(
            self, job_id, job_enable_options=None, custom_headers=None, raw=False, **operation_config):
        """Enables the specified Job, allowing new Tasks to run.

        When you call this API, the Batch service sets a disabled Job to the
        enabling state. After the this operation is completed, the Job moves to
        the active state, and scheduling of new Tasks under the Job resumes.
        The Batch service does not allow a Task to remain in the active state
        for more than 180 days. Therefore, if you enable a Job containing
        active Tasks which were added more than 180 days ago, those Tasks will
        not run.

        :param job_id: The ID of the Job to enable.
        :type job_id: str
        :param job_enable_options: Additional parameters for the operation
        :type job_enable_options: ~azure.batch.models.JobEnableOptions
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: None or ClientRawResponse if raw=true
        :rtype: None or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`BatchErrorException<azure.batch.models.BatchErrorException>`
        """
        timeout = None
        if job_enable_options is not None:
            timeout = job_enable_options.timeout
        client_request_id = None
        if job_enable_options is not None:
            client_request_id = job_enable_options.client_request_id
        return_client_request_id = None
        if job_enable_options is not None:
            return_client_request_id = job_enable_options.return_client_request_id
        ocp_date = None
        if job_enable_options is not None:
            ocp_date = job_enable_options.ocp_date
        if_match = None
        if job_enable_options is not None:
            if_match = job_enable_options.if_match
        if_none_match = None
        if job_enable_options is not None:
            if_none_match = job_enable_options.if_none_match
        if_modified_since = None
        if job_enable_options is not None:
            if_modified_since = job_enable_options.if_modified_since
        if_unmodified_since = None
        if job_enable_options is not None:
            if_unmodified_since = job_enable_options.if_unmodified_since

        # Construct URL
        url = self.enable.metadata['url']
        path_format_arguments = {
            'batchUrl': self._serialize.url("self.config.batch_url", self.config.batch_url, 'str', skip_quote=True),
            'jobId': self._serialize.url("job_id", job_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

        # Construct headers
        header_parameters = {}
        if self.config.generate_client_request_id:
            header_parameters['client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
        if client_request_id is not None:
            header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
        if return_client_request_id is not None:
            header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
        if ocp_date is not None:
            header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')
        if if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')
        if if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", if_none_match, 'str')
        if if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", if_modified_since, 'rfc-1123')
        if if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", if_unmodified_since, 'rfc-1123')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [202]:
            raise models.BatchErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            client_raw_response.add_headers({
                'client-request-id': 'str',
                'request-id': 'str',
                'ETag': 'str',
                'Last-Modified': 'rfc-1123',
                'DataServiceId': 'str',
            })
            return client_raw_response
    enable.metadata = {'url': '/jobs/{jobId}/enable'}

    def terminate(
            self, job_id, terminate_reason=None, job_terminate_options=None, custom_headers=None, raw=False, **operation_config):
        """Terminates the specified Job, marking it as completed.

        When a Terminate Job request is received, the Batch service sets the
        Job to the terminating state. The Batch service then terminates any
        running Tasks associated with the Job and runs any required Job release
        Tasks. Then the Job moves into the completed state. If there are any
        Tasks in the Job in the active state, they will remain in the active
        state. Once a Job is terminated, new Tasks cannot be added and any
        remaining active Tasks will not be scheduled.

        :param job_id: The ID of the Job to terminate.
        :type job_id: str
        :param terminate_reason: The text you want to appear as the Job's
         TerminateReason. The default is 'UserTerminate'.
        :type terminate_reason: str
        :param job_terminate_options: Additional parameters for the operation
        :type job_terminate_options: ~azure.batch.models.JobTerminateOptions
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: None or ClientRawResponse if raw=true
        :rtype: None or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`BatchErrorException<azure.batch.models.BatchErrorException>`
        """
        timeout = None
        if job_terminate_options is not None:
            timeout = job_terminate_options.timeout
        client_request_id = None
        if job_terminate_options is not None:
            client_request_id = job_terminate_options.client_request_id
        return_client_request_id = None
        if job_terminate_options is not None:
            return_client_request_id = job_terminate_options.return_client_request_id
        ocp_date = None
        if job_terminate_options is not None:
            ocp_date = job_terminate_options.ocp_date
        if_match = None
        if job_terminate_options is not None:
            if_match = job_terminate_options.if_match
        if_none_match = None
        if job_terminate_options is not None:
            if_none_match = job_terminate_options.if_none_match
        if_modified_since = None
        if job_terminate_options is not None:
            if_modified_since = job_terminate_options.if_modified_since
        if_unmodified_since = None
        if job_terminate_options is not None:
            if_unmodified_since = job_terminate_options.if_unmodified_since
        job_terminate_parameter = None
        if terminate_reason is not None:
            job_terminate_parameter = models.JobTerminateParameter(terminate_reason=terminate_reason)

        # Construct URL
        url = self.terminate.metadata['url']
        path_format_arguments = {
            'batchUrl': self._serialize.url("self.config.batch_url", self.config.batch_url, 'str', skip_quote=True),
            'jobId': self._serialize.url("job_id", job_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; odata=minimalmetadata; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
        if client_request_id is not None:
            header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
        if return_client_request_id is not None:
            header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
        if ocp_date is not None:
            header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')
        if if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')
        if if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", if_none_match, 'str')
        if if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", if_modified_since, 'rfc-1123')
        if if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", if_unmodified_since, 'rfc-1123')

        # Construct body
        if job_terminate_parameter is not None:
            body_content = self._serialize.body(job_terminate_parameter, 'JobTerminateParameter')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [202]:
            raise models.BatchErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            client_raw_response.add_headers({
                'client-request-id': 'str',
                'request-id': 'str',
                'ETag': 'str',
                'Last-Modified': 'rfc-1123',
                'DataServiceId': 'str',
            })
            return client_raw_response
    terminate.metadata = {'url': '/jobs/{jobId}/terminate'}

    def add(
            self, job, job_add_options=None, custom_headers=None, raw=False, **operation_config):
        """Adds a Job to the specified Account.

        The Batch service supports two ways to control the work done as part of
        a Job. In the first approach, the user specifies a Job Manager Task.
        The Batch service launches this Task when it is ready to start the Job.
        The Job Manager Task controls all other Tasks that run under this Job,
        by using the Task APIs. In the second approach, the user directly
        controls the execution of Tasks under an active Job, by using the Task
        APIs. Also note: when naming Jobs, avoid including sensitive
        information such as user names or secret project names. This
        information may appear in telemetry logs accessible to Microsoft
        Support engineers.

        :param job: The Job to be added.
        :type job: ~azure.batch.models.JobAddParameter
        :param job_add_options: Additional parameters for the operation
        :type job_add_options: ~azure.batch.models.JobAddOptions
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: None or ClientRawResponse if raw=true
        :rtype: None or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`BatchErrorException<azure.batch.models.BatchErrorException>`
        """
        timeout = None
        if job_add_options is not None:
            timeout = job_add_options.timeout
        client_request_id = None
        if job_add_options is not None:
            client_request_id = job_add_options.client_request_id
        return_client_request_id = None
        if job_add_options is not None:
            return_client_request_id = job_add_options.return_client_request_id
        ocp_date = None
        if job_add_options is not None:
            ocp_date = job_add_options.ocp_date

        # Construct URL
        url = self.add.metadata['url']
        path_format_arguments = {
            'batchUrl': self._serialize.url("self.config.batch_url", self.config.batch_url, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; odata=minimalmetadata; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
        if client_request_id is not None:
            header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
        if return_client_request_id is not None:
            header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
        if ocp_date is not None:
            header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')

        # Construct body
        body_content = self._serialize.body(job, 'JobAddParameter')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [201]:
            raise models.BatchErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            client_raw_response.add_headers({
                'client-request-id': 'str',
                'request-id': 'str',
                'ETag': 'str',
                'Last-Modified': 'rfc-1123',
                'DataServiceId': 'str',
            })
            return client_raw_response
    add.metadata = {'url': '/jobs'}

    def list(
            self, job_list_options=None, custom_headers=None, raw=False, **operation_config):
        """Lists all of the Jobs in the specified Account.

        :param job_list_options: Additional parameters for the operation
        :type job_list_options: ~azure.batch.models.JobListOptions
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: An iterator like instance of CloudJob
        :rtype:
         ~azure.batch.models.CloudJobPaged[~azure.batch.models.CloudJob]
        :raises:
         :class:`BatchErrorException<azure.batch.models.BatchErrorException>`
        """
        filter = None
        if job_list_options is not None:
            filter = job_list_options.filter
        select = None
        if job_list_options is not None:
            select = job_list_options.select
        expand = None
        if job_list_options is not None:
            expand = job_list_options.expand
        max_results = None
        if job_list_options is not None:
            max_results = job_list_options.max_results
        timeout = None
        if job_list_options is not None:
            timeout = job_list_options.timeout
        client_request_id = None
        if job_list_options is not None:
            client_request_id = job_list_options.client_request_id
        return_client_request_id = None
        if job_list_options is not None:
            return_client_request_id = job_list_options.return_client_request_id
        ocp_date = None
        if job_list_options is not None:
            ocp_date = job_list_options.ocp_date

        def prepare_request(next_link=None):
            if not next_link:
                # Construct URL
                url = self.list.metadata['url']
                path_format_arguments = {
                    'batchUrl': self._serialize.url("self.config.batch_url", self.config.batch_url, 'str', skip_quote=True)
                }
                url = self._client.format_url(url, **path_format_arguments)

                # Construct parameters
                query_parameters = {}
                query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
                if filter is not None:
                    query_parameters['$filter'] = self._serialize.query("filter", filter, 'str')
                if select is not None:
                    query_parameters['$select'] = self._serialize.query("select", select, 'str')
                if expand is not None:
                    query_parameters['$expand'] = self._serialize.query("expand", expand, 'str')
                if max_results is not None:
                    query_parameters['maxresults'] = self._serialize.query("max_results", max_results, 'int', maximum=1000, minimum=1)
                if timeout is not None:
                    query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

            else:
                url = next_link
                query_parameters = {}

            # Construct headers
            header_parameters = {}
            header_parameters['Accept'] = 'application/json'
            if self.config.generate_client_request_id:
                header_parameters['client-request-id'] = str(uuid.uuid1())
            if custom_headers:
                header_parameters.update(custom_headers)
            if self.config.accept_language is not None:
                header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
            if client_request_id is not None:
                header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
            if return_client_request_id is not None:
                header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
            if ocp_date is not None:
                header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')

            # Construct and send request
            request = self._client.get(url, query_parameters, header_parameters)
            return request

        def internal_paging(next_link=None):
            request = prepare_request(next_link)

            response = self._client.send(request, stream=False, **operation_config)

            if response.status_code not in [200]:
                raise models.BatchErrorException(self._deserialize, response)

            return response

        # Deserialize response
        header_dict = None
        if raw:
            header_dict = {}
        deserialized = models.CloudJobPaged(internal_paging, self._deserialize.dependencies, header_dict)

        return deserialized
    list.metadata = {'url': '/jobs'}

    def list_from_job_schedule(
            self, job_schedule_id, job_list_from_job_schedule_options=None, custom_headers=None, raw=False, **operation_config):
        """Lists the Jobs that have been created under the specified Job Schedule.

        :param job_schedule_id: The ID of the Job Schedule from which you want
         to get a list of Jobs.
        :type job_schedule_id: str
        :param job_list_from_job_schedule_options: Additional parameters for
         the operation
        :type job_list_from_job_schedule_options:
         ~azure.batch.models.JobListFromJobScheduleOptions
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: An iterator like instance of CloudJob
        :rtype:
         ~azure.batch.models.CloudJobPaged[~azure.batch.models.CloudJob]
        :raises:
         :class:`BatchErrorException<azure.batch.models.BatchErrorException>`
        """
        filter = None
        if job_list_from_job_schedule_options is not None:
            filter = job_list_from_job_schedule_options.filter
        select = None
        if job_list_from_job_schedule_options is not None:
            select = job_list_from_job_schedule_options.select
        expand = None
        if job_list_from_job_schedule_options is not None:
            expand = job_list_from_job_schedule_options.expand
        max_results = None
        if job_list_from_job_schedule_options is not None:
            max_results = job_list_from_job_schedule_options.max_results
        timeout = None
        if job_list_from_job_schedule_options is not None:
            timeout = job_list_from_job_schedule_options.timeout
        client_request_id = None
        if job_list_from_job_schedule_options is not None:
            client_request_id = job_list_from_job_schedule_options.client_request_id
        return_client_request_id = None
        if job_list_from_job_schedule_options is not None:
            return_client_request_id = job_list_from_job_schedule_options.return_client_request_id
        ocp_date = None
        if job_list_from_job_schedule_options is not None:
            ocp_date = job_list_from_job_schedule_options.ocp_date

        def prepare_request(next_link=None):
            if not next_link:
                # Construct URL
                url = self.list_from_job_schedule.metadata['url']
                path_format_arguments = {
                    'batchUrl': self._serialize.url("self.config.batch_url", self.config.batch_url, 'str', skip_quote=True),
                    'jobScheduleId': self._serialize.url("job_schedule_id", job_schedule_id, 'str')
                }
                url = self._client.format_url(url, **path_format_arguments)

                # Construct parameters
                query_parameters = {}
                query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
                if filter is not None:
                    query_parameters['$filter'] = self._serialize.query("filter", filter, 'str')
                if select is not None:
                    query_parameters['$select'] = self._serialize.query("select", select, 'str')
                if expand is not None:
                    query_parameters['$expand'] = self._serialize.query("expand", expand, 'str')
                if max_results is not None:
                    query_parameters['maxresults'] = self._serialize.query("max_results", max_results, 'int', maximum=1000, minimum=1)
                if timeout is not None:
                    query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

            else:
                url = next_link
                query_parameters = {}

            # Construct headers
            header_parameters = {}
            header_parameters['Accept'] = 'application/json'
            if self.config.generate_client_request_id:
                header_parameters['client-request-id'] = str(uuid.uuid1())
            if custom_headers:
                header_parameters.update(custom_headers)
            if self.config.accept_language is not None:
                header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
            if client_request_id is not None:
                header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
            if return_client_request_id is not None:
                header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
            if ocp_date is not None:
                header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')

            # Construct and send request
            request = self._client.get(url, query_parameters, header_parameters)
            return request

        def internal_paging(next_link=None):
            request = prepare_request(next_link)

            response = self._client.send(request, stream=False, **operation_config)

            if response.status_code not in [200]:
                raise models.BatchErrorException(self._deserialize, response)

            return response

        # Deserialize response
        header_dict = None
        if raw:
            header_dict = {}
        deserialized = models.CloudJobPaged(internal_paging, self._deserialize.dependencies, header_dict)

        return deserialized
    list_from_job_schedule.metadata = {'url': '/jobschedules/{jobScheduleId}/jobs'}

    def list_preparation_and_release_task_status(
            self, job_id, job_list_preparation_and_release_task_status_options=None, custom_headers=None, raw=False, **operation_config):
        """Lists the execution status of the Job Preparation and Job Release Task
        for the specified Job across the Compute Nodes where the Job has run.

        This API returns the Job Preparation and Job Release Task status on all
        Compute Nodes that have run the Job Preparation or Job Release Task.
        This includes Compute Nodes which have since been removed from the
        Pool. If this API is invoked on a Job which has no Job Preparation or
        Job Release Task, the Batch service returns HTTP status code 409
        (Conflict) with an error code of JobPreparationTaskNotSpecified.

        :param job_id: The ID of the Job.
        :type job_id: str
        :param job_list_preparation_and_release_task_status_options:
         Additional parameters for the operation
        :type job_list_preparation_and_release_task_status_options:
         ~azure.batch.models.JobListPreparationAndReleaseTaskStatusOptions
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: An iterator like instance of
         JobPreparationAndReleaseTaskExecutionInformation
        :rtype:
         ~azure.batch.models.JobPreparationAndReleaseTaskExecutionInformationPaged[~azure.batch.models.JobPreparationAndReleaseTaskExecutionInformation]
        :raises:
         :class:`BatchErrorException<azure.batch.models.BatchErrorException>`
        """
        filter = None
        if job_list_preparation_and_release_task_status_options is not None:
            filter = job_list_preparation_and_release_task_status_options.filter
        select = None
        if job_list_preparation_and_release_task_status_options is not None:
            select = job_list_preparation_and_release_task_status_options.select
        max_results = None
        if job_list_preparation_and_release_task_status_options is not None:
            max_results = job_list_preparation_and_release_task_status_options.max_results
        timeout = None
        if job_list_preparation_and_release_task_status_options is not None:
            timeout = job_list_preparation_and_release_task_status_options.timeout
        client_request_id = None
        if job_list_preparation_and_release_task_status_options is not None:
            client_request_id = job_list_preparation_and_release_task_status_options.client_request_id
        return_client_request_id = None
        if job_list_preparation_and_release_task_status_options is not None:
            return_client_request_id = job_list_preparation_and_release_task_status_options.return_client_request_id
        ocp_date = None
        if job_list_preparation_and_release_task_status_options is not None:
            ocp_date = job_list_preparation_and_release_task_status_options.ocp_date

        def prepare_request(next_link=None):
            if not next_link:
                # Construct URL
                url = self.list_preparation_and_release_task_status.metadata['url']
                path_format_arguments = {
                    'batchUrl': self._serialize.url("self.config.batch_url", self.config.batch_url, 'str', skip_quote=True),
                    'jobId': self._serialize.url("job_id", job_id, 'str')
                }
                url = self._client.format_url(url, **path_format_arguments)

                # Construct parameters
                query_parameters = {}
                query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
                if filter is not None:
                    query_parameters['$filter'] = self._serialize.query("filter", filter, 'str')
                if select is not None:
                    query_parameters['$select'] = self._serialize.query("select", select, 'str')
                if max_results is not None:
                    query_parameters['maxresults'] = self._serialize.query("max_results", max_results, 'int', maximum=1000, minimum=1)
                if timeout is not None:
                    query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

            else:
                url = next_link
                query_parameters = {}

            # Construct headers
            header_parameters = {}
            header_parameters['Accept'] = 'application/json'
            if self.config.generate_client_request_id:
                header_parameters['client-request-id'] = str(uuid.uuid1())
            if custom_headers:
                header_parameters.update(custom_headers)
            if self.config.accept_language is not None:
                header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
            if client_request_id is not None:
                header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
            if return_client_request_id is not None:
                header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
            if ocp_date is not None:
                header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')

            # Construct and send request
            request = self._client.get(url, query_parameters, header_parameters)
            return request

        def internal_paging(next_link=None):
            request = prepare_request(next_link)

            response = self._client.send(request, stream=False, **operation_config)

            if response.status_code not in [200]:
                raise models.BatchErrorException(self._deserialize, response)

            return response

        # Deserialize response
        header_dict = None
        if raw:
            header_dict = {}
        deserialized = models.JobPreparationAndReleaseTaskExecutionInformationPaged(internal_paging, self._deserialize.dependencies, header_dict)

        return deserialized
    list_preparation_and_release_task_status.metadata = {'url': '/jobs/{jobId}/jobpreparationandreleasetaskstatus'}

    def get_task_counts(
            self, job_id, job_get_task_counts_options=None, custom_headers=None, raw=False, **operation_config):
        """Gets the Task counts for the specified Job.

        Task counts provide a count of the Tasks by active, running or
        completed Task state, and a count of Tasks which succeeded or failed.
        Tasks in the preparing state are counted as running.

        :param job_id: The ID of the Job.
        :type job_id: str
        :param job_get_task_counts_options: Additional parameters for the
         operation
        :type job_get_task_counts_options:
         ~azure.batch.models.JobGetTaskCountsOptions
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: TaskCounts or ClientRawResponse if raw=true
        :rtype: ~azure.batch.models.TaskCounts or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`BatchErrorException<azure.batch.models.BatchErrorException>`
        """
        timeout = None
        if job_get_task_counts_options is not None:
            timeout = job_get_task_counts_options.timeout
        client_request_id = None
        if job_get_task_counts_options is not None:
            client_request_id = job_get_task_counts_options.client_request_id
        return_client_request_id = None
        if job_get_task_counts_options is not None:
            return_client_request_id = job_get_task_counts_options.return_client_request_id
        ocp_date = None
        if job_get_task_counts_options is not None:
            ocp_date = job_get_task_counts_options.ocp_date

        # Construct URL
        url = self.get_task_counts.metadata['url']
        path_format_arguments = {
            'batchUrl': self._serialize.url("self.config.batch_url", self.config.batch_url, 'str', skip_quote=True),
            'jobId': self._serialize.url("job_id", job_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self.config.generate_client_request_id:
            header_parameters['client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
        if client_request_id is not None:
            header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
        if return_client_request_id is not None:
            header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
        if ocp_date is not None:
            header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.BatchErrorException(self._deserialize, response)

        header_dict = {}
        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('TaskCounts', response)
            header_dict = {
                'client-request-id': 'str',
                'request-id': 'str',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized
    get_task_counts.metadata = {'url': '/jobs/{jobId}/taskcounts'}
