# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.hybridcompute import HybridComputeManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestHybridComputeManagementMachineRunCommandsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(HybridComputeManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_create_or_update(self, resource_group):
        response = self.client.machine_run_commands.begin_create_or_update(
            resource_group_name=resource_group.name,
            machine_name="str",
            run_command_name="str",
            run_command_properties={
                "location": "str",
                "asyncExecution": False,
                "errorBlobManagedIdentity": {"clientId": "str", "objectId": "str"},
                "errorBlobUri": "str",
                "id": "str",
                "instanceView": {
                    "endTime": "2020-02-20 00:00:00",
                    "error": "str",
                    "executionMessage": "str",
                    "executionState": "str",
                    "exitCode": 0,
                    "output": "str",
                    "startTime": "2020-02-20 00:00:00",
                    "statuses": [
                        {
                            "code": "str",
                            "displayStatus": "str",
                            "level": "str",
                            "message": "str",
                            "time": "2020-02-20 00:00:00",
                        }
                    ],
                },
                "name": "str",
                "outputBlobManagedIdentity": {"clientId": "str", "objectId": "str"},
                "outputBlobUri": "str",
                "parameters": [{"name": "str", "value": "str"}],
                "protectedParameters": [{"name": "str", "value": "str"}],
                "provisioningState": "str",
                "runAsPassword": "str",
                "runAsUser": "str",
                "source": {
                    "commandId": "str",
                    "script": "str",
                    "scriptUri": "str",
                    "scriptUriManagedIdentity": {"clientId": "str", "objectId": "str"},
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "timeoutInSeconds": 0,
                "type": "str",
            },
            api_version="2024-07-31-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_delete(self, resource_group):
        response = self.client.machine_run_commands.begin_delete(
            resource_group_name=resource_group.name,
            machine_name="str",
            run_command_name="str",
            api_version="2024-07-31-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get(self, resource_group):
        response = self.client.machine_run_commands.get(
            resource_group_name=resource_group.name,
            machine_name="str",
            run_command_name="str",
            api_version="2024-07-31-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list(self, resource_group):
        response = self.client.machine_run_commands.list(
            resource_group_name=resource_group.name,
            machine_name="str",
            api_version="2024-07-31-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
