# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.resource import PolicyClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestPolicyPolicyAssignmentsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(PolicyClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_policy_assignments_delete(self, resource_group):
        response = self.client.policy_assignments.delete(
            scope="str",
            policy_assignment_name="str",
            api_version="2022-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_policy_assignments_create(self, resource_group):
        response = self.client.policy_assignments.create(
            scope="str",
            policy_assignment_name="str",
            parameters={
                "description": "str",
                "displayName": "str",
                "enforcementMode": "Default",
                "id": "str",
                "identity": {
                    "principalId": "str",
                    "tenantId": "str",
                    "type": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "location": "str",
                "metadata": {},
                "name": "str",
                "nonComplianceMessages": [{"message": "str", "policyDefinitionReferenceId": "str"}],
                "notScopes": ["str"],
                "overrides": [
                    {"kind": "str", "selectors": [{"in": ["str"], "kind": "str", "notIn": ["str"]}], "value": "str"}
                ],
                "parameters": {"str": {"value": {}}},
                "policyDefinitionId": "str",
                "resourceSelectors": [{"name": "str", "selectors": [{"in": ["str"], "kind": "str", "notIn": ["str"]}]}],
                "scope": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
            api_version="2022-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_policy_assignments_get(self, resource_group):
        response = self.client.policy_assignments.get(
            scope="str",
            policy_assignment_name="str",
            api_version="2022-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_policy_assignments_update(self, resource_group):
        response = self.client.policy_assignments.update(
            scope="str",
            policy_assignment_name="str",
            parameters={
                "identity": {
                    "principalId": "str",
                    "tenantId": "str",
                    "type": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "location": "str",
                "overrides": [
                    {"kind": "str", "selectors": [{"in": ["str"], "kind": "str", "notIn": ["str"]}], "value": "str"}
                ],
                "resourceSelectors": [{"name": "str", "selectors": [{"in": ["str"], "kind": "str", "notIn": ["str"]}]}],
            },
            api_version="2022-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_policy_assignments_list_for_resource_group(self, resource_group):
        response = self.client.policy_assignments.list_for_resource_group(
            resource_group_name=resource_group.name,
            api_version="2022-06-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_policy_assignments_list_for_resource(self, resource_group):
        response = self.client.policy_assignments.list_for_resource(
            resource_group_name=resource_group.name,
            resource_provider_namespace="str",
            parent_resource_path="str",
            resource_type="str",
            resource_name="str",
            api_version="2022-06-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_policy_assignments_list_for_management_group(self, resource_group):
        response = self.client.policy_assignments.list_for_management_group(
            management_group_id="str",
            api_version="2022-06-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_policy_assignments_list(self, resource_group):
        response = self.client.policy_assignments.list(
            api_version="2022-06-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_policy_assignments_delete_by_id(self, resource_group):
        response = self.client.policy_assignments.delete_by_id(
            policy_assignment_id="str",
            api_version="2022-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_policy_assignments_create_by_id(self, resource_group):
        response = self.client.policy_assignments.create_by_id(
            policy_assignment_id="str",
            parameters={
                "description": "str",
                "displayName": "str",
                "enforcementMode": "Default",
                "id": "str",
                "identity": {
                    "principalId": "str",
                    "tenantId": "str",
                    "type": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "location": "str",
                "metadata": {},
                "name": "str",
                "nonComplianceMessages": [{"message": "str", "policyDefinitionReferenceId": "str"}],
                "notScopes": ["str"],
                "overrides": [
                    {"kind": "str", "selectors": [{"in": ["str"], "kind": "str", "notIn": ["str"]}], "value": "str"}
                ],
                "parameters": {"str": {"value": {}}},
                "policyDefinitionId": "str",
                "resourceSelectors": [{"name": "str", "selectors": [{"in": ["str"], "kind": "str", "notIn": ["str"]}]}],
                "scope": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
            api_version="2022-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_policy_assignments_get_by_id(self, resource_group):
        response = self.client.policy_assignments.get_by_id(
            policy_assignment_id="str",
            api_version="2022-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_policy_assignments_update_by_id(self, resource_group):
        response = self.client.policy_assignments.update_by_id(
            policy_assignment_id="str",
            parameters={
                "identity": {
                    "principalId": "str",
                    "tenantId": "str",
                    "type": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "location": "str",
                "overrides": [
                    {"kind": "str", "selectors": [{"in": ["str"], "kind": "str", "notIn": ["str"]}], "value": "str"}
                ],
                "resourceSelectors": [{"name": "str", "selectors": [{"in": ["str"], "kind": "str", "notIn": ["str"]}]}],
            },
            api_version="2022-06-01",
        )

        # please add some check logic here by yourself
        # ...
