#
# PySNMP MIB module TRIP-MIB (http://pysnmp.sf.net)
# ASN.1 source http://mibs.snmplabs.com:80/asn1/TRIP-MIB
# Produced by pysmi-0.0.7 at Sun Feb 14 00:32:10 2016
# On host bldfarm platform Linux version 4.1.13-100.fc21.x86_64 by user goose
# Using Python version 3.5.0 (default, Jan  5 2016, 17:11:52) 
#
( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( SingleValueConstraint, ConstraintsUnion, ConstraintsIntersection, ValueRangeConstraint, ValueSizeConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "SingleValueConstraint", "ConstraintsUnion", "ConstraintsIntersection", "ValueRangeConstraint", "ValueSizeConstraint")
( InetPortNumber, InetAddress, InetAddressType, ) = mibBuilder.importSymbols("INET-ADDRESS-MIB", "InetPortNumber", "InetAddress", "InetAddressType")
( applRFC2788Group, applIndex, ) = mibBuilder.importSymbols("NETWORK-SERVICES-MIB", "applRFC2788Group", "applIndex")
( NotificationGroup, ObjectGroup, ModuleCompliance, ) = mibBuilder.importSymbols("SNMPv2-CONF", "NotificationGroup", "ObjectGroup", "ModuleCompliance")
( Unsigned32, Counter64, MibIdentifier, ModuleIdentity, MibScalar, MibTable, MibTableRow, MibTableColumn, IpAddress, NotificationType, Bits, iso, TimeTicks, Integer32, ObjectIdentity, Gauge32, mib_2, Counter32, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Unsigned32", "Counter64", "MibIdentifier", "ModuleIdentity", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "IpAddress", "NotificationType", "Bits", "iso", "TimeTicks", "Integer32", "ObjectIdentity", "Gauge32", "mib-2", "Counter32")
( TimeInterval, RowStatus, DisplayString, TruthValue, TimeStamp, TextualConvention, DateAndTime, StorageType, ) = mibBuilder.importSymbols("SNMPv2-TC", "TimeInterval", "RowStatus", "DisplayString", "TruthValue", "TimeStamp", "TextualConvention", "DateAndTime", "StorageType")
( TripSendReceiveMode, TripAppProtocol, TripAddressFamily, TripCommunityId, TripId, TripProtocolVersion, TripItad, ) = mibBuilder.importSymbols("TRIP-TC-MIB", "TripSendReceiveMode", "TripAppProtocol", "TripAddressFamily", "TripCommunityId", "TripId", "TripProtocolVersion", "TripItad")
tripMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 116)).setRevisions(("2004-09-02 00:00",))
if mibBuilder.loadTexts: tripMIB.setLastUpdated('200409020000Z')
if mibBuilder.loadTexts: tripMIB.setOrganization('IETF IPTel Working Group.\n\n\n            Mailing list: iptel@lists.bell-labs.com')
if mibBuilder.loadTexts: tripMIB.setContactInfo('Co-editor  David Zinman\n            postal:    265 Ridley Blvd.\n                       Toronto ON, M5M 4N8\n                       Canada\n            email:     dzinman@rogers.com\n            phone:     +1 416 433 4298\n\n        Co-editor: David Walker\n                   Sedna Wireless Inc.\n        postal:    495 March Road, Suite 500\n                   Ottawa, ON K2K 3G1\n                   Canada\n        email:     david.walker@sedna-wireless.com\n        phone:     +1 613 878 8142\n\n        Co-editor   Jianping Jiang\n                    Syndesis Limited\n        postal:     30 Fulton Way\n                    Richmond Hill, ON L4B 1J5\n                    Canada\n\n        email:      jjiang@syndesis.com\n        phone:      +1 905 886-7818 x2515\n            ')
if mibBuilder.loadTexts: tripMIB.setDescription('The MIB module describing Telephony Routing over IP\n            (TRIP). TRIP is a policy driven inter-administrative\n            domain protocol for advertising the reachability of\n            telephony destinations between location servers (LS), and\n            for advertising attributes of the routes to those\n            destinations.\n\n            Copyright (C) The Internet Society (2004). This version of\n            this MIB module is part of RFC 3872, see the RFC itself\n            for full legal notices.')
tripMIBNotifications = MibIdentifier((1, 3, 6, 1, 2, 1, 116, 0))
tripMIBObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 116, 1))
tripMIBConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 116, 2))
tripMIBNotifObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 116, 3))
tripMIBCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 116, 2, 1))
tripMIBGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 116, 2, 2))
tripCfgTable = MibTable((1, 3, 6, 1, 2, 1, 116, 1, 1), )
if mibBuilder.loadTexts: tripCfgTable.setDescription("This table contains the common configuration objects\n             applicable to all TRIP applications referenced by the\n             applIndex.  Each row represents those objects for a\n             particular TRIP LS present in this system. The\n             instances of TRIP LS's are uniquely identified by the\n             applIndex. The objects in this table SHOULD be\n             nonVolatile and survive a reboot.")
tripCfgEntry = MibTableRow((1, 3, 6, 1, 2, 1, 116, 1, 1, 1), ).setIndexNames((0, "NETWORK-SERVICES-MIB", "applIndex"))
if mibBuilder.loadTexts: tripCfgEntry.setDescription('A row of common configuration.')
tripCfgProtocolVersion = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 1, 1, 1), TripProtocolVersion()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripCfgProtocolVersion.setDescription('This object will reflect the version of TRIP\n            supported by this system.  It follows the same\n            format as TRIP version information contained\n            in the TRIP messages generated by this TRIP entity.')
tripCfgItad = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 1, 1, 2), TripItad()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: tripCfgItad.setDescription('The Internet Telephony Administrative domain (ITAD)\n            of this LS.')
tripCfgIdentifier = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 1, 1, 3), TripId()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripCfgIdentifier.setDescription('The object that identifies this TRIP Client.')
tripCfgAdminStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 1, 1, 4), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("up", 1), ("down", 2),))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: tripCfgAdminStatus.setDescription('The desired TRIP state.\n\n             up(1)  : Set the application to normal operation.\n\n             down(2): Set the application to a state where it will\n                      not process TRIP messages.\n\n             Setting this object should be reflected in\n             tripCfgOperStatus. If an unknown error occurs\n             tripCfgOperStatus will return unknown(0).')
tripCfgOperStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 1, 1, 5), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1, 2, 3,))).clone(namedValues=NamedValues(("unknown", 0), ("up", 1), ("down", 2), ("faulty", 3),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripCfgOperStatus.setDescription('The current operational state of the TRIP protocol.\n\n             unknown(0): The operating status of the application is\n                         unknown.\n\n             up(1):      The application is operating normally, and\n                         is ready to process (receive and issue) TRIP\n                         requests and responses.\n\n             down(2):    The application is currently not processing\n                         TRIP messages. This occurs if the TRIP\n                         application is in an initialization state or\n                         if tripCfgAdminStatus is set to down(2).\n\n             faulty(3):  The application is not operating normally due\n                         to a fault in the system.\n\n            If tripCfgAdminStatus is down(2) then tripOperStatus SHOULD\n            be down(2). If tripAdminStatus is changed to up(1) then\n            tripOperStatus SHOULD change to up(1) if there is no\n            fault that prevents the TRIP protocol from moving to the\n            up(1) state.')
tripCfgAddrIAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 1, 1, 6), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripCfgAddrIAddrType.setDescription('The type of Inet Address of the tripAddr.')
tripCfgAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 1, 1, 7), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripCfgAddr.setDescription('The network address of the local LS that the peer\n            connects to. The type of address depends on the object\n            tripCfgAddrIAddrType. The type of this address is\n            determined by the value of the\n            tripCfgAddrIAddrType object.')
tripCfgPort = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 1, 1, 8), InetPortNumber()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: tripCfgPort.setDescription('The local tcp/udp port on the local LS that the peer\n            connects to.')
tripCfgMinItadOriginationInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 1, 1, 9), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,2147483647)).clone(30)).setUnits('Seconds').setMaxAccess("readwrite")
if mibBuilder.loadTexts: tripCfgMinItadOriginationInterval.setDescription("The minimum amount of time that MUST elapse between\n            advertisement of the update message that reports changes\n            within the LS's own ITAD.")
tripCfgMinRouteAdvertisementInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 1, 1, 10), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,2147483647)).clone(30)).setUnits('Seconds').setMaxAccess("readwrite")
if mibBuilder.loadTexts: tripCfgMinRouteAdvertisementInterval.setDescription('Specifies minimal interval between successive\n            advertisements to a particular destination from an LS.')
tripCfgMaxPurgeTime = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 1, 1, 11), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,2147483647)).clone(10)).setUnits('Seconds').setMaxAccess("readwrite")
if mibBuilder.loadTexts: tripCfgMaxPurgeTime.setDescription('Indicates the interval that the LS MUST maintain routes\n            marked as withdrawn in its database.')
tripCfgDisableTime = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 1, 1, 12), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,2147483647)).clone(180)).setUnits('Seconds').setMaxAccess("readwrite")
if mibBuilder.loadTexts: tripCfgDisableTime.setDescription('Indicates the interval that the TRIP module of the\n            LS MUST be disabled while routes originated by this\n            LS with high sequence numbers can be removed.')
tripCfgSendReceiveMode = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 1, 1, 13), TripSendReceiveMode()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripCfgSendReceiveMode.setDescription('The operational mode of the TRIP entity running on this\n            system.')
tripCfgStorage = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 1, 1, 14), StorageType().clone('nonVolatile')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: tripCfgStorage.setDescription("The storage type for this conceptual row. Conceptual rows\n           having the value 'permanent' need not allow write-access\n           to any columnar objects in the row.")
tripRouteTypeTable = MibTable((1, 3, 6, 1, 2, 1, 116, 1, 2), )
if mibBuilder.loadTexts: tripRouteTypeTable.setDescription('The TRIP peer Route Type table contains one entry per\n            supported protocol - address family pair.  The objects in\n            this table are volatile and are refreshed after a reboot.')
tripRouteTypeEntry = MibTableRow((1, 3, 6, 1, 2, 1, 116, 1, 2, 1), ).setIndexNames((0, "NETWORK-SERVICES-MIB", "applIndex"), (0, "TRIP-MIB", "tripRouteTypeAddrInetType"), (0, "TRIP-MIB", "tripRouteTypeAddr"), (0, "TRIP-MIB", "tripRouteTypePort"), (0, "TRIP-MIB", "tripRouteTypeProtocolId"), (0, "TRIP-MIB", "tripRouteTypeAddrFamilyId"))
if mibBuilder.loadTexts: tripRouteTypeEntry.setDescription('An entry containing information about the route type\n            that a particular TRIP entity supports. Each entry\n            represents information about either the local or a remote\n            LS peer.  The object tripRouteTypePeer is used to\n            distinguish this.  In the case of a local LS, the\n            address/port information will reflect the values\n            configured in tripCfgTable.  In the case of a remote\n            peer, the address/port information will reflect the\n            values of an entry in the tripPeerTable.\n\n            Implementation need to be aware that if the size of\n            tripRouteTypeAddr exceeds 111 sub-IDs, then OIDs of column\n            instances in this table will have more than 128 sub-IDs\n            and cannot be accessed using SNMPv1, SNMPv2c, or snmpv3.')
tripRouteTypeAddrInetType = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 2, 1, 1), InetAddressType())
if mibBuilder.loadTexts: tripRouteTypeAddrInetType.setDescription('The type of Inet Address of the tripRouteTypeAddr.')
tripRouteTypeAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 2, 1, 2), InetAddress())
if mibBuilder.loadTexts: tripRouteTypeAddr.setDescription("The network address of this entry's TRIP peer LS. The\n            type of this address is determined by the value of the\n            tripRouteTypeAddrInetType object.")
tripRouteTypePort = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 2, 1, 3), InetPortNumber())
if mibBuilder.loadTexts: tripRouteTypePort.setDescription('The port for the TCP connection between this and\n            an associated TRIP peer.')
tripRouteTypeProtocolId = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 2, 1, 4), TripAppProtocol())
if mibBuilder.loadTexts: tripRouteTypeProtocolId.setDescription('The object identifier of a protocol that the associated\n            peer is using.')
tripRouteTypeAddrFamilyId = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 2, 1, 5), TripAddressFamily())
if mibBuilder.loadTexts: tripRouteTypeAddrFamilyId.setDescription('The object identifier of an address family that the\n            associated peer belongs to.')
tripRouteTypePeer = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 2, 1, 6), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("local", 1), ("remote", 2),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripRouteTypePeer.setDescription("This object identifies whether this entry is\n\n\n\n            associated with a 'local' or 'remote' LS peer.")
tripSupportedCommunityTable = MibTable((1, 3, 6, 1, 2, 1, 116, 1, 3), )
if mibBuilder.loadTexts: tripSupportedCommunityTable.setDescription('The list of TRIP communities that this LS supports. A\n            TRIP community is a group of destinations that share\n            common properties.\n\n            The TRIP Supported Communities entry is used to group\n            destinations so that the routing decision can be based\n            on the identity of the group.')
tripSupportedCommunityEntry = MibTableRow((1, 3, 6, 1, 2, 1, 116, 1, 3, 1), ).setIndexNames((0, "NETWORK-SERVICES-MIB", "applIndex"), (0, "TRIP-MIB", "tripSupportedCommunityId"))
if mibBuilder.loadTexts: tripSupportedCommunityEntry.setDescription('Entry containing information about a community. A TRIP\n            community is a group of destinations that share some\n            common property. This attribute is used so that routing\n            decisions can be based on the identity of the group.')
tripSupportedCommunityId = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 3, 1, 1), TripCommunityId())
if mibBuilder.loadTexts: tripSupportedCommunityId.setDescription('The identifier of the supported Community.')
tripSupportedCommunityItad = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 3, 1, 2), TripItad()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tripSupportedCommunityItad.setDescription('The ITAD of the community.')
tripSupportedCommunityStorage = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 3, 1, 3), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tripSupportedCommunityStorage.setDescription("The storage type for this conceptual row.  Conceptual\n          rows having the value 'permanent' need not allow write-\n          access to any columnar objects in the row. It is not a\n          requirement that this storage be non volatile.")
tripSupportedCommunityRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 3, 1, 4), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tripSupportedCommunityRowStatus.setDescription('The row status of the entry. This object is REQUIRED\n            to create or delete rows by a manager. A value for\n            tripSupportedCommunityItad MUST be set for row creation\n            to be successful. If the instance already exists for a\n            particular applIndex, the row create operation will\n            fail.\n\n            The value of this object has no effect on whether\n            other objects in this conceptual row can be modified.')
tripPeerTable = MibTable((1, 3, 6, 1, 2, 1, 116, 1, 4), )
if mibBuilder.loadTexts: tripPeerTable.setDescription('The TRIP peer table. This table contains one entry per\n            TRIP peer, and information about the connection with\n\n\n\n            the peer.')
tripPeerEntry = MibTableRow((1, 3, 6, 1, 2, 1, 116, 1, 4, 1), ).setIndexNames((0, "NETWORK-SERVICES-MIB", "applIndex"), (0, "TRIP-MIB", "tripPeerRemoteAddrInetType"), (0, "TRIP-MIB", "tripPeerRemoteAddr"), (0, "TRIP-MIB", "tripPeerRemotePort"))
if mibBuilder.loadTexts: tripPeerEntry.setDescription('Entry containing information about the connection with\n            a TRIP peer.\n\n            Implementation need to be aware that if the size of\n            tripPeerRemoteAddr exceeds 113 sub-IDs, then OIDs of\n            column instances in this table will have more than 128\n            sub-IDs and cannot be accessed using SNMPv1, SNMPv2c, or\n            snmpv3.')
tripPeerRemoteAddrInetType = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 4, 1, 1), InetAddressType())
if mibBuilder.loadTexts: tripPeerRemoteAddrInetType.setDescription('The type of Inet Address of the tripPeerRemoteAddr.')
tripPeerRemoteAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 4, 1, 2), InetAddress())
if mibBuilder.loadTexts: tripPeerRemoteAddr.setDescription("The IP address of this entry's TRIP peer LS. The type of\n            this address is determined by the value of the\n            tripPeerRemoteAddrInetType object.")
tripPeerRemotePort = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 4, 1, 3), InetPortNumber())
if mibBuilder.loadTexts: tripPeerRemotePort.setDescription('The remote port for the TCP connection between the\n            TRIP peers.')
tripPeerIdentifier = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 4, 1, 4), TripId()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripPeerIdentifier.setDescription('TRIP identifier of the peer.')
tripPeerState = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 4, 1, 5), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6,))).clone(namedValues=NamedValues(("idle", 1), ("connect", 2), ("active", 3), ("openSent", 4), ("openConfirm", 5), ("established", 6),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripPeerState.setDescription('TRIP Peer Finite State Machine state.\n\n            idle(1)       : The initial state. Local LS refuses all\n                            incoming connections. No application\n                            resources are allocated to processing\n                            information about the remote peer.\n\n            connect(2)    : Local LS waiting for a transport\n                            protocol connection to be completed to\n                            the peer, and is listening for inbound\n                            transport connections from the peer.\n\n            active(3)     : Local LS is listening for an inbound\n                            connection from the peer, but is not in\n                            the process of initiating a connection\n                            to the remote peer.\n\n            openSent(4)   : Local LS has sent an OPEN message to its\n                            peer and is waiting for an OPEN message\n                            from the remote peer.\n\n            openConfirm(5): Local LS has sent an OPEN message to the\n                            remote peer, received an OPEN message from\n                            the remote peer, and sent a KEEPALIVE\n                            message in response to the OPEN. The local\n                            LS is now waiting for a KEEPALIVE message\n                            or a NOTIFICATION message in response to\n                            its OPEN message.\n\n            established(6): LS can exchange UPDATE, NOTIFICATION, and\n                            KEEPALIVE messages with its peer.')
tripPeerAdminStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 4, 1, 6), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("up", 1), ("down", 2),)).clone('up')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tripPeerAdminStatus.setDescription('This object is used to affect the TRIP connection\n            state.\n\n            up(1)   : Allow a connection with the peer LS.\n\n            down(2) : disconnect the connection from the peer LS and\n                      do not allow any further connections to this\n\n\n\n                      peer.\n\n            If this value is set to down(2) then tripPeerState will\n            have the value of idle(1).')
tripPeerNegotiatedVersion = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 4, 1, 7), TripProtocolVersion()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripPeerNegotiatedVersion.setDescription('The negotiated version of TRIP running between this\n            local entity and this peer.')
tripPeerSendReceiveMode = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 4, 1, 8), TripSendReceiveMode()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripPeerSendReceiveMode.setDescription('The operational mode of this peer.')
tripPeerRemoteItad = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 4, 1, 9), TripItad()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripPeerRemoteItad.setDescription('The Internet Telephony Administrative domain of\n            this peer.')
tripPeerConnectRetryInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 4, 1, 10), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,2147483647)).clone(120)).setUnits('Seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: tripPeerConnectRetryInterval.setDescription('Specifies the initial amount of time that will elapse\n            between connection retry. This value SHOULD double\n            after each attempt up to the value of\n            tripPeerMaxRetryInterval. This value MUST always be less\n            than or equal to the value of tripPeerMaxRetryInterval.\n            Attempts to set this value higher than the max retry\n            will not be allowed.')
tripPeerMaxRetryInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 4, 1, 11), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,2147483647)).clone(360)).setUnits('Seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: tripPeerMaxRetryInterval.setDescription('Specifies the maximum amount of time that will elapse\n            between connection retries. Once the value of\n            tripPeerConnectRetryInterval has reached this value, no\n            more retries will be attempted. Attempts to set this\n            value lower than the retry interval SHOULD not be\n            allowed.')
tripPeerHoldTime = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 4, 1, 12), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,2147483647))).setUnits('Seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: tripPeerHoldTime.setDescription('The time interval in seconds for the hold timer that\n            is established with the peer. The value of this object\n            is the smaller of the values in\n            tripPeerHoldTimeConfigured and the hold time received\n            in the open message.')
tripPeerKeepAlive = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 4, 1, 13), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,2147483647))).setUnits('Seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: tripPeerKeepAlive.setDescription('Specifies the amount of time that MUST elapse between\n            keep alive messages. This value is negotiated with the\n            remote when a connection is established.')
tripPeerHoldTimeConfigured = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 4, 1, 14), Unsigned32().subtype(subtypeSpec=ConstraintsUnion(ValueRangeConstraint(0,0),ValueRangeConstraint(3,65535),)).clone(240)).setUnits('Seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: tripPeerHoldTimeConfigured.setDescription('Specifies the maximum time that MAY elapse between the\n            receipt of successive keepalive or update message. A value\n            of 0 means that keepalive or update messages will not be\n\n\n\n            sent.')
tripPeerKeepAliveConfigured = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 4, 1, 15), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,2147483647)).clone(30)).setUnits('Seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: tripPeerKeepAliveConfigured.setDescription('Specifies the amount of time that MUST elapse between\n            keep alive messages.')
tripPeerMaxPurgeTime = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 4, 1, 16), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,65535)).clone(10)).setUnits('Seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: tripPeerMaxPurgeTime.setDescription('Indicates the interval that the LS MUST maintain routes\n            marked as withdrawn in its database.')
tripPeerDisableTime = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 4, 1, 17), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,65535)).clone(180)).setUnits('Seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: tripPeerDisableTime.setDescription('Indicate the interval that the TRIP module of the remote\n            peer LS MUST be disabled while routes originated by the\n            local LS with high sequence numbers can be removed.')
tripPeerLearned = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 4, 1, 18), TruthValue().clone('false')).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripPeerLearned.setDescription('Indicates whether this entry was learned or\n            configured.')
tripPeerStorage = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 4, 1, 19), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tripPeerStorage.setDescription("The storage type for this conceptual row.  Conceptual\n           rows having the value 'permanent' need not allow write-\n           access to any columnar objects in the row. It is not a\n           requirement that this storage be non volatile.")
tripPeerRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 4, 1, 20), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tripPeerRowStatus.setDescription('The row status of the entry. This object is REQUIRED to\n            create or delete rows remotely by a manager. If the\n            instance already exists for a particular applIndex, the\n            row create operation will fail.\n\n            The value of this object has no effect on whether\n            other objects in this conceptual row can be modified.\n\n            Entries in this table can be learned by the TRIP\n            application, or provisioned through this table.')
tripPeerStatisticsTable = MibTable((1, 3, 6, 1, 2, 1, 116, 1, 5), )
if mibBuilder.loadTexts: tripPeerStatisticsTable.setDescription('The TRIP peer stats table. This table contains one\n            entry per remote TRIP peer, and statistics related to the\n            connection with the remote peer. The objects in this\n            table are volatile.')
tripPeerStatisticsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 116, 1, 5, 1), )
tripPeerEntry.registerAugmentions(("TRIP-MIB", "tripPeerStatisticsEntry"))
tripPeerStatisticsEntry.setIndexNames(*tripPeerEntry.getIndexNames())
if mibBuilder.loadTexts: tripPeerStatisticsEntry.setDescription('Entry containing information about the connection with\n            a TRIP peer.')
tripPeerInUpdates = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 5, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripPeerInUpdates.setDescription('The number of TRIP update messages received from this\n            remote peer since the last restart of this location\n            server.')
tripPeerOutUpdates = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 5, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripPeerOutUpdates.setDescription('The number of TRIP update messages sent to this remote\n            peer since the last restart of this LS.')
tripPeerInTotalMessages = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 5, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripPeerInTotalMessages.setDescription('The total number of TRIP messages received from the\n            remote peer on this connection since the last restart\n            of this LS.')
tripPeerOutTotalMessages = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 5, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripPeerOutTotalMessages.setDescription('The total number of outgoing TRIP messages sent to the\n            remote peer since the last restart of this LS.')
tripPeerFsmEstablishedTransitions = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 5, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripPeerFsmEstablishedTransitions.setDescription('The number of times the remote peer has transitioned\n            into the established state since the last restart of this\n            LS.')
tripPeerFsmEstablishedTime = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 5, 1, 6), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripPeerFsmEstablishedTime.setDescription("Indicates the time and date that this remote peer entered\n            the 'established' state.")
tripPeerInUpdateElapsedTime = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 5, 1, 7), TimeInterval()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripPeerInUpdateElapsedTime.setDescription('Elapsed time in hundredths of seconds since the last\n            TRIP update message was received from this remote peer.')
tripPeerStateChangeTime = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 5, 1, 8), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripPeerStateChangeTime.setDescription('The value of sysUpTime when the last state change of\n            tripPeerState took place.')
tripRouteTable = MibTable((1, 3, 6, 1, 2, 1, 116, 1, 6), )
if mibBuilder.loadTexts: tripRouteTable.setDescription('The TRIP route table containing information about\n            reachable routes that are to be added to service by the\n            receiving LS. The objects in this table are volatile\n            and are refreshed when this LS rediscovers its route\n            table.')
tripRouteEntry = MibTableRow((1, 3, 6, 1, 2, 1, 116, 1, 6, 1), ).setIndexNames((0, "NETWORK-SERVICES-MIB", "applIndex"), (0, "TRIP-MIB", "tripRouteAppProtocol"), (0, "TRIP-MIB", "tripRouteAddressFamily"), (0, "TRIP-MIB", "tripRouteAddress"), (0, "TRIP-MIB", "tripRoutePeer"))
if mibBuilder.loadTexts: tripRouteEntry.setDescription('Information about a route to a called destination.')
tripRouteAppProtocol = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 6, 1, 1), TripAppProtocol())
if mibBuilder.loadTexts: tripRouteAppProtocol.setDescription('The protocol for which this entry of the routing table\n            is maintained.')
tripRouteAddressFamily = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 6, 1, 2), TripAddressFamily())
if mibBuilder.loadTexts: tripRouteAddressFamily.setDescription('Specifies the type of address for the destination\n            route.')
tripRouteAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 6, 1, 3), OctetString().subtype(subtypeSpec=ValueSizeConstraint(1,105)))
if mibBuilder.loadTexts: tripRouteAddress.setDescription('This is the address (prefix) of the family type given\n            by Address Family of the destination. It is the prefix\n            of addresses reachable from this gateway via the next\n            hop server. The SIZE value of 105 has been assigned due\n            to the sub identifier of object types length limitation\n            as defined in SMIv2.')
tripRoutePeer = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 6, 1, 4), TripId())
if mibBuilder.loadTexts: tripRoutePeer.setDescription('The identifier of the peer where the route information\n            was learned.')
tripRouteTRIBMask = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 6, 1, 5), Bits().clone(namedValues=NamedValues(("adjTribIns", 0), ("extTrib", 1), ("locTrib", 2), ("adjTribOut", 3),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripRouteTRIBMask.setDescription('Indicates which Telephony Routing Information Base (TRIB)\n            this entry belongs to. This is\n            a bit-map of possible types. If the bit has a value of\n            1, then the entry is a member of the corresponding TRIB\n            type. If the bit has a value of 0 then the entry is not\n            a member of the TRIP type. The various bit positions\n            are:\n\n            0    adjTribIns     The entry is of type adj-TRIBs-ins,\n                                stores routing information that has\n                                been learned from inbound UPDATE\n                                messages.\n            1    extTrib        The entry is of type ext-TRIB, the\n                                best route for a given destination.\n            2    locTrib        The entry is of type loc-TRIB contains\n                                the local TRIP routing information\n                                that the LS has selected.\n            3    adjTribOut     The entry is of type adj-TRIBs-out,\n                                stores the information that the local\n                                LS has selected for advertisement to\n                                its external peers.')
tripRouteAddressSequenceNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 6, 1, 6), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripRouteAddressSequenceNumber.setDescription('Indicates the version of the destination route\n            originated by the LS identified by\n            tripRouteAddressOriginatorId intra-domain attribute.')
tripRouteAddressOriginatorId = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 6, 1, 7), TripId()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripRouteAddressOriginatorId.setDescription('This is an intra-domain attribute indicating the\n            internal LS that originated the route into the ITAD.')
tripRouteNextHopServerIAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 6, 1, 8), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripRouteNextHopServerIAddrType.setDescription('The type of Inet Address of the tripRouteNextHopServer.')
tripRouteNextHopServer = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 6, 1, 9), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripRouteNextHopServer.setDescription('Indicates the next hop that messages of a given protocol\n            destined for tripRouteAddress SHOULD be sent to. The type\n            of this address is determined by the value of the\n            tripRouteNextHopServerIAddrType object.')
tripRouteNextHopServerPort = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 6, 1, 10), InetPortNumber()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripRouteNextHopServerPort.setDescription('The port of the next hop server that this route\n            will use.')
tripRouteNextHopServerItad = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 6, 1, 11), TripItad()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripRouteNextHopServerItad.setDescription('Indicates the domain of the next hop.')
tripRouteMultiExitDisc = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 6, 1, 12), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,4294967295))).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripRouteMultiExitDisc.setDescription('The Multiple Exit Discriminator allows an LS to\n            discriminate between, and indicate preference for,\n            otherwise similar routes to a neighbouring domain.\n            A higher value represents a more preferred routing\n            object.')
tripRouteLocalPref = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 6, 1, 13), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,4294967295))).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripRouteLocalPref.setDescription("Indicated the local LS's degree of preference for an\n            advertised route destination.")
tripRouteAdvertisementPath = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 6, 1, 14), OctetString().subtype(subtypeSpec=ValueSizeConstraint(4,252))).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripRouteAdvertisementPath.setDescription('Identifies the sequence of domains through which this\n            advertisement has passed.\n\n            This object is probably best represented as sequence of\n            TripItads. For SMI compatibility, though, it is\n            represented as an OCTET STRING. This object is a sequence\n            of ITADs where each set of 4 octets corresponds to a TRIP\n            ITAD in network byte order.')
tripRouteRoutedPath = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 6, 1, 15), OctetString().subtype(subtypeSpec=ValueSizeConstraint(4,252))).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripRouteRoutedPath.setDescription('Identifies the ITADs through which messages sent using\n            this route would pass. These are a subset of\n            tripRouteAdvertisementPath.\n\n            This object is probably best represented as sequence of\n            TripItads. For SMI compatibility, though, it is\n            represented as OCTET STRING.  This object is a sequence\n            of ITADs where each set of 4 octets corresponds to a TRIP\n            ITAD in network byte order.')
tripRouteAtomicAggregate = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 6, 1, 16), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripRouteAtomicAggregate.setDescription('Indicates that a route MAY traverse domains not listed\n            in tripRouteRoutedPath. If an LS selects the less\n            specific route from a set of overlapping routes, then\n            this value returns TRUE.')
tripRouteUnknown = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 6, 1, 17), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0,255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripRouteUnknown.setDescription('This object contains one or more attributes that were not\n            understood, and because they were transitive, were dropped\n            during aggregation. They take the format of a triple\n            <attribute type, attribute length, attribute value>, of\n            variable length. If no attributes were dropped, this\n            returns an OCTET STRING of size 0.')
tripRouteWithdrawn = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 6, 1, 18), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripRouteWithdrawn.setDescription('Indicates if this route is to be removed from service\n            by the receiving LS.')
tripRouteConverted = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 6, 1, 19), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripRouteConverted.setDescription('Indicates if this route has been converted to a\n            different application protocol than it had originally.')
tripRouteReceivedTime = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 6, 1, 20), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripRouteReceivedTime.setDescription('The value of sysUpTime when this route was received.')
tripRouteCommunityTable = MibTable((1, 3, 6, 1, 2, 1, 116, 1, 7), )
if mibBuilder.loadTexts: tripRouteCommunityTable.setDescription('A table containing a list of TRIP communities associated\n            with a route. Each instance of tripRouteTypeEntry that has\n            the tripRouteTypePeer object set to remote(2) has an\n            instance in the tripRouteTable as a parent. The objects\n            in this table are volatile and are refreshed after a\n            reboot.')
tripRouteCommunityEntry = MibTableRow((1, 3, 6, 1, 2, 1, 116, 1, 7, 1), ).setIndexNames((0, "NETWORK-SERVICES-MIB", "applIndex"), (0, "TRIP-MIB", "tripRouteAppProtocol"), (0, "TRIP-MIB", "tripRouteAddressFamily"), (0, "TRIP-MIB", "tripRouteAddress"), (0, "TRIP-MIB", "tripRoutePeer"), (0, "TRIP-MIB", "tripRouteCommunityId"))
if mibBuilder.loadTexts: tripRouteCommunityEntry.setDescription('Information about communities associated with a route.\n            An entry with a tripRouteAddress of 00 and a\n            tripRoutePeer of 0 refers to the local LS.')
tripRouteCommunityId = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 7, 1, 1), TripCommunityId())
if mibBuilder.loadTexts: tripRouteCommunityId.setDescription('The community identifier.')
tripRouteCommunityItad = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 7, 1, 2), TripItad()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripRouteCommunityItad.setDescription('The ITAD associated with this community.')
tripItadTopologyTable = MibTable((1, 3, 6, 1, 2, 1, 116, 1, 8), )
if mibBuilder.loadTexts: tripItadTopologyTable.setDescription('The sequence of link connections between peers within an\n            ITAD. The objects in this table are volatile and are\n            refreshed after a reboot.')
tripItadTopologyEntry = MibTableRow((1, 3, 6, 1, 2, 1, 116, 1, 8, 1), ).setIndexNames((0, "NETWORK-SERVICES-MIB", "applIndex"), (0, "TRIP-MIB", "tripItadTopologyOrigId"))
if mibBuilder.loadTexts: tripItadTopologyEntry.setDescription('Information about a peer of the LS identified by\n            tripItadTopologyOrigId.')
tripItadTopologyOrigId = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 8, 1, 1), TripId())
if mibBuilder.loadTexts: tripItadTopologyOrigId.setDescription('Indicates the internal LS that originated the ITAD\n            topology information into the ITAD.')
tripItadTopologySeqNum = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 8, 1, 2), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripItadTopologySeqNum.setDescription('Indicates the version of the ITAD topology originated\n            by the LS identified by tripItadTopologyOrigId.')
tripItadTopologyIdTable = MibTable((1, 3, 6, 1, 2, 1, 116, 1, 9), )
if mibBuilder.loadTexts: tripItadTopologyIdTable.setDescription("The list of other LS's within the ITAD domain that the\n            LS identified by tripItadTopologyOrigId is currently\n            peering. Each instance of tripItadTopologyIdEntry has an\n            instance in the tripItadTopologyTable as a parent. The\n            objects in this table are volatile and are refreshed\n            after a reboot.")
tripItadTopologyIdEntry = MibTableRow((1, 3, 6, 1, 2, 1, 116, 1, 9, 1), ).setIndexNames((0, "NETWORK-SERVICES-MIB", "applIndex"), (0, "TRIP-MIB", "tripItadTopologyOrigId"), (0, "TRIP-MIB", "tripItadTopologyId"))
if mibBuilder.loadTexts: tripItadTopologyIdEntry.setDescription('Information about a peer to the LS identified by\n            tripItadTopologyOrigId.')
tripItadTopologyId = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 9, 1, 1), TripId()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripItadTopologyId.setDescription('The index into this entry. Indicates the other location\n            servers within the ITAD domain that this LS identified\n            by tripItadTopologyOrigId is currently peering.')
tripNotifApplIndex = MibScalar((1, 3, 6, 1, 2, 1, 116, 3, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,2147483647))).setMaxAccess("accessiblefornotify")
if mibBuilder.loadTexts: tripNotifApplIndex.setDescription('This object contains the application Index. It is used\n             to bind this notification with a specific instance of\n             TRIP entity.')
tripNotifPeerAddrInetType = MibScalar((1, 3, 6, 1, 2, 1, 116, 3, 2), InetAddressType()).setMaxAccess("accessiblefornotify")
if mibBuilder.loadTexts: tripNotifPeerAddrInetType.setDescription('The type of Inet Address of the tripNotifPeerAddr.')
tripNotifPeerAddr = MibScalar((1, 3, 6, 1, 2, 1, 116, 3, 3), InetAddress()).setMaxAccess("accessiblefornotify")
if mibBuilder.loadTexts: tripNotifPeerAddr.setDescription("The IP address of this entry's TRIP peer LS. This object\n            contains the value of tripPeerRemoteAddr. The type of this\n            address is determined by the value of the\n            tripNotifPeerAddrInetType object.")
tripNotifPeerErrCode = MibScalar((1, 3, 6, 1, 2, 1, 116, 3, 4), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6, 7,))).clone(namedValues=NamedValues(("messageHeader", 1), ("openMessage", 2), ("updateMessage", 3), ("holdTimerExpired", 4), ("finiteStateMachine", 5), ("cease", 6), ("tripNotification", 7),))).setMaxAccess("accessiblefornotify")
if mibBuilder.loadTexts: tripNotifPeerErrCode.setDescription('Notification message of TRIP error. The meaning of this\n            value is applicable to the following functions:\n\n            messageHeader(1)\n             - All errors detected while processing the TRIP message\n               header.\n\n            openMessage(2)\n             - All errors detected while processing the OPEN message.\n\n            updateMessage(3)\n             - All errors detected while processing the UPDATE\n               message.\n\n            holdTimerExpired(4)\n             - A notification generated when the hold timer expires.\n\n            finiteStateMachine(5)\n             - All errors detected by the TRIP Finite State Machine.\n\n            cease(6)\n             - Any fatal error condition that the rest of the values\n               do not cover.\n\n            tripNotification(7)\n             - Any error encountered while sending a notification\n               message.')
tripNotifPeerErrSubcode = MibScalar((1, 3, 6, 1, 2, 1, 116, 3, 5), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,2147483647))).setMaxAccess("accessiblefornotify")
if mibBuilder.loadTexts: tripNotifPeerErrSubcode.setDescription('The sub error code associated with error code. The\n\n\n\n            meaning of this value is dependent on the value of\n            tripNotifPeerErrCode.\n\n            Message Header (1) Error Subcodes:\n            1 - Bad Message Length.\n            2 - Bad Message Type.\n\n            OPEN Message (2) Error Subcodes:\n            1 - Unsupported Version Number.\n            2 - Bad Peer ITAD.\n            3 - Bad TRIP Identifier.\n            4 - Unsupported Optional Parameter.\n            5 - Unacceptable Hold Time.\n            6 - Unsupported Capability.\n            7 - Capability Mismatch.\n\n            UPDATE Message (3) Error Subcodes:\n            1 - Malformed Attribute List.\n            2 - Unrecognized Well-known Attribute.\n            3 - Missing Well-known Mandatory Attribute.\n            4 - Attribute Flags Error.\n            5 - Attribute Length Error.\n            6 - Invalid Attribute.')
tripConnectionEstablished = NotificationType((1, 3, 6, 1, 2, 1, 116, 0, 1)).setObjects(*(("TRIP-MIB", "tripNotifApplIndex"), ("TRIP-MIB", "tripNotifPeerAddrInetType"), ("TRIP-MIB", "tripNotifPeerAddr"),))
if mibBuilder.loadTexts: tripConnectionEstablished.setDescription('The TRIP Connection Established event is generated when\n            the TRIP finite state machine enters the ESTABLISHED\n            state.')
tripConnectionDropped = NotificationType((1, 3, 6, 1, 2, 1, 116, 0, 2)).setObjects(*(("TRIP-MIB", "tripNotifApplIndex"), ("TRIP-MIB", "tripNotifPeerAddrInetType"), ("TRIP-MIB", "tripNotifPeerAddr"),))
if mibBuilder.loadTexts: tripConnectionDropped.setDescription('The TRIP Connection Dropped event is generated when the\n\n\n\n            TRIP finite state machine leaves the ESTABLISHED state.')
tripFSM = NotificationType((1, 3, 6, 1, 2, 1, 116, 0, 3)).setObjects(*(("TRIP-MIB", "tripNotifApplIndex"), ("TRIP-MIB", "tripNotifPeerAddrInetType"), ("TRIP-MIB", "tripNotifPeerAddr"), ("TRIP-MIB", "tripNotifPeerErrCode"), ("TRIP-MIB", "tripNotifPeerErrSubcode"), ("TRIP-MIB", "tripPeerState"),))
if mibBuilder.loadTexts: tripFSM.setDescription('The trip FSM Event is generated when any error is\n            detected by the TRIP Finite State Machine.')
tripOpenMessageError = NotificationType((1, 3, 6, 1, 2, 1, 116, 0, 4)).setObjects(*(("TRIP-MIB", "tripNotifApplIndex"), ("TRIP-MIB", "tripNotifPeerAddrInetType"), ("TRIP-MIB", "tripNotifPeerAddr"), ("TRIP-MIB", "tripNotifPeerErrCode"), ("TRIP-MIB", "tripNotifPeerErrSubcode"), ("TRIP-MIB", "tripPeerState"),))
if mibBuilder.loadTexts: tripOpenMessageError.setDescription('Errors detected while processing the OPEN message.')
tripUpdateMessageError = NotificationType((1, 3, 6, 1, 2, 1, 116, 0, 5)).setObjects(*(("TRIP-MIB", "tripNotifApplIndex"), ("TRIP-MIB", "tripNotifPeerAddrInetType"), ("TRIP-MIB", "tripNotifPeerAddr"), ("TRIP-MIB", "tripNotifPeerErrCode"), ("TRIP-MIB", "tripNotifPeerErrSubcode"), ("TRIP-MIB", "tripPeerState"),))
if mibBuilder.loadTexts: tripUpdateMessageError.setDescription('Errors detected while processing the UPDATE message.')
tripHoldTimerExpired = NotificationType((1, 3, 6, 1, 2, 1, 116, 0, 6)).setObjects(*(("TRIP-MIB", "tripNotifApplIndex"), ("TRIP-MIB", "tripNotifPeerAddrInetType"), ("TRIP-MIB", "tripNotifPeerAddr"), ("TRIP-MIB", "tripNotifPeerErrCode"), ("TRIP-MIB", "tripNotifPeerErrSubcode"), ("TRIP-MIB", "tripPeerState"),))
if mibBuilder.loadTexts: tripHoldTimerExpired.setDescription('The system does not receive successive messages within\n            the period specified by the negotiated Hold Time.')
tripConnectionCollision = NotificationType((1, 3, 6, 1, 2, 1, 116, 0, 7)).setObjects(*(("TRIP-MIB", "tripNotifApplIndex"),))
if mibBuilder.loadTexts: tripConnectionCollision.setDescription('A pair of LSs tried to simultaneously to establish a\n            transport connection to each other.')
tripCease = NotificationType((1, 3, 6, 1, 2, 1, 116, 0, 8)).setObjects(*(("TRIP-MIB", "tripNotifApplIndex"), ("TRIP-MIB", "tripNotifPeerAddrInetType"), ("TRIP-MIB", "tripNotifPeerAddr"), ("TRIP-MIB", "tripNotifPeerErrCode"), ("TRIP-MIB", "tripNotifPeerErrSubcode"), ("TRIP-MIB", "tripPeerState"),))
if mibBuilder.loadTexts: tripCease.setDescription('A TRIP peer MAY choose at any given time to close its TRIP\n            connection by sending this notification message. However,\n            the Cease notification message MUST NOT be used when a\n            fatal error occurs.')
tripNotificationErr = NotificationType((1, 3, 6, 1, 2, 1, 116, 0, 9)).setObjects(*(("TRIP-MIB", "tripNotifApplIndex"),))
if mibBuilder.loadTexts: tripNotificationErr.setDescription('Generated if there is an error detected in a TRIP\n            notification message sent with another cause. Note that\n            the TRIP notification referred to in this object is not\n            an SNMP notification, it is a specific message described\n            in the TRIP specification.')
tripMIBFullCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 116, 2, 1, 1)).setObjects(*(("TRIP-MIB", "tripConfigGroup"), ("TRIP-MIB", "tripPeerTableConfigGroup"), ("TRIP-MIB", "tripRouteGroup"), ("TRIP-MIB", "tripItadTopologyGroup"), ("TRIP-MIB", "tripPeerTableStatsGroup"), ("TRIP-MIB", "tripNotificationGroup"), ("TRIP-MIB", "tripNotifObjectGroup"), ("NETWORK-SERVICES-MIB", "applRFC2788Group"),))
if mibBuilder.loadTexts: tripMIBFullCompliance.setDescription('The compliance statement for TRIP entities that\n             implement this MIB module in read-write mode, such\n             that it can be used for both monitoring and configuring\n             the TRIP entity.\n\n             There is one INDEX object that cannot be represented in\n             the form of OBJECT clauses in SMIv2, but for which there\n             is a compliance requirement, expressed in OBJECT clause\n             form in this description:\n\n             -- OBJECT      tripRouteTypeAddrInetType\n             -- SYNTAX      InetAddressType (ipv4(1), ipv6(2),\n             --                              ipv4z(3), ipv6z(4))\n             -- DESCRIPTION\n             --     This MIB requires support for global and\n             --     non-global ipv4 and ipv6 addresses.\n             --\n             -- OBJECT      tripRouteTypeAddr\n             -- SYNTAX      InetAddress (SIZE (4 | 8 | 16 | 20))\n             -- DESCRIPTION\n             --     This MIB requires support for global and\n             --     non-global IPv4 and IPv6 addresses.\n             --\n             ')
tripMIBReadOnlyCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 116, 2, 1, 2)).setObjects(*(("TRIP-MIB", "tripConfigGroup"), ("TRIP-MIB", "tripPeerTableConfigGroup"), ("TRIP-MIB", "tripRouteGroup"), ("TRIP-MIB", "tripItadTopologyGroup"), ("TRIP-MIB", "tripPeerTableStatsGroup"), ("TRIP-MIB", "tripNotificationGroup"), ("TRIP-MIB", "tripNotifObjectGroup"), ("NETWORK-SERVICES-MIB", "applRFC2788Group"),))
if mibBuilder.loadTexts: tripMIBReadOnlyCompliance.setDescription('The compliance statement for TRIP entities that\n             implement this MIB module in read only mode. Such TRIP\n             entities can then only be monitored, but not be\n             configured via this MIB module.\n\n             In read-only mode, the manager will not be able to add,\n             remove or modify rows to any table, however the TRIP\n             application may modify, remove or add rows to a table.\n\n             There is one INDEX object that cannot be represented in\n             the form of OBJECT clauses in SMIv2, but for which there\n             is a compliance requirement, expressed in OBJECT clause\n             form in this description:\n\n             -- OBJECT      tripRouteTypeAddrInetType\n             -- SYNTAX      InetAddressType (ipv4(1), ipv6(2),\n             --                              ipv4z(3), ipv6z(4))\n             -- DESCRIPTION\n             --     This MIB requires support for global and\n             --     non-global ipv4 and ipv6 addresses.\n             --\n             -- OBJECT      tripRouteTypeAddr\n             -- SYNTAX      InetAddress (SIZE (4 | 8 | 16 | 20))\n             -- DESCRIPTION\n             --     This MIB requires support for global and\n\n\n\n             --     non-global IPv4 and IPv6 addresses.\n             --\n             ')
tripConfigGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 116, 2, 2, 1)).setObjects(*(("TRIP-MIB", "tripCfgProtocolVersion"), ("TRIP-MIB", "tripCfgItad"), ("TRIP-MIB", "tripCfgIdentifier"), ("TRIP-MIB", "tripCfgOperStatus"), ("TRIP-MIB", "tripCfgAdminStatus"), ("TRIP-MIB", "tripCfgAddrIAddrType"), ("TRIP-MIB", "tripCfgAddr"), ("TRIP-MIB", "tripCfgPort"), ("TRIP-MIB", "tripCfgMinItadOriginationInterval"), ("TRIP-MIB", "tripCfgMinRouteAdvertisementInterval"), ("TRIP-MIB", "tripCfgMaxPurgeTime"), ("TRIP-MIB", "tripCfgDisableTime"), ("TRIP-MIB", "tripCfgSendReceiveMode"), ("TRIP-MIB", "tripCfgStorage"), ("TRIP-MIB", "tripSupportedCommunityItad"), ("TRIP-MIB", "tripSupportedCommunityStorage"), ("TRIP-MIB", "tripRouteTypePeer"), ("TRIP-MIB", "tripSupportedCommunityRowStatus"),))
if mibBuilder.loadTexts: tripConfigGroup.setDescription('The global objects for configuring trip.')
tripPeerTableConfigGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 116, 2, 2, 2)).setObjects(*(("TRIP-MIB", "tripPeerIdentifier"), ("TRIP-MIB", "tripPeerState"), ("TRIP-MIB", "tripPeerAdminStatus"), ("TRIP-MIB", "tripPeerNegotiatedVersion"), ("TRIP-MIB", "tripPeerSendReceiveMode"), ("TRIP-MIB", "tripPeerRemoteItad"), ("TRIP-MIB", "tripPeerConnectRetryInterval"), ("TRIP-MIB", "tripPeerMaxRetryInterval"), ("TRIP-MIB", "tripPeerHoldTime"), ("TRIP-MIB", "tripPeerKeepAlive"), ("TRIP-MIB", "tripPeerHoldTimeConfigured"), ("TRIP-MIB", "tripPeerKeepAliveConfigured"), ("TRIP-MIB", "tripPeerMaxPurgeTime"), ("TRIP-MIB", "tripPeerDisableTime"), ("TRIP-MIB", "tripPeerLearned"), ("TRIP-MIB", "tripPeerStorage"), ("TRIP-MIB", "tripPeerRowStatus"),))
if mibBuilder.loadTexts: tripPeerTableConfigGroup.setDescription('The global objects for configuring the TRIP peer\n            table.')
tripPeerTableStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 116, 2, 2, 3)).setObjects(*(("TRIP-MIB", "tripPeerInUpdates"), ("TRIP-MIB", "tripPeerOutUpdates"), ("TRIP-MIB", "tripPeerInTotalMessages"), ("TRIP-MIB", "tripPeerOutTotalMessages"), ("TRIP-MIB", "tripPeerFsmEstablishedTransitions"), ("TRIP-MIB", "tripPeerFsmEstablishedTime"), ("TRIP-MIB", "tripPeerInUpdateElapsedTime"), ("TRIP-MIB", "tripPeerStateChangeTime"),))
if mibBuilder.loadTexts: tripPeerTableStatsGroup.setDescription('The global statistics the TRIP peer table.')
tripRouteGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 116, 2, 2, 4)).setObjects(*(("TRIP-MIB", "tripRouteTRIBMask"), ("TRIP-MIB", "tripRouteAddressSequenceNumber"), ("TRIP-MIB", "tripRouteAddressOriginatorId"), ("TRIP-MIB", "tripRouteNextHopServerIAddrType"), ("TRIP-MIB", "tripRouteNextHopServer"), ("TRIP-MIB", "tripRouteNextHopServerPort"), ("TRIP-MIB", "tripRouteNextHopServerItad"), ("TRIP-MIB", "tripRouteMultiExitDisc"), ("TRIP-MIB", "tripRouteLocalPref"), ("TRIP-MIB", "tripRouteAdvertisementPath"), ("TRIP-MIB", "tripRouteRoutedPath"), ("TRIP-MIB", "tripRouteAtomicAggregate"), ("TRIP-MIB", "tripRouteUnknown"), ("TRIP-MIB", "tripRouteWithdrawn"), ("TRIP-MIB", "tripRouteConverted"), ("TRIP-MIB", "tripRouteReceivedTime"), ("TRIP-MIB", "tripRouteCommunityItad"),))
if mibBuilder.loadTexts: tripRouteGroup.setDescription('The global objects for configuring route attribute.')
tripItadTopologyGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 116, 2, 2, 5)).setObjects(*(("TRIP-MIB", "tripItadTopologySeqNum"), ("TRIP-MIB", "tripItadTopologyId"),))
if mibBuilder.loadTexts: tripItadTopologyGroup.setDescription('The objects that define the TRIP ITAD topology.')
tripNotificationGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 116, 2, 2, 6)).setObjects(*(("TRIP-MIB", "tripConnectionEstablished"), ("TRIP-MIB", "tripConnectionDropped"), ("TRIP-MIB", "tripFSM"), ("TRIP-MIB", "tripOpenMessageError"), ("TRIP-MIB", "tripUpdateMessageError"), ("TRIP-MIB", "tripHoldTimerExpired"), ("TRIP-MIB", "tripConnectionCollision"), ("TRIP-MIB", "tripCease"), ("TRIP-MIB", "tripNotificationErr"),))
if mibBuilder.loadTexts: tripNotificationGroup.setDescription('A collection of notifications defined for TRIP.')
tripNotifObjectGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 116, 2, 2, 7)).setObjects(*(("TRIP-MIB", "tripNotifApplIndex"), ("TRIP-MIB", "tripNotifPeerAddrInetType"), ("TRIP-MIB", "tripNotifPeerAddr"), ("TRIP-MIB", "tripNotifPeerErrCode"), ("TRIP-MIB", "tripNotifPeerErrSubcode"),))
if mibBuilder.loadTexts: tripNotifObjectGroup.setDescription('The collection of objects that specify information for\n            TRIP notifications.')
mibBuilder.exportSymbols("TRIP-MIB", tripPeerOutUpdates=tripPeerOutUpdates, tripSupportedCommunityStorage=tripSupportedCommunityStorage, tripCfgPort=tripCfgPort, tripPeerState=tripPeerState, tripPeerStatisticsTable=tripPeerStatisticsTable, tripPeerInTotalMessages=tripPeerInTotalMessages, tripCfgAddr=tripCfgAddr, tripNotifApplIndex=tripNotifApplIndex, tripPeerTableStatsGroup=tripPeerTableStatsGroup, tripPeerHoldTime=tripPeerHoldTime, tripPeerTableConfigGroup=tripPeerTableConfigGroup, tripRouteTypeAddr=tripRouteTypeAddr, tripCfgProtocolVersion=tripCfgProtocolVersion, tripSupportedCommunityEntry=tripSupportedCommunityEntry, tripPeerOutTotalMessages=tripPeerOutTotalMessages, tripCfgItad=tripCfgItad, tripRouteAdvertisementPath=tripRouteAdvertisementPath, tripPeerLearned=tripPeerLearned, tripRouteEntry=tripRouteEntry, tripPeerInUpdateElapsedTime=tripPeerInUpdateElapsedTime, tripCfgMaxPurgeTime=tripCfgMaxPurgeTime, tripItadTopologyTable=tripItadTopologyTable, tripPeerRemoteAddr=tripPeerRemoteAddr, tripSupportedCommunityId=tripSupportedCommunityId, tripCfgIdentifier=tripCfgIdentifier, tripPeerKeepAliveConfigured=tripPeerKeepAliveConfigured, tripNotificationErr=tripNotificationErr, tripRouteNextHopServerIAddrType=tripRouteNextHopServerIAddrType, tripRouteGroup=tripRouteGroup, tripRouteTable=tripRouteTable, tripRouteMultiExitDisc=tripRouteMultiExitDisc, tripRouteNextHopServerItad=tripRouteNextHopServerItad, tripMIBObjects=tripMIBObjects, tripRouteCommunityId=tripRouteCommunityId, tripConnectionDropped=tripConnectionDropped, tripPeerFsmEstablishedTime=tripPeerFsmEstablishedTime, tripNotificationGroup=tripNotificationGroup, tripRouteNextHopServerPort=tripRouteNextHopServerPort, tripPeerInUpdates=tripPeerInUpdates, tripPeerSendReceiveMode=tripPeerSendReceiveMode, tripMIBConformance=tripMIBConformance, tripRouteTypeTable=tripRouteTypeTable, tripRouteUnknown=tripRouteUnknown, tripConnectionEstablished=tripConnectionEstablished, tripCease=tripCease, tripMIBGroups=tripMIBGroups, tripNotifPeerErrCode=tripNotifPeerErrCode, tripPeerNegotiatedVersion=tripPeerNegotiatedVersion, tripCfgAdminStatus=tripCfgAdminStatus, PYSNMP_MODULE_ID=tripMIB, tripRouteAddressOriginatorId=tripRouteAddressOriginatorId, tripUpdateMessageError=tripUpdateMessageError, tripRouteAddress=tripRouteAddress, tripPeerTable=tripPeerTable, tripItadTopologySeqNum=tripItadTopologySeqNum, tripRouteLocalPref=tripRouteLocalPref, tripRouteTypeAddrFamilyId=tripRouteTypeAddrFamilyId, tripItadTopologyGroup=tripItadTopologyGroup, tripMIBReadOnlyCompliance=tripMIBReadOnlyCompliance, tripRouteCommunityItad=tripRouteCommunityItad, tripMIBFullCompliance=tripMIBFullCompliance, tripPeerMaxPurgeTime=tripPeerMaxPurgeTime, tripRouteReceivedTime=tripRouteReceivedTime, tripRouteAtomicAggregate=tripRouteAtomicAggregate, tripFSM=tripFSM, tripRouteAddressFamily=tripRouteAddressFamily, tripRouteAppProtocol=tripRouteAppProtocol, tripPeerMaxRetryInterval=tripPeerMaxRetryInterval, tripRouteTypeProtocolId=tripRouteTypeProtocolId, tripMIBCompliances=tripMIBCompliances, tripNotifPeerErrSubcode=tripNotifPeerErrSubcode, tripConfigGroup=tripConfigGroup, tripPeerIdentifier=tripPeerIdentifier, tripItadTopologyIdEntry=tripItadTopologyIdEntry, tripPeerDisableTime=tripPeerDisableTime, tripCfgTable=tripCfgTable, tripPeerRowStatus=tripPeerRowStatus, tripNotifPeerAddr=tripNotifPeerAddr, tripNotifPeerAddrInetType=tripNotifPeerAddrInetType, tripPeerRemoteAddrInetType=tripPeerRemoteAddrInetType, tripRouteNextHopServer=tripRouteNextHopServer, tripRouteWithdrawn=tripRouteWithdrawn, tripSupportedCommunityRowStatus=tripSupportedCommunityRowStatus, tripRouteCommunityEntry=tripRouteCommunityEntry, tripCfgSendReceiveMode=tripCfgSendReceiveMode, tripPeerStatisticsEntry=tripPeerStatisticsEntry, tripPeerRemotePort=tripPeerRemotePort, tripRouteAddressSequenceNumber=tripRouteAddressSequenceNumber, tripItadTopologyIdTable=tripItadTopologyIdTable, tripPeerStorage=tripPeerStorage, tripPeerRemoteItad=tripPeerRemoteItad, tripPeerStateChangeTime=tripPeerStateChangeTime, tripRouteTRIBMask=tripRouteTRIBMask, tripCfgDisableTime=tripCfgDisableTime, tripRouteTypePort=tripRouteTypePort, tripPeerHoldTimeConfigured=tripPeerHoldTimeConfigured, tripRouteTypeEntry=tripRouteTypeEntry, tripCfgOperStatus=tripCfgOperStatus, tripCfgStorage=tripCfgStorage, tripHoldTimerExpired=tripHoldTimerExpired, tripMIB=tripMIB, tripCfgMinRouteAdvertisementInterval=tripCfgMinRouteAdvertisementInterval, tripRouteRoutedPath=tripRouteRoutedPath, tripPeerKeepAlive=tripPeerKeepAlive, tripCfgMinItadOriginationInterval=tripCfgMinItadOriginationInterval, tripMIBNotifObjects=tripMIBNotifObjects, tripSupportedCommunityTable=tripSupportedCommunityTable, tripPeerFsmEstablishedTransitions=tripPeerFsmEstablishedTransitions, tripConnectionCollision=tripConnectionCollision, tripMIBNotifications=tripMIBNotifications, tripItadTopologyOrigId=tripItadTopologyOrigId, tripPeerConnectRetryInterval=tripPeerConnectRetryInterval, tripCfgEntry=tripCfgEntry, tripItadTopologyEntry=tripItadTopologyEntry, tripRoutePeer=tripRoutePeer, tripRouteTypePeer=tripRouteTypePeer, tripOpenMessageError=tripOpenMessageError, tripNotifObjectGroup=tripNotifObjectGroup, tripPeerAdminStatus=tripPeerAdminStatus, tripRouteConverted=tripRouteConverted, tripPeerEntry=tripPeerEntry, tripRouteTypeAddrInetType=tripRouteTypeAddrInetType, tripItadTopologyId=tripItadTopologyId, tripCfgAddrIAddrType=tripCfgAddrIAddrType, tripSupportedCommunityItad=tripSupportedCommunityItad, tripRouteCommunityTable=tripRouteCommunityTable)
