/***************************************************************************
 *   Copyright (C) 2005 by Johan Maes   *
 *   on4qz@telenet.be   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 *                                                                         *
 *   In addition, as a special exception, the copyright holders give       *
 *   permission to link the code of this program with any edition of       *
 *   the Qt library by Trolltech AS, Norway (or with modified versions     *
 *   of Qt that use the same license as Qt), and distribute linked         *
 *   combinations including the two.  You must obey the GNU General        *
 *   Public License in all respects for all of the code used other than    *
 *   Qt.  If you modify this file, you may extend this exception to        *
 *   your version of the file, but you are not obligated to do so.  If     *
 *   you do not wish to do so, delete this exception statement from        *
 *   your version.                                                         *
 ***************************************************************************/
#include "modergb.h"

modeRGB::modeRGB(esstvMode m,unsigned int len, bool tx):modeBase(m,len,tx)
{
}

#define MODERGBDEBUG

modeRGB::~modeRGB()
{
}

void modeRGB::setupParams(double clock)
{
	visibleLineLength=(lineLength(mode,clock)-fp-bp-2*blank-syncDuration)/3.;
}


modeBase::embState modeRGB::rxSetupLine()
{	

  start=lineTimeTableRX[lineCounter];
  switch(subLine)
		{
			case 0:
				calcPixelPositionTable(REDLINE,false);
				pixelArrayPtr=redArrayPtr;
				return MBPIXELS;
			case 1:
				debugState=stG1;
				marker=(unsigned int)round(start+blank+visibleLineLength);
				return MBRXWAIT;
			case 2:
				calcPixelPositionTable(GREENLINE,false);
				pixelArrayPtr=greenArrayPtr;
				return MBPIXELS;
			case 3:
				debugState=stG1;
				marker=(unsigned int)round(start+2*blank+2*visibleLineLength);
				return MBRXWAIT;				
			case 4:
				calcPixelPositionTable(BLUELINE,false);
				pixelArrayPtr=blueArrayPtr;
				return MBPIXELS;
			case 5:
				debugState=stFP;
				marker=(unsigned int)round(start+2*blank+3*visibleLineLength+fp);
				return MBRXWAIT;				
			case 6:
				debugState=stSync;
        syncPosition=(unsigned int)round(lineTimeTableRX[lineCounter+1]-bp);
				return MBSYNC;
			case 7:
				debugState=stBP;
        marker=(unsigned int)round(lineTimeTableRX[lineCounter+1]);
				return MBRXWAIT;				
			default:
				return MBENDOFLINE;
		}
}

void modeRGB::calcPixelPositionTable(unsigned int colorLine,bool tx)
{
	unsigned int i;
	int ofx=0;
	if(tx) ofx=1;
	debugState=colorLine;
	switch (colorLine)
		{
			case REDLINE:
				start+=bp;
			break;
			case GREENLINE:
				start+=bp+blank+visibleLineLength;
			break;
			case BLUELINE:
				start+=bp+2.*blank+2.*visibleLineLength;
			break;
		}
  for(i=0;i<activeSSTVParam->numberOfPixels;i++)
		{
      pixelPositionTable[i]=(unsigned int)round(start+(((float)(i+ofx)*visibleLineLength)/activeSSTVParam->numberOfPixels));

		}
}

modeBase::embState modeRGB::txSetupLine()
{
  start=lineTimeTableTX[lineCounter];
  switch(subLine)
		{
			case 0:
				calcPixelPositionTable(REDLINE,true);
				pixelArrayPtr=redArrayPtr;
				return MBPIXELS;
			case 1:
				txFreq=1500.;
				txDur=(unsigned int)rint(blank);
				return MBTXGAP;
			case 2:
				calcPixelPositionTable(GREENLINE,true);
				pixelArrayPtr=greenArrayPtr;
				return MBPIXELS;
			case 3:
				txFreq=1500.;
				txDur=(unsigned int)rint(blank);
				return MBTXGAP;
			case 4:
				calcPixelPositionTable(BLUELINE,true);
				pixelArrayPtr=blueArrayPtr;
				return MBPIXELS;
			case 5:
				txFreq=1500;
				txDur=(unsigned int)rint(fp);
				return MBTXGAP;
			case 6:
				txFreq=1200;
				txDur=(unsigned int)rint(syncDuration);
				return MBTXGAP;
			case 7:
				txFreq=1500;
				txDur=(unsigned int)rint(bp);
				return MBTXGAP;
			default:
				return MBENDOFLINE;
		}
}

