
# QuantLib: the free/open-source library for quantitative finance

[![Download](https://img.shields.io/github/v/release/lballabio/QuantLib?label=Download&sort=semver)](https://github.com/lballabio/QuantLib/releases/latest)
[![Licensed under the BSD 3-Clause License](https://img.shields.io/badge/License-BSD--3--Clause-blue.svg)](https://github.com/lballabio/QuantLib/blob/master/LICENSE.TXT)
[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.1440997.svg)](https://doi.org/10.5281/zenodo.1440997)
[![PRs Welcome](https://img.shields.io/badge/PRs%20-welcome-brightgreen.svg)](https://github.com/lballabio/QuantLib/blob/master/CONTRIBUTING.md)

[![Linux build status](https://github.com/lballabio/QuantLib/workflows/Linux%20build/badge.svg?branch=master)](https://github.com/lballabio/QuantLib/actions?query=workflow%3A%22Linux+build%22)
[![Windows build status](https://ci.appveyor.com/api/projects/status/bmpiucu74eldfkm0/branch/master?svg=true)](https://ci.appveyor.com/project/lballabio/quantlib/branch/master)
[![Mac OS build status](https://github.com/lballabio/QuantLib/workflows/Mac%20OS%20build/badge.svg?branch=master)](https://github.com/lballabio/QuantLib/actions?query=workflow%3A%22Mac+OS+build%22)
[![CMake build status](https://github.com/lballabio/QuantLib/workflows/CMake%20build/badge.svg?branch=master)](https://github.com/lballabio/QuantLib/actions?query=workflow%3A%22CMake+build%22)

[![Codacy Badge](https://app.codacy.com/project/badge/Grade/b4bc1058db994f24aa931b119a885eea)](https://www.codacy.com/gh/lballabio/QuantLib/dashboard)
[![Coverage Status](https://coveralls.io/repos/github/lballabio/QuantLib/badge.svg?branch=master)](https://coveralls.io/github/lballabio/QuantLib?branch=master)

---

The QuantLib project (<https://www.quantlib.org>) is aimed at providing a
comprehensive software framework for quantitative finance. QuantLib is
a free/open-source library for modeling, trading, and risk management
in real-life.

QuantLib is Non-Copylefted Free Software and OSI Certified Open Source
Software.


## Download and usage

QuantLib can be downloaded from <https://www.quantlib.org/download.shtml>;
installation instructions are available at
<https://www.quantlib.org/install.shtml> for most platforms.

Documentation for the usage and the design of the QuantLib library is
available from <https://www.quantlib.org/docs.shtml>.

A list of changes for each past versions of the library can be
browsed at <https://www.quantlib.org/reference/history.html>.


## Questions and feedback

The preferred channel for questions (and the one with the largest
audience) is the quantlib-users mailing list.  Instructions for
subscribing are at <https://www.quantlib.org/mailinglists.shtml>.

Bugs can be reported as a GitHub issue at
<https://github.com/lballabio/QuantLib/issues>; if you have a patch
available, you can open a pull request instead (see "Contributing"
below).


## Contributing

Contributions are very welcome!  Details are in
[CONTRIBUTING.md](https://github.com/lballabio/QuantLib/blob/master/CONTRIBUTING.md)

