% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dpt.r
\docType{class}
\name{DPT-class}
\alias{DPT-class}
\alias{DPT}
\title{Diffusion Pseudo Time}
\usage{
DPT(dm, tips = random_root(dm), ..., w_width = 0.1)
}
\arguments{
\item{dm}{A \code{\link{DiffusionMap}} object. Its transition probabilities will be used to calculate the DPT}

\item{tips}{The cell index/indices from which to calculate the DPT(s) (integer of length 1-3)}

\item{...}{Unused. All parameters to the right of the \code{...} have to be specified by name (e.g. \code{DPT(dm, w_width = 0.2)})}

\item{w_width}{Window width to use for deciding the branch cutoff}
}
\value{
A \code{DPT} object:
}
\description{
Create pseudotime ordering and assigns cell to one of three branches
}
\details{
Treat it as a matrix of pseudotime by subsetting (\code{\link[=dim.DPT]{[ dim nrow ncol}} \code{\link[=as.matrix.DPT]{as.matrix}}), and as a list of pseudodime, and expression vectors (\code{\link[=names.DPT]{$ [[ names}} \code{\link[=as.data.frame.DPT]{as.data.frame}}).
}
\section{Slots}{

\describe{
\item{\code{branch}}{\code{\link[base]{matrix}} (of \code{\link[base]{integer}}) recursive branch labels for each cell (row); \code{NA} for undeceided. Use \code{\link{branch_divide}} to modify this.}

\item{\code{tips}}{\code{\link[base]{matrix}} (of \code{\link[base]{logical}}) indicating if a cell (row) is a tip of the corresponding banch level (col)}

\item{\code{dm}}{\code{\link{DiffusionMap}} used to create this DPT object}
}}

\examples{
data(guo_norm)
dm <- DiffusionMap(guo_norm)
dpt <- DPT(dm)
str(dpt)

}
