% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/310-extractDrugAutocorrelationPolarizability.R
\name{extractDrugAutocorrelationPolarizability}
\alias{extractDrugAutocorrelationPolarizability}
\title{Calculate the Moreau-Broto Autocorrelation Descriptors using Polarizability}
\usage{
extractDrugAutocorrelationPolarizability(molecules, silent = TRUE)
}
\arguments{
\item{molecules}{Parsed molucule object.}

\item{silent}{Logical. Whether the calculating process
should be shown or not, default is \code{TRUE}.}
}
\value{
A data frame, each row represents one of the molecules,
each column represents one feature. This function returns 5 columns named
\code{ATSp1}, \code{ATSp2}, \code{ATSp3}, \code{ATSp4}, \code{ATSp5}.
}
\description{
Calculate the Moreau-Broto Autocorrelation Descriptors using Polarizability
}
\details{
Calculates the ATS autocorrelation descriptor using polarizability.
}
\examples{
smi = system.file('vignettedata/FDAMDD.smi', package = 'Rcpi')
\donttest{
mol = readMolFromSmi(smi, type = 'mol')
dat = extractDrugAutocorrelationPolarizability(mol)
head(dat)}
}
\author{
Nan Xiao <\url{https://nanx.me}>
}
\keyword{Autocorrelation}
\keyword{Polarizability}
\keyword{extractDrugAutocorrelationPolarizability}
