% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hierarchyMethods.R
\docType{methods}
\name{hier}
\alias{hier}
\alias{hier,genind-method}
\alias{hier,genlight-method}
\alias{hier<-}
\alias{hier<-,genind-method}
\alias{hier<-,genlight-method}
\title{Access and manipulate the population hierarchy for genind or genlight objects.}
\usage{
hier(x, formula = NULL, combine = TRUE, value)

hier(x) <- value
}
\arguments{
\item{x}{a genind or genlight object}

\item{formula}{a nested formula indicating the order of the population 
hierarchy to be returned.}

\item{combine}{if \code{TRUE} (default), the levels will be combined
according to the formula argument. If it is \code{FALSE}, the levels will
not be combined.}

\item{value}{a formula specifying the full hierarchy of columns in the strata
slot. \strong{(See Details below)}}
}
\description{
The following methods allow the user to quickly change the hierarchy or
population of a genind or genlight object.
}
\details{
You must first specify your strata before you can specify your 
  hierarchies. Hierarchies are special cases of strata in that the levels 
  must be nested within each other. An error will occur if you specify a 
  hierarchy that is not truly hierarchical.
  
  \subsection{Details on Formulas}{
  
  The preferred use of these functions is with a \code{\link{formula}} 
  object. Specifically, a hierarchical formula argument is used to name which
  strata are hierarchical. An example of a hierarchical formula would
  be:\tabular{r}{ \code{~Country/City/Neighborhood}} This convention was
  chosen as it becomes easier to type and makes intuitive sense when defining
  a hierarchy. Note: it is important to use hierarchical formulas when
  specifying hierarchies as other types of formulas (eg. 
  \code{~Country*City*Neighborhood}) will give incorrect results.}
}
\examples{
# let's look at the microbov data set:
data(microbov)
microbov

# We see that we have three vectors of different names in the 'other' slot. 
?microbov
# These are Country, Breed, and Species
names(other(microbov))

# Let's set the hierarchy
strata(microbov) <- data.frame(other(microbov))
microbov

# And change the names so we know what they are
nameStrata(microbov) <- ~Country/Breed/Species

# let's see what the hierarchy looks like by Species and Breed:
hier(microbov) <- ~Species/Breed
head(hier(microbov, ~Species/Breed))

}
\seealso{
\code{\link{strata}} \code{\link{genind}}
  \code{\link{as.genind}}
}
\author{
Zhian N. Kamvar
}
