% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyHtmlTable.R
\name{tidyHtmlTable}
\alias{tidyHtmlTable}
\title{Generate an htmlTable using a ggplot2-like interface}
\usage{
tidyHtmlTable(
  x,
  value = "value",
  header = "header",
  rnames = "rnames",
  rgroup = NULL,
  hidden_rgroup = NULL,
  cgroup1 = NULL,
  cgroup2 = NULL,
  tspanner = NULL,
  hidden_tspanner = NULL,
  ...
)
}
\arguments{
\item{x}{Tidy data used to build the \code{htmlTable}}

\item{value}{The column containing values filling individual cells of the
output \code{htmlTable}}

\item{header}{The column in \code{x} specifying column headings}

\item{rnames}{The column in \code{x} specifying row names}

\item{rgroup}{The column in \code{x} specifying row groups}

\item{hidden_rgroup}{rgroup values that will be hidden.}

\item{cgroup1}{The column in \code{x} specifying the inner most column
groups}

\item{cgroup2}{The column in \code{x} specifying the outer most column
groups}

\item{tspanner}{The column in \code{x} specifying tspanner groups}

\item{hidden_tspanner}{tspanner values that will be hidden.}

\item{...}{Additional arguments that will be passed to the inner
\code{htmlTable} function}
}
\value{
Returns html code that will build a pretty table
}
\description{
Builds an \code{htmlTable} by mapping columns from the input data, \code{x},
to elements of an output \code{htmlTable} (e.g. rnames, header, etc.)
}
\section{Column-mapping parameters}{

  The \code{tidyHtmlTable} function is designed to work like ggplot2 in that
  columns from \code{x} are mapped to specific parameters from the
  \code{htmlTable} function. At minimum, \code{x} must contain the names
  of columns mapping to \code{rnames}, \code{header}, and \code{rnames}.
  \code{header} and \code{rnames} retain the same meaning as in the
  htmlTable function. \code{value} contains the individual values that will
  be used to fill each cell within the output \code{htmlTable}.

  A full list of parameters from \code{htmlTable} which may be mapped to
  columns within \code{x} include:

  \itemize{
    \item \code{value}
    \item \code{header}
    \item \code{rnames}
    \item \code{rgroup}
    \item \code{cgroup1}
    \item \code{cgroup2}
    \item \code{tspanner}
  }

  Note that unlike in \code{htmlTable} which contains \code{cgroup},
  and which may specify a variable number of column groups,
  \code{tidyhtmlTable} contains the parameters \code{cgroup1} and
  \code{cgroup2}. These parameters correspond to the inward most and outward
  most column groups respectively.

  Also note that the coordinates of each \code{value} within \code{x} must be
  unambiguously mapped to a position within the output \code{htmlTable}.
  Therefore, the each row-wise combination the variables specified above
  contained in \code{x} must be unique.
}

\section{Hidden values}{

  \code{htmlTable} Allows for some values within \code{rgroup},
  \code{cgroup}, etc. to be specified as \code{""}. The following parameters
  allow for specific values to be treated as if they were a string of length
  zero in the \code{htmlTable} function.

  \itemize{
    \item \code{hidden_rgroup}
    \item \code{hidden_tspanner}
  }
}

\section{Additional dependencies}{

 In order to run this function you also must have \code{\link[dplyr]{dplyr}} and
 \code{\link[tidyr]{tidyr}} packages installed. These have been removed due to
 the additional 20 Mb that these dependencies added (issue #47). The particular
 functions required are:

 \itemize{
   \item \code{\link[dplyr]{dplyr}}:
   \code{mutate_at},
   \code{select},
   \code{pull},
   \code{slice},
   \code{filter},
   \code{arrange_at},
   \code{mutate_if},
   \code{is.grouped_df},
   \code{left_join}
   \item \code{\link[tidyr]{tidyr}}: \code{spread}
 }
}

\examples{
\dontrun{
library(tidyverse)
mtcars \%>\%
    rownames_to_column \%>\%
    select(rowname, cyl, gear, hp, mpg, qsec) \%>\%
    gather(per_metric, value, hp, mpg, qsec) \%>\%
    group_by(cyl, gear, per_metric) \%>\%
    summarise(Mean = round(mean(value), 1),
              SD = round(sd(value), 1),
              Min = round(min(value), 1),
              Max = round(max(value), 1)) \%>\%
     gather(summary_stat, value, Mean, SD, Min, Max) \%>\%
     ungroup \%>\%
     mutate(gear = paste(gear, "Gears"),
            cyl = paste(cyl, "Cylinders")) \%>\%
     tidyHtmlTable(header = "gear",
                  cgroup1 = "cyl",
                  cell_value = "value",
                  rnames = "summary_stat",
                  rgroup = "per_metric")
}
}
\seealso{
\code{\link{htmlTable}}
}
