% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout.R
\name{miniTabstripPanel}
\alias{miniTabstripPanel}
\alias{miniTabPanel}
\title{Create a tabstrip panel}
\usage{
miniTabstripPanel(..., id = NULL, selected = NULL, between = NULL)

miniTabPanel(title, ..., value = title, icon = NULL)
}
\arguments{
\item{...}{For \code{miniTabstripPanel}, \code{miniTabPanel} elements to
include in the tabset. For \code{miniTabPanel}, UI elements to include
within the tab.}

\item{id}{If provided, you can use \code{input$id} in your
server logic to determine which of the current tabs is active. The value
will correspond to the \code{value} argument that is passed to
\code{\link[=miniTabPanel]{miniTabPanel()}}.}

\item{selected}{The \code{value} (or, if none was supplied, the \code{title})
of the tab that should be selected by default. If \code{NULL}, the first
tab will be selected.}

\item{between}{A tag or list of tags that should be inserted between the
content (above) and tabstrip (below).}

\item{title}{Display title for tab.}

\item{value}{The value that should be sent when \code{miniTabstripPanel}
reports that this tab is selected. If omitted and \code{miniTabstripPanel}
has an \code{id}, then the tab's title will be used as the value.}

\item{icon}{Icon to appear on the tab; see \code{\link[shiny:icon]{shiny::icon()}}.}
}
\description{
\code{miniTabstripPanel} is a tabstrip panel that contains
\code{miniTabPanel} elements. Similar to
\code{\link[shiny:tabsetPanel]{shiny::tabsetPanel()}}, but optimized for small page
sizes like mobile devices or the RStudio Viewer pane.
}
\examples{
library(shiny)

miniTabstripPanel(
  miniTabPanel("Data", icon = icon("table"),
    selectInput("dataset", "Data set", ls("package:datasets"))),
  miniTabPanel("Subset", icon = icon("sliders"),
    uiOutput("subset_ui")
  )
)

}
\seealso{
For more information, see the
\href{http://shiny.rstudio.com/articles/gadget-ui.html}{Designing Gadget UI}
article on shiny.rstudio.com.
}
