% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/SDMXServiceProvider-methods.R
\name{addSDMXServiceProvider}
\alias{addSDMXServiceProvider}
\title{addSDMXServiceProvider}
\usage{
addSDMXServiceProvider(provider)
}
\arguments{
\item{provider}{an object of class "SDMXServiceProvider"}
}
\description{
function that allows configuring a new \link{SDMXServiceProvider}
             as part of the list of providers known by \pkg{rsdmx}, hence by
             \link{readSDMX}
}
\examples{
#create a provider
  myBuilder <- SDMXREST20RequestBuilder(regUrl = "http://www.myorg.org/registry",
                                      repoUrl = "http://www.myorg.org/repository",
                                      compliant = TRUE)
  myProvider <- SDMXServiceProvider(
    agencyId = "MYORG", name = "My Organization",
    builder = myBuilder
  )

  #add it
  addSDMXServiceProvider(myProvider)

  #check out the list of existing provider (only list the agency Ids)
  sapply(slot(getSDMXServiceProviders(), "providers"), function(x){slot(x, "agencyId")})
}
\author{
Emmanuel Blondel, \email{emmanuel.blondel1@gmail.com}
}
\seealso{
\link{getSDMXServiceProviders} \link{findSDMXServiceProvider}
         \link{readSDMX}
}

