% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{methods}
\name{dbConnect,SQLiteDriver-method}
\alias{SQLITE_RO}
\alias{SQLITE_RW}
\alias{SQLITE_RWC}
\alias{dbConnect,SQLiteConnection-method}
\alias{dbConnect,SQLiteDriver-method}
\alias{dbDisconnect,SQLiteConnection-method}
\title{Connect to/disconnect from a SQLite database.}
\usage{
\S4method{dbConnect}{SQLiteDriver}(drv, dbname = "",
  loadable.extensions = TRUE, cache_size = NULL, synchronous = "off",
  flags = SQLITE_RWC, vfs = NULL)

\S4method{dbConnect}{SQLiteConnection}(drv)

\S4method{dbDisconnect}{SQLiteConnection}(conn)
}
\arguments{
\item{drv,conn}{An objected generated by \code{\link{SQLite}}, or an existing
\code{\linkS4class{SQLiteConnection}}. If an connection, the connection
will be cloned.}

\item{dbname}{The path to the database file. There are two special values:

  \itemize{
  \item \code{""}: creates a temporary on-disk database The file will be
     deleted when the connection is closed.
  \item \code{":memory:"}: create a temporary in-memory database.
  }}

\item{loadable.extensions}{When \code{TRUE} (default) SQLite3
loadable extensions are enabled. Setting this value to \code{FALSE}
prevents extensions from being loaded.}

\item{cache_size}{Advanced option. A positive integer to change the maximum
number of disk pages that SQLite holds in memory (SQLite's default is
2000 pages). See \url{http://www.sqlite.org/pragma.html#pragma_cache_size}
for details.}

\item{synchronous}{Advanced options. Possible values for \code{synchronous}
are "off" (the default), "normal", or  "full".  Users have reported
significant speed ups using \code{sychronous = "off"}, and the SQLite
documentation itself implies considerable improved performance at the very
modest risk of database corruption in the unlikely case of the operating
system (\emph{not} the R application) crashing. See
\url{http://www.sqlite.org/pragma.html#pragma_synchronous} for details.}

\item{flags}{\code{SQLITE_RWC}: open the database in read/write mode
and create the database file if it does not already exist;
\code{SQLITE_RW}: open the database in read/write mode. Raise an error
if the file does not already exist; \code{SQLITE_RO}: open the database in
read only mode.  Raise an error if the file does not already exist}

\item{vfs}{Select the SQLite3 OS interface. See
\url{http://www.sqlite.org/vfs.html} for details. Allowed values are
\code{"unix-posix"}, \code{"unix-unix-afp"},
\code{"unix-unix-flock"}, \code{"unix-dotfile"}, and
\code{"unix-none"}.}
}
\description{
Connect to/disconnect from a SQLite database.
}
\examples{
# Create temporary in-memory db
tmp <- dbConnect(SQLite(), ":memory:")
summary(tmp)
dbDisconnect(tmp)

# Create temporary on-disk db with bigger cache and safer synchronisation
tmp <- dbConnect(SQLite(), "", cache_size = 5000, synchronous = "full")
summary(tmp)
dbDisconnect(tmp)
}

