% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-predicates.R
\name{geos_binary_pred}
\alias{geos_binary_pred}
\alias{st_intersects}
\alias{st_disjoint}
\alias{st_touches}
\alias{st_crosses}
\alias{st_within}
\alias{st_contains}
\alias{st_contains_properly}
\alias{st_overlaps}
\alias{st_equals}
\alias{st_covers}
\alias{st_covered_by}
\alias{st_equals_exact}
\alias{st_is_within_distance}
\title{Geometric binary predicates on pairs of simple feature geometry sets}
\usage{
st_intersects(x, y, sparse = TRUE, ...)

st_disjoint(x, y = x, sparse = TRUE, prepared = TRUE, ...)

st_touches(x, y, sparse = TRUE, prepared = TRUE, ...)

st_crosses(x, y, sparse = TRUE, prepared = TRUE, ...)

st_within(x, y, sparse = TRUE, prepared = TRUE, ...)

st_contains(x, y, sparse = TRUE, prepared = TRUE, ..., model = "open")

st_contains_properly(x, y, sparse = TRUE, prepared = TRUE, ...)

st_overlaps(x, y, sparse = TRUE, prepared = TRUE, ...)

st_equals(
  x,
  y,
  sparse = TRUE,
  prepared = FALSE,
  ...,
  retain_unique = FALSE,
  remove_self = FALSE
)

st_covers(x, y, sparse = TRUE, prepared = TRUE, ..., model = "closed")

st_covered_by(x, y = x, sparse = TRUE, prepared = TRUE, ..., model = "closed")

st_equals_exact(x, y, par, sparse = TRUE, prepared = FALSE, ...)

st_is_within_distance(x, y = x, dist, sparse = TRUE, ..., remove_self = FALSE)
}
\arguments{
\item{x}{object of class \code{sf}, \code{sfc} or \code{sfg}}

\item{y}{object of class \code{sf}, \code{sfc} or \code{sfg}; if missing, \code{x} is used}

\item{sparse}{logical; should a sparse index list be returned (\code{TRUE}) or a dense logical matrix? See below.}

\item{...}{
  Arguments passed on to \code{\link[s2:s2_options]{s2::s2_options}}
  \describe{
    \item{\code{snap}}{Use \code{s2_snap_identity()}, \code{s2_snap_distance()}, \code{s2_snap_level()},
or \code{s2_snap_precision()} to specify how or if coordinate rounding should
occur.}
    \item{\code{snap_radius}}{As opposed to the snap function, which specifies
the maximum distance a vertex should move, the snap radius (in radians) sets
the minimum distance between vertices of the output that don't cause vertices
to move more than the distance specified by the snap function. This can be used
to simplify the result of a boolean operation. Use -1 to specify that any
minimum distance is acceptable.}
    \item{\code{duplicate_edges}}{Use \code{TRUE} to keep duplicate edges (e.g., duplicate
points).}
    \item{\code{edge_type}}{One of 'directed' (default) or 'undirected'.}
    \item{\code{validate}}{Use \code{TRUE} to validate the result from the builder.}
    \item{\code{polyline_type}}{One of 'path' (default) or 'walk'. If 'walk',
polylines that backtrack are preserved.}
    \item{\code{polyline_sibling_pairs}}{One of 'discard' (default) or 'keep'.}
    \item{\code{simplify_edge_chains}}{Use \code{TRUE} to remove vertices that are within
\code{snap_radius} of the original vertex.}
    \item{\code{split_crossing_edges}}{Use \code{TRUE} to split crossing polyline edges
when creating geometries.}
    \item{\code{idempotent}}{Use \code{FALSE} to apply snap even if snapping is not necessary
to satisfy vertex constraints.}
    \item{\code{dimensions}}{A combination of 'point', 'polyline', and/or 'polygon'
that can used to constrain the output of \code{\link[s2:s2_rebuild]{s2_rebuild()}} or a
boolean operation.}
  }}

\item{prepared}{logical; prepare geometry for \code{x}, before looping over \code{y}? See Details.}

\item{model}{character; polygon/polyline model; one of
"open", "semi-open" or "closed"; see Details.}

\item{retain_unique}{logical; if \code{TRUE} (and \code{y} is missing) return only indexes of points larger than the current index; this can be used to select unique geometries, see examples. This argument can be used for all geometry predicates; see also \link{distinct.sf} to find records where geometries AND attributes are distinct.}

\item{remove_self}{logical; if \code{TRUE} (and \code{y} is missing) return only indexes of geometries different from the current index; this can be used to omit self-intersections; see examples. This argument can be used for all geometry predicates}

\item{par}{numeric; parameter used for "equals_exact" (margin);}

\item{dist}{distance threshold; geometry indexes with distances smaller or equal to this value are returned; numeric value or units value having distance units.}
}
\value{
If \code{sparse=FALSE}, \code{st_predicate} (with \code{predicate} e.g. "intersects") returns a dense logical matrix with element \code{i,j} equal to \code{TRUE} when \code{predicate(x[i], y[j])} (e.g., when geometry of feature i and j intersect); if \code{sparse=TRUE}, an object of class \code{\link{sgbp}} is returned, which is a sparse list representation of the same matrix, with list element \code{i} an integer vector with all indices \code{j} for which \code{predicate(x[i],y[j])} is \code{TRUE} (and hence a zero-length integer vector if none of them is \code{TRUE}). From the dense matrix, one can find out if one or more elements intersect by \code{apply(mat, 1, any)}, and from the sparse list by \code{lengths(lst) > 0}, see examples below.
}
\description{
Geometric binary predicates on pairs of simple feature geometry sets
}
\details{
If \code{prepared} is \code{TRUE}, and \code{x} contains POINT geometries and \code{y} contains polygons, then the polygon geometries are prepared, rather than the points.

For most predicates, a spatial index is built on argument \code{x}; see \url{https://r-spatial.org/r/2017/06/22/spatial-index.html}.
Specifically, \code{st_intersects}, \code{st_disjoint}, \code{st_touches} \code{st_crosses}, \code{st_within}, \code{st_contains}, \code{st_contains_properly}, \code{st_overlaps}, \code{st_equals}, \code{st_covers} and \code{st_covered_by} all build spatial indexes for more efficient geometry calculations. \code{st_relate}, \code{st_equals_exact}, and do not; \code{st_is_within_distance} uses a spatial index for geographic coordinates when \code{sf_use_s2()} is true.

If \code{y} is missing, \code{st_predicate(x, x)} is effectively called, and a square matrix is returned with diagonal elements \code{st_predicate(x[i], x[i])}.

Sparse geometry binary predicate (\code{\link{sgbp}}) lists have the following attributes: \code{region.id} with the \code{row.names} of \code{x} (if any, else \code{1:n}), \code{ncol} with the number of features in \code{y}, and \code{predicate} with the name of the predicate used.

for \code{model}, see https://github.com/r-spatial/s2/issues/32

\code{st_contains_properly(A,B)} is true if A intersects B's interior, but not its edges or exterior; A contains A, but A does not properly contain A.

See also \link{st_relate} and \url{https://en.wikipedia.org/wiki/DE-9IM} for a more detailed description of the underlying algorithms.

\code{st_equals_exact} returns true for two geometries of the same type and their vertices corresponding by index are equal up to a specified tolerance.
}
\note{
For intersection on pairs of simple feature geometries, use
the function \code{\link{st_intersection}} instead of \code{st_intersects}.
}
\examples{
pts = st_sfc(st_point(c(.5,.5)), st_point(c(1.5, 1.5)), st_point(c(2.5, 2.5)))
pol = st_polygon(list(rbind(c(0,0), c(2,0), c(2,2), c(0,2), c(0,0))))
(lst = st_intersects(pts, pol))
(mat = st_intersects(pts, pol, sparse = FALSE))
# which points fall inside a polygon?
apply(mat, 1, any)
lengths(lst) > 0
# which points fall inside the first polygon?
st_intersects(pol, pts)[[1]]
# remove duplicate geometries:
p1 = st_point(0:1)
p2 = st_point(2:1)
p = st_sf(a = letters[1:8], geom = st_sfc(p1, p1, p2, p1, p1, p2, p2, p1))
st_equals(p)
st_equals(p, remove_self = TRUE)
(u = st_equals(p, retain_unique = TRUE))
# retain the records with unique geometries:
p[-unlist(u),]
}
