% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/password.R
\name{Password storage}
\alias{Password storage}
\alias{password_store}
\alias{password}
\alias{password_verify}
\title{Password Storage}
\usage{
password_store(password)

password_verify(hash, password)
}
\arguments{
\item{password}{a string of length one with a password}

\item{hash}{a hash string of length one generated by \code{password_store}}
}
\description{
Wrapper that implements best practices for storing passwords based on scrypt with
a random salt.
}
\details{
The \link{password_store} function returns an ASCII encoded string which contains
the result of a memory-hard, CPU-intensive hash function along with the automatically
generated salt and other parameters required to verify the password. Use
\link{password_verify} to verify a password from this string.
}
\examples{
# Example password
password <- "I like cookies"

# Hash is what you store in the database
hash <- password_store(password)

# To verify the password when the user logs in
stopifnot(password_verify(hash, password))
}
\references{
\url{http://doc.libsodium.org/password_hashing/}
}
