% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/picor.R
\name{picor}
\alias{picor}
\alias{knots.picor}
\alias{predict.picor}
\alias{plot.picor}
\alias{print.picor}
\title{Piecewise-constant regression}
\usage{
picor(formula, data, method, min_length = 0, ...)

\method{knots}{picor}(Fn, ...)

\method{predict}{picor}(object, newdata, ...)

\method{plot}{picor}(x, ...)

\method{print}{picor}(x, ...)
}
\arguments{
\item{formula}{formula of the model to be fitted.}

\item{data}{optional data frame.}

\item{method}{character. If \code{method = "isotonic"}, then isotonic regression is 
applied with the \code{\link[stats]{isoreg}} from package \pkg{stats}. 
Otherwise, \code{\link[rpart]{rpart}} is used, with the corresponding 
\code{method} argument.}

\item{min_length}{integer. 
The minimal distance between two consecutive knots.}

\item{...}{Additional arguments to be passed to \code{\link[rpart]{rpart}}.}

\item{object, x, Fn}{An object of class \code{"picor"}.}

\item{newdata}{data.frame to be passed to the \code{predict} method.}
}
\value{
An object of class \code{"picor"}, which is a list composed of the 
following elements: 
\itemize{
  \item formula: the formula passed as an argument; 
  \item x: the numeric vector of predictors; 
  \item y: the numeric vector of responses; 
  \item knots: a numeric vector (possibly of length 0), the knots found; 
  \item values: a numeric vector (of length \code{length(knots)+1}), 
  the constant values taken by the regression function between the knots. 
}
}
\description{
\code{picor} looks for a piecewise-constant function as a regression 
function. The regression is necessarily univariate. 
This is essentially a wrapper for \code{\link[rpart]{rpart}} (regression 
tree) and \code{\link[stats]{isoreg}}.
}
\examples{
\dontrun{
s <- stats::stepfun(c(-1,0,1), c(1., 2., 4., 3.))
x <- stats::rnorm(1000)
y <- s(x)
p <- picor(y ~ x, data.frame(x = x, y = y))
print(p)
plot(p)
}

}
