% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/worms_downstream.R
\name{worms_downstream}
\alias{worms_downstream}
\title{Retrieve all taxa names downstream in hierarchy for WORMS}
\usage{
worms_downstream(id, downto, intermediate = FALSE, start = 1, ...)
}
\arguments{
\item{id}{(integer) One or more AphiaID's}

\item{downto}{(character) The taxonomic level you want to go down to.
See examples below. The taxonomic level IS case sensitive, and you do have
to spell it correctly. See \code{data(rank_ref)} for spelling.}

\item{intermediate}{(logical) If \code{TRUE}, return a list of length two
with target taxon rank names, with additional list of data.frame's of
intermediate taxonomic groups. Default: \code{FALSE}}

\item{start}{(integer) Record number to start at}

\item{...}{crul options passed on to \link[crul:verb-GET]{crul::verb-GET}}
}
\value{
data.frame of taxonomic information downstream to family from e.g.,
Order, Class, etc., or if \code{intermediated=TRUE}, list of length two,
with target taxon rank names, and intermediate names.
}
\description{
Retrieve all taxa names downstream in hierarchy for WORMS
}
\examples{
\dontrun{
## the genus Gadus
worms_downstream(id = 125732, downto="species")
worms_downstream(id = 125732, downto="species", intermediate=TRUE)

worms_downstream(id = 51, downto="class")
worms_downstream(id = 51, downto="subclass", intermediate=TRUE)

worms_downstream(id = 105, downto="subclass")
}
}
