// --- Generated by AidaCxxStub ---
#ifndef __RAPICORN_SERVERAPI_HH_
#define __RAPICORN_SERVERAPI_HH_

// includes:
#include <ui/utilities.hh>
#include <ui/clientapi.hh>
namespace Rapicorn {
class WidgetImpl;
class WindowImpl;
}

// --- ServerHH Boilerplate ---
#include <rapicorn-core.hh>

#include <rapicorn-core.hh> // for rcore/signal.hh

// --- Interfaces (class declarations) ---

namespace Rapicorn {

/** @interface ListModel
 * See also the corresponding C++ servant class ListModelIface. */
/// See also the corresponding IDL class ListModel.
class ListModelIface : public virtual Rapicorn::BaseObject
{
protected:
  explicit                               ListModelIface ();
  virtual /*Des*/                       ~ListModelIface () = 0;
public:
  static Rapicorn::Aida::BaseConnection* __aida_connection__();
  Rapicorn::Aida::TypeCode               __aida_type_code__ ()	{ return Rapicorn::Aida::TypeMap::lookup (__aida_type_name__()); }
  virtual std::string                    __aida_type_name__ () const	{ return "Rapicorn::ListModel"; }
  virtual void                           __aida_typelist__ (Rapicorn::Aida::TypeHashList&) const;
  virtual const Rapicorn::Aida::PropertyList& __aida_properties__ ();
  typedef Rapicorn::Aida::Signal<void (const UpdateRequest &urequest)> Signal_updated;
  Signal_updated sig_updated;
  virtual int                           count          () = 0;
  virtual Rapicorn::Aida::Any           row            (int index) = 0;
};
void operator<<= (Rapicorn::Aida::FieldBuffer&, ListModelIface*);
void operator>>= (Rapicorn::Aida::FieldReader&, ListModelIface*&);
ListModelIface* operator->* (ListModelHandle &sh, Rapicorn::Aida::_ServantType);
ListModelHandle operator->* (ListModelIface *obj, Rapicorn::Aida::_HandleType);

/** @interface ListModelRelay
 * See also the corresponding C++ servant class ListModelRelayIface. */
/// See also the corresponding IDL class ListModelRelay.
class ListModelRelayIface : public virtual Rapicorn::BaseObject
{
protected:
  explicit                               ListModelRelayIface ();
  virtual /*Des*/                       ~ListModelRelayIface () = 0;
public:
  static Rapicorn::Aida::BaseConnection* __aida_connection__();
  Rapicorn::Aida::TypeCode               __aida_type_code__ ()	{ return Rapicorn::Aida::TypeMap::lookup (__aida_type_name__()); }
  virtual std::string                    __aida_type_name__ () const	{ return "Rapicorn::ListModelRelay"; }
  virtual void                           __aida_typelist__ (Rapicorn::Aida::TypeHashList&) const;
  virtual const Rapicorn::Aida::PropertyList& __aida_properties__ ();
  typedef Rapicorn::Aida::Signal<void (const UpdateRequest &urequest)> Signal_refill;
  Signal_refill sig_refill;
  virtual ListModelIface*               model               () = 0;
  virtual void                          fill                (int first,
                                                             const AnySeq &asq) = 0;
  virtual void                          update              (const UpdateRequest &urequest) = 0;
};
void operator<<= (Rapicorn::Aida::FieldBuffer&, ListModelRelayIface*);
void operator>>= (Rapicorn::Aida::FieldReader&, ListModelRelayIface*&);
ListModelRelayIface* operator->* (ListModelRelayHandle &sh, Rapicorn::Aida::_ServantType);
ListModelRelayHandle operator->* (ListModelRelayIface *obj, Rapicorn::Aida::_HandleType);

class WidgetIface;

/** @interface Widget
 * See also the corresponding C++ servant class WidgetIface. */
/// See also the corresponding IDL class Widget.
class WidgetIface : public virtual Rapicorn::BaseObject
{
protected:
  explicit                               WidgetIface ();
  virtual /*Des*/                       ~WidgetIface () = 0;
public:
  static Rapicorn::Aida::BaseConnection* __aida_connection__();
  Rapicorn::Aida::TypeCode               __aida_type_code__ ()	{ return Rapicorn::Aida::TypeMap::lookup (__aida_type_name__()); }
  virtual std::string                    __aida_type_name__ () const	{ return "Rapicorn::Widget"; }
  virtual void                           __aida_typelist__ (Rapicorn::Aida::TypeHashList&) const;
  virtual const Rapicorn::Aida::PropertyList& __aida_properties__ ();
  virtual std::string                   name           () const = 0;
  virtual void                          name           (const std::string&) = 0;
  virtual double                        width          () const = 0;
  virtual void                          width          (double) = 0;
  virtual double                        height         () const = 0;
  virtual void                          height         (double) = 0;
  virtual bool                          hexpand        () const = 0;
  virtual void                          hexpand        (bool) = 0;
  virtual bool                          vexpand        () const = 0;
  virtual void                          vexpand        (bool) = 0;
  virtual bool                          hspread        () const = 0;
  virtual void                          hspread        (bool) = 0;
  virtual bool                          vspread        () const = 0;
  virtual void                          vspread        (bool) = 0;
  virtual bool                          hshrink        () const = 0;
  virtual void                          hshrink        (bool) = 0;
  virtual bool                          vshrink        () const = 0;
  virtual void                          vshrink        (bool) = 0;
  virtual bool                          visible        () const = 0;
  virtual void                          visible        (bool) = 0;
  virtual bool                          sensitive      () const = 0;
  virtual void                          sensitive      (bool) = 0;
  virtual double                        hposition      () const = 0;
  virtual void                          hposition      (double) = 0;
  virtual double                        hspan          () const = 0;
  virtual void                          hspan          (double) = 0;
  virtual double                        vposition      () const = 0;
  virtual void                          vposition      (double) = 0;
  virtual double                        vspan          () const = 0;
  virtual void                          vspan          (double) = 0;
  virtual int                           left_spacing   () const = 0;
  virtual void                          left_spacing   (int) = 0;
  virtual int                           right_spacing  () const = 0;
  virtual void                          right_spacing  (int) = 0;
  virtual int                           bottom_spacing () const = 0;
  virtual void                          bottom_spacing (int) = 0;
  virtual int                           top_spacing    () const = 0;
  virtual void                          top_spacing    (int) = 0;
  virtual double                        hanchor        () const = 0;
  virtual void                          hanchor        (double) = 0;
  virtual double                        vanchor        () const = 0;
  virtual void                          vanchor        (double) = 0;
  virtual double                        halign         () const = 0;
  virtual void                          halign         (double) = 0;
  virtual double                        hscale         () const = 0;
  virtual void                          hscale         (double) = 0;
  virtual double                        valign         () const = 0;
  virtual void                          valign         (double) = 0;
  virtual double                        vscale         () const = 0;
  virtual void                          vscale         (double) = 0;
  virtual ColorSchemeType               color_scheme   () const = 0;
  virtual void                          color_scheme   (ColorSchemeType) = 0;
  virtual bool                          match_selector        (const std::string &selector) = 0;
  virtual WidgetIface*                  query_selector        (const std::string &selector) = 0;
  virtual WidgetSeq                     query_selector_all    (const std::string &selector) = 0;
  virtual WidgetIface*                  query_selector_unique (const std::string &selector) = 0;
  virtual std::string                   test_dump             () = 0;
  // class_scope:Widget:
  WidgetImpl&       impl ();
  const WidgetImpl& impl () const;
};
void operator<<= (Rapicorn::Aida::FieldBuffer&, WidgetIface*);
void operator>>= (Rapicorn::Aida::FieldReader&, WidgetIface*&);
WidgetIface* operator->* (WidgetHandle &sh, Rapicorn::Aida::_ServantType);
WidgetHandle operator->* (WidgetIface *obj, Rapicorn::Aida::_HandleType);

/** @interface Container
 * See also the corresponding C++ servant class ContainerIface. */
/// See also the corresponding IDL class Container.
class ContainerIface : public virtual WidgetIface
{
protected:
  explicit                               ContainerIface ();
  virtual /*Des*/                       ~ContainerIface () = 0;
public:
  virtual std::string                    __aida_type_name__ () const	{ return "Rapicorn::Container"; }
  virtual void                           __aida_typelist__ (Rapicorn::Aida::TypeHashList&) const;
  virtual const Rapicorn::Aida::PropertyList& __aida_properties__ ();
  virtual WidgetIface*                  create_child   (const std::string &widget_identifier,
                                                        const StringSeq &args = StringSeq()) = 0;
};
void operator<<= (Rapicorn::Aida::FieldBuffer&, ContainerIface*);
void operator>>= (Rapicorn::Aida::FieldReader&, ContainerIface*&);
ContainerIface* operator->* (ContainerHandle &sh, Rapicorn::Aida::_ServantType);
ContainerHandle operator->* (ContainerIface *obj, Rapicorn::Aida::_HandleType);

/** @interface ButtonArea
 * See also the corresponding C++ servant class ButtonAreaIface. */
/// See also the corresponding IDL class ButtonArea.
class ButtonAreaIface : public virtual ContainerIface
{
protected:
  explicit                               ButtonAreaIface ();
  virtual /*Des*/                       ~ButtonAreaIface () = 0;
public:
  virtual std::string                    __aida_type_name__ () const	{ return "Rapicorn::ButtonArea"; }
  virtual void                           __aida_typelist__ (Rapicorn::Aida::TypeHashList&) const;
  virtual const Rapicorn::Aida::PropertyList& __aida_properties__ ();
  virtual std::string                   on_click  () const = 0;
  virtual void                          on_click  (const std::string&) = 0;
  virtual std::string                   on_click2 () const = 0;
  virtual void                          on_click2 (const std::string&) = 0;
  virtual std::string                   on_click3 () const = 0;
  virtual void                          on_click3 (const std::string&) = 0;
};
void operator<<= (Rapicorn::Aida::FieldBuffer&, ButtonAreaIface*);
void operator>>= (Rapicorn::Aida::FieldReader&, ButtonAreaIface*&);
ButtonAreaIface* operator->* (ButtonAreaHandle &sh, Rapicorn::Aida::_ServantType);
ButtonAreaHandle operator->* (ButtonAreaIface *obj, Rapicorn::Aida::_HandleType);

/** @interface Drawable
 * See also the corresponding C++ servant class DrawableIface. */
/// See also the corresponding IDL class Drawable.
class DrawableIface : public virtual WidgetIface
{
protected:
  explicit                               DrawableIface ();
  virtual /*Des*/                       ~DrawableIface () = 0;
public:
  virtual std::string                    __aida_type_name__ () const	{ return "Rapicorn::Drawable"; }
  virtual void                           __aida_typelist__ (Rapicorn::Aida::TypeHashList&) const;
  virtual const Rapicorn::Aida::PropertyList& __aida_properties__ ();
  typedef Rapicorn::Aida::Signal<void (int x, int y, int w, int h)> Signal_redraw;
  Signal_redraw sig_redraw;
  virtual void                          draw_rect     (int x,
                                                       int y,
                                                       const Pixbuf &pixbuf) = 0;
};
void operator<<= (Rapicorn::Aida::FieldBuffer&, DrawableIface*);
void operator>>= (Rapicorn::Aida::FieldReader&, DrawableIface*&);
DrawableIface* operator->* (DrawableHandle &sh, Rapicorn::Aida::_ServantType);
DrawableHandle operator->* (DrawableIface *obj, Rapicorn::Aida::_HandleType);

/** @interface WidgetList
 * See also the corresponding C++ servant class WidgetListIface. */
/// See also the corresponding IDL class WidgetList.
class WidgetListIface : public virtual ContainerIface
{
protected:
  explicit                               WidgetListIface ();
  virtual /*Des*/                       ~WidgetListIface () = 0;
public:
  virtual std::string                    __aida_type_name__ () const	{ return "Rapicorn::WidgetList"; }
  virtual void                           __aida_typelist__ (Rapicorn::Aida::TypeHashList&) const;
  virtual const Rapicorn::Aida::PropertyList& __aida_properties__ ();
  virtual std::string                   model          () const = 0;
  virtual void                          model          (const std::string&) = 0;
  virtual SelectionMode                 selection_mode () const = 0;
  virtual void                          selection_mode (SelectionMode) = 0;
  virtual void                          set_selection   (const BoolSeq &selection) = 0;
  virtual BoolSeq                       get_selection   () = 0;
  virtual void                          select_range    (int first,
                                                         int length) = 0;
  virtual void                          unselect_range  (int first,
                                                         int length) = 0;
};
void operator<<= (Rapicorn::Aida::FieldBuffer&, WidgetListIface*);
void operator>>= (Rapicorn::Aida::FieldReader&, WidgetListIface*&);
WidgetListIface* operator->* (WidgetListHandle &sh, Rapicorn::Aida::_ServantType);
WidgetListHandle operator->* (WidgetListIface *obj, Rapicorn::Aida::_HandleType);

/** @interface Window
 * See also the corresponding C++ servant class WindowIface. */
/// See also the corresponding IDL class Window.
class WindowIface : public virtual ContainerIface
{
protected:
  explicit                               WindowIface ();
  virtual /*Des*/                       ~WindowIface () = 0;
public:
  virtual std::string                    __aida_type_name__ () const	{ return "Rapicorn::Window"; }
  virtual void                           __aida_typelist__ (Rapicorn::Aida::TypeHashList&) const;
  virtual const Rapicorn::Aida::PropertyList& __aida_properties__ ();
  virtual std::string                   title      () const = 0;
  virtual void                          title      (const std::string&) = 0;
  virtual bool                          auto_focus () const = 0;
  virtual void                          auto_focus (bool) = 0;
  typedef Rapicorn::Aida::AsyncSignal<bool (const std::string &cmdname, const StringSeq &args)> Signal_commands;
  typedef Rapicorn::Aida::Signal<void ()> Signal_displayed;
  Signal_commands sig_commands;
  Signal_displayed sig_displayed;
  virtual bool                          viewable          () = 0;
  virtual void                          show              () = 0;
  virtual bool                          closed            () = 0;
  virtual void                          close             () = 0;
  virtual bool                          snapshot          (const std::string &pngname) = 0;
  virtual bool                          synthesize_click  (WidgetIface &widget,
                                                           int button,
                                                           double xalign = 0.5,
                                                           double yalign = 0.5) = 0;
  virtual bool                          synthesize_enter  (double xalign = 0.5,
                                                           double yalign = 0.5) = 0;
  virtual bool                          synthesize_leave  () = 0;
  virtual bool                          synthesize_delete () = 0;
  // class_scope:Window:
  WindowImpl&       impl ();
  const WindowImpl& impl () const;
};
void operator<<= (Rapicorn::Aida::FieldBuffer&, WindowIface*);
void operator>>= (Rapicorn::Aida::FieldReader&, WindowIface*&);
WindowIface* operator->* (WindowHandle &sh, Rapicorn::Aida::_ServantType);
WindowHandle operator->* (WindowIface *obj, Rapicorn::Aida::_HandleType);

/** @interface Application
 * See also the corresponding C++ servant class ApplicationIface. */
/// See also the corresponding IDL class Application.
class ApplicationIface : public virtual Rapicorn::BaseObject
{
protected:
  explicit                               ApplicationIface ();
  virtual /*Des*/                       ~ApplicationIface () = 0;
public:
  static Rapicorn::Aida::BaseConnection* __aida_connection__();
  Rapicorn::Aida::TypeCode               __aida_type_code__ ()	{ return Rapicorn::Aida::TypeMap::lookup (__aida_type_name__()); }
  virtual std::string                    __aida_type_name__ () const	{ return "Rapicorn::Application"; }
  virtual void                           __aida_typelist__ (Rapicorn::Aida::TypeHashList&) const;
  virtual const Rapicorn::Aida::PropertyList& __aida_properties__ ();
  typedef Rapicorn::Aida::Signal<void ()> Signal_missing_primary;
  Signal_missing_primary sig_missing_primary;
  virtual std::string                   auto_path               (const std::string &file_name,
                                                                 const std::string &binary_path,
                                                                 bool search_vpath = 1) = 0;
  virtual StringSeq                     auto_load               (const std::string &defs_domain,
                                                                 const std::string &file_name,
                                                                 const std::string &binary_path,
                                                                 const std::string &i18n_domain = "") = 0;
  virtual bool                          factory_window          (const std::string &factory_definition);
  virtual void                          load_string             (const std::string &defs_domain,
                                                                 const std::string &xml_string,
                                                                 const std::string &i18n_domain = "") = 0;
  virtual WindowIface*                  create_window           (const std::string &window_identifier,
                                                                 const StringSeq &arguments = StringSeq()) = 0;
  virtual bool                          finishable              ();
  virtual void                          close_all               () = 0;
  virtual WindowIface*                  query_window            (const std::string &selector) = 0;
  virtual WindowList                    query_windows           (const std::string &selector) = 0;
  virtual WindowList                    list_windows            () = 0;
  virtual ListModelRelayIface*          create_list_model_relay (const std::string &name = "") = 0;
  virtual void                          test_counter_set        (int val) = 0;
  virtual void                          test_counter_add        (int val) = 0;
  virtual int                           test_counter_get        () = 0;
  virtual int                           test_counter_inc_fetch  () = 0;
  virtual Rapicorn::Aida::int64         test_hook               () = 0;
  // class_scope:Application:
  static bool            xurl_add   (const String &model_path, ListModelIface &model);
  static bool            xurl_sub   (ListModelIface &model);
  static ListModelIface* xurl_find  (const String &model_path);
  static String          xurl_path  (const ListModelIface &model);
};
void operator<<= (Rapicorn::Aida::FieldBuffer&, ApplicationIface*);
void operator>>= (Rapicorn::Aida::FieldReader&, ApplicationIface*&);
ApplicationIface* operator->* (ApplicationHandle &sh, Rapicorn::Aida::_ServantType);
ApplicationHandle operator->* (ApplicationIface *obj, Rapicorn::Aida::_HandleType);

/** @interface IdlTestWidget
 * See also the corresponding C++ servant class IdlTestWidgetIface. */
/// See also the corresponding IDL class IdlTestWidget.
class IdlTestWidgetIface : public virtual WidgetIface
{
protected:
  explicit                               IdlTestWidgetIface ();
  virtual /*Des*/                       ~IdlTestWidgetIface () = 0;
public:
  virtual std::string                    __aida_type_name__ () const	{ return "Rapicorn::IdlTestWidget"; }
  virtual void                           __aida_typelist__ (Rapicorn::Aida::TypeHashList&) const;
  virtual const Rapicorn::Aida::PropertyList& __aida_properties__ ();
  virtual bool                          bool_prop     () const = 0;
  virtual void                          bool_prop     (bool) = 0;
  virtual int                           int_prop      () const = 0;
  virtual void                          int_prop      (int) = 0;
  virtual double                        float_prop    () const = 0;
  virtual void                          float_prop    (double) = 0;
  virtual std::string                   string_prop   () const = 0;
  virtual void                          string_prop   (const std::string&) = 0;
  virtual TestEnum                      enum_prop     () const = 0;
  virtual void                          enum_prop     (TestEnum) = 0;
  virtual Requisition                   record_prop   () const = 0;
  virtual void                          record_prop   (const Requisition&) = 0;
  virtual StringSeq                     sequence_prop () const = 0;
  virtual void                          sequence_prop (const StringSeq&) = 0;
  virtual IdlTestWidgetIface*           self_prop     () const = 0;
  virtual void                          self_prop     (IdlTestWidgetIface*) = 0;
};
void operator<<= (Rapicorn::Aida::FieldBuffer&, IdlTestWidgetIface*);
void operator>>= (Rapicorn::Aida::FieldReader&, IdlTestWidgetIface*&);
IdlTestWidgetIface* operator->* (IdlTestWidgetHandle &sh, Rapicorn::Aida::_ServantType);
IdlTestWidgetHandle operator->* (IdlTestWidgetIface *obj, Rapicorn::Aida::_HandleType);
} // Rapicorn

// global_scope:
// #define RAPICORN_PIXBUF_TYPE    Rapicorn::Pixbuf
#include <ui/pixmap.hh>
#endif /* __RAPICORN_SERVERAPI_HH_ */
