#include "rheolef.h"
using namespace rheolef;
using namespace std;

size_t N; 
Float u_ex (const point& x) { return 0.5*(x[0]*(1-x[0]) + x[1]*(1-x[1]))/Float(N); }
Float g    (const point& x) { return u_ex(x) - 0.5/N; }

int main(int argc, char**argv) {
  geo omega (argv[1]);
  N = omega.dimension();
  domain boundary = omega["boundary"];
  space Xh (omega, argv[2]);
  space Wh (omega, boundary, argv[2]);
  form a  (Xh, Xh, "grad_grad");
  form ab (Xh, Xh, "mass", boundary);
  a = a + ab;
  form m  (Xh, Xh, "mass");
  form mb (Wh, Xh, "mass") ;
  field fh (Xh, 1);
  field gh = interpolate(Wh, g);
  field uh (Xh);
  if (omega.dimension() < 3) {
    ssk<Float> fact = ldlt(a.uu);
    uh.u = fact.solve(m.uu*fh.u + m.ub*fh.b + mb.uu*gh.u + mb.ub*gh.b - a.ub*uh.b);
  } else {
    size_t max_iter = 10000;
    Float tol = 1e-15;
    uh.u = 0;
    int status = pcg (a.uu, uh.u, m.uu*fh.u + m.ub*fh.b + mb.uu*gh.u + mb.ub*gh.b - a.ub*uh.b,
                  ic0(a.uu), max_iter, tol, &cerr);
  }
  cout << uh;
  return 0;
}
