#!/bin/sh
#
# This file is part of Rheolef.
#
# Copyright (C) 2000-2009 Pierre Saramito 
#
# Rheolef is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Rheolef is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Rheolef; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# -------------------------------------------------------------------------
# =======================================================================
# test read & write HB files with right-hand sides with the hb2hb program
# =======================================================================
# test unitaire
# -------------
# pores1.hb		simple
# 1rhs.hb		un second membre
# 2rhs.hb		deux second membres (origine: nist/harwell_io)
# 6rhs.hb		six seconds membres
# 
# animal
# ------
# aninal-s.hb	un second membre, non triee par j croissant
# aninal-s2.hb	idem, en plus petit
# 
# cerfacs
# -------
# lsq1.hb
# sherman1.hb
# 
# fidap (Y. Saad)
# -----
# FIDAP004.hb	un second membre et une solution exacte 
# FIDAP001.hb	meme chose; variante sans lignes blanches
# ne sont plus utilises pour les tests (gros fichiers...)
if [ x"${GZIP_BIN}" = x"" ]; then  
    echo "can not test since GZIP_BIN is missing" 1>&2  
    exit 0
fi
echo "checking for Harwell-Boeing input-output..."
SRCDIR=${SRCDIR-"."}
TMPDIR=${TMPDIR-"/tmp"}
HB=./csr
HBFLAGS="-hb -rhs -notranspose-in -notranspose-out"
INPUTS=`/bin/ls ${SRCDIR}/in-*.hb.gz`

for g in ${INPUTS}; do
    f=`expr $g : '.*/in-\(.*\).gz'`
    if test $f = pores1.hb; then
        /bin/echo "      $f...(skipped)"
        continue
    fi
    /bin/echo "      $f..."
    tmpin=${TMPDIR}/check-in-$$-${f}
    tmpout=${TMPDIR}/check-out-$$-${f}
    $GZIP_BIN -dc < $g > ${tmpin}
    ${HB} ${HBFLAGS} < ${tmpin} 2>/dev/null > ${tmpout}
    status_i=$?
    /bin/rm -f ${tmpin}
    if test "${status_i}" = "0"; then
        if $GZIP_BIN -dc < ${SRCDIR}/out-$f.gz | diff -c - ${tmpout} > /dev/null ; then
	    true
        else
            echo "        => *NO*"
	    status=1
        fi
    else
        echo "        => *NO*"
	status=1
    fi
    /bin/rm -f ${tmpout}
done
exit $status
