# encoding: utf-8
=begin

* Name: SiSU

** Description: documents, structuring, processing, publishing, search
** xml template

** Author: Ralph Amissah
  <ralph@amissah.com>
  <ralph.amissah@gmail.com>

** Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
  2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015 Ralph Amissah,
  All Rights Reserved.

** License: GPL 3 or later:

  SiSU, a framework for document structuring, publishing and search

  Copyright (C) Ralph Amissah

  This program is free software: you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation, either version 3 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along with
  this program. If not, see <http://www.gnu.org/licenses/>.

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
  <http://www.fsf.org/licensing/licenses/gpl.html>
  <http://www.gnu.org/licenses/gpl.html>

  <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

** SiSU uses:
  * Standard SiSU markup syntax,
  * Standard SiSU meta-markup syntax, and the
  * Standard SiSU object citation numbering and system

** Hompages:
  <http://www.jus.uio.no/sisu>
  <http://www.sisudoc.org>

** Git
  <http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
  <http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=blob;f=lib/sisu/xml_format.rb;hb=HEAD>

=end
module SiSU_XML_Format
  require_relative 'dp'                                 # dp.rb
  require_relative 'xml_parts'                          # xml_parts.rb
  include SiSU_Param
  class ParagraphNumber
    def initialize(md,paranum)
      @md=md
      @paranum=(paranum ? (/(\d+)/m.match(paranum)[1]) : nil)
    end
    def display
      p_num_display=if @paranum
        @paranum.gsub(/(\d+)/,
        '<font size="1" color="#777777">' +
        '&nbsp;&nbsp;\1</font>')
      else ''
      end
      p_num_display
    end
    def name
      p_num_name=@paranum.gsub(/(\d+)/,'<a name="\1"></a>')
      p_num_name
    end
    def goto
      p_num_goto=@paranum.gsub(/(\d+)/,'<a href="#\1">')
      p_num_goto
    end
  end
  class HeadInformation
    include SiSU_Parts_XML
    def initialize #dc rdf
      @full_title=@subtitle=@author=@subject=@description=@publisher=@contributor=@date=@type=@format=@identifier=@source=@language=@relation=@coverage=@rights=@copyright=@owner=@keywords=''
      @md=@@md
      # DublinCore 1 - title
      @rdfurl=%{  rdf:about="http://www.jus.uio.no/lm/toc"\n}
      if defined? @md.title.full \
      and @md.title.full                          # DublinCore 1 - title
        @rdf_title=%{    dc.title="#{seg_name}#{@md.title.full}"\n}
        @full_title=%{<meta name="dc.title" content="#{seg_name}#{@md.title.full}" />\n}
      end
      if defined? @md.creator.author \
      and @md.creator.author                                                  # DublinCore 2 - creator/author (author)
        @rdf_author=%{    dc.author="#{@md.creator.author}"\n}
        @author=%{<meta name="dc.author" content="#{@md.creator.author}" />\n}
      end
      if defined? @md.classify.subject \
      and @md.classify.subject=~/\S+/                                          # DublinCore 3 - subject (us library of congress, eric or udc, or schema???)
        @rdf_subject=%{    dc.subject="#{@md.classify.subject}"\n}
        @subject=%{<meta name="dc.subject" content="#{@md.classify.subject}" />\n}
      end
      if defined? @md.notes.description \
      and @md.notes.description=~/\S+/                                        # DublinCore 4 - description
        @rdf_description=%{    dc.description="#{@md.notes.description}"\n}
        @description=%{<meta name="dc.description" content="#{@md.notes.description}" />\n}
      end
      if defined? @md.publisher \
      and @md.publisher=~/\S+/                                                # DublinCore 5 - publisher (current copy published by)
        @rdf_publisher=%{    dc.publisher="#{@md.publisher}"\n}
        @publisher=%{<meta name="dc.publisher" content="#{@md.publisher}" />\n}
      end
      if defined? @md.creator.contributor \
      and @md.creator.contributor=~/\S+/                                      # DublinCore 6 - contributor
        @rdf_contributor=%{    dc.contributor="#{@md.creator.contributor}"\n}
        @contributor=%{<meta name="dc.contributor" content="#{@md.creator.contributor}" />\n}
      end
      if defined? @md.date.published \
      and @md.date.published                                                  # DublinCore 7 - date year-mm-dd
        @rdf_date=%{    dc.date="#{@md.date.published}"\n}
        @date=%{<meta name="dc.date" content="#{@md.date.published}" #{@md.date_scheme} />\n}
      end
      if defined? @md.date.created \
      and @md.date.created                                                    # DublinCore 7 - date.created year-mm-dd
        @rdf_date_created=%{    dc.date.created="#{@md.date.created}"\n}
        @date_created=%{<meta name="dc.date.created" content="#{@md.date.created}" #{@md.date_created_scheme} />\n}
      end
      if defined? @md.date.issued \
      and @md.date.issued                                                      # DublinCore 7 - date.issued year-mm-dd
        @rdf_date_issued=%{    dc.date.issued="#{@md.date.issued}"\n}
        @date_issued=%{<meta name="dc.date.issued" content="#{@md.date.issued}" #{@md.date_issued_scheme} />\n}
      end
      if defined? @md.date.available \
      and @md.date.available                                                  # DublinCore 7 - date.available year-mm-dd
        @rdf_date_available=%{    dc.date.available="#{@md.date.available}"\n}
        @date_available=%{<meta name="dc.date.available" content="#{@md.date.available}" #{@md.date_available_scheme} />\n}
      end
      if defined? @md.date.valid \
      and @md.date.valid                                                      # DublinCore 7 - date.valid year-mm-dd
        @rdf_date_valid=%{    dc.date.valid="#{@md.date.valid}"\n}
        @date_valid=%{<meta name="dc.date.valid" content="#{@md.date.valid}" #{@md.date_valid_scheme} />\n}
      end
      if defined? @md.date.modified \
      and @md.date.modified                                                   # DublinCore 7 - date.modified year-mm-dd
        @rdf_date_modified=%{    dc.date.modified="#{@md.date.modified}"\n}
        @date_modified=%{<meta name="dc.date.modified" content="#{@md.date.modified}" #{@md.date_modified_scheme} />\n}
      end
      if defined? @md.notes.coverage \
      and @md.notes.coverage=~/\S+/                                        # DublinCore 14 - coverage
        @rdf_coverage=%{    dc.coverage="#{@md.notes.coverage}"\n}
        @coverage=%{<meta name="dc.coverage" content="#{@md.notes.coverage}" />\n}
      end
      if defined? @md.notes.relation \
      and @md.notes.relation=~/\S+/                                         # DublinCore 13 - relation
        @rdf_relation=%{    dc.relation="#{@md.notes.relation}"\n}
        @relation=%{<meta name="dc.relation" content="#{@md.notes.relation}" />\n}
      end
      if defined? @md.notes.type \
      and @md.notes.type                                                            # DublinCore 8 - type (genre eg. report, convention etc)
        @rdf_type=%{    dc.type="#{@md.notes.type}"\n}
        @type=%{<meta name="dc.type" content="#{@md.notes.type}" />\n}
      end
      if defined? @md.notes.format \
      and @md.notes.format=~/\S+/                                              # DublinCore 9 - format (use your mime type)
        @rdf_format=%{    dc.format="#{@md.notes.format}"\n}
        @format=%{<meta name="dc.format" content="#{@md.notes.format}" />\n}
      end
      #if defined? @md.identifier.sisupod \
      #and @md.identifier.sisupod=~/\S+/                                       # DublinCore 10 - identifier (your identifier, could use urn which is free)
      #  @rdf_identifier=%{    dc.identifier="#{@md.identifier.sisupod}"\n}
      #  @identifier=%{<meta name="dc.identifier" content="#{@md.identifier.sisupod}" />\n}
      #end
      if defined? @md.original.source \
      and @md.original.source=~/\S+/                                           # DublinCore 11 - source (document source)
        @rdf_source=%{    dc.source="#{@md.original.source}"\n}
        @source=%{<meta name="dc.source" content="#{@md.source}" />\n}
      end
      if defined? @md.original.language \
      and @md.original.language=~/\S+/                                         # DublinCore 12 - language (English)
        @rdf_language=%{    dc.language="#{@md.original.title}"\n}
        @language=%{<meta name="dc.language" content="#{@md.language[:name]}" />\n}
      end
      if defined? @md.rights.all \
      and @md.rights.all=~/\S+/                                               # DublinCore 15 - rights
        rights=meta_content_clean(@md.rights.all)
        copyright=meta_content_clean(@md.rights.copyright.all)
        @rdf_rights=%{    dc.rights="#{rights}"\n}
        @rights=%{<meta name="dc.rights" content="#{rights}" />\n}
      end
      @copyright=%{<meta name="copyright" content="#{copyright}" />\n} \
        if @md.rights.copyright.all # possibly redundant see dc.rights
      @owner=%{<meta name="owner" content="#{@md.owner}" />\n} if @md.owner
      @keywords=%{<meta name="keywords" content="#{@md.keywords}" />\n} if @md.keywords
      @index='index'
    end
    def meta_content_clean(content='')
      content=if not content.nil?
        content=content.tr('"',"'").
           gsub(/&/,'&amp;')
        content=SiSU_XML_Munge::Trans.new(@md).char_enc.utf8(content)
      else content
      end
    end
    def table_close
      '</font> </td></tr></table>'
    end
    def toc_head
      <<WOK
<html>
<head>
<title>#{@md.html_title}</title>
<rdf:RDF xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
         xmlns:dc="http://purl.org/dc/elements/1.1/">
 <rdf:Description
#{@rdfurl}
#{@rdf_title}
#{@rdf_subtitle}
#{@rdf_author}
#{@rdf_subject}
#{@rdf_description}
#{@rdf_publisher}
#{@rdf_contributor}
#{@rdf_date}
#{@rdf_date_created}
#{@rdf_date_issued}
#{@rdf_date_available}
#{@rdf_date_valid}
#{@rdf_date_modified}
#{@rdf_type}
#{@rdf_format}
#{@rdf_identifier}
#{@rdf_source}
#{@rdf_language}
#{@rdf_relation}
#{@rdf_coverage}
#{@rdf_rights}
  />
</rdf:RDF>
#{@full_title}
#{@author}
#{@subject}
#{@description}
#{@publisher}
#{@contributor}
#{@date}
#{@date_created}
#{@date_issued}
#{@date_available}
#{@date_valid}
#{@date_modified}
#{@type}
#{@format}
#{@identifier}
#{@source}
#{@language}
#{@relation}
#{@coverage}
#{@rights}
#{@copyright}
#{@owner}
#{@png.ico}
#{@txt.generator}
#{@js.head}
\n</head>
#{@color.body}
#{@font.css_table_file}
<a name="top"></a>
<a name="up"></a>
<a name="start"></a>
#{@js.top}
WOK
    end
  end
  class FormatTextObject
    include SiSU_Parts_XML
    attr_accessor :md,:txt,:format,:paranum,:p_num,:para_id,:headname,:font
    def initialize(md,dob)
      @md,@dob=md,dob
      if @dob[:ocn]=~/\d+/
        @paranum=/(\d+)/m.match(@dob[:ocn])[1]
        @headname=''
        @headname=%{<a name="h#{dob.name}"></a>} if defined? dob.name
        @p_num=SiSU_XML_Format::ParagraphNumber.new(@md,dob.ocn)
      end
      rgx=/^[1-6-]~{1,2}/ #watch
      @lnk_url=@lnk_url.gsub(rgx,'') if @lnk_url =~rgx
      rgx=/~\{\d+\s+(.+?)\}~/
      @lnk_url=@lnk_url.gsub(rgx,'\1') if @lnk_url =~rgx
    end
    def scr_endnote_body
      "<endnote>#{@txt}</endnote> "
    end
  end
  class FormatScroll < FormatTextObject
    def initialize(md,dob)
      super(md,dob)
    end
    def heading_body
      %{<p class="norm">#{@p_num.name}#{@headname}#{@dob.obj} </p>} +
      %{<p class="paranum"><font size="1" color="#777777">&nbsp;&nbsp;#{@dob.ocn}</font></p>\n}
    end
    def heading_body0
      %{<h1 class="norm">#{@p_num.name}#{@headname}#{@dob.obj}</h1>} +
      %{<p class="paranum"><font size="1" color="#777777">&nbsp;&nbsp;#{@dob.ocn}</font></p>\n}
    end
    def heading_body1
      %{<h2 class="norm">#{@p_num.name}#{@headname}#{@dob.obj}</h2>} +
      %{<p class="paranum"><font size="1" color="#777777">&nbsp;&nbsp;#{@dob.ocn}</font></p>\n}
    end
    def heading_body2
      %{<h3 class="norm">#{@p_num.name}#{@headname}#{@dob.obj}</h3>} +
      %{<p class="paranum"><font size="1" color="#777777">&nbsp;&nbsp;#{@dob.ocn}</font></p>\n}
    end
    def heading_body3
      %{<h4 class="norm">#{@p_num.name}#{@headname}#{@dob.obj}</h4>} +
      %{<p class="paranum"><font size="1" color="#777777">&nbsp;&nbsp;#{@dob.ocn}</font></p>\n}
    end
    def heading_body4
      %{<h5 class="norm">#{@p_num.name}#{@headname}#{@dob.obj}</h5>} +
      %{<p class="paranum"><font size="1" color="#777777">&nbsp;&nbsp;#{@dob.ocn}</font></p>\n}
    end
    def heading_body5
      %{<h6 class="norm">#{@p_num.name}#{@headname}#{@dob.obj}</h6>} +
      %{<p class="paranum"><font size="1" color="#777777">&nbsp;&nbsp;#{@dob.ocn}</font></p>\n}
    end
    def heading_body6
      %{<h7 class="norm">#{@p_num.name}#{@headname}#{@dob.obj}</h7>} +
      %{<p class="paranum"><font size="1" color="#777777">&nbsp;&nbsp;#{@dob.ocn}</font></p>\n}
    end
  end
  class ParagraphNumber
    def initialize(md,ocn)
      @md,@ocn=md,ocn.to_s
      @ocn ||=''
    end
    def ocn_display
      @make=SiSU_Env::ProcessingSettings.new(@md)
      if @make.build.ocn?
        ocn_class='ocn'
        if @ocn.to_i==0
          @ocn.gsub(/^(\d+|)$/,
            %{<label class="#{ocn_class}"><a name="#{@ocn}">&nbsp;</a></label>})
        else
          @ocn.gsub(/^(\d+|)$/,
            %{<label class="#{ocn_class}"><a name="#{@ocn}">\\1</a></label>})
        end
      else
        ocn_class='ocn_off'
        @ocn.gsub(/^(\d+|)$/,
          %{<label class="#{ocn_class}">&nbsp;</label>})
      end
    end
    def name
      %{<a name="#{@ocn}"></a>}
    end
    def id #w3c? "tidy" complains about numbers as identifiers ! annoying
      %{id="o#{@ocn}"}
    end
    def goto
      %{<a href="##{@ocn}">}
    end
  end
  class HeadInformation
    include SiSU_Parts_XML
    attr_reader :md,:sfx,:pdf,:rdf,:vz
    def initialize(md)
      @md=md
      @rdf=SiSU_XML_Tags::RDF.new(md)
      # DublinCore 1 - title
      @stylesheet=SiSU_Style::CSS_HeadInfo.new(md).stylesheet
      @seg_name_html=(SiSU_HTML::Source::Seg.new.seg_name_html || [])
      @seg_name_html_tracker=(SiSU_HTML::Source::Seg.new.seg_name_html_tracker || [])
      @index='index'
      @metalink='#metadata'
      @tocband_scroll,@tocband_segtoc=nil,nil
    end
    def doc_type
      %{<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">\n}
    end
    def table_close
      %{  </font>
#{the_table_close}}
    end
    def html_close #moved
    %{</body>
</html>}
    end
  end
  class XML
  end
  class FormatTextObject
    include SiSU_Parts_XML
    attr_accessor :md,:dob,:txt,:ocn,:format,:table,:link,:linkname,:paranum,:p_num,:headname,:banner,:url
    def initialize(md,t_o)
      @md,@t_o=md,t_o
      if t_o.is_a?(Hash)
        @txt            =t_o[:txt]            || nil
        @ocn            =t_o[:ocn]            || nil
        @ocn_display    =t_o[:ocn_display]    || nil
        @headname       =t_o[:headname]       || nil
        @trailer        =t_o[:trailer]        || nil
        @endnote_part_a =t_o[:endnote_part_a] || nil
        @endnote_part_b =t_o[:endnote_part_b] || nil
        @lnk_url        =t_o[:lnk_url]        || nil
        @lnk_txt        =t_o[:lnk_txt]        || nil
        @format         =t_o[:format]         || nil
        @target         =t_o[:target]         || nil #occasionally passed but not used
      elsif t_o.class.inspect =~/Object/
        @txt=if defined? t_o.obj; t_o.obj
        else nil
        end
        @ocn=if defined? t_o.ocn; t_o.ocn.to_s
        else nil
        end
        @headname=if t_o.is==:heading and defined? t_o.name; t_o.name
        else nil
        end
      else
        if @md.opt.act[:maintenance][:set]==:on
          p __FILE__ << ':' << __LINE__.to_s
          p t_o.class
          p caller
        end
      end
      if defined? @t_o.ocn
        ocn=((@t_o.ocn.to_s =~/\d+/) ? @t_o.ocn : nil)
        @p_num=ParagraphNumber.new(@md,ocn)
      end
      if @format and not @format.empty?
        if @format=~/^\d:(\S+)/ #need more reliable marker #if @format =~ /#{Rx[:lv]}/
          headname=$1 #format[/\d~(\S+)/m,1]
          @headname=if headname =~/^[a-zA-Z]/; %{<a name="#{headname}" id="#{headname}"></a>} #consider: h_#{headname}
          else %{<a name="h#{headname}" id="h#{headname}"></a>}
          end
        end
      end
      @dob=t_o if defined? t_o.is
    end
    def endnote_body
      %{
<p class="endnote">
  #{@txt}
</p>
}
    end
    def endnote_body_indent
      %{
  <p class="endnote_indent">
    #{@txt}
  </p>
}
    end
    def no_paranum
      %{
<div class="substance">
  <label class="ocn">&nbsp;</label>
  <p class="norm">
    #{@txt}
  </p>
</div>
}
    end
    def para_form_css(tag,attrib)                                                    # regular paragraphs shaped here
      ul=ulc=''
      ul,ulc="<ul>\n  ","\n  </ul>" if @tag =~/li/
      %{
<div class="substance">
  #{@p_num.ocn_display}
  #{ul}<#{tag} class="#{attrib}" #{@p_num.id}>
    #{@txt}
  </#{tag}>#{ulc}
</div>
}
    end
    def para
      para_form_css('p','norm')
    end
    def code
      para_form_css('p','code')
    end
    def center
      para_form_css('p','center')
    end
    def bold
      para_form_css('p','bold')
    end
    def bullet
      para_form_css('li','bullet')
    end
    def format(tag,attrib)
      para_form_css(tag,attrib)
    end
    def heading_normal(tag,attrib)
      %{
<div class="substance">
  #{@p_num.ocn_display}
  <#{tag} class="#{attrib}" #{@p_num.id}>#{@p_num.name}
    #{@headname}#{@txt}
  </#{tag}>
</div>
}
    end
    def heading_body
      heading_normal('p','norm')
    end
    def heading_body0
      heading_normal('h1','norm')
    end
    def heading_body1
      heading_normal('h1','norm')
    end
    def heading_body2
      heading_normal('h2','norm')
    end
    def heading_body3
      heading_normal('h3','norm')
    end
    def heading_body4
      heading_normal('h4','norm')
    end
    def heading_body5
      heading_normal('h5','norm')
    end
    def heading_body6
      heading_normal('h6','norm')
    end
    def heading_body7
      heading_normal('h7','norm')
    end
    def title_header(tag,attrib)
      %{
<div class="content">
<#{tag} class="#{attrib}">
    #{@txt}
  </#{tag}>
</div>
}
    end
    def title_header1
      title_header('h1','tiny')
    end
    def title_header2
      title_header('h2','tiny')
    end
    def title_header3
      title_header('h3','tiny')
    end
    def title_header4
      ''
    end
    def title_header4_old
      %{
<div class="substance">
  <label class="ocn">&nbsp;</label>
  <h4 class="banner">
    #{@txt}
  </h4>
</div>
}
    end
    def dl #check :trailer
      "<dl><b>#{@txt}</b> #{@trailer}</dl>"
    end
    def table_css_end      #<!TZ!>
      '</table>
    </p>
  </div>'
    end
    def gsub_body
#fix
      @txt=case @txt
      when /^\s*\((i+|iv|v|vi+|ix|x|xi+)\)/
        @txt.gsub(/^\((i+|iv|v|vi+|ix|x|xi+)\)/,'<b>(\1)</b>').
          gsub(/^(#{Mx[:pa_o]}i[1-9]#{Mx[:pa_c]})\s*\((i+|iv|v|vi+|ix|x|xi+)\)/,'\1<b>(\2)</b>')
      when /^\s*\(?(\d|[a-z])+\)/
        @txt.gsub(/^\((\d+|[a-z])+\)/,'<b>(\1)</b>').
          gsub(/^(#{Mx[:pa_o]}i[1-9]#{Mx[:pa_c]})\s*\((\d+|[a-z])+\)/,'\1<b>(\2)</b>')
      when /^\s*\d{1,3}\.\s/
        @txt.gsub(/^\s*(\d+\.)/,'<b>\1</b>')
      when /^\s*[A-Z]\.\s/
        @txt.gsub(/^\s*([A-Z]\.)/,'<b>\1</b>')
      else @txt
      end
    end
    def bold_para
      %{#{the_margin.txt_0}
  <p class="bold">
    #{@txt}
  </p>
#{the_margin.num_css}
  &nbsp;&nbsp;&nbsp;
#{the_table_close}}
    end
    def bold_header
      @txt=@txt.gsub(/[1-9]~(\S+)/,'<a name="\1"></a>').
        gsub(/[1-9]~/,'')
      %{<p class="bold">
    #{@txt}
  </p>
#{the_margin.num_css}
  &nbsp;&nbsp;&nbsp;
#{the_table_close}}
    end
    def toc_head_copy_at
      %{<p class="center">#{@txt}</p>\n}
    end
    def center
      %{<p class="center">#{@txt}</p>\n}
    end
    def bold
      %{<p class="bold">#{@txt}</p>\n}
    end
    def center_bold
      %{<p class="centerbold">#{@txt}</p>\n}
    end
  end
  class FormatScroll < FormatTextObject
    include SiSU_Parts_XML
    def initialize(md,txt)
      super(md,txt)
    end
  end
  class FormatSeg < FormatTextObject
    def initialize(md,txt)
      super(md,txt)
    end
    def navigation_toc_lev1_advert
      %{#{@banner.home_button}\n
<center>
#{@txt}
#{@two}
</a></center><p />}
    end
    def navigation_toc_lev1
      %{#{@banner.nav_toc}}
    end
    def navigation_toc_lev2                                                      #change bold use css
      %{<p />
<table summary="navigation segment level 2">
<tr><td width ="20">
</td>
<td>
  <font size="3" #{the_font.set_face}>
    <b>#{@txt}</b>
  </font>
  </p>
#{the_table_close}}
    end
    def navigation_toc_lev3                                                      #change bold use css
      %{<p />
<table summary="navigation segment level 3">
<tr><td width ="20">
</td>
<td>
  <font size="3" #{the_font.set_face}>
    <b>#{@txt}</b>
  </font>
  </p>
#{the_table_close}}
    end
    def navigation_toc_lev4
      %{<table summary="navigation segment level 4">
<tr><td width ="80">
</td>
<td>
<p>
  #{@txt}
</p>
#{the_table_close}}
    end
    def navigation_toc_lev5
    end
    def navigation_toc_lev6
    end
    def endnote_seg_body(fn='')  #FIX                                                #url construction keep within single line... BUG WATCH 200408
      fn='doc' if fn.empty? #you may wish to reconsider, sends to 'doc' where no segment info # Sfx[:html] or Sfx[:xhtml] ?
      %{
  <p class="endnote">
    #{@endnote_part_a}#{fn}#{@md.lang_code_insert}#{Sfx[:html]}#{@endnote_part_b}
  </p>
}
    end
    def subtoc_lev(tag,attrib)
      txt=if @txt \
      and @txt =~/<\/?i>|<a\s+name="\S+?">/mi
        @txt.gsub(/<\/?i>|<a\s+name="\S+?">/mi,'') #removes name markers from subtoc, go directly to substantive text
      else @txt
      end
      note=''
      if txt =~/(#{Mx[:en_a_o]}.+?#{Mx[:en_a_c]}|#{Mx[:en_b_o]}.+?#{Mx[:en_b_c]}\s*)/m
        note=$1
        note=note.gsub(/[\n\s]+/m,' ')
        txt=txt.gsub(/(?:#{Mx[:en_a_o]}.+?#{Mx[:en_a_c]}|#{Mx[:en_b_o]}.+?#{Mx[:en_b_c]})\s*/m,' ').
          gsub(/<a[\n\s]+name="-\d+"[\n\s]+href="#_\d+">&nbsp;<sup>\d+<\/sup>&nbsp;/m,'')
      end
      %{<#{tag} class="#{attrib}">
    <a href="##{@ocn}"><i>#{txt}</i></a> #{note}
  </#{tag}>}
    end
    def subtoc_lev5
      subtoc_lev('h5','subtoc') if @txt
    end
    def subtoc_lev6
      subtoc_lev('h6','subtoc') if @txt
    end
    def subtoc_lev7
      subtoc_lev('h7','subtoc') if @txt
    end
    #% para sisu
    def header_sub(tag,attrib)
      @txt=@txt.gsub(/(?:#{Mx[:en_a_o]}.+?#{Mx[:en_a_c]}|#{Mx[:en_b_o]}.+?#{Mx[:en_b_c]})\s*/m,' ')
      %{
<div class="substance">
  #{@p_num.ocn_display}
  <#{tag} class="#{attrib}" #{@p_num.id}>#{@p_num.name} #{@headname}
    #{@txt}
  </#{tag}>
</div>
}
    end
    def header4
      %{
<div class="substance">
  #{@p_num.ocn_display}
  <h1 class="norm" #{@p_num.id}>#{@p_num.name}
    #{@t_o[:format]}
    #{@txt}
  </h1>
</div>
}
    end
    def header5
      header_sub('p','bold')
    end
    def header6
      header_sub('p','bold')
    end
    def header7
      header_sub('p','bold')
    end
    def navigation_header4
      %{<table summary="navigation segment header 4" width=100% bgcolor="#08163f" border="0">
<tr><td align="center">
<p class="bold">
  #{@txt}
</p>
#{the_table_close}}
    end
    def navigation_header5
      %{<p class="bold">
  #{@txt}
</p>}
    end
    def navigation_header6
      %{<p class="bold">
  #{@txt}
</p>}
    end
    def navigation_header7
      %{<p class="bold">
  #{@txt}
</p>}
    end
    def navigation_center
      "<center>#{@txt}</center>"
    end
  end
  class FormatToc < FormatTextObject
    def initialize(md,txt)
      super(md,txt)
    end
    def links_guide
      %{  <li class="doc">
    <a href="#{@lnk_url}" target="_top">
      #{@lnk_txt}
    </a>
  </li>
}
    end
    def lev(tag,attrib)
      if @txt
        %{<#{tag} class="#{attrib}">
    #{@txt}
  </#{tag}>
}
      else ''
      end
    end
    def lev1
      lev('h1','toc')
    end
    def lev2
      lev('h2','toc')
    end
    def lev3
      lev('h3','toc')
    end
    def lev4
      lev('h4','toc')
    end
    def lev5
      lev('h5','toc')
    end
    def lev6
      lev('h6','toc')
    end
    def lev7
      lev('h7','toc')
      #lev('b','toc')
    end
    def lev0 #docinfo
      lev('h0','toc')
    end
    def mini_lev1
      lev('h1','minitoc')
    end
    def mini_lev2
      lev('h2','minitoc')
    end
    def mini_lev3
      lev('h3','minitoc')
    end
    def mini_lev4
      lev('h4','minitoc')
    end
    def mini_lev5
      lev('h5','minitoc')
    end
    def mini_lev6
      lev('h6','minitoc')
    end
    def mini_lev7
      lev('h7','minitoc')
    end
    def mini_lev0 #docinfo
      lev('h0','minitoc')
    end
    def mini_tail
  %{
  <h4 class="minitoc">
    <a href="sisu_manifest.html">Manifest (alternative outputs)</a>
  </h4>
}
    end
    def mini_concord_tail
  %{
  <h4 class="minitoc">
    <a href="concordance.html">Concordance (wordlist)</a>
  </h4>
  <h4 class="minitoc">
    <a href="sisu_manifest.html">Manifest (alternative outputs)</a>
  </h4>
}
    end
  end
  class XML
  end
end
__END__
** Notes: tidy -xml index.xml >> index.tidy
