/* Public domain. */

#include <errno.h>
#include "bytestr.h"
#include "envalloc.h"

int envalloc_uniq (envalloc *v, char delim)
{
  unsigned int m = 0 ;
  register unsigned int i = 0 ;
  for (; i < v->len ; i++)
  {
    register unsigned int j = i+1 ;
    char const *s = v->s[i] ;
    unsigned int n = str_chr(s, delim) ;
    if (delim && !s[n]) return (errno = EINVAL, -1) ;
    for (; j < v->len ; j++)
    {
      if (!str_diffn(s, v->s[j], n))
      {
        v->s[j] = v->s[--v->len] ;
        m++ ;
      }
    }
  }
  return (int)m ;
}
