/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Thu Mar  3 12:51:49 2022

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_61 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 32223, "epsg", 32223,
        "WGS 72 / UTM zone 23N", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=23 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 23N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",-45],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 10,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 11,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32223\"]]");
    p = add_epsg_def_ex (filter, first, last, 32224, "epsg", 32224,
        "WGS 72 / UTM zone 24N", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=24 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 24N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",-39],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 10,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 11,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32224\"]]");
    p = add_epsg_def_ex (filter, first, last, 32225, "epsg", 32225,
        "WGS 72 / UTM zone 25N", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=25 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 25N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",-33],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 10,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 11,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32225\"]]");
    p = add_epsg_def_ex (filter, first, last, 32226, "epsg", 32226,
        "WGS 72 / UTM zone 26N", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=26 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 26N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",-27],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 10,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 11,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32226\"]]");
    p = add_epsg_def_ex (filter, first, last, 32227, "epsg", 32227,
        "WGS 72 / UTM zone 27N", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=27 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 27N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",-21],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 10,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 11,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32227\"]]");
    p = add_epsg_def_ex (filter, first, last, 32228, "epsg", 32228,
        "WGS 72 / UTM zone 28N", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=28 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 28N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",-15],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 10,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 11,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32228\"]]");
    p = add_epsg_def_ex (filter, first, last, 32229, "epsg", 32229,
        "WGS 72 / UTM zone 29N", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=29 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 29N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",-9],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 9,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 10,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32229\"]]");
    p = add_epsg_def_ex (filter, first, last, 32230, "epsg", 32230,
        "WGS 72 / UTM zone 30N", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=30 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 30N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",-3],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 9,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 10,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32230\"]]");
    p = add_epsg_def_ex (filter, first, last, 32231, "epsg", 32231,
        "WGS 72 / UTM zone 31N", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=31 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 31N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",3],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 9,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 10,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"32231\"]]");
    p = add_epsg_def_ex (filter, first, last, 32232, "epsg", 32232,
        "WGS 72 / UTM zone 32N", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 32N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",9],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 9,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 10,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"32232\"]]");
    p = add_epsg_def_ex (filter, first, last, 32233, "epsg", 32233,
        "WGS 72 / UTM zone 33N", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=33 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 33N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",15],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 9,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 10,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32233\"]]");
    p = add_epsg_def_ex (filter, first, last, 32234, "epsg", 32234,
        "WGS 72 / UTM zone 34N", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=34 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 34N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",21],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 9,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 10,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32234\"]]");
    p = add_epsg_def_ex (filter, first, last, 32235, "epsg", 32235,
        "WGS 72 / UTM zone 35N", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=35 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 35N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",27],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 9,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 10,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32235\"]]");
    p = add_epsg_def_ex (filter, first, last, 32236, "epsg", 32236,
        "WGS 72 / UTM zone 36N", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=36 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 36N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",33],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 9,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 10,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32236\"]]");
    p = add_epsg_def_ex (filter, first, last, 32237, "epsg", 32237,
        "WGS 72 / UTM zone 37N", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=37 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 37N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",39],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 9,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 10,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32237\"]]");
    p = add_epsg_def_ex (filter, first, last, 32238, "epsg", 32238,
        "WGS 72 / UTM zone 38N", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=38 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 38N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",45],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 9,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 10,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32238\"]]");
    p = add_epsg_def_ex (filter, first, last, 32239, "epsg", 32239,
        "WGS 72 / UTM zone 39N", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=39 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 39N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",51],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 9,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 10,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32239\"]]");
    p = add_epsg_def_ex (filter, first, last, 32240, "epsg", 32240,
        "WGS 72 / UTM zone 40N", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=40 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 40N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",57],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 9,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 10,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32240\"]]");
    p = add_epsg_def_ex (filter, first, last, 32241, "epsg", 32241,
        "WGS 72 / UTM zone 41N", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=41 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 41N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",63],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 9,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 10,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32241\"]]");
    p = add_epsg_def_ex (filter, first, last, 32242, "epsg", 32242,
        "WGS 72 / UTM zone 42N", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=42 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 42N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",69],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 9,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 10,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32242\"]]");
    p = add_epsg_def_ex (filter, first, last, 32243, "epsg", 32243,
        "WGS 72 / UTM zone 43N", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=43 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 43N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",75],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 9,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 10,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32243\"]]");
    p = add_epsg_def_ex (filter, first, last, 32244, "epsg", 32244,
        "WGS 72 / UTM zone 44N", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=44 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 44N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",81],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 9,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 10,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32244\"]]");
    p = add_epsg_def_ex (filter, first, last, 32245, "epsg", 32245,
        "WGS 72 / UTM zone 45N", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=45 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 45N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",87],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 9,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 10,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32245\"]]");
    p = add_epsg_def_ex (filter, first, last, 32246, "epsg", 32246,
        "WGS 72 / UTM zone 46N", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=46 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 46N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",93],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 9,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 10,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32246\"]]");
    p = add_epsg_def_ex (filter, first, last, 32247, "epsg", 32247,
        "WGS 72 / UTM zone 47N", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=47 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 47N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",99],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 9,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 10,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32247\"]]");
    p = add_epsg_def_ex (filter, first, last, 32248, "epsg", 32248,
        "WGS 72 / UTM zone 48N", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=48 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 48N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",105],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 10,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 11,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32248\"]]");
    p = add_epsg_def_ex (filter, first, last, 32249, "epsg", 32249,
        "WGS 72 / UTM zone 49N", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=49 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 49N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",111],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 10,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 11,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32249\"]]");
    p = add_epsg_def_ex (filter, first, last, 32250, "epsg", 32250,
        "WGS 72 / UTM zone 50N", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=50 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 50N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",117],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 10,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 11,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32250\"]]");
    p = add_epsg_def_ex (filter, first, last, 32251, "epsg", 32251,
        "WGS 72 / UTM zone 51N", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=51 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 51N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",123],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 10,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 11,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32251\"]]");
    p = add_epsg_def_ex (filter, first, last, 32252, "epsg", 32252,
        "WGS 72 / UTM zone 52N", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=52 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 52N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",129],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 10,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 11,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32252\"]]");
    p = add_epsg_def_ex (filter, first, last, 32253, "epsg", 32253,
        "WGS 72 / UTM zone 53N", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=53 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 53N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",135],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 10,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 11,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32253\"]]");
    p = add_epsg_def_ex (filter, first, last, 32254, "epsg", 32254,
        "WGS 72 / UTM zone 54N", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=54 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 54N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",141],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 10,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 11,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32254\"]]");
    p = add_epsg_def_ex (filter, first, last, 32255, "epsg", 32255,
        "WGS 72 / UTM zone 55N", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=55 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 55N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",147],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 10,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 11,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32255\"]]");
    p = add_epsg_def_ex (filter, first, last, 32256, "epsg", 32256,
        "WGS 72 / UTM zone 56N", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=56 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 56N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",153],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 10,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 11,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32256\"]]");
    p = add_epsg_def_ex (filter, first, last, 32257, "epsg", 32257,
        "WGS 72 / UTM zone 57N", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=57 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 57N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",159],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 10,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 11,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32257\"]]");
    p = add_epsg_def_ex (filter, first, last, 32258, "epsg", 32258,
        "WGS 72 / UTM zone 58N", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=58 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 58N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",165],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 10,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 11,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32258\"]]");
    p = add_epsg_def_ex (filter, first, last, 32259, "epsg", 32259,
        "WGS 72 / UTM zone 59N", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=59 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 59N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",171],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 10,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 11,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32259\"]]");
    p = add_epsg_def_ex (filter, first, last, 32260, "epsg", 32260,
        "WGS 72 / UTM zone 60N", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=60 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 60N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",177],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 10,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 11,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32260\"]]");
    p = add_epsg_def_ex (filter, first, last, 32301, "epsg", 32301,
        "WGS 72 / UTM zone 1S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=1 +south +ellps=WGS72 +towgs84=0,0,4.5,0");
    add_proj4text (p, 1,
        ",0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 1S\",GEOGCS[\"WGS 72\",DATUM[");
    add_srs_wkt (p, 1,
        "\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",63781");
    add_srs_wkt (p, 2,
        "35,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJEC");
    add_srs_wkt (p, 6,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 7,
        "igin\",0],PARAMETER[\"central_meridian\",-177],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",10000000],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 11,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32301\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 32302, "epsg", 32302,
        "WGS 72 / UTM zone 2S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=2 +south +ellps=WGS72 +towgs84=0,0,4.5,0");
    add_proj4text (p, 1,
        ",0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 2S\",GEOGCS[\"WGS 72\",DATUM[");
    add_srs_wkt (p, 1,
        "\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",63781");
    add_srs_wkt (p, 2,
        "35,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJEC");
    add_srs_wkt (p, 6,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 7,
        "igin\",0],PARAMETER[\"central_meridian\",-171],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",10000000],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 11,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32302\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 32303, "epsg", 32303,
        "WGS 72 / UTM zone 3S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=3 +south +ellps=WGS72 +towgs84=0,0,4.5,0");
    add_proj4text (p, 1,
        ",0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 3S\",GEOGCS[\"WGS 72\",DATUM[");
    add_srs_wkt (p, 1,
        "\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",63781");
    add_srs_wkt (p, 2,
        "35,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJEC");
    add_srs_wkt (p, 6,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 7,
        "igin\",0],PARAMETER[\"central_meridian\",-165],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",10000000],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 11,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32303\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 32304, "epsg", 32304,
        "WGS 72 / UTM zone 4S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=4 +south +ellps=WGS72 +towgs84=0,0,4.5,0");
    add_proj4text (p, 1,
        ",0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 4S\",GEOGCS[\"WGS 72\",DATUM[");
    add_srs_wkt (p, 1,
        "\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",63781");
    add_srs_wkt (p, 2,
        "35,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJEC");
    add_srs_wkt (p, 6,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 7,
        "igin\",0],PARAMETER[\"central_meridian\",-159],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",10000000],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 11,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32304\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 32305, "epsg", 32305,
        "WGS 72 / UTM zone 5S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=5 +south +ellps=WGS72 +towgs84=0,0,4.5,0");
    add_proj4text (p, 1,
        ",0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 5S\",GEOGCS[\"WGS 72\",DATUM[");
    add_srs_wkt (p, 1,
        "\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",63781");
    add_srs_wkt (p, 2,
        "35,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJEC");
    add_srs_wkt (p, 6,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 7,
        "igin\",0],PARAMETER[\"central_meridian\",-153],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",10000000],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 11,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32305\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 32306, "epsg", 32306,
        "WGS 72 / UTM zone 6S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=6 +south +ellps=WGS72 +towgs84=0,0,4.5,0");
    add_proj4text (p, 1,
        ",0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 6S\",GEOGCS[\"WGS 72\",DATUM[");
    add_srs_wkt (p, 1,
        "\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",63781");
    add_srs_wkt (p, 2,
        "35,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJEC");
    add_srs_wkt (p, 6,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 7,
        "igin\",0],PARAMETER[\"central_meridian\",-147],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",10000000],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 11,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32306\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 32307, "epsg", 32307,
        "WGS 72 / UTM zone 7S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=7 +south +ellps=WGS72 +towgs84=0,0,4.5,0");
    add_proj4text (p, 1,
        ",0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 7S\",GEOGCS[\"WGS 72\",DATUM[");
    add_srs_wkt (p, 1,
        "\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",63781");
    add_srs_wkt (p, 2,
        "35,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJEC");
    add_srs_wkt (p, 6,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 7,
        "igin\",0],PARAMETER[\"central_meridian\",-141],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",10000000],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 11,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32307\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 32308, "epsg", 32308,
        "WGS 72 / UTM zone 8S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=8 +south +ellps=WGS72 +towgs84=0,0,4.5,0");
    add_proj4text (p, 1,
        ",0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 8S\",GEOGCS[\"WGS 72\",DATUM[");
    add_srs_wkt (p, 1,
        "\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",63781");
    add_srs_wkt (p, 2,
        "35,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJEC");
    add_srs_wkt (p, 6,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 7,
        "igin\",0],PARAMETER[\"central_meridian\",-135],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",10000000],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 11,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32308\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 32309, "epsg", 32309,
        "WGS 72 / UTM zone 9S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=9 +south +ellps=WGS72 +towgs84=0,0,4.5,0");
    add_proj4text (p, 1,
        ",0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 9S\",GEOGCS[\"WGS 72\",DATUM[");
    add_srs_wkt (p, 1,
        "\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",63781");
    add_srs_wkt (p, 2,
        "35,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJEC");
    add_srs_wkt (p, 6,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 7,
        "igin\",0],PARAMETER[\"central_meridian\",-129],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",10000000],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 11,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32309\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 32310, "epsg", 32310,
        "WGS 72 / UTM zone 10S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=10 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 10S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",-123],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",5");
    add_srs_wkt (p, 9,
        "00000],PARAMETER[\"false_northing\",10000000],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 11,
        "ST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32310\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 32311, "epsg", 32311,
        "WGS 72 / UTM zone 11S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=11 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 11S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",-117],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",5");
    add_srs_wkt (p, 9,
        "00000],PARAMETER[\"false_northing\",10000000],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 11,
        "ST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32311\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 32312, "epsg", 32312,
        "WGS 72 / UTM zone 12S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=12 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 12S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",-111],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",5");
    add_srs_wkt (p, 9,
        "00000],PARAMETER[\"false_northing\",10000000],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 11,
        "ST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32312\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 32313, "epsg", 32313,
        "WGS 72 / UTM zone 13S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=13 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 13S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",-105],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",5");
    add_srs_wkt (p, 9,
        "00000],PARAMETER[\"false_northing\",10000000],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 11,
        "ST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32313\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 32314, "epsg", 32314,
        "WGS 72 / UTM zone 14S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=14 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 14S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",-99],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",10000000],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 11,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32314\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 32315, "epsg", 32315,
        "WGS 72 / UTM zone 15S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=15 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 15S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",-93],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",10000000],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 11,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32315\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 32316, "epsg", 32316,
        "WGS 72 / UTM zone 16S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=16 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 16S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",-87],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",10000000],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 11,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32316\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 32317, "epsg", 32317,
        "WGS 72 / UTM zone 17S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 17S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",-81],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",10000000],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 11,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32317\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 32318, "epsg", 32318,
        "WGS 72 / UTM zone 18S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 18S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",-75],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",10000000],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 11,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32318\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 32319, "epsg", 32319,
        "WGS 72 / UTM zone 19S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 19S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",-69],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",10000000],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 11,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32319\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 32320, "epsg", 32320,
        "WGS 72 / UTM zone 20S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 20S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",-63],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",10000000],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 11,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32320\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 32321, "epsg", 32321,
        "WGS 72 / UTM zone 21S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 21S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",-57],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",10000000],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 11,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32321\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 32322, "epsg", 32322,
        "WGS 72 / UTM zone 22S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 22S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",-51],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",10000000],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 11,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32322\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 32323, "epsg", 32323,
        "WGS 72 / UTM zone 23S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=23 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 23S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",-45],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",10000000],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 11,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32323\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 32324, "epsg", 32324,
        "WGS 72 / UTM zone 24S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=24 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 24S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",-39],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",10000000],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 11,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32324\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 32325, "epsg", 32325,
        "WGS 72 / UTM zone 25S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=25 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 25S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",-33],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",10000000],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 11,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32325\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 32326, "epsg", 32326,
        "WGS 72 / UTM zone 26S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=26 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 26S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",-27],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",10000000],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 11,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32326\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 32327, "epsg", 32327,
        "WGS 72 / UTM zone 27S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=27 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 27S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",-21],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",10000000],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 11,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32327\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 32328, "epsg", 32328,
        "WGS 72 / UTM zone 28S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=28 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 28S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",-15],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",10000000],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 11,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32328\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 32329, "epsg", 32329,
        "WGS 72 / UTM zone 29S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=29 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 29S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",-9],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 9,
        "000],PARAMETER[\"false_northing\",10000000],UNIT[\"metre");
    add_srs_wkt (p, 10,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 11,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32329\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 32330, "epsg", 32330,
        "WGS 72 / UTM zone 30S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=30 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 30S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",-3],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 9,
        "000],PARAMETER[\"false_northing\",10000000],UNIT[\"metre");
    add_srs_wkt (p, 10,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 11,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32330\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 32331, "epsg", 32331,
        "WGS 72 / UTM zone 31S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=31 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 31S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",3],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 9,
        "0],PARAMETER[\"false_northing\",10000000],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32331\"]]");
    p = add_epsg_def_ex (filter, first, last, 32332, "epsg", 32332,
        "WGS 72 / UTM zone 32S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 32S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",9],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 9,
        "0],PARAMETER[\"false_northing\",10000000],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32332\"]]");
    p = add_epsg_def_ex (filter, first, last, 32333, "epsg", 32333,
        "WGS 72 / UTM zone 33S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=33 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 33S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",15],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 9,
        "000],PARAMETER[\"false_northing\",10000000],UNIT[\"metre");
    add_srs_wkt (p, 10,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 11,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32333\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 32334, "epsg", 32334,
        "WGS 72 / UTM zone 34S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=34 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 34S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",21],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 9,
        "000],PARAMETER[\"false_northing\",10000000],UNIT[\"metre");
    add_srs_wkt (p, 10,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 11,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32334\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 32335, "epsg", 32335,
        "WGS 72 / UTM zone 35S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=35 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 35S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",27],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 9,
        "000],PARAMETER[\"false_northing\",10000000],UNIT[\"metre");
    add_srs_wkt (p, 10,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 11,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32335\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 32336, "epsg", 32336,
        "WGS 72 / UTM zone 36S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=36 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 36S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",33],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 9,
        "000],PARAMETER[\"false_northing\",10000000],UNIT[\"metre");
    add_srs_wkt (p, 10,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 11,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32336\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 32337, "epsg", 32337,
        "WGS 72 / UTM zone 37S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=37 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 37S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",39],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 9,
        "000],PARAMETER[\"false_northing\",10000000],UNIT[\"metre");
    add_srs_wkt (p, 10,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 11,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32337\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 32338, "epsg", 32338,
        "WGS 72 / UTM zone 38S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=38 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 38S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",45],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 9,
        "000],PARAMETER[\"false_northing\",10000000],UNIT[\"metre");
    add_srs_wkt (p, 10,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 11,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32338\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 32339, "epsg", 32339,
        "WGS 72 / UTM zone 39S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=39 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 39S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",51],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 9,
        "000],PARAMETER[\"false_northing\",10000000],UNIT[\"metre");
    add_srs_wkt (p, 10,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 11,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32339\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 32340, "epsg", 32340,
        "WGS 72 / UTM zone 40S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=40 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 40S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",57],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 9,
        "000],PARAMETER[\"false_northing\",10000000],UNIT[\"metre");
    add_srs_wkt (p, 10,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 11,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32340\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 32341, "epsg", 32341,
        "WGS 72 / UTM zone 41S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=41 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 41S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",63],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 9,
        "000],PARAMETER[\"false_northing\",10000000],UNIT[\"metre");
    add_srs_wkt (p, 10,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 11,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32341\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 32342, "epsg", 32342,
        "WGS 72 / UTM zone 42S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=42 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 42S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",69],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 9,
        "000],PARAMETER[\"false_northing\",10000000],UNIT[\"metre");
    add_srs_wkt (p, 10,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 11,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32342\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 32343, "epsg", 32343,
        "WGS 72 / UTM zone 43S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=43 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 43S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",75],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 9,
        "000],PARAMETER[\"false_northing\",10000000],UNIT[\"metre");
    add_srs_wkt (p, 10,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 11,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32343\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 32344, "epsg", 32344,
        "WGS 72 / UTM zone 44S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=44 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 44S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",81],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 9,
        "000],PARAMETER[\"false_northing\",10000000],UNIT[\"metre");
    add_srs_wkt (p, 10,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 11,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32344\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 32345, "epsg", 32345,
        "WGS 72 / UTM zone 45S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=45 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 45S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",87],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 9,
        "000],PARAMETER[\"false_northing\",10000000],UNIT[\"metre");
    add_srs_wkt (p, 10,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 11,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32345\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 32346, "epsg", 32346,
        "WGS 72 / UTM zone 46S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=46 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 46S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",93],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 9,
        "000],PARAMETER[\"false_northing\",10000000],UNIT[\"metre");
    add_srs_wkt (p, 10,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 11,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32346\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 32347, "epsg", 32347,
        "WGS 72 / UTM zone 47S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=47 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 47S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",99],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 9,
        "000],PARAMETER[\"false_northing\",10000000],UNIT[\"metre");
    add_srs_wkt (p, 10,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 11,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32347\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 32348, "epsg", 32348,
        "WGS 72 / UTM zone 48S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=48 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 48S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",105],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",10000000],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 11,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32348\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 32349, "epsg", 32349,
        "WGS 72 / UTM zone 49S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=49 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 49S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",111],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",10000000],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 11,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32349\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 32350, "epsg", 32350,
        "WGS 72 / UTM zone 50S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=50 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 50S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",117],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",10000000],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 11,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32350\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 32351, "epsg", 32351,
        "WGS 72 / UTM zone 51S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=51 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 51S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",123],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",10000000],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 11,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32351\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 32352, "epsg", 32352,
        "WGS 72 / UTM zone 52S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=52 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 52S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",129],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",10000000],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 11,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32352\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 32353, "epsg", 32353,
        "WGS 72 / UTM zone 53S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=53 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 53S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",135],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",10000000],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 11,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32353\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 32354, "epsg", 32354,
        "WGS 72 / UTM zone 54S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=54 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 54S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",141],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",10000000],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 11,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32354\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 32355, "epsg", 32355,
        "WGS 72 / UTM zone 55S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=55 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 55S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",147],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",10000000],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 11,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32355\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 32356, "epsg", 32356,
        "WGS 72 / UTM zone 56S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=56 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 56S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",153],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",10000000],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 11,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32356\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 32357, "epsg", 32357,
        "WGS 72 / UTM zone 57S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=57 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 57S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",159],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",10000000],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 11,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32357\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 32358, "epsg", 32358,
        "WGS 72 / UTM zone 58S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=58 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 58S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",165],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",10000000],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 11,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32358\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 32359, "epsg", 32359,
        "WGS 72 / UTM zone 59S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=59 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 59S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",171],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",10000000],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 11,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32359\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 32360, "epsg", 32360,
        "WGS 72 / UTM zone 60S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=60 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 60S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",177],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",10000000],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 11,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32360\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 32401, "epsg", 32401,
        "WGS 72BE / UTM zone 1N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=1 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.81");
    add_proj4text (p, 1,
        "4,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 1N\",GEOGCS[\"WGS 72BE\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"432");
    add_srs_wkt (p, 6,
        "4\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",-17");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"324");
    add_srs_wkt (p, 12,
        "01\"]]");
    p = add_epsg_def_ex (filter, first, last, 32402, "epsg", 32402,
        "WGS 72BE / UTM zone 2N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=2 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.81");
    add_proj4text (p, 1,
        "4,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 2N\",GEOGCS[\"WGS 72BE\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"432");
    add_srs_wkt (p, 6,
        "4\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",-17");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"324");
    add_srs_wkt (p, 12,
        "02\"]]");
    p = add_epsg_def_ex (filter, first, last, 32403, "epsg", 32403,
        "WGS 72BE / UTM zone 3N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=3 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.81");
    add_proj4text (p, 1,
        "4,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 3N\",GEOGCS[\"WGS 72BE\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"432");
    add_srs_wkt (p, 6,
        "4\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",-16");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"324");
    add_srs_wkt (p, 12,
        "03\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

