/* -------------------------------------------------------------------------- */
/*                                                                            */
/* [pathes.h]      Path Iterator / File Access & I/O Handling                 */
/*                                                                            */
/* Copyright (c) 1993 by D\olle, Manns                                        */
/* -------------------------------------------------------------------------- */

/* File generated by 'ctoh'. Don't change manually. */

#ifndef pathes_INCL
#define pathes_INCL


#include "standard.h"


#ifdef __cplusplus
extern "C" {
#endif


/* ----------------------- Types -------------------------------------------- */

AbstractType(PIT); /* Abstract tokenizer / path iterator type */

/* ------------------- Tokenizer / Path iterator ---------------------------- */

PIT PIT_make(c_string PathList)
/* creates a tokenizer / path iterator from 'PathList' */
;

void PIT_sep(PIT Piter,c_string sep)
/* defines 'sep' as token separator for iterator 'Piter' */
;

c_string PIT_read(PIT Piter);    /* next token / path in iterator 'Piter'   */
void     PIT_drop(PIT Piter);    /* drops tokenizer / path iterator 'Piter' */

/* -------------------- File access / information -------------------------- */

c_string DirSep(void);               /* directory separator ( constant )    */
c_string PathSep(void);              /* path separator ( constant )         */

c_bool AbsolutePathSep(c_string file)
/* whether 'file' starts with a path separator */
;

c_bool   AbsolutPath(c_string file); /* whether 'file' is an absolut path   */
c_bool   PathIgnCase(void);          /* whether pathes are case insensitive */

c_string FileLName(c_string file)
/* filename of path 'file'; allocs memory */
;

c_string FilePrefix(c_string file)
/* directory prefix of path 'file'; allocs memory */
;

c_string FileSuffix(c_string file); /* suffix of path 'file'; allocs memory */
c_string BaseFile(c_string file); /* basename of path 'file'; allocs memory */

c_bool IsPath(c_string path)
/* whether 'path' is a regular file, directory, ... */
;

c_bool IsDirEntry(c_string file, c_string dir)
/* whether 'file' is an entry of directory 'dir' */
;

c_string GetEnvCtx(c_string env)
/* value of context or environment variable or NULL */
;

c_string MkPath(c_string direnv, c_string basename, c_string ext, char opt)
/* path = cons(env,dir_separation,basename,ext); allocs memory. Note:
                  opt = 'd'                     --> env = direnv
   direnv  = "" & opt = 'c' & relative basename --> env = dirname(cwd)
   direnv != "" & opt = '$'                     --> env = $direnv
   direnv != "" & opt = 'e'                     --> env = getenv(direnv)
   direnv != "" & opt = 'p'                     --> env = findPath in
                                                          getenv(direnv)
*/
;

long   PathMTime(c_string path);       /* file modification time of 'path'  */
long   Path_FileSize(c_string path);   /* the file size of 'path'           */
c_bool IsDirPath(c_string path);       /* path = directory ?                */
c_bool IsRegPath(c_string path);       /* path = regular file ?             */
c_bool IsCDevPath(c_string path);      /* path = character device ?         */
c_bool IsBDevPath(c_string path);      /* path = block device ?             */
c_bool IsFifoPath(c_string path);      /* path = FIFO ?                     */

/* -------------------------- File I/O handling ----------------------------- */

FILE* TryOpnFile(c_string path, c_string access)
/* tries to open 'path' in mode 'access' ( MSDOS convention 'w|r[+]t|b' ) */
;

FILE* OpnFile(c_string path, c_string access)
/* opens 'path' in mode 'access' ( MSDOS convention 'w|r[+]t|b' );
   raises exception
*/
;

FILE* TryOpenPath(c_string env, c_string file, c_string ext, c_string acc)
/* tries to open Path(env,file,ext) in mode 'acc'
   ( MSDOS convention 'w|r[+]t|b' )
*/
;

FILE* OpenPath(c_string env, c_string file, c_string ext, c_string acc)
/* opens Path(env,file,ext) in mode 'acc'
   ( MSDOS convention 'w|r[+]t|b' ); raises exception
*/
;



#ifdef __cplusplus
}
#endif

#endif
