/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_CUSTOMEVENTS_H
#define _SC_CUSTOMEVENTS_H

// qt
#include <QtCore/QEvent>

/**
 * \brief custom event types.
 */

enum ScEvents
{
  /**
   * command events
   */
  ScLogEvent            = QEvent::User, ///< log results
  ScBlameEvent,                         ///< blame results 
  ScDiffSummarizeEvent,                 ///< diff summarize result
  ScParameterEvent,

  /**
   * other events
   */
  ScDialogEvent,                        ///< dialog request
  ScCancelEvent,                        ///< cancel cmd

  ScLoggingEvent,                       ///< log output
  ScCmdProgressEvent,
  ScCancelStartEvent,                   ///< cancel start
  ScCancelStopEvent,                    ///< cancel stop

  ScErrorEvent,                         ///< show error dialog
  ScExceptionEvent,                     ///< show exception dialog
  ScUpdateWcEvent,                      ///< update the wc view
  ScLviOnItemEvent,                     ///< item info (path/url)

  ScReOrderProjectsEvent,               ///< reorder projects
  ScMoveWcItemEvent,                    ///< move wc items
  ScCopyWcItemEvent                     ///< copy wc items
};

#endif // _SC_CUSTOMEVENTS_H
