/*
 * VersionDialog.java
 *
 *
 *  The Salamander Project - 2D and 3D graphics libraries in Java
 *  Copyright (C) 2004 Mark McKay
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *  Mark McKay can be contacted at mark@kitfox.com.  Salamander and other
 *  projects can be found at http://www.kitfox.com
 *
 * Created on January 13, 2005, 7:23 AM
 */

package com.kitfox.svg.app;

import java.net.*;
import java.io.*;
import java.util.*;
import javax.swing.event.*;
import javax.swing.*;
import javax.swing.text.html.*;


/**
 *
 * @author  kitfox
 */
public class VersionDialog extends javax.swing.JDialog
{
    public static final long serialVersionUID = 1;
    
    final boolean verbose;
    
    /** Creates new form VersionDialog */
    public VersionDialog(java.awt.Frame parent, boolean modal, boolean verbose)
    {
        super(parent, modal);
        initComponents();
        
        this.verbose = verbose;
        
        textpane_text.setContentType("text/html");
        
        StringBuffer sb = new StringBuffer();
        try
        {
            URL url = getClass().getResource("/res/help/about/about.html");
            if (verbose)
            {
                System.err.println("" + getClass() + " trying to load about html " + url);
            }
            
            BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
            while (true)
            {
                String line = reader.readLine();
                if (line == null) break;
                sb.append(line);
            }
            
            textpane_text.setText(sb.toString());
        }
        catch (Exception e)
        {
            e.printStackTrace();
        }
        
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents()
    {
        jPanel1 = new javax.swing.JPanel();
        textpane_text = new javax.swing.JTextPane();
        jPanel2 = new javax.swing.JPanel();
        bn_close = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("About SVG Salamander");
        jPanel1.setLayout(new java.awt.BorderLayout());

        textpane_text.setEditable(false);
        textpane_text.setPreferredSize(new java.awt.Dimension(400, 300));
        jPanel1.add(textpane_text, java.awt.BorderLayout.CENTER);

        getContentPane().add(jPanel1, java.awt.BorderLayout.CENTER);

        bn_close.setText("Close");
        bn_close.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                bn_closeActionPerformed(evt);
            }
        });

        jPanel2.add(bn_close);

        getContentPane().add(jPanel2, java.awt.BorderLayout.SOUTH);

        pack();
    }
    // </editor-fold>//GEN-END:initComponents

    private void bn_closeActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_bn_closeActionPerformed
    {//GEN-HEADEREND:event_bn_closeActionPerformed
        setVisible(false);
        dispose();
    }//GEN-LAST:event_bn_closeActionPerformed
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[])
    {
        java.awt.EventQueue.invokeLater(new Runnable()
        {
            public void run()
            {
                new VersionDialog(new javax.swing.JFrame(), true, true).setVisible(true);
            }
        });
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton bn_close;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JTextPane textpane_text;
    // End of variables declaration//GEN-END:variables
    
}
