C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE LRASY1
C                       *****************
C
C     --------------------
     *(NDIM,NPOINR,NELRAY)
C     --------------------
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C      1ere LECTURE DU MAILLAGE ELEMENTS FINIS  POUR LE RAYONNEMENT    *
C             --> STRUCTURE DE DONNEE ISSUE DE SYRTHES                 *
C             (Necessaire pour les dimensionnements de tableaux)       *
C                                                                      *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /XREFER/  !    ! D  !                                              !
C ! /NLOFES/  !    ! D  !                                              !
C ! /NLOFCT/  !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) :
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) :
C
C***********************************************************************
C
      IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#include "optct.h"
#include "nlofes.h"
#include "nlofct.h"
C
C***********************************************************************
C 
C.. Variables externes
      INTEGER NDIM,NPOINR,NELRAY
C
C.. Variables internes
      INTEGER NBNO,LCH
      CHARACTER CH*80,FORMA*80
C
C***********************************************************************
C
C     1- INITIALISATIONS
C     ==================
      NPOINR = 0
      NELRAY = 0
C
C     2- NOMBRE DE NOEUDS ET D'ELEMENTS
C     =================================
C
      REWIND(NFSGRA)
      READ(NFSGRA,1000) CH,CH,CH,CH
C
      READ(NFSGRA,1001) CH
      CALL CHFORM ('I',CH(22:),LCH,1,FORMA)
      READ(CH(22:),FORMA) NPOINR
C
      READ(NFSGRA,1001) CH
      CALL CHFORM ('I',CH(23:),LCH,1,FORMA)
      READ(CH(23:),FORMA) NELRAY
C
      READ(NFSGRA,1001) CH
      CALL CHFORM ('I',CH(34:),LCH,1,FORMA)
      READ(CH(34:),FORMA) NBNO
C
      IF (NDIM .NE. NBNO) THEN
        WRITE(NFECRA,2000)
        STOP
      ENDIF
C
C
C--------
C FORMATS
C--------
C 
 1000 FORMAT(A80,/,A80,/,A80,/,A80)
 1001 FORMAT(A80)
 2000 FORMAT('  %% ERREUR LRASY1 : LE MAILLAGE POSSEDE DES'
     &                             ,' NOEUDS MILIEUX')      
C

      END
