/*
    		 Crown Copyright (c) 1997
    
    This TenDRA(r) Computer Program is subject to Copyright
    owned by the United Kingdom Secretary of State for Defence
    acting through the Defence Evaluation and Research Agency
    (DERA).  It is made available to Recipients with a
    royalty-free licence for its use, reproduction, transfer
    to other parties and amendment for any purpose not excluding
    product development provided that any such use et cetera
    shall be deemed to be acceptance of the following conditions:-
    
        (1) Its Recipients shall ensure that this Notice is
        reproduced upon any copies or amended versions of it;
    
        (2) Any amended version of it shall be clearly marked to
        show both the nature of and the organisation responsible
        for the relevant amendment or amendments;
    
        (3) Its onward transfer from a recipient to another
        party shall be deemed to be that party's acceptance of
        these conditions;
    
        (4) DERA gives no warranty or assurance as to its
        quality or suitability for any purpose and DERA accepts
        no liability whatsoever in relation to any use to which
        it may be put.
*/


#ifndef CONFIG_INCLUDED
#define CONFIG_INCLUDED


/*
    ANSI API SPECIFICATION

    The API for this program is ANSI.  This defines the basic interface,
    and utility.c includes stdarg.h (or varargs.h).
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>


/*
    HACKS FOR BAD API IMPLEMENTATIONS

    These values are meant to be in the headers above, but sometimes
    they are omitted.
*/

#ifndef EXIT_SUCCESS
#define EXIT_SUCCESS		0
#define EXIT_FAILURE		1
#endif

#ifndef SEEK_SET
#define SEEK_SET		0
#define SEEK_CUR		1
#define SEEK_END		2
#endif

#ifdef __MSDOS__
#define FS_NO_MODE_T		1
#endif


/*
    COMPILER DEPENDENT MACROS
*/

#include "ossg.h"


/*
    BASIC TYPES

    These types are so ubiquitous that this is the only suitable place
    for them.
*/

typedef char boolean ;
#if FS_PTR_VOID
typedef void *pointer ;
#else
typedef char *pointer ;
#endif


/*
    UTILITY MACROS

    These macros are just a matter of programming style.
*/

#define null			NULL
#define null_str		( ( char * ) NULL )
#define streq( X, Y )		( strcmp ( ( X ), ( Y ) ) == 0 )
#define strneq( X, Y, Z )	( strncmp ( ( X ), ( Y ), ( Z ) ) == 0 )


#endif
