/*
 * Decompiled with CFR 0.152.
 */
package com.google.scrollview.events;

import com.google.scrollview.ScrollView;
import com.google.scrollview.events.SVEvent;
import com.google.scrollview.events.SVEventType;
import com.google.scrollview.ui.SVWindow;
import java.awt.Color;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.Timer;
import org.piccolo2d.PCamera;
import org.piccolo2d.PNode;
import org.piccolo2d.event.PBasicInputEventHandler;
import org.piccolo2d.event.PInputEvent;
import org.piccolo2d.nodes.PPath;

public class SVEventHandler
extends PBasicInputEventHandler
implements ActionListener,
KeyListener,
WindowListener {
    public Timer timer = new Timer(1000, this);
    private SVWindow svWindow;
    private int lastX = 0;
    private int lastY = 0;
    private int lastXMove = 0;
    private int lastYMove = 0;
    private int startX = 0;
    private int startY = 0;
    private float rubberBandTransparency = 0.5f;
    private PNode selection = null;
    private String keyStr = "!";

    public SVEventHandler(SVWindow sVWindow) {
        this.svWindow = sVWindow;
    }

    private void processEvent(SVEvent sVEvent) {
        this.lastXMove = sVEvent.x;
        this.lastYMove = sVEvent.y;
        ScrollView.addMessage(sVEvent);
        this.timer.restart();
    }

    private void showPopup(PInputEvent pInputEvent) {
        double d = pInputEvent.getCanvasPosition().getX();
        double d2 = pInputEvent.getCanvasPosition().getY();
        if (this.svWindow.svPuMenu != null) {
            this.svWindow.svPuMenu.show(this.svWindow, (int)d, (int)d2);
        }
    }

    public void mouseClicked(PInputEvent pInputEvent) {
        if (pInputEvent.isPopupTrigger()) {
            this.showPopup(pInputEvent);
        } else {
            this.processEvent(new SVEvent(SVEventType.SVET_CLICK, this.svWindow, (int)pInputEvent.getPosition().getX(), (int)pInputEvent.getPosition().getY(), 0, 0, null));
        }
    }

    public void mousePressed(PInputEvent pInputEvent) {
        if (pInputEvent.isPopupTrigger()) {
            this.showPopup(pInputEvent);
        } else {
            this.lastX = (int)pInputEvent.getPosition().getX();
            this.lastY = (int)pInputEvent.getPosition().getY();
            this.timer.restart();
        }
    }

    public void mouseDragged(PInputEvent pInputEvent) {
        this.processEvent(new SVEvent(SVEventType.SVET_MOUSE, this.svWindow, (int)pInputEvent.getPosition().getX(), (int)pInputEvent.getPosition().getY(), (int)pInputEvent.getPosition().getX() - this.lastX, (int)pInputEvent.getPosition().getY() - this.lastY, null));
        if (this.selection == null) {
            this.startX = (int)pInputEvent.getPosition().getX();
            this.startY = (int)pInputEvent.getPosition().getY();
            this.selection = PPath.createRectangle((float)this.startX, (float)this.startY, (float)1.0f, (float)1.0f);
            this.selection.setTransparency(this.rubberBandTransparency);
            this.svWindow.canvas.getLayer().addChild(this.selection);
        } else {
            int n = Math.max(this.startX, (int)pInputEvent.getPosition().getX());
            int n2 = Math.min(this.startX, (int)pInputEvent.getPosition().getX());
            int n3 = Math.max(this.startY, (int)pInputEvent.getPosition().getY());
            int n4 = Math.min(this.startY, (int)pInputEvent.getPosition().getY());
            this.svWindow.canvas.getLayer().removeChild(this.selection);
            this.selection = PPath.createRectangle((float)n2, (float)n4, (float)(n - n2), (float)(n3 - n4));
            this.selection.setPaint((Paint)Color.YELLOW);
            this.selection.setTransparency(this.rubberBandTransparency);
            this.svWindow.canvas.getLayer().addChild(this.selection);
        }
    }

    public void mouseReleased(PInputEvent pInputEvent) {
        if (pInputEvent.isPopupTrigger()) {
            this.showPopup(pInputEvent);
        } else {
            this.processEvent(new SVEvent(SVEventType.SVET_SELECTION, this.svWindow, (int)pInputEvent.getPosition().getX(), (int)pInputEvent.getPosition().getY(), (int)pInputEvent.getPosition().getX() - this.lastX, (int)pInputEvent.getPosition().getY() - this.lastY, null));
        }
        if (this.selection != null) {
            this.svWindow.canvas.getLayer().removeChild(this.selection);
            this.selection = null;
        }
    }

    public void mouseWheelRotated(PInputEvent pInputEvent) {
        PCamera pCamera = this.svWindow.canvas.getCamera();
        double d = 2.0;
        if (pInputEvent.getWheelRotation() < 0) {
            d = 1.0 / d;
        }
        pCamera.scaleViewAboutPoint(pCamera.getScale() / d, pInputEvent.getPosition().getX(), pInputEvent.getPosition().getY());
    }

    public void mouseMoved(PInputEvent pInputEvent) {
        this.processEvent(new SVEvent(SVEventType.SVET_MOTION, this.svWindow, (int)pInputEvent.getPosition().getX(), (int)pInputEvent.getPosition().getY(), 0, 0, null));
    }

    public void mouseEntered(PInputEvent pInputEvent) {
        this.timer.restart();
    }

    public void mouseExited(PInputEvent pInputEvent) {
        this.timer.stop();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.processEvent(new SVEvent(SVEventType.SVET_HOVER, this.svWindow, this.lastXMove, this.lastYMove, 0, 0, null));
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (c == '\r' || c == '\n' || c == '\u0000' || c == '?') {
            this.processEvent(new SVEvent(SVEventType.SVET_INPUT, this.svWindow, this.lastXMove, this.lastYMove, 0, 0, this.keyStr));
            this.keyStr = "!";
        } else {
            this.processEvent(new SVEvent(SVEventType.SVET_INPUT, this.svWindow, this.lastXMove, this.lastYMove, 0, 0, String.valueOf(c)));
            this.keyStr = this.keyStr + c;
        }
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.processEvent(new SVEvent(SVEventType.SVET_DESTROY, this.svWindow, this.lastXMove, this.lastYMove, 0, 0, null));
        windowEvent.getWindow().dispose();
        if (--SVWindow.nrWindows == 0) {
            this.processEvent(new SVEvent(SVEventType.SVET_EXIT, this.svWindow, this.lastXMove, this.lastYMove, 0, 0, null));
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }
}

