/*
 * Copyright (C) 2014 Canonical Ltd.
 *
 * This file is part of unity-chromium-extension
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef UNITY_WEBAPPS_SERVICE
#define UNITY_WEBAPPS_SERVICE

#include <QObject>
#include <QVariantMap>

namespace UnityWebapps {

class ServicePrivate;

class Service: public QObject
{
    Q_OBJECT
    Q_PROPERTY(bool isIdle READ isIdle NOTIFY isIdleChanged)

public:
    explicit Service(QObject *parent = 0);
    ~Service();

    bool isIdle() const;

    void addHandler(QObject *handler);

public Q_SLOTS:
    void handleMessage(const QVariantMap &message);

Q_SIGNALS:
    void messageHandled(const QVariantMap &reply);
    void isIdleChanged();

private:
    ServicePrivate *d_ptr;
    Q_DECLARE_PRIVATE(Service)
};

} // namespace

#endif // UNITY_WEBAPPS_SERVICE
