/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;

class inp_panel
extends Panel
implements MouseListener,
MouseMotionListener {
    public static final int CURVE = 0;
    public static final int RECT = 1;
    public static final int CIRCLE = 2;
    public static final int LINES = 3;
    public static final int LINE = 4;
    public static final int SLINE = 5;
    public static final int SEG = 6;
    public static final int POLY = 7;
    public static final int POINTS = 8;
    public static int ctype;
    static int ll;
    Image bg;
    Vector lines = new Vector(16384);
    int x1;
    int y1;
    int x2;
    int y2;
    int radius;
    int drag;
    int st;

    public inp_panel(Color color, Image image) {
        this.setBackground(color);
        this.setForeground(Color.black);
        this.bg = image;
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.st = 0;
    }

    public void retry() {
        this.lines.removeAllElements();
        this.st = 0;
        this.repaint();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n = this.lines.size();
        mouseEvent.consume();
        switch (ctype) {
            case 0: {
                if (n < 2000) {
                    this.x1 = mouseEvent.getX();
                    this.y1 = mouseEvent.getY();
                    this.lines.addElement(new Point(this.x1, this.y1));
                    this.repaint();
                }
                this.st = 2;
                return;
            }
        }
        int n2 = this.drag;
        this.mouseMoved(mouseEvent);
        this.drag = n2 + 1;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        mouseEvent.consume();
        this.drag = 0;
        switch (ctype) {
            case 0: 
            case 3: 
            case 7: 
            case 8: {
                if (this.st == 0) {
                    return;
                }
                this.st = 1;
                this.x2 = mouseEvent.getX();
                this.y2 = mouseEvent.getY();
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                if (this.st != 1) {
                    return;
                }
                this.x2 = mouseEvent.getX();
                this.y2 = mouseEvent.getY();
                this.radius = (int)Math.sqrt((this.x2 - this.x1) * (this.x2 - this.x1) + (this.y2 - this.y1) * (this.y2 - this.y1));
                break;
            }
            default: {
                return;
            }
        }
        if (ctype != 8) {
            this.repaint();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        mouseEvent.consume();
        switch (ctype) {
            case 0: {
                if (this.st > 0) {
                    return;
                }
                this.x1 = mouseEvent.getX();
                this.y1 = mouseEvent.getY();
                this.x2 = this.x1;
                this.y2 = this.y1;
                this.lines.removeAllElements();
                this.lines.addElement(new Point(this.x1, this.y1));
                this.repaint();
                this.st = 2;
                return;
            }
            case 3: 
            case 7: 
            case 8: {
                this.x2 = mouseEvent.getX();
                this.y2 = mouseEvent.getY();
                if (this.st == 0) {
                    this.lines.removeAllElements();
                }
                this.lines.addElement(new Point(this.x2, this.y2));
                this.st = 1;
                this.x1 = this.x2;
                this.y1 = this.y2;
                this.repaint();
                return;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                this.x2 = mouseEvent.getX();
                this.y2 = mouseEvent.getY();
                switch (this.st) {
                    case 0: 
                    case 2: {
                        this.x1 = this.x2;
                        this.y1 = this.y2;
                        this.radius = 0;
                        this.st = 1;
                        this.repaint();
                        return;
                    }
                    case 1: {
                        this.radius = (int)Math.sqrt((this.x2 - this.x1) * (this.x2 - this.x1) + (this.y2 - this.y1) * (this.y2 - this.y1));
                        this.st = 2;
                        return;
                    }
                }
                break;
            }
            default: {
                return;
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        mouseEvent.consume();
        switch (ctype) {
            case 0: {
                if (this.st == 2) {
                    return;
                }
                this.x2 = mouseEvent.getX();
                this.y2 = mouseEvent.getY();
                if (this.st == 0) {
                    this.lines.removeAllElements();
                }
                this.lines.addElement(new Point(this.x2, this.y2));
                this.st = 1;
                this.x1 = this.x2;
                this.y1 = this.y2;
                return;
            }
            case 8: {
                return;
            }
        }
        if (this.st > 0 && this.drag >= 8) {
            this.mousePressed(mouseEvent);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (ctype != 0 && ctype != 3 && ctype != 7) {
            return;
        }
        mouseEvent.consume();
        this.x2 = this.x1;
        this.y2 = this.y1;
        if (this.st > 0) {
            this.repaint();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void paint(Graphics graphics) {
        int n = this.lines.size();
        if (this.bg != null) {
            graphics.drawImage(this.bg, 0, 0, this);
        }
        switch (ctype) {
            case 8: {
                if (n <= 0) break;
                for (int i = 0; i < n; ++i) {
                    this.pointPaint(graphics, (Point)this.lines.elementAt(i));
                }
                break;
            }
            case 0: 
            case 3: 
            case 7: {
                Point point;
                if (n > 0) {
                    Point point2 = (Point)this.lines.elementAt(0);
                    for (int i = 1; i < n; ++i) {
                        point = (Point)this.lines.elementAt(i);
                        graphics.drawLine(point2.x, point2.y, point.x, point.y);
                        point2 = point;
                    }
                    if (this.st == 1) {
                        graphics.drawLine(this.x1, this.y1, this.x2, this.y2);
                    }
                }
                if (ctype != 7 || n <= 1) break;
                Point point3 = (Point)this.lines.elementAt(0);
                point = (Point)this.lines.elementAt(n - 1);
                if (this.st == 0) {
                    graphics.drawLine(point3.x, point3.y, point.x, point.y);
                    break;
                }
                graphics.drawLine(point3.x, point3.y, this.x2, this.y2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                if (this.st <= 0) break;
                int n2 = Math.min(this.x1, this.x2);
                int n3 = Math.min(this.y1, this.y2);
                int n4 = Math.max(this.x1, this.x2);
                int n5 = Math.max(this.y1, this.y2);
                int n6 = Math.max(Math.abs(this.x2 - this.x1), Math.abs(this.y2 - this.y1));
                if (n6 < 10) {
                    n6 = 10;
                }
                n6 = 500 / n6 + 1;
                switch (ctype) {
                    case 1: {
                        graphics.drawRect(n2, n3, n4 - n2, n5 - n3);
                        break;
                    }
                    case 5: {
                        graphics.fillOval(this.x1 - 2, this.y1 - 2, 4, 4);
                        graphics.drawLine(this.x1, this.y1, n6 * this.x2 - (n6 - 1) * this.x1, n6 * this.y2 - (n6 - 1) * this.y1);
                        break;
                    }
                    case 4: {
                        graphics.fillOval(this.x1 - 2, this.y1 - 2, 4, 4);
                        graphics.fillOval(this.x2 - 2, this.y2 - 2, 4, 4);
                        graphics.drawLine(n6 * this.x1 - (n6 - 1) * this.x2, n6 * this.y1 - (n6 - 1) * this.y2, n6 * this.x2 - (n6 - 1) * this.x1, n6 * this.y2 - (n6 - 1) * this.y1);
                        break;
                    }
                    case 6: {
                        graphics.drawLine(this.x1, this.y1, this.x2, this.y2);
                    }
                }
                break;
            }
            case 2: {
                if (this.st <= 0) break;
                this.pointPaint(graphics, new Point(this.x1, this.y1));
                graphics.drawOval(this.x1 - this.radius, this.y1 - this.radius, this.radius * 2, this.radius * 2);
            }
        }
    }

    void pointPaint(Graphics graphics, Point point) {
        graphics.drawLine(point.x - ll, point.y + ll, point.x + ll, point.y - ll);
        graphics.drawLine(point.x + ll, point.y + ll, point.x - ll, point.y - ll);
    }

    static {
        ll = 4;
    }
}

