require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&__ASM_PTRACE_H)) {
    eval 'sub __ASM_PTRACE_H () {1;}' unless defined(&__ASM_PTRACE_H);
    require 'linux/types.ph';
    require 'asm/hwcap.ph';
    require 'asm/sve_context.ph';
    eval 'sub PSR_MODE_EL0t () {0x;}' unless defined(&PSR_MODE_EL0t);
    eval 'sub PSR_MODE_EL1t () {0x4;}' unless defined(&PSR_MODE_EL1t);
    eval 'sub PSR_MODE_EL1h () {0x5;}' unless defined(&PSR_MODE_EL1h);
    eval 'sub PSR_MODE_EL2t () {0x8;}' unless defined(&PSR_MODE_EL2t);
    eval 'sub PSR_MODE_EL2h () {0x9;}' unless defined(&PSR_MODE_EL2h);
    eval 'sub PSR_MODE_EL3t () {0xc;}' unless defined(&PSR_MODE_EL3t);
    eval 'sub PSR_MODE_EL3h () {0xd;}' unless defined(&PSR_MODE_EL3h);
    eval 'sub PSR_MODE_MASK () {0xf;}' unless defined(&PSR_MODE_MASK);
    eval 'sub PSR_MODE32_BIT () {0x10;}' unless defined(&PSR_MODE32_BIT);
    eval 'sub PSR_F_BIT () {0x40;}' unless defined(&PSR_F_BIT);
    eval 'sub PSR_I_BIT () {0x80;}' unless defined(&PSR_I_BIT);
    eval 'sub PSR_A_BIT () {0x100;}' unless defined(&PSR_A_BIT);
    eval 'sub PSR_D_BIT () {0x200;}' unless defined(&PSR_D_BIT);
    eval 'sub PSR_BTYPE_MASK () {0xc00;}' unless defined(&PSR_BTYPE_MASK);
    eval 'sub PSR_SSBS_BIT () {0x1000;}' unless defined(&PSR_SSBS_BIT);
    eval 'sub PSR_PAN_BIT () {0x400000;}' unless defined(&PSR_PAN_BIT);
    eval 'sub PSR_UAO_BIT () {0x800000;}' unless defined(&PSR_UAO_BIT);
    eval 'sub PSR_DIT_BIT () {0x1000000;}' unless defined(&PSR_DIT_BIT);
    eval 'sub PSR_TCO_BIT () {0x2000000;}' unless defined(&PSR_TCO_BIT);
    eval 'sub PSR_V_BIT () {0x10000000;}' unless defined(&PSR_V_BIT);
    eval 'sub PSR_C_BIT () {0x20000000;}' unless defined(&PSR_C_BIT);
    eval 'sub PSR_Z_BIT () {0x40000000;}' unless defined(&PSR_Z_BIT);
    eval 'sub PSR_N_BIT () {0x80000000;}' unless defined(&PSR_N_BIT);
    eval 'sub PSR_BTYPE_SHIFT () {10;}' unless defined(&PSR_BTYPE_SHIFT);
    eval 'sub PSR_f () {0xff000000;}' unless defined(&PSR_f);
    eval 'sub PSR_s () {0xff0000;}' unless defined(&PSR_s);
    eval 'sub PSR_x () {0xff00;}' unless defined(&PSR_x);
    eval 'sub PSR_c () {0xff;}' unless defined(&PSR_c);
    eval 'sub PSR_BTYPE_NONE () {(0 &b00 <<  &PSR_BTYPE_SHIFT);}' unless defined(&PSR_BTYPE_NONE);
    eval 'sub PSR_BTYPE_JC () {(0 &b01 <<  &PSR_BTYPE_SHIFT);}' unless defined(&PSR_BTYPE_JC);
    eval 'sub PSR_BTYPE_C () {(0 &b10 <<  &PSR_BTYPE_SHIFT);}' unless defined(&PSR_BTYPE_C);
    eval 'sub PSR_BTYPE_J () {(0 &b11 <<  &PSR_BTYPE_SHIFT);}' unless defined(&PSR_BTYPE_J);
    eval 'sub PTRACE_SYSEMU () {31;}' unless defined(&PTRACE_SYSEMU);
    eval 'sub PTRACE_SYSEMU_SINGLESTEP () {32;}' unless defined(&PTRACE_SYSEMU_SINGLESTEP);
    eval 'sub PTRACE_PEEKMTETAGS () {33;}' unless defined(&PTRACE_PEEKMTETAGS);
    eval 'sub PTRACE_POKEMTETAGS () {34;}' unless defined(&PTRACE_POKEMTETAGS);
    unless(defined(&__ASSEMBLY__)) {
	eval 'sub SVE_PT_REGS_MASK () {(1<< 0);}' unless defined(&SVE_PT_REGS_MASK);
	eval 'sub SVE_PT_REGS_FPSIMD () {0;}' unless defined(&SVE_PT_REGS_FPSIMD);
	eval 'sub SVE_PT_REGS_SVE () { &SVE_PT_REGS_MASK;}' unless defined(&SVE_PT_REGS_SVE);
	eval 'sub SVE_PT_VL_INHERIT () {((1<< 17) >> 16);}' unless defined(&SVE_PT_VL_INHERIT);
	eval 'sub SVE_PT_VL_ONEXEC () {((1<< 18) >> 16);}' unless defined(&SVE_PT_VL_ONEXEC);
	eval 'sub SVE_PT_REGS_OFFSET () {(($sizeof{\'struct user_sve_header\'} + ( &__SVE_VQ_BYTES - 1)) /  &__SVE_VQ_BYTES *  &__SVE_VQ_BYTES);}' unless defined(&SVE_PT_REGS_OFFSET);
	eval 'sub SVE_PT_FPSIMD_OFFSET () { &SVE_PT_REGS_OFFSET;}' unless defined(&SVE_PT_FPSIMD_OFFSET);
	eval 'sub SVE_PT_FPSIMD_SIZE {
	    my($vq, $flags) = @_;
    	    eval q(($sizeof{\'struct user_fpsimd_state\'}));
	}' unless defined(&SVE_PT_FPSIMD_SIZE);
	eval 'sub SVE_PT_SVE_ZREG_SIZE {
	    my($vq) = @_;
    	    eval q( &__SVE_ZREG_SIZE($vq));
	}' unless defined(&SVE_PT_SVE_ZREG_SIZE);
	eval 'sub SVE_PT_SVE_PREG_SIZE {
	    my($vq) = @_;
    	    eval q( &__SVE_PREG_SIZE($vq));
	}' unless defined(&SVE_PT_SVE_PREG_SIZE);
	eval 'sub SVE_PT_SVE_FFR_SIZE {
	    my($vq) = @_;
    	    eval q( &__SVE_FFR_SIZE($vq));
	}' unless defined(&SVE_PT_SVE_FFR_SIZE);
	eval 'sub SVE_PT_SVE_FPSR_SIZE () {$sizeof{ &__u32};}' unless defined(&SVE_PT_SVE_FPSR_SIZE);
	eval 'sub SVE_PT_SVE_FPCR_SIZE () {$sizeof{ &__u32};}' unless defined(&SVE_PT_SVE_FPCR_SIZE);
	eval 'sub SVE_PT_SVE_OFFSET () { &SVE_PT_REGS_OFFSET;}' unless defined(&SVE_PT_SVE_OFFSET);
	eval 'sub SVE_PT_SVE_ZREGS_OFFSET () {( &SVE_PT_REGS_OFFSET +  &__SVE_ZREGS_OFFSET);}' unless defined(&SVE_PT_SVE_ZREGS_OFFSET);
	eval 'sub SVE_PT_SVE_ZREG_OFFSET {
	    my($vq, $n) = @_;
    	    eval q(( &SVE_PT_REGS_OFFSET +  &__SVE_ZREG_OFFSET($vq, $n)));
	}' unless defined(&SVE_PT_SVE_ZREG_OFFSET);
	eval 'sub SVE_PT_SVE_ZREGS_SIZE {
	    my($vq) = @_;
    	    eval q(( &SVE_PT_SVE_ZREG_OFFSET($vq,  &__SVE_NUM_ZREGS) -  &SVE_PT_SVE_ZREGS_OFFSET));
	}' unless defined(&SVE_PT_SVE_ZREGS_SIZE);
	eval 'sub SVE_PT_SVE_PREGS_OFFSET {
	    my($vq) = @_;
    	    eval q(( &SVE_PT_REGS_OFFSET +  &__SVE_PREGS_OFFSET($vq)));
	}' unless defined(&SVE_PT_SVE_PREGS_OFFSET);
	eval 'sub SVE_PT_SVE_PREG_OFFSET {
	    my($vq, $n) = @_;
    	    eval q(( &SVE_PT_REGS_OFFSET +  &__SVE_PREG_OFFSET($vq, $n)));
	}' unless defined(&SVE_PT_SVE_PREG_OFFSET);
	eval 'sub SVE_PT_SVE_PREGS_SIZE {
	    my($vq) = @_;
    	    eval q(( &SVE_PT_SVE_PREG_OFFSET($vq,  &__SVE_NUM_PREGS) -  &SVE_PT_SVE_PREGS_OFFSET($vq)));
	}' unless defined(&SVE_PT_SVE_PREGS_SIZE);
	eval 'sub SVE_PT_SVE_FFR_OFFSET {
	    my($vq) = @_;
    	    eval q(( &SVE_PT_REGS_OFFSET +  &__SVE_FFR_OFFSET($vq)));
	}' unless defined(&SVE_PT_SVE_FFR_OFFSET);
	eval 'sub SVE_PT_SVE_FPSR_OFFSET {
	    my($vq) = @_;
    	    eval q((( &SVE_PT_SVE_FFR_OFFSET($vq) +  &SVE_PT_SVE_FFR_SIZE($vq) + ( &__SVE_VQ_BYTES - 1)) /  &__SVE_VQ_BYTES *  &__SVE_VQ_BYTES));
	}' unless defined(&SVE_PT_SVE_FPSR_OFFSET);
	eval 'sub SVE_PT_SVE_FPCR_OFFSET {
	    my($vq) = @_;
    	    eval q(( &SVE_PT_SVE_FPSR_OFFSET($vq) +  &SVE_PT_SVE_FPSR_SIZE));
	}' unless defined(&SVE_PT_SVE_FPCR_OFFSET);
	eval 'sub SVE_PT_SVE_SIZE {
	    my($vq, $flags) = @_;
    	    eval q((( &SVE_PT_SVE_FPCR_OFFSET($vq) +  &SVE_PT_SVE_FPCR_SIZE -  &SVE_PT_SVE_OFFSET + ( &__SVE_VQ_BYTES - 1)) /  &__SVE_VQ_BYTES *  &__SVE_VQ_BYTES));
	}' unless defined(&SVE_PT_SVE_SIZE);
	eval 'sub SVE_PT_SIZE {
	    my($vq, $flags) = @_;
    	    eval q(((($flags) &  &SVE_PT_REGS_MASK) ==  &SVE_PT_REGS_SVE ?  &SVE_PT_SVE_OFFSET +  &SVE_PT_SVE_SIZE($vq, $flags) : (((($flags) &  &SVE_PT_REGS_MASK) ==  &SVE_PT_REGS_FPSIMD ?  &SVE_PT_FPSIMD_OFFSET +  &SVE_PT_FPSIMD_SIZE($vq, $flags) :  &SVE_PT_REGS_OFFSET))));
	}' unless defined(&SVE_PT_SIZE);
	eval 'sub ZA_PT_VL_INHERIT () {((1<< 17) >> 16);}' unless defined(&ZA_PT_VL_INHERIT);
	eval 'sub ZA_PT_VL_ONEXEC () {((1<< 18) >> 16);}' unless defined(&ZA_PT_VL_ONEXEC);
	eval 'sub ZA_PT_ZA_OFFSET () {(($sizeof{\'struct user_za_header\'} + ( &__SVE_VQ_BYTES - 1)) /  &__SVE_VQ_BYTES *  &__SVE_VQ_BYTES);}' unless defined(&ZA_PT_ZA_OFFSET);
	eval 'sub ZA_PT_ZAV_OFFSET {
	    my($vq, $n) = @_;
    	    eval q(( &ZA_PT_ZA_OFFSET + (($vq *  &__SVE_VQ_BYTES) * $n)));
	}' unless defined(&ZA_PT_ZAV_OFFSET);
	eval 'sub ZA_PT_ZA_SIZE {
	    my($vq) = @_;
    	    eval q((($vq *  &__SVE_VQ_BYTES) * ($vq *  &__SVE_VQ_BYTES)));
	}' unless defined(&ZA_PT_ZA_SIZE);
	eval 'sub ZA_PT_SIZE {
	    my($vq) = @_;
    	    eval q(( &ZA_PT_ZA_OFFSET +  &ZA_PT_ZA_SIZE($vq)));
	}' unless defined(&ZA_PT_SIZE);
    }
}
1;
