require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_COMEDI_H)) {
    eval 'sub _COMEDI_H () {1;}' unless defined(&_COMEDI_H);
    eval 'sub COMEDI_MAJORVERSION () {0;}' unless defined(&COMEDI_MAJORVERSION);
    eval 'sub COMEDI_MINORVERSION () {7;}' unless defined(&COMEDI_MINORVERSION);
    eval 'sub COMEDI_MICROVERSION () {76;}' unless defined(&COMEDI_MICROVERSION);
    eval 'sub VERSION () {"0.7.76";}' unless defined(&VERSION);
    eval 'sub COMEDI_MAJOR () {98;}' unless defined(&COMEDI_MAJOR);
    eval 'sub COMEDI_NDEVICES () {16;}' unless defined(&COMEDI_NDEVICES);
    eval 'sub COMEDI_NDEVCONFOPTS () {32;}' unless defined(&COMEDI_NDEVCONFOPTS);
    eval 'sub COMEDI_DEVCONF_AUX_DATA3_LENGTH () {25;}' unless defined(&COMEDI_DEVCONF_AUX_DATA3_LENGTH);
    eval 'sub COMEDI_DEVCONF_AUX_DATA2_LENGTH () {26;}' unless defined(&COMEDI_DEVCONF_AUX_DATA2_LENGTH);
    eval 'sub COMEDI_DEVCONF_AUX_DATA1_LENGTH () {27;}' unless defined(&COMEDI_DEVCONF_AUX_DATA1_LENGTH);
    eval 'sub COMEDI_DEVCONF_AUX_DATA0_LENGTH () {28;}' unless defined(&COMEDI_DEVCONF_AUX_DATA0_LENGTH);
    eval 'sub COMEDI_DEVCONF_AUX_DATA_HI () {29;}' unless defined(&COMEDI_DEVCONF_AUX_DATA_HI);
    eval 'sub COMEDI_DEVCONF_AUX_DATA_LO () {30;}' unless defined(&COMEDI_DEVCONF_AUX_DATA_LO);
    eval 'sub COMEDI_DEVCONF_AUX_DATA_LENGTH () {31;}' unless defined(&COMEDI_DEVCONF_AUX_DATA_LENGTH);
    eval 'sub COMEDI_NAMELEN () {20;}' unless defined(&COMEDI_NAMELEN);
    eval 'sub CR_PACK {
        my($chan, $rng, $aref) = @_;
	    eval q((((($aref) & 0x3) << 24) | ((($rng) & 0xff) << 16) | ($chan)));
    }' unless defined(&CR_PACK);
    eval 'sub CR_PACK_FLAGS {
        my($chan, $range, $aref, $flags) = @_;
	    eval q(( &CR_PACK($chan, $range, $aref) | (($flags) &  &CR_FLAGS_MASK)));
    }' unless defined(&CR_PACK_FLAGS);
    eval 'sub CR_CHAN {
        my($a) = @_;
	    eval q((($a) & 0xffff));
    }' unless defined(&CR_CHAN);
    eval 'sub CR_RANGE {
        my($a) = @_;
	    eval q(((($a) >> 16) & 0xff));
    }' unless defined(&CR_RANGE);
    eval 'sub CR_AREF {
        my($a) = @_;
	    eval q(((($a) >> 24) & 0x3));
    }' unless defined(&CR_AREF);
    eval 'sub CR_FLAGS_MASK () {0xfc000000;}' unless defined(&CR_FLAGS_MASK);
    eval 'sub CR_ALT_FILTER () {0x4000000;}' unless defined(&CR_ALT_FILTER);
    eval 'sub CR_DITHER () { &CR_ALT_FILTER;}' unless defined(&CR_DITHER);
    eval 'sub CR_DEGLITCH () { &CR_ALT_FILTER;}' unless defined(&CR_DEGLITCH);
    eval 'sub CR_ALT_SOURCE () {0x8000000;}' unless defined(&CR_ALT_SOURCE);
    eval 'sub CR_EDGE () {0x40000000;}' unless defined(&CR_EDGE);
    eval 'sub CR_INVERT () {0x80000000;}' unless defined(&CR_INVERT);
    eval 'sub AREF_GROUND () {0x;}' unless defined(&AREF_GROUND);
    eval 'sub AREF_COMMON () {0x1;}' unless defined(&AREF_COMMON);
    eval 'sub AREF_DIFF () {0x2;}' unless defined(&AREF_DIFF);
    eval 'sub AREF_OTHER () {0x3;}' unless defined(&AREF_OTHER);
    eval 'sub GPCT_RESET () {0x1;}' unless defined(&GPCT_RESET);
    eval 'sub GPCT_SET_SOURCE () {0x2;}' unless defined(&GPCT_SET_SOURCE);
    eval 'sub GPCT_SET_GATE () {0x4;}' unless defined(&GPCT_SET_GATE);
    eval 'sub GPCT_SET_DIRECTION () {0x8;}' unless defined(&GPCT_SET_DIRECTION);
    eval 'sub GPCT_SET_OPERATION () {0x10;}' unless defined(&GPCT_SET_OPERATION);
    eval 'sub GPCT_ARM () {0x20;}' unless defined(&GPCT_ARM);
    eval 'sub GPCT_DISARM () {0x40;}' unless defined(&GPCT_DISARM);
    eval 'sub GPCT_GET_INT_CLK_FRQ () {0x80;}' unless defined(&GPCT_GET_INT_CLK_FRQ);
    eval 'sub GPCT_INT_CLOCK () {0x1;}' unless defined(&GPCT_INT_CLOCK);
    eval 'sub GPCT_EXT_PIN () {0x2;}' unless defined(&GPCT_EXT_PIN);
    eval 'sub GPCT_NO_GATE () {0x4;}' unless defined(&GPCT_NO_GATE);
    eval 'sub GPCT_UP () {0x8;}' unless defined(&GPCT_UP);
    eval 'sub GPCT_DOWN () {0x10;}' unless defined(&GPCT_DOWN);
    eval 'sub GPCT_HWUD () {0x20;}' unless defined(&GPCT_HWUD);
    eval 'sub GPCT_SIMPLE_EVENT () {0x40;}' unless defined(&GPCT_SIMPLE_EVENT);
    eval 'sub GPCT_SINGLE_PERIOD () {0x80;}' unless defined(&GPCT_SINGLE_PERIOD);
    eval 'sub GPCT_SINGLE_PW () {0x100;}' unless defined(&GPCT_SINGLE_PW);
    eval 'sub GPCT_CONT_PULSE_OUT () {0x200;}' unless defined(&GPCT_CONT_PULSE_OUT);
    eval 'sub GPCT_SINGLE_PULSE_OUT () {0x400;}' unless defined(&GPCT_SINGLE_PULSE_OUT);
    eval 'sub INSN_MASK_WRITE () {0x8000000;}' unless defined(&INSN_MASK_WRITE);
    eval 'sub INSN_MASK_READ () {0x4000000;}' unless defined(&INSN_MASK_READ);
    eval 'sub INSN_MASK_SPECIAL () {0x2000000;}' unless defined(&INSN_MASK_SPECIAL);
    eval 'sub INSN_READ () {(0|  &INSN_MASK_READ);}' unless defined(&INSN_READ);
    eval 'sub INSN_WRITE () {(1|  &INSN_MASK_WRITE);}' unless defined(&INSN_WRITE);
    eval 'sub INSN_BITS () {(2|  &INSN_MASK_READ |  &INSN_MASK_WRITE);}' unless defined(&INSN_BITS);
    eval 'sub INSN_CONFIG () {(3|  &INSN_MASK_READ |  &INSN_MASK_WRITE);}' unless defined(&INSN_CONFIG);
    eval 'sub INSN_DEVICE_CONFIG () {( &INSN_CONFIG |  &INSN_MASK_SPECIAL);}' unless defined(&INSN_DEVICE_CONFIG);
    eval 'sub INSN_GTOD () {(4|  &INSN_MASK_READ |  &INSN_MASK_SPECIAL);}' unless defined(&INSN_GTOD);
    eval 'sub INSN_WAIT () {(5|  &INSN_MASK_WRITE |  &INSN_MASK_SPECIAL);}' unless defined(&INSN_WAIT);
    eval 'sub INSN_INTTRIG () {(6|  &INSN_MASK_WRITE |  &INSN_MASK_SPECIAL);}' unless defined(&INSN_INTTRIG);
    eval 'sub CMDF_BOGUS () {0x1;}' unless defined(&CMDF_BOGUS);
    eval 'sub CMDF_PRIORITY () {0x8;}' unless defined(&CMDF_PRIORITY);
    eval 'sub CMDF_WAKE_EOS () {0x20;}' unless defined(&CMDF_WAKE_EOS);
    eval 'sub CMDF_WRITE () {0x40;}' unless defined(&CMDF_WRITE);
    eval 'sub CMDF_RAWDATA () {0x80;}' unless defined(&CMDF_RAWDATA);
    eval 'sub CMDF_ROUND_MASK () {0x30000;}' unless defined(&CMDF_ROUND_MASK);
    eval 'sub CMDF_ROUND_NEAREST () {0x;}' unless defined(&CMDF_ROUND_NEAREST);
    eval 'sub CMDF_ROUND_DOWN () {0x10000;}' unless defined(&CMDF_ROUND_DOWN);
    eval 'sub CMDF_ROUND_UP () {0x20000;}' unless defined(&CMDF_ROUND_UP);
    eval 'sub CMDF_ROUND_UP_NEXT () {0x30000;}' unless defined(&CMDF_ROUND_UP_NEXT);
    eval 'sub COMEDI_EV_START () {0x40000;}' unless defined(&COMEDI_EV_START);
    eval 'sub COMEDI_EV_SCAN_BEGIN () {0x80000;}' unless defined(&COMEDI_EV_SCAN_BEGIN);
    eval 'sub COMEDI_EV_CONVERT () {0x100000;}' unless defined(&COMEDI_EV_CONVERT);
    eval 'sub COMEDI_EV_SCAN_END () {0x200000;}' unless defined(&COMEDI_EV_SCAN_END);
    eval 'sub COMEDI_EV_STOP () {0x400000;}' unless defined(&COMEDI_EV_STOP);
    eval 'sub TRIG_BOGUS () { &CMDF_BOGUS;}' unless defined(&TRIG_BOGUS);
    eval 'sub TRIG_RT () { &CMDF_PRIORITY;}' unless defined(&TRIG_RT);
    eval 'sub TRIG_WAKE_EOS () { &CMDF_WAKE_EOS;}' unless defined(&TRIG_WAKE_EOS);
    eval 'sub TRIG_WRITE () { &CMDF_WRITE;}' unless defined(&TRIG_WRITE);
    eval 'sub TRIG_ROUND_MASK () { &CMDF_ROUND_MASK;}' unless defined(&TRIG_ROUND_MASK);
    eval 'sub TRIG_ROUND_NEAREST () { &CMDF_ROUND_NEAREST;}' unless defined(&TRIG_ROUND_NEAREST);
    eval 'sub TRIG_ROUND_DOWN () { &CMDF_ROUND_DOWN;}' unless defined(&TRIG_ROUND_DOWN);
    eval 'sub TRIG_ROUND_UP () { &CMDF_ROUND_UP;}' unless defined(&TRIG_ROUND_UP);
    eval 'sub TRIG_ROUND_UP_NEXT () { &CMDF_ROUND_UP_NEXT;}' unless defined(&TRIG_ROUND_UP_NEXT);
    eval 'sub TRIG_ANY () {0xffffffff;}' unless defined(&TRIG_ANY);
    eval 'sub TRIG_INVALID () {0x;}' unless defined(&TRIG_INVALID);
    eval 'sub TRIG_NONE () {0x1;}' unless defined(&TRIG_NONE);
    eval 'sub TRIG_NOW () {0x2;}' unless defined(&TRIG_NOW);
    eval 'sub TRIG_FOLLOW () {0x4;}' unless defined(&TRIG_FOLLOW);
    eval 'sub TRIG_TIME () {0x8;}' unless defined(&TRIG_TIME);
    eval 'sub TRIG_TIMER () {0x10;}' unless defined(&TRIG_TIMER);
    eval 'sub TRIG_COUNT () {0x20;}' unless defined(&TRIG_COUNT);
    eval 'sub TRIG_EXT () {0x40;}' unless defined(&TRIG_EXT);
    eval 'sub TRIG_INT () {0x80;}' unless defined(&TRIG_INT);
    eval 'sub TRIG_OTHER () {0x100;}' unless defined(&TRIG_OTHER);
    eval 'sub SDF_BUSY () {0x1;}' unless defined(&SDF_BUSY);
    eval 'sub SDF_BUSY_OWNER () {0x2;}' unless defined(&SDF_BUSY_OWNER);
    eval 'sub SDF_LOCKED () {0x4;}' unless defined(&SDF_LOCKED);
    eval 'sub SDF_LOCK_OWNER () {0x8;}' unless defined(&SDF_LOCK_OWNER);
    eval 'sub SDF_MAXDATA () {0x10;}' unless defined(&SDF_MAXDATA);
    eval 'sub SDF_FLAGS () {0x20;}' unless defined(&SDF_FLAGS);
    eval 'sub SDF_RANGETYPE () {0x40;}' unless defined(&SDF_RANGETYPE);
    eval 'sub SDF_PWM_COUNTER () {0x80;}' unless defined(&SDF_PWM_COUNTER);
    eval 'sub SDF_PWM_HBRIDGE () {0x100;}' unless defined(&SDF_PWM_HBRIDGE);
    eval 'sub SDF_CMD () {0x1000;}' unless defined(&SDF_CMD);
    eval 'sub SDF_SOFT_CALIBRATED () {0x2000;}' unless defined(&SDF_SOFT_CALIBRATED);
    eval 'sub SDF_CMD_WRITE () {0x4000;}' unless defined(&SDF_CMD_WRITE);
    eval 'sub SDF_CMD_READ () {0x8000;}' unless defined(&SDF_CMD_READ);
    eval 'sub SDF_READABLE () {0x10000;}' unless defined(&SDF_READABLE);
    eval 'sub SDF_WRITABLE () {0x20000;}' unless defined(&SDF_WRITABLE);
    eval 'sub SDF_WRITEABLE () { &SDF_WRITABLE;}' unless defined(&SDF_WRITEABLE);
    eval 'sub SDF_INTERNAL () {0x40000;}' unless defined(&SDF_INTERNAL);
    eval 'sub SDF_GROUND () {0x100000;}' unless defined(&SDF_GROUND);
    eval 'sub SDF_COMMON () {0x200000;}' unless defined(&SDF_COMMON);
    eval 'sub SDF_DIFF () {0x400000;}' unless defined(&SDF_DIFF);
    eval 'sub SDF_OTHER () {0x800000;}' unless defined(&SDF_OTHER);
    eval 'sub SDF_DITHER () {0x1000000;}' unless defined(&SDF_DITHER);
    eval 'sub SDF_DEGLITCH () {0x2000000;}' unless defined(&SDF_DEGLITCH);
    eval 'sub SDF_MMAP () {0x4000000;}' unless defined(&SDF_MMAP);
    eval 'sub SDF_RUNNING () {0x8000000;}' unless defined(&SDF_RUNNING);
    eval 'sub SDF_LSAMPL () {0x10000000;}' unless defined(&SDF_LSAMPL);
    eval 'sub SDF_PACKED () {0x20000000;}' unless defined(&SDF_PACKED);
    eval("sub COMEDI_SUBD_UNUSED () { 0; }") unless defined(&COMEDI_SUBD_UNUSED);
    eval("sub COMEDI_SUBD_AI () { 1; }") unless defined(&COMEDI_SUBD_AI);
    eval("sub COMEDI_SUBD_AO () { 2; }") unless defined(&COMEDI_SUBD_AO);
    eval("sub COMEDI_SUBD_DI () { 3; }") unless defined(&COMEDI_SUBD_DI);
    eval("sub COMEDI_SUBD_DO () { 4; }") unless defined(&COMEDI_SUBD_DO);
    eval("sub COMEDI_SUBD_DIO () { 5; }") unless defined(&COMEDI_SUBD_DIO);
    eval("sub COMEDI_SUBD_COUNTER () { 6; }") unless defined(&COMEDI_SUBD_COUNTER);
    eval("sub COMEDI_SUBD_TIMER () { 7; }") unless defined(&COMEDI_SUBD_TIMER);
    eval("sub COMEDI_SUBD_MEMORY () { 8; }") unless defined(&COMEDI_SUBD_MEMORY);
    eval("sub COMEDI_SUBD_CALIB () { 9; }") unless defined(&COMEDI_SUBD_CALIB);
    eval("sub COMEDI_SUBD_PROC () { 10; }") unless defined(&COMEDI_SUBD_PROC);
    eval("sub COMEDI_SUBD_SERIAL () { 11; }") unless defined(&COMEDI_SUBD_SERIAL);
    eval("sub COMEDI_SUBD_PWM () { 12; }") unless defined(&COMEDI_SUBD_PWM);
    eval("sub COMEDI_INPUT () { 0; }") unless defined(&COMEDI_INPUT);
    eval("sub COMEDI_OUTPUT () { 1; }") unless defined(&COMEDI_OUTPUT);
    eval("sub COMEDI_OPENDRAIN () { 2; }") unless defined(&COMEDI_OPENDRAIN);
    eval("sub INSN_CONFIG_DIO_INPUT () { COMEDI_INPUT; }") unless defined(&INSN_CONFIG_DIO_INPUT);
    eval("sub INSN_CONFIG_DIO_OUTPUT () { COMEDI_OUTPUT; }") unless defined(&INSN_CONFIG_DIO_OUTPUT);
    eval("sub INSN_CONFIG_DIO_OPENDRAIN () { COMEDI_OPENDRAIN; }") unless defined(&INSN_CONFIG_DIO_OPENDRAIN);
    eval("sub INSN_CONFIG_ANALOG_TRIG () { 16; }") unless defined(&INSN_CONFIG_ANALOG_TRIG);
    eval("sub INSN_CONFIG_ALT_SOURCE () { 20; }") unless defined(&INSN_CONFIG_ALT_SOURCE);
    eval("sub INSN_CONFIG_DIGITAL_TRIG () { 21; }") unless defined(&INSN_CONFIG_DIGITAL_TRIG);
    eval("sub INSN_CONFIG_BLOCK_SIZE () { 22; }") unless defined(&INSN_CONFIG_BLOCK_SIZE);
    eval("sub INSN_CONFIG_TIMER_1 () { 23; }") unless defined(&INSN_CONFIG_TIMER_1);
    eval("sub INSN_CONFIG_FILTER () { 24; }") unless defined(&INSN_CONFIG_FILTER);
    eval("sub INSN_CONFIG_CHANGE_NOTIFY () { 25; }") unless defined(&INSN_CONFIG_CHANGE_NOTIFY);
    eval("sub INSN_CONFIG_SERIAL_CLOCK () { 26; }") unless defined(&INSN_CONFIG_SERIAL_CLOCK);
    eval("sub INSN_CONFIG_BIDIRECTIONAL_DATA () { 27; }") unless defined(&INSN_CONFIG_BIDIRECTIONAL_DATA);
    eval("sub INSN_CONFIG_DIO_QUERY () { 28; }") unless defined(&INSN_CONFIG_DIO_QUERY);
    eval("sub INSN_CONFIG_PWM_OUTPUT () { 29; }") unless defined(&INSN_CONFIG_PWM_OUTPUT);
    eval("sub INSN_CONFIG_GET_PWM_OUTPUT () { 30; }") unless defined(&INSN_CONFIG_GET_PWM_OUTPUT);
    eval("sub INSN_CONFIG_ARM () { 31; }") unless defined(&INSN_CONFIG_ARM);
    eval("sub INSN_CONFIG_DISARM () { 32; }") unless defined(&INSN_CONFIG_DISARM);
    eval("sub INSN_CONFIG_GET_COUNTER_STATUS () { 33; }") unless defined(&INSN_CONFIG_GET_COUNTER_STATUS);
    eval("sub INSN_CONFIG_RESET () { 34; }") unless defined(&INSN_CONFIG_RESET);
    eval("sub INSN_CONFIG_GPCT_SINGLE_PULSE_GENERATOR () { 1001; }") unless defined(&INSN_CONFIG_GPCT_SINGLE_PULSE_GENERATOR);
    eval("sub INSN_CONFIG_GPCT_PULSE_TRAIN_GENERATOR () { 1002; }") unless defined(&INSN_CONFIG_GPCT_PULSE_TRAIN_GENERATOR);
    eval("sub INSN_CONFIG_GPCT_QUADRATURE_ENCODER () { 1003; }") unless defined(&INSN_CONFIG_GPCT_QUADRATURE_ENCODER);
    eval("sub INSN_CONFIG_SET_GATE_SRC () { 2001; }") unless defined(&INSN_CONFIG_SET_GATE_SRC);
    eval("sub INSN_CONFIG_GET_GATE_SRC () { 2002; }") unless defined(&INSN_CONFIG_GET_GATE_SRC);
    eval("sub INSN_CONFIG_SET_CLOCK_SRC () { 2003; }") unless defined(&INSN_CONFIG_SET_CLOCK_SRC);
    eval("sub INSN_CONFIG_GET_CLOCK_SRC () { 2004; }") unless defined(&INSN_CONFIG_GET_CLOCK_SRC);
    eval("sub INSN_CONFIG_SET_OTHER_SRC () { 2005; }") unless defined(&INSN_CONFIG_SET_OTHER_SRC);
    eval("sub INSN_CONFIG_GET_HARDWARE_BUFFER_SIZE () { 2006; }") unless defined(&INSN_CONFIG_GET_HARDWARE_BUFFER_SIZE);
    eval("sub INSN_CONFIG_SET_COUNTER_MODE () { 4097; }") unless defined(&INSN_CONFIG_SET_COUNTER_MODE);
    eval("sub INSN_CONFIG_8254_SET_MODE () { INSN_CONFIG_SET_COUNTER_MODE; }") unless defined(&INSN_CONFIG_8254_SET_MODE);
    eval("sub INSN_CONFIG_8254_READ_STATUS () { 4098; }") unless defined(&INSN_CONFIG_8254_READ_STATUS);
    eval("sub INSN_CONFIG_SET_ROUTING () { 4099; }") unless defined(&INSN_CONFIG_SET_ROUTING);
    eval("sub INSN_CONFIG_GET_ROUTING () { 4109; }") unless defined(&INSN_CONFIG_GET_ROUTING);
    eval("sub INSN_CONFIG_PWM_SET_PERIOD () { 5000; }") unless defined(&INSN_CONFIG_PWM_SET_PERIOD);
    eval("sub INSN_CONFIG_PWM_GET_PERIOD () { 5001; }") unless defined(&INSN_CONFIG_PWM_GET_PERIOD);
    eval("sub INSN_CONFIG_GET_PWM_STATUS () { 5002; }") unless defined(&INSN_CONFIG_GET_PWM_STATUS);
    eval("sub INSN_CONFIG_PWM_SET_H_BRIDGE () { 5003; }") unless defined(&INSN_CONFIG_PWM_SET_H_BRIDGE);
    eval("sub INSN_CONFIG_PWM_GET_H_BRIDGE () { 5004; }") unless defined(&INSN_CONFIG_PWM_GET_H_BRIDGE);
    eval("sub INSN_CONFIG_GET_CMD_TIMING_CONSTRAINTS () { 5005; }") unless defined(&INSN_CONFIG_GET_CMD_TIMING_CONSTRAINTS);
    eval("sub INSN_DEVICE_CONFIG_TEST_ROUTE () { 0; }") unless defined(&INSN_DEVICE_CONFIG_TEST_ROUTE);
    eval("sub INSN_DEVICE_CONFIG_CONNECT_ROUTE () { 1; }") unless defined(&INSN_DEVICE_CONFIG_CONNECT_ROUTE);
    eval("sub INSN_DEVICE_CONFIG_DISCONNECT_ROUTE () { 2; }") unless defined(&INSN_DEVICE_CONFIG_DISCONNECT_ROUTE);
    eval("sub INSN_DEVICE_CONFIG_GET_ROUTES () { 3; }") unless defined(&INSN_DEVICE_CONFIG_GET_ROUTES);
    eval("sub COMEDI_DIGITAL_TRIG_DISABLE () { 0; }") unless defined(&COMEDI_DIGITAL_TRIG_DISABLE);
    eval("sub COMEDI_DIGITAL_TRIG_ENABLE_EDGES () { 1; }") unless defined(&COMEDI_DIGITAL_TRIG_ENABLE_EDGES);
    eval("sub COMEDI_DIGITAL_TRIG_ENABLE_LEVELS () { 2; }") unless defined(&COMEDI_DIGITAL_TRIG_ENABLE_LEVELS);
    eval("sub COMEDI_UNKNOWN_SUPPORT () { 0; }") unless defined(&COMEDI_UNKNOWN_SUPPORT);
    eval("sub COMEDI_SUPPORTED () { 1; }") unless defined(&COMEDI_SUPPORTED);
    eval("sub COMEDI_UNSUPPORTED () { 2; }") unless defined(&COMEDI_UNSUPPORTED);
    eval("sub COMEDI_COUNTER_ARMED () { 0x1; }") unless defined(&COMEDI_COUNTER_ARMED);
    eval("sub COMEDI_COUNTER_COUNTING () { 0x2; }") unless defined(&COMEDI_COUNTER_COUNTING);
    eval("sub COMEDI_COUNTER_TERMINAL_COUNT () { 0x4; }") unless defined(&COMEDI_COUNTER_TERMINAL_COUNT);
    eval 'sub CIO () {ord(\'d\');}' unless defined(&CIO);
    eval 'sub COMEDI_DEVCONFIG () { &_IOW( &CIO, 0, \'struct comedi_devconfig\');}' unless defined(&COMEDI_DEVCONFIG);
    eval 'sub COMEDI_DEVINFO () { &_IOR( &CIO, 1, \'struct comedi_devinfo\');}' unless defined(&COMEDI_DEVINFO);
    eval 'sub COMEDI_SUBDINFO () { &_IOR( &CIO, 2, \'struct comedi_subdinfo\');}' unless defined(&COMEDI_SUBDINFO);
    eval 'sub COMEDI_CHANINFO () { &_IOR( &CIO, 3, \'struct comedi_chaninfo\');}' unless defined(&COMEDI_CHANINFO);
    eval 'sub COMEDI_LOCK () { &_IO( &CIO, 5);}' unless defined(&COMEDI_LOCK);
    eval 'sub COMEDI_UNLOCK () { &_IO( &CIO, 6);}' unless defined(&COMEDI_UNLOCK);
    eval 'sub COMEDI_CANCEL () { &_IO( &CIO, 7);}' unless defined(&COMEDI_CANCEL);
    eval 'sub COMEDI_RANGEINFO () { &_IOR( &CIO, 8, \'struct comedi_rangeinfo\');}' unless defined(&COMEDI_RANGEINFO);
    eval 'sub COMEDI_CMD () { &_IOR( &CIO, 9, \'struct comedi_cmd\');}' unless defined(&COMEDI_CMD);
    eval 'sub COMEDI_CMDTEST () { &_IOR( &CIO, 10, \'struct comedi_cmd\');}' unless defined(&COMEDI_CMDTEST);
    eval 'sub COMEDI_INSNLIST () { &_IOR( &CIO, 11, \'struct comedi_insnlist\');}' unless defined(&COMEDI_INSNLIST);
    eval 'sub COMEDI_INSN () { &_IOR( &CIO, 12, \'struct comedi_insn\');}' unless defined(&COMEDI_INSN);
    eval 'sub COMEDI_BUFCONFIG () { &_IOR( &CIO, 13, \'struct comedi_bufconfig\');}' unless defined(&COMEDI_BUFCONFIG);
    eval 'sub COMEDI_BUFINFO () { &_IOWR( &CIO, 14, \'struct comedi_bufinfo\');}' unless defined(&COMEDI_BUFINFO);
    eval 'sub COMEDI_POLL () { &_IO( &CIO, 15);}' unless defined(&COMEDI_POLL);
    eval 'sub COMEDI_SETRSUBD () { &_IO( &CIO, 16);}' unless defined(&COMEDI_SETRSUBD);
    eval 'sub COMEDI_SETWSUBD () { &_IO( &CIO, 17);}' unless defined(&COMEDI_SETWSUBD);
    eval 'sub __RANGE {
        my($a, $b) = @_;
	    eval q((((($a) & 0xffff) << 16) | (($b) & 0xffff)));
    }' unless defined(&__RANGE);
    eval 'sub RANGE_OFFSET {
        my($a) = @_;
	    eval q(((($a) >> 16) & 0xffff));
    }' unless defined(&RANGE_OFFSET);
    eval 'sub RANGE_LENGTH {
        my($b) = @_;
	    eval q((($b) & 0xffff));
    }' unless defined(&RANGE_LENGTH);
    eval 'sub RF_UNIT {
        my($flags) = @_;
	    eval q((($flags) & 0xff));
    }' unless defined(&RF_UNIT);
    eval 'sub RF_EXTERNAL () {0x100;}' unless defined(&RF_EXTERNAL);
    eval 'sub UNIT_volt () {0;}' unless defined(&UNIT_volt);
    eval 'sub UNIT_mA () {1;}' unless defined(&UNIT_mA);
    eval 'sub UNIT_none () {2;}' unless defined(&UNIT_none);
    eval 'sub COMEDI_MIN_SPEED () {0xffffffff;}' unless defined(&COMEDI_MIN_SPEED);
    eval("sub I8254_MODE0 () { (0<<1); }") unless defined(&I8254_MODE0);
    eval("sub I8254_MODE1 () { (1<<1); }") unless defined(&I8254_MODE1);
    eval("sub I8254_MODE2 () { (2<<1); }") unless defined(&I8254_MODE2);
    eval("sub I8254_MODE3 () { (3<<1); }") unless defined(&I8254_MODE3);
    eval("sub I8254_MODE4 () { (4<<1); }") unless defined(&I8254_MODE4);
    eval("sub I8254_MODE5 () { (5<<1); }") unless defined(&I8254_MODE5);
    eval("sub I8254_BCD () { 1; }") unless defined(&I8254_BCD);
    eval("sub I8254_BINARY () { 0; }") unless defined(&I8254_BINARY);
    eval 'sub NI_NAMES_BASE () {0x8000;}' unless defined(&NI_NAMES_BASE);
    eval 'sub _TERM_N {
        my($base, $n, $x) = @_;
	    eval q((($base) + (($x) & (($n) - 1))));
    }' unless defined(&_TERM_N);
    eval 'sub NI_PFI {
        my($x) = @_;
	    eval q( &_TERM_N( &NI_NAMES_BASE, 64, $x));
    }' unless defined(&NI_PFI);
    eval 'sub TRIGGER_LINE {
        my($x) = @_;
	    eval q( &_TERM_N( &NI_PFI(-1) + 1, 8, $x));
    }' unless defined(&TRIGGER_LINE);
    eval 'sub NI_RTSI_BRD {
        my($x) = @_;
	    eval q( &_TERM_N( &TRIGGER_LINE(-1) + 1, 4, $x));
    }' unless defined(&NI_RTSI_BRD);
    eval 'sub NI_MAX_COUNTERS () {8;}' unless defined(&NI_MAX_COUNTERS);
    eval 'sub NI_COUNTER_NAMES_BASE () {( &NI_RTSI_BRD(-1) + 1);}' unless defined(&NI_COUNTER_NAMES_BASE);
    eval 'sub NI_CtrSource {
        my($x) = @_;
	    eval q( &_TERM_N( &NI_COUNTER_NAMES_BASE,  &NI_MAX_COUNTERS, $x));
    }' unless defined(&NI_CtrSource);
    eval 'sub NI_GATES_NAMES_BASE () {( &NI_CtrSource(-1) + 1);}' unless defined(&NI_GATES_NAMES_BASE);
    eval 'sub NI_CtrGate {
        my($x) = @_;
	    eval q( &_TERM_N( &NI_GATES_NAMES_BASE,  &NI_MAX_COUNTERS, $x));
    }' unless defined(&NI_CtrGate);
    eval 'sub NI_CtrAux {
        my($x) = @_;
	    eval q( &_TERM_N( &NI_CtrGate(-1) + 1,  &NI_MAX_COUNTERS, $x));
    }' unless defined(&NI_CtrAux);
    eval 'sub NI_CtrA {
        my($x) = @_;
	    eval q( &_TERM_N( &NI_CtrAux(-1) + 1,  &NI_MAX_COUNTERS, $x));
    }' unless defined(&NI_CtrA);
    eval 'sub NI_CtrB {
        my($x) = @_;
	    eval q( &_TERM_N( &NI_CtrA(-1) + 1,  &NI_MAX_COUNTERS, $x));
    }' unless defined(&NI_CtrB);
    eval 'sub NI_CtrZ {
        my($x) = @_;
	    eval q( &_TERM_N( &NI_CtrB(-1) + 1,  &NI_MAX_COUNTERS, $x));
    }' unless defined(&NI_CtrZ);
    eval 'sub NI_GATES_NAMES_MAX () { &NI_CtrZ(-1);}' unless defined(&NI_GATES_NAMES_MAX);
    eval 'sub NI_CtrArmStartTrigger {
        my($x) = @_;
	    eval q( &_TERM_N( &NI_CtrZ(-1) + 1,  &NI_MAX_COUNTERS, $x));
    }' unless defined(&NI_CtrArmStartTrigger);
    eval 'sub NI_CtrInternalOutput {
        my($x) = @_;
	    eval q( &_TERM_N( &NI_CtrArmStartTrigger(-1) + 1,  &NI_MAX_COUNTERS, $x));
    }' unless defined(&NI_CtrInternalOutput);
    eval 'sub NI_CtrOut {
        my($x) = @_;
	    eval q( &_TERM_N( &NI_CtrInternalOutput(-1) + 1,  &NI_MAX_COUNTERS, $x));
    }' unless defined(&NI_CtrOut);
    eval 'sub NI_CtrSampleClock {
        my($x) = @_;
	    eval q( &_TERM_N( &NI_CtrOut(-1) + 1,  &NI_MAX_COUNTERS, $x));
    }' unless defined(&NI_CtrSampleClock);
    eval 'sub NI_COUNTER_NAMES_MAX () { &NI_CtrSampleClock(-1);}' unless defined(&NI_COUNTER_NAMES_MAX);
    eval("sub PXI_Star () { NI_COUNTER_NAMES_MAX+1; }") unless defined(&PXI_Star);
    eval("sub PXI_Clk10 () { 1; }") unless defined(&PXI_Clk10);
    eval("sub PXIe_Clk100 () { 2; }") unless defined(&PXIe_Clk100);
    eval("sub NI_AI_SampleClock () { 3; }") unless defined(&NI_AI_SampleClock);
    eval("sub NI_AI_SampleClockTimebase () { 4; }") unless defined(&NI_AI_SampleClockTimebase);
    eval("sub NI_AI_StartTrigger () { 5; }") unless defined(&NI_AI_StartTrigger);
    eval("sub NI_AI_ReferenceTrigger () { 6; }") unless defined(&NI_AI_ReferenceTrigger);
    eval("sub NI_AI_ConvertClock () { 7; }") unless defined(&NI_AI_ConvertClock);
    eval("sub NI_AI_ConvertClockTimebase () { 8; }") unless defined(&NI_AI_ConvertClockTimebase);
    eval("sub NI_AI_PauseTrigger () { 9; }") unless defined(&NI_AI_PauseTrigger);
    eval("sub NI_AI_HoldCompleteEvent () { 10; }") unless defined(&NI_AI_HoldCompleteEvent);
    eval("sub NI_AI_HoldComplete () { 11; }") unless defined(&NI_AI_HoldComplete);
    eval("sub NI_AI_ExternalMUXClock () { 12; }") unless defined(&NI_AI_ExternalMUXClock);
    eval("sub NI_AI_STOP () { 13; }") unless defined(&NI_AI_STOP);
    eval("sub NI_AO_SampleClock () { 14; }") unless defined(&NI_AO_SampleClock);
    eval("sub NI_AO_SampleClockTimebase () { 15; }") unless defined(&NI_AO_SampleClockTimebase);
    eval("sub NI_AO_StartTrigger () { 16; }") unless defined(&NI_AO_StartTrigger);
    eval("sub NI_AO_PauseTrigger () { 17; }") unless defined(&NI_AO_PauseTrigger);
    eval("sub NI_DI_SampleClock () { 18; }") unless defined(&NI_DI_SampleClock);
    eval("sub NI_DI_SampleClockTimebase () { 19; }") unless defined(&NI_DI_SampleClockTimebase);
    eval("sub NI_DI_StartTrigger () { 20; }") unless defined(&NI_DI_StartTrigger);
    eval("sub NI_DI_ReferenceTrigger () { 21; }") unless defined(&NI_DI_ReferenceTrigger);
    eval("sub NI_DI_PauseTrigger () { 22; }") unless defined(&NI_DI_PauseTrigger);
    eval("sub NI_DI_InputBufferFull () { 23; }") unless defined(&NI_DI_InputBufferFull);
    eval("sub NI_DI_ReadyForStartEvent () { 24; }") unless defined(&NI_DI_ReadyForStartEvent);
    eval("sub NI_DI_ReadyForTransferEventBurst () { 25; }") unless defined(&NI_DI_ReadyForTransferEventBurst);
    eval("sub NI_DI_ReadyForTransferEventPipelined () { 26; }") unless defined(&NI_DI_ReadyForTransferEventPipelined);
    eval("sub NI_DO_SampleClock () { 27; }") unless defined(&NI_DO_SampleClock);
    eval("sub NI_DO_SampleClockTimebase () { 28; }") unless defined(&NI_DO_SampleClockTimebase);
    eval("sub NI_DO_StartTrigger () { 29; }") unless defined(&NI_DO_StartTrigger);
    eval("sub NI_DO_PauseTrigger () { 30; }") unless defined(&NI_DO_PauseTrigger);
    eval("sub NI_DO_OutputBufferFull () { 31; }") unless defined(&NI_DO_OutputBufferFull);
    eval("sub NI_DO_DataActiveEvent () { 32; }") unless defined(&NI_DO_DataActiveEvent);
    eval("sub NI_DO_ReadyForStartEvent () { 33; }") unless defined(&NI_DO_ReadyForStartEvent);
    eval("sub NI_DO_ReadyForTransferEvent () { 34; }") unless defined(&NI_DO_ReadyForTransferEvent);
    eval("sub NI_MasterTimebase () { 35; }") unless defined(&NI_MasterTimebase);
    eval("sub NI_20MHzTimebase () { 36; }") unless defined(&NI_20MHzTimebase);
    eval("sub NI_80MHzTimebase () { 37; }") unless defined(&NI_80MHzTimebase);
    eval("sub NI_100MHzTimebase () { 38; }") unless defined(&NI_100MHzTimebase);
    eval("sub NI_200MHzTimebase () { 39; }") unless defined(&NI_200MHzTimebase);
    eval("sub NI_100kHzTimebase () { 40; }") unless defined(&NI_100kHzTimebase);
    eval("sub NI_10MHzRefClock () { 41; }") unless defined(&NI_10MHzRefClock);
    eval("sub NI_FrequencyOutput () { 42; }") unless defined(&NI_FrequencyOutput);
    eval("sub NI_ChangeDetectionEvent () { 43; }") unless defined(&NI_ChangeDetectionEvent);
    eval("sub NI_AnalogComparisonEvent () { 44; }") unless defined(&NI_AnalogComparisonEvent);
    eval("sub NI_WatchdogExpiredEvent () { 45; }") unless defined(&NI_WatchdogExpiredEvent);
    eval("sub NI_WatchdogExpirationTrigger () { 46; }") unless defined(&NI_WatchdogExpirationTrigger);
    eval("sub NI_SCXI_Trig1 () { 47; }") unless defined(&NI_SCXI_Trig1);
    eval("sub NI_LogicLow () { 48; }") unless defined(&NI_LogicLow);
    eval("sub NI_LogicHigh () { 49; }") unless defined(&NI_LogicHigh);
    eval("sub NI_ExternalStrobe () { 50; }") unless defined(&NI_ExternalStrobe);
    eval("sub NI_PFI_DO () { 51; }") unless defined(&NI_PFI_DO);
    eval("sub NI_CaseGround () { 52; }") unless defined(&NI_CaseGround);
    eval("sub NI_RGOUT0 () { 53; }") unless defined(&NI_RGOUT0);
    eval("sub _NI_NAMES_MAX_PLUS_1 () { 54; }") unless defined(&_NI_NAMES_MAX_PLUS_1);
    eval("sub NI_NUM_NAMES () { _NI_NAMES_MAX_PLUS_1-NI_NAMES_BASE; }") unless defined(&NI_NUM_NAMES);
    eval 'sub NI_USUAL_PFI_SELECT {
        my($x) = @_;
	    eval q(((($x) < 10) ? (0x1 + ($x)) : (0xb + ($x))));
    }' unless defined(&NI_USUAL_PFI_SELECT);
    eval 'sub NI_USUAL_RTSI_SELECT {
        my($x) = @_;
	    eval q(((($x) < 7) ? (0xb + ($x)) : 0x1b));
    }' unless defined(&NI_USUAL_RTSI_SELECT);
    eval 'sub NI_GPCT_COUNTING_MODE_SHIFT () {16;}' unless defined(&NI_GPCT_COUNTING_MODE_SHIFT);
    eval 'sub NI_GPCT_INDEX_PHASE_BITSHIFT () {20;}' unless defined(&NI_GPCT_INDEX_PHASE_BITSHIFT);
    eval 'sub NI_GPCT_COUNTING_DIRECTION_SHIFT () {24;}' unless defined(&NI_GPCT_COUNTING_DIRECTION_SHIFT);
    eval("sub NI_GPCT_GATE_ON_BOTH_EDGES_BIT () { 0x4; }") unless defined(&NI_GPCT_GATE_ON_BOTH_EDGES_BIT);
    eval("sub NI_GPCT_EDGE_GATE_MODE_MASK () { 0x18; }") unless defined(&NI_GPCT_EDGE_GATE_MODE_MASK);
    eval("sub NI_GPCT_EDGE_GATE_STARTS_STOPS_BITS () { 0x0; }") unless defined(&NI_GPCT_EDGE_GATE_STARTS_STOPS_BITS);
    eval("sub NI_GPCT_EDGE_GATE_STOPS_STARTS_BITS () { 0x8; }") unless defined(&NI_GPCT_EDGE_GATE_STOPS_STARTS_BITS);
    eval("sub NI_GPCT_EDGE_GATE_STARTS_BITS () { 0x10; }") unless defined(&NI_GPCT_EDGE_GATE_STARTS_BITS);
    eval("sub NI_GPCT_EDGE_GATE_NO_STARTS_NO_STOPS_BITS () { 0x18; }") unless defined(&NI_GPCT_EDGE_GATE_NO_STARTS_NO_STOPS_BITS);
    eval("sub NI_GPCT_STOP_MODE_MASK () { 0x60; }") unless defined(&NI_GPCT_STOP_MODE_MASK);
    eval("sub NI_GPCT_STOP_ON_GATE_BITS () { 0x00; }") unless defined(&NI_GPCT_STOP_ON_GATE_BITS);
    eval("sub NI_GPCT_STOP_ON_GATE_OR_TC_BITS () { 0x20; }") unless defined(&NI_GPCT_STOP_ON_GATE_OR_TC_BITS);
    eval("sub NI_GPCT_STOP_ON_GATE_OR_SECOND_TC_BITS () { 0x40; }") unless defined(&NI_GPCT_STOP_ON_GATE_OR_SECOND_TC_BITS);
    eval("sub NI_GPCT_LOAD_B_SELECT_BIT () { 0x80; }") unless defined(&NI_GPCT_LOAD_B_SELECT_BIT);
    eval("sub NI_GPCT_OUTPUT_MODE_MASK () { 0x300; }") unless defined(&NI_GPCT_OUTPUT_MODE_MASK);
    eval("sub NI_GPCT_OUTPUT_TC_PULSE_BITS () { 0x100; }") unless defined(&NI_GPCT_OUTPUT_TC_PULSE_BITS);
    eval("sub NI_GPCT_OUTPUT_TC_TOGGLE_BITS () { 0x200; }") unless defined(&NI_GPCT_OUTPUT_TC_TOGGLE_BITS);
    eval("sub NI_GPCT_OUTPUT_TC_OR_GATE_TOGGLE_BITS () { 0x300; }") unless defined(&NI_GPCT_OUTPUT_TC_OR_GATE_TOGGLE_BITS);
    eval("sub NI_GPCT_HARDWARE_DISARM_MASK () { 0xc00; }") unless defined(&NI_GPCT_HARDWARE_DISARM_MASK);
    eval("sub NI_GPCT_NO_HARDWARE_DISARM_BITS () { 0x000; }") unless defined(&NI_GPCT_NO_HARDWARE_DISARM_BITS);
    eval("sub NI_GPCT_DISARM_AT_TC_BITS () { 0x400; }") unless defined(&NI_GPCT_DISARM_AT_TC_BITS);
    eval("sub NI_GPCT_DISARM_AT_GATE_BITS () { 0x800; }") unless defined(&NI_GPCT_DISARM_AT_GATE_BITS);
    eval("sub NI_GPCT_DISARM_AT_TC_OR_GATE_BITS () { 0xc00; }") unless defined(&NI_GPCT_DISARM_AT_TC_OR_GATE_BITS);
    eval("sub NI_GPCT_LOADING_ON_TC_BIT () { 0x1000; }") unless defined(&NI_GPCT_LOADING_ON_TC_BIT);
    eval("sub NI_GPCT_LOADING_ON_GATE_BIT () { 0x4000; }") unless defined(&NI_GPCT_LOADING_ON_GATE_BIT);
    eval("sub NI_GPCT_COUNTING_MODE_MASK () { 0x7<<NI_GPCT_COUNTING_MODE_SHIFT; }") unless defined(&NI_GPCT_COUNTING_MODE_MASK);
    eval("sub NI_GPCT_COUNTING_MODE_NORMAL_BITS () { 0x0<<NI_GPCT_COUNTING_MODE_SHIFT; }") unless defined(&NI_GPCT_COUNTING_MODE_NORMAL_BITS);
    eval("sub NI_GPCT_COUNTING_MODE_QUADRATURE_X1_BITS () { 0x1<<NI_GPCT_COUNTING_MODE_SHIFT; }") unless defined(&NI_GPCT_COUNTING_MODE_QUADRATURE_X1_BITS);
    eval("sub NI_GPCT_COUNTING_MODE_QUADRATURE_X2_BITS () { 0x2<<NI_GPCT_COUNTING_MODE_SHIFT; }") unless defined(&NI_GPCT_COUNTING_MODE_QUADRATURE_X2_BITS);
    eval("sub NI_GPCT_COUNTING_MODE_QUADRATURE_X4_BITS () { 0x3<<NI_GPCT_COUNTING_MODE_SHIFT; }") unless defined(&NI_GPCT_COUNTING_MODE_QUADRATURE_X4_BITS);
    eval("sub NI_GPCT_COUNTING_MODE_TWO_PULSE_BITS () { 0x4<<NI_GPCT_COUNTING_MODE_SHIFT; }") unless defined(&NI_GPCT_COUNTING_MODE_TWO_PULSE_BITS);
    eval("sub NI_GPCT_COUNTING_MODE_SYNC_SOURCE_BITS () { 0x6<<NI_GPCT_COUNTING_MODE_SHIFT; }") unless defined(&NI_GPCT_COUNTING_MODE_SYNC_SOURCE_BITS);
    eval("sub NI_GPCT_INDEX_PHASE_MASK () { 0x3<<NI_GPCT_INDEX_PHASE_BITSHIFT; }") unless defined(&NI_GPCT_INDEX_PHASE_MASK);
    eval("sub NI_GPCT_INDEX_PHASE_LOW_A_LOW_B_BITS () { 0x0<<NI_GPCT_INDEX_PHASE_BITSHIFT; }") unless defined(&NI_GPCT_INDEX_PHASE_LOW_A_LOW_B_BITS);
    eval("sub NI_GPCT_INDEX_PHASE_LOW_A_HIGH_B_BITS () { 0x1<<NI_GPCT_INDEX_PHASE_BITSHIFT; }") unless defined(&NI_GPCT_INDEX_PHASE_LOW_A_HIGH_B_BITS);
    eval("sub NI_GPCT_INDEX_PHASE_HIGH_A_LOW_B_BITS () { 0x2<<NI_GPCT_INDEX_PHASE_BITSHIFT; }") unless defined(&NI_GPCT_INDEX_PHASE_HIGH_A_LOW_B_BITS);
    eval("sub NI_GPCT_INDEX_PHASE_HIGH_A_HIGH_B_BITS () { 0x3<<NI_GPCT_INDEX_PHASE_BITSHIFT; }") unless defined(&NI_GPCT_INDEX_PHASE_HIGH_A_HIGH_B_BITS);
    eval("sub NI_GPCT_INDEX_ENABLE_BIT () { 0x400000; }") unless defined(&NI_GPCT_INDEX_ENABLE_BIT);
    eval("sub NI_GPCT_COUNTING_DIRECTION_MASK () { 0x3<<NI_GPCT_COUNTING_DIRECTION_SHIFT; }") unless defined(&NI_GPCT_COUNTING_DIRECTION_MASK);
    eval("sub NI_GPCT_COUNTING_DIRECTION_DOWN_BITS () { 0x00<<NI_GPCT_COUNTING_DIRECTION_SHIFT; }") unless defined(&NI_GPCT_COUNTING_DIRECTION_DOWN_BITS);
    eval("sub NI_GPCT_COUNTING_DIRECTION_UP_BITS () { 0x1<<NI_GPCT_COUNTING_DIRECTION_SHIFT; }") unless defined(&NI_GPCT_COUNTING_DIRECTION_UP_BITS);
    eval("sub NI_GPCT_COUNTING_DIRECTION_HW_UP_DOWN_BITS () { 0x2<<NI_GPCT_COUNTING_DIRECTION_SHIFT; }") unless defined(&NI_GPCT_COUNTING_DIRECTION_HW_UP_DOWN_BITS);
    eval("sub NI_GPCT_COUNTING_DIRECTION_HW_GATE_BITS () { 0x3<<NI_GPCT_COUNTING_DIRECTION_SHIFT; }") unless defined(&NI_GPCT_COUNTING_DIRECTION_HW_GATE_BITS);
    eval("sub NI_GPCT_RELOAD_SOURCE_MASK () { 0xc000000; }") unless defined(&NI_GPCT_RELOAD_SOURCE_MASK);
    eval("sub NI_GPCT_RELOAD_SOURCE_FIXED_BITS () { 0x0; }") unless defined(&NI_GPCT_RELOAD_SOURCE_FIXED_BITS);
    eval("sub NI_GPCT_RELOAD_SOURCE_SWITCHING_BITS () { 0x4000000; }") unless defined(&NI_GPCT_RELOAD_SOURCE_SWITCHING_BITS);
    eval("sub NI_GPCT_RELOAD_SOURCE_GATE_SELECT_BITS () { 0x8000000; }") unless defined(&NI_GPCT_RELOAD_SOURCE_GATE_SELECT_BITS);
    eval("sub NI_GPCT_OR_GATE_BIT () { 0x10000000; }") unless defined(&NI_GPCT_OR_GATE_BIT);
    eval("sub NI_GPCT_INVERT_OUTPUT_BIT () { 0x20000000; }") unless defined(&NI_GPCT_INVERT_OUTPUT_BIT);
    eval("sub NI_GPCT_CLOCK_SRC_SELECT_MASK () { 0x3f; }") unless defined(&NI_GPCT_CLOCK_SRC_SELECT_MASK);
    eval("sub NI_GPCT_TIMEBASE_1_CLOCK_SRC_BITS () { 0x0; }") unless defined(&NI_GPCT_TIMEBASE_1_CLOCK_SRC_BITS);
    eval("sub NI_GPCT_TIMEBASE_2_CLOCK_SRC_BITS () { 0x1; }") unless defined(&NI_GPCT_TIMEBASE_2_CLOCK_SRC_BITS);
    eval("sub NI_GPCT_TIMEBASE_3_CLOCK_SRC_BITS () { 0x2; }") unless defined(&NI_GPCT_TIMEBASE_3_CLOCK_SRC_BITS);
    eval("sub NI_GPCT_LOGIC_LOW_CLOCK_SRC_BITS () { 0x3; }") unless defined(&NI_GPCT_LOGIC_LOW_CLOCK_SRC_BITS);
    eval("sub NI_GPCT_NEXT_GATE_CLOCK_SRC_BITS () { 0x4; }") unless defined(&NI_GPCT_NEXT_GATE_CLOCK_SRC_BITS);
    eval("sub NI_GPCT_NEXT_TC_CLOCK_SRC_BITS () { 0x5; }") unless defined(&NI_GPCT_NEXT_TC_CLOCK_SRC_BITS);
    eval("sub NI_GPCT_SOURCE_PIN_i_CLOCK_SRC_BITS () { 0x6; }") unless defined(&NI_GPCT_SOURCE_PIN_i_CLOCK_SRC_BITS);
    eval("sub NI_GPCT_PXI10_CLOCK_SRC_BITS () { 0x7; }") unless defined(&NI_GPCT_PXI10_CLOCK_SRC_BITS);
    eval("sub NI_GPCT_PXI_STAR_TRIGGER_CLOCK_SRC_BITS () { 0x8; }") unless defined(&NI_GPCT_PXI_STAR_TRIGGER_CLOCK_SRC_BITS);
    eval("sub NI_GPCT_ANALOG_TRIGGER_OUT_CLOCK_SRC_BITS () { 0x9; }") unless defined(&NI_GPCT_ANALOG_TRIGGER_OUT_CLOCK_SRC_BITS);
    eval("sub NI_GPCT_PRESCALE_MODE_CLOCK_SRC_MASK () { 0x30000000; }") unless defined(&NI_GPCT_PRESCALE_MODE_CLOCK_SRC_MASK);
    eval("sub NI_GPCT_NO_PRESCALE_CLOCK_SRC_BITS () { 0x0; }") unless defined(&NI_GPCT_NO_PRESCALE_CLOCK_SRC_BITS);
    eval("sub NI_GPCT_PRESCALE_X2_CLOCK_SRC_BITS () { 0x10000000; }") unless defined(&NI_GPCT_PRESCALE_X2_CLOCK_SRC_BITS);
    eval("sub NI_GPCT_PRESCALE_X8_CLOCK_SRC_BITS () { 0x20000000; }") unless defined(&NI_GPCT_PRESCALE_X8_CLOCK_SRC_BITS);
    eval("sub NI_GPCT_INVERT_CLOCK_SRC_BIT () { 0x80000000; }") unless defined(&NI_GPCT_INVERT_CLOCK_SRC_BIT);
    eval 'sub NI_GPCT_SOURCE_PIN_CLOCK_SRC_BITS {
        my($x) = @_;
	    eval q((0x10 + ($x)));
    }' unless defined(&NI_GPCT_SOURCE_PIN_CLOCK_SRC_BITS);
    eval 'sub NI_GPCT_RTSI_CLOCK_SRC_BITS {
        my($x) = @_;
	    eval q((0x18 + ($x)));
    }' unless defined(&NI_GPCT_RTSI_CLOCK_SRC_BITS);
    eval 'sub NI_GPCT_PFI_CLOCK_SRC_BITS {
        my($x) = @_;
	    eval q((0x20 + ($x)));
    }' unless defined(&NI_GPCT_PFI_CLOCK_SRC_BITS);
    eval("sub NI_GPCT_TIMESTAMP_MUX_GATE_SELECT () { 0x0; }") unless defined(&NI_GPCT_TIMESTAMP_MUX_GATE_SELECT);
    eval("sub NI_GPCT_AI_START2_GATE_SELECT () { 0x12; }") unless defined(&NI_GPCT_AI_START2_GATE_SELECT);
    eval("sub NI_GPCT_PXI_STAR_TRIGGER_GATE_SELECT () { 0x13; }") unless defined(&NI_GPCT_PXI_STAR_TRIGGER_GATE_SELECT);
    eval("sub NI_GPCT_NEXT_OUT_GATE_SELECT () { 0x14; }") unless defined(&NI_GPCT_NEXT_OUT_GATE_SELECT);
    eval("sub NI_GPCT_AI_START1_GATE_SELECT () { 0x1c; }") unless defined(&NI_GPCT_AI_START1_GATE_SELECT);
    eval("sub NI_GPCT_NEXT_SOURCE_GATE_SELECT () { 0x1d; }") unless defined(&NI_GPCT_NEXT_SOURCE_GATE_SELECT);
    eval("sub NI_GPCT_ANALOG_TRIGGER_OUT_GATE_SELECT () { 0x1e; }") unless defined(&NI_GPCT_ANALOG_TRIGGER_OUT_GATE_SELECT);
    eval("sub NI_GPCT_LOGIC_LOW_GATE_SELECT () { 0x1f; }") unless defined(&NI_GPCT_LOGIC_LOW_GATE_SELECT);
    eval("sub NI_GPCT_SOURCE_PIN_i_GATE_SELECT () { 0x100; }") unless defined(&NI_GPCT_SOURCE_PIN_i_GATE_SELECT);
    eval("sub NI_GPCT_GATE_PIN_i_GATE_SELECT () { 0x101; }") unless defined(&NI_GPCT_GATE_PIN_i_GATE_SELECT);
    eval("sub NI_GPCT_UP_DOWN_PIN_i_GATE_SELECT () { 0x201; }") unless defined(&NI_GPCT_UP_DOWN_PIN_i_GATE_SELECT);
    eval("sub NI_GPCT_SELECTED_GATE_GATE_SELECT () { 0x21e; }") unless defined(&NI_GPCT_SELECTED_GATE_GATE_SELECT);
    eval("sub NI_GPCT_DISABLED_GATE_SELECT () { 0x8000; }") unless defined(&NI_GPCT_DISABLED_GATE_SELECT);
    eval 'sub NI_GPCT_GATE_PIN_GATE_SELECT {
        my($x) = @_;
	    eval q((0x102 + ($x)));
    }' unless defined(&NI_GPCT_GATE_PIN_GATE_SELECT);
    eval 'sub NI_GPCT_RTSI_GATE_SELECT {
        my($x) = @_;
	    eval q( &NI_USUAL_RTSI_SELECT($x));
    }' unless defined(&NI_GPCT_RTSI_GATE_SELECT);
    eval 'sub NI_GPCT_PFI_GATE_SELECT {
        my($x) = @_;
	    eval q( &NI_USUAL_PFI_SELECT($x));
    }' unless defined(&NI_GPCT_PFI_GATE_SELECT);
    eval 'sub NI_GPCT_UP_DOWN_PIN_GATE_SELECT {
        my($x) = @_;
	    eval q((0x202 + ($x)));
    }' unless defined(&NI_GPCT_UP_DOWN_PIN_GATE_SELECT);
    eval("sub NI_GPCT_SOURCE_ENCODER_A () { 0; }") unless defined(&NI_GPCT_SOURCE_ENCODER_A);
    eval("sub NI_GPCT_SOURCE_ENCODER_B () { 1; }") unless defined(&NI_GPCT_SOURCE_ENCODER_B);
    eval("sub NI_GPCT_SOURCE_ENCODER_Z () { 2; }") unless defined(&NI_GPCT_SOURCE_ENCODER_Z);
    eval("sub NI_GPCT_DISABLED_OTHER_SELECT () { 0x8000; }") unless defined(&NI_GPCT_DISABLED_OTHER_SELECT);
    eval 'sub NI_GPCT_PFI_OTHER_SELECT {
        my($x) = @_;
	    eval q( &NI_USUAL_PFI_SELECT($x));
    }' unless defined(&NI_GPCT_PFI_OTHER_SELECT);
    eval("sub NI_GPCT_ARM_IMMEDIATE () { 0x0; }") unless defined(&NI_GPCT_ARM_IMMEDIATE);
    eval("sub NI_GPCT_ARM_PAIRED_IMMEDIATE () { 0x1; }") unless defined(&NI_GPCT_ARM_PAIRED_IMMEDIATE);
    eval("sub NI_GPCT_HW_ARM () { 0x1000; }") unless defined(&NI_GPCT_HW_ARM);
    eval("sub NI_GPCT_ARM_UNKNOWN () { NI_GPCT_HW_ARM; }") unless defined(&NI_GPCT_ARM_UNKNOWN);
    eval("sub NI_GPCT_FILTER_OFF () { 0x0; }") unless defined(&NI_GPCT_FILTER_OFF);
    eval("sub NI_GPCT_FILTER_TIMEBASE_3_SYNC () { 0x1; }") unless defined(&NI_GPCT_FILTER_TIMEBASE_3_SYNC);
    eval("sub NI_GPCT_FILTER_100x_TIMEBASE_1 () { 0x2; }") unless defined(&NI_GPCT_FILTER_100x_TIMEBASE_1);
    eval("sub NI_GPCT_FILTER_20x_TIMEBASE_1 () { 0x3; }") unless defined(&NI_GPCT_FILTER_20x_TIMEBASE_1);
    eval("sub NI_GPCT_FILTER_10x_TIMEBASE_1 () { 0x4; }") unless defined(&NI_GPCT_FILTER_10x_TIMEBASE_1);
    eval("sub NI_GPCT_FILTER_2x_TIMEBASE_1 () { 0x5; }") unless defined(&NI_GPCT_FILTER_2x_TIMEBASE_1);
    eval("sub NI_GPCT_FILTER_2x_TIMEBASE_3 () { 0x6; }") unless defined(&NI_GPCT_FILTER_2x_TIMEBASE_3);
    eval("sub NI_PFI_FILTER_OFF () { 0x0; }") unless defined(&NI_PFI_FILTER_OFF);
    eval("sub NI_PFI_FILTER_125ns () { 0x1; }") unless defined(&NI_PFI_FILTER_125ns);
    eval("sub NI_PFI_FILTER_6425ns () { 0x2; }") unless defined(&NI_PFI_FILTER_6425ns);
    eval("sub NI_PFI_FILTER_2550us () { 0x3; }") unless defined(&NI_PFI_FILTER_2550us);
    eval("sub NI_MIO_INTERNAL_CLOCK () { 0; }") unless defined(&NI_MIO_INTERNAL_CLOCK);
    eval("sub NI_MIO_RTSI_CLOCK () { 1; }") unless defined(&NI_MIO_RTSI_CLOCK);
    eval("sub NI_MIO_PLL_PXI_STAR_TRIGGER_CLOCK () { 2; }") unless defined(&NI_MIO_PLL_PXI_STAR_TRIGGER_CLOCK);
    eval("sub NI_MIO_PLL_PXI10_CLOCK () { 3; }") unless defined(&NI_MIO_PLL_PXI10_CLOCK);
    eval("sub NI_MIO_PLL_RTSI0_CLOCK () { 4; }") unless defined(&NI_MIO_PLL_RTSI0_CLOCK);
    eval 'sub NI_MIO_PLL_RTSI_CLOCK {
        my($x) = @_;
	    eval q(( &NI_MIO_PLL_RTSI0_CLOCK + ($x)));
    }' unless defined(&NI_MIO_PLL_RTSI_CLOCK);
    eval("sub NI_RTSI_OUTPUT_ADR_START1 () { 0; }") unless defined(&NI_RTSI_OUTPUT_ADR_START1);
    eval("sub NI_RTSI_OUTPUT_ADR_START2 () { 1; }") unless defined(&NI_RTSI_OUTPUT_ADR_START2);
    eval("sub NI_RTSI_OUTPUT_SCLKG () { 2; }") unless defined(&NI_RTSI_OUTPUT_SCLKG);
    eval("sub NI_RTSI_OUTPUT_DACUPDN () { 3; }") unless defined(&NI_RTSI_OUTPUT_DACUPDN);
    eval("sub NI_RTSI_OUTPUT_DA_START1 () { 4; }") unless defined(&NI_RTSI_OUTPUT_DA_START1);
    eval("sub NI_RTSI_OUTPUT_G_SRC0 () { 5; }") unless defined(&NI_RTSI_OUTPUT_G_SRC0);
    eval("sub NI_RTSI_OUTPUT_G_GATE0 () { 6; }") unless defined(&NI_RTSI_OUTPUT_G_GATE0);
    eval("sub NI_RTSI_OUTPUT_RGOUT0 () { 7; }") unless defined(&NI_RTSI_OUTPUT_RGOUT0);
    eval("sub NI_RTSI_OUTPUT_RTSI_BRD_0 () { 8; }") unless defined(&NI_RTSI_OUTPUT_RTSI_BRD_0);
    eval("sub NI_RTSI_OUTPUT_RTSI_OSC () { 12; }") unless defined(&NI_RTSI_OUTPUT_RTSI_OSC);
    eval 'sub NI_RTSI_OUTPUT_RTSI_BRD {
        my($x) = @_;
	    eval q(( &NI_RTSI_OUTPUT_RTSI_BRD_0 + ($x)));
    }' unless defined(&NI_RTSI_OUTPUT_RTSI_BRD);
    eval("sub NI_PFI_OUTPUT_PFI_DEFAULT () { 0; }") unless defined(&NI_PFI_OUTPUT_PFI_DEFAULT);
    eval("sub NI_PFI_OUTPUT_AI_START1 () { 1; }") unless defined(&NI_PFI_OUTPUT_AI_START1);
    eval("sub NI_PFI_OUTPUT_AI_START2 () { 2; }") unless defined(&NI_PFI_OUTPUT_AI_START2);
    eval("sub NI_PFI_OUTPUT_AI_CONVERT () { 3; }") unless defined(&NI_PFI_OUTPUT_AI_CONVERT);
    eval("sub NI_PFI_OUTPUT_G_SRC1 () { 4; }") unless defined(&NI_PFI_OUTPUT_G_SRC1);
    eval("sub NI_PFI_OUTPUT_G_GATE1 () { 5; }") unless defined(&NI_PFI_OUTPUT_G_GATE1);
    eval("sub NI_PFI_OUTPUT_AO_UPDATE_N () { 6; }") unless defined(&NI_PFI_OUTPUT_AO_UPDATE_N);
    eval("sub NI_PFI_OUTPUT_AO_START1 () { 7; }") unless defined(&NI_PFI_OUTPUT_AO_START1);
    eval("sub NI_PFI_OUTPUT_AI_START_PULSE () { 8; }") unless defined(&NI_PFI_OUTPUT_AI_START_PULSE);
    eval("sub NI_PFI_OUTPUT_G_SRC0 () { 9; }") unless defined(&NI_PFI_OUTPUT_G_SRC0);
    eval("sub NI_PFI_OUTPUT_G_GATE0 () { 10; }") unless defined(&NI_PFI_OUTPUT_G_GATE0);
    eval("sub NI_PFI_OUTPUT_EXT_STROBE () { 11; }") unless defined(&NI_PFI_OUTPUT_EXT_STROBE);
    eval("sub NI_PFI_OUTPUT_AI_EXT_MUX_CLK () { 12; }") unless defined(&NI_PFI_OUTPUT_AI_EXT_MUX_CLK);
    eval("sub NI_PFI_OUTPUT_GOUT0 () { 13; }") unless defined(&NI_PFI_OUTPUT_GOUT0);
    eval("sub NI_PFI_OUTPUT_GOUT1 () { 14; }") unless defined(&NI_PFI_OUTPUT_GOUT1);
    eval("sub NI_PFI_OUTPUT_FREQ_OUT () { 15; }") unless defined(&NI_PFI_OUTPUT_FREQ_OUT);
    eval("sub NI_PFI_OUTPUT_PFI_DO () { 16; }") unless defined(&NI_PFI_OUTPUT_PFI_DO);
    eval("sub NI_PFI_OUTPUT_I_ATRIG () { 17; }") unless defined(&NI_PFI_OUTPUT_I_ATRIG);
    eval("sub NI_PFI_OUTPUT_RTSI0 () { 18; }") unless defined(&NI_PFI_OUTPUT_RTSI0);
    eval("sub NI_PFI_OUTPUT_PXI_STAR_TRIGGER_IN () { 26; }") unless defined(&NI_PFI_OUTPUT_PXI_STAR_TRIGGER_IN);
    eval("sub NI_PFI_OUTPUT_SCXI_TRIG1 () { 27; }") unless defined(&NI_PFI_OUTPUT_SCXI_TRIG1);
    eval("sub NI_PFI_OUTPUT_DIO_CHANGE_DETECT_RTSI () { 28; }") unless defined(&NI_PFI_OUTPUT_DIO_CHANGE_DETECT_RTSI);
    eval("sub NI_PFI_OUTPUT_CDI_SAMPLE () { 29; }") unless defined(&NI_PFI_OUTPUT_CDI_SAMPLE);
    eval("sub NI_PFI_OUTPUT_CDO_UPDATE () { 30; }") unless defined(&NI_PFI_OUTPUT_CDO_UPDATE);
    eval 'sub NI_PFI_OUTPUT_RTSI {
        my($x) = @_;
	    eval q(( &NI_PFI_OUTPUT_RTSI0 + ($x)));
    }' unless defined(&NI_PFI_OUTPUT_RTSI);
    eval("sub NI_660X_PFI_OUTPUT_COUNTER () { 1; }") unless defined(&NI_660X_PFI_OUTPUT_COUNTER);
    eval("sub NI_660X_PFI_OUTPUT_DIO () { 2; }") unless defined(&NI_660X_PFI_OUTPUT_DIO);
    eval 'sub NI_EXT_PFI {
        my($x) = @_;
	    eval q(( &NI_USUAL_PFI_SELECT($x) - 1));
    }' unless defined(&NI_EXT_PFI);
    eval 'sub NI_EXT_RTSI {
        my($x) = @_;
	    eval q(( &NI_USUAL_RTSI_SELECT($x) - 1));
    }' unless defined(&NI_EXT_RTSI);
    eval("sub NI_CDIO_SCAN_BEGIN_SRC_GROUND () { 0; }") unless defined(&NI_CDIO_SCAN_BEGIN_SRC_GROUND);
    eval("sub NI_CDIO_SCAN_BEGIN_SRC_AI_START () { 18; }") unless defined(&NI_CDIO_SCAN_BEGIN_SRC_AI_START);
    eval("sub NI_CDIO_SCAN_BEGIN_SRC_AI_CONVERT () { 19; }") unless defined(&NI_CDIO_SCAN_BEGIN_SRC_AI_CONVERT);
    eval("sub NI_CDIO_SCAN_BEGIN_SRC_PXI_STAR_TRIGGER () { 20; }") unless defined(&NI_CDIO_SCAN_BEGIN_SRC_PXI_STAR_TRIGGER);
    eval("sub NI_CDIO_SCAN_BEGIN_SRC_G0_OUT () { 28; }") unless defined(&NI_CDIO_SCAN_BEGIN_SRC_G0_OUT);
    eval("sub NI_CDIO_SCAN_BEGIN_SRC_G1_OUT () { 29; }") unless defined(&NI_CDIO_SCAN_BEGIN_SRC_G1_OUT);
    eval("sub NI_CDIO_SCAN_BEGIN_SRC_ANALOG_TRIGGER () { 30; }") unless defined(&NI_CDIO_SCAN_BEGIN_SRC_ANALOG_TRIGGER);
    eval("sub NI_CDIO_SCAN_BEGIN_SRC_AO_UPDATE () { 31; }") unless defined(&NI_CDIO_SCAN_BEGIN_SRC_AO_UPDATE);
    eval("sub NI_CDIO_SCAN_BEGIN_SRC_FREQ_OUT () { 32; }") unless defined(&NI_CDIO_SCAN_BEGIN_SRC_FREQ_OUT);
    eval("sub NI_CDIO_SCAN_BEGIN_SRC_DIO_CHANGE_DETECT_IRQ () { 33; }") unless defined(&NI_CDIO_SCAN_BEGIN_SRC_DIO_CHANGE_DETECT_IRQ);
    eval 'sub NI_CDIO_SCAN_BEGIN_SRC_PFI {
        my($x) = @_;
	    eval q( &NI_USUAL_PFI_SELECT($x));
    }' unless defined(&NI_CDIO_SCAN_BEGIN_SRC_PFI);
    eval 'sub NI_CDIO_SCAN_BEGIN_SRC_RTSI {
        my($x) = @_;
	    eval q( &NI_USUAL_RTSI_SELECT($x));
    }' unless defined(&NI_CDIO_SCAN_BEGIN_SRC_RTSI);
    eval 'sub NI_AO_SCAN_BEGIN_SRC_PFI {
        my($x) = @_;
	    eval q( &NI_USUAL_PFI_SELECT($x));
    }' unless defined(&NI_AO_SCAN_BEGIN_SRC_PFI);
    eval 'sub NI_AO_SCAN_BEGIN_SRC_RTSI {
        my($x) = @_;
	    eval q( &NI_USUAL_RTSI_SELECT($x));
    }' unless defined(&NI_AO_SCAN_BEGIN_SRC_RTSI);
    eval("sub NI_FREQ_OUT_TIMEBASE_1_DIV_2_CLOCK_SRC () { 0; }") unless defined(&NI_FREQ_OUT_TIMEBASE_1_DIV_2_CLOCK_SRC);
    eval("sub NI_FREQ_OUT_TIMEBASE_2_CLOCK_SRC () { 1; }") unless defined(&NI_FREQ_OUT_TIMEBASE_2_CLOCK_SRC);
    eval("sub AMPLC_DIO_CLK_CLKN () { 0; }") unless defined(&AMPLC_DIO_CLK_CLKN);
    eval("sub AMPLC_DIO_CLK_10MHZ () { 1; }") unless defined(&AMPLC_DIO_CLK_10MHZ);
    eval("sub AMPLC_DIO_CLK_1MHZ () { 2; }") unless defined(&AMPLC_DIO_CLK_1MHZ);
    eval("sub AMPLC_DIO_CLK_100KHZ () { 3; }") unless defined(&AMPLC_DIO_CLK_100KHZ);
    eval("sub AMPLC_DIO_CLK_10KHZ () { 4; }") unless defined(&AMPLC_DIO_CLK_10KHZ);
    eval("sub AMPLC_DIO_CLK_1KHZ () { 5; }") unless defined(&AMPLC_DIO_CLK_1KHZ);
    eval("sub AMPLC_DIO_CLK_OUTNM1 () { 6; }") unless defined(&AMPLC_DIO_CLK_OUTNM1);
    eval("sub AMPLC_DIO_CLK_EXT () { 7; }") unless defined(&AMPLC_DIO_CLK_EXT);
    eval("sub AMPLC_DIO_CLK_VCC () { 8; }") unless defined(&AMPLC_DIO_CLK_VCC);
    eval("sub AMPLC_DIO_CLK_GND () { 9; }") unless defined(&AMPLC_DIO_CLK_GND);
    eval("sub AMPLC_DIO_CLK_PAT_PRESENT () { 10; }") unless defined(&AMPLC_DIO_CLK_PAT_PRESENT);
    eval("sub AMPLC_DIO_CLK_20MHZ () { 11; }") unless defined(&AMPLC_DIO_CLK_20MHZ);
    eval("sub AMPLC_DIO_TS_CLK_1GHZ () { 0; }") unless defined(&AMPLC_DIO_TS_CLK_1GHZ);
    eval("sub AMPLC_DIO_TS_CLK_1MHZ () { 1; }") unless defined(&AMPLC_DIO_TS_CLK_1MHZ);
    eval("sub AMPLC_DIO_TS_CLK_1KHZ () { 2; }") unless defined(&AMPLC_DIO_TS_CLK_1KHZ);
    eval("sub AMPLC_DIO_GAT_VCC () { 0; }") unless defined(&AMPLC_DIO_GAT_VCC);
    eval("sub AMPLC_DIO_GAT_GND () { 1; }") unless defined(&AMPLC_DIO_GAT_GND);
    eval("sub AMPLC_DIO_GAT_GATN () { 2; }") unless defined(&AMPLC_DIO_GAT_GATN);
    eval("sub AMPLC_DIO_GAT_NOUTNM2 () { 3; }") unless defined(&AMPLC_DIO_GAT_NOUTNM2);
    eval("sub AMPLC_DIO_GAT_RESERVED4 () { 4; }") unless defined(&AMPLC_DIO_GAT_RESERVED4);
    eval("sub AMPLC_DIO_GAT_RESERVED5 () { 5; }") unless defined(&AMPLC_DIO_GAT_RESERVED5);
    eval("sub AMPLC_DIO_GAT_RESERVED6 () { 6; }") unless defined(&AMPLC_DIO_GAT_RESERVED6);
    eval("sub AMPLC_DIO_GAT_RESERVED7 () { 7; }") unless defined(&AMPLC_DIO_GAT_RESERVED7);
    eval("sub AMPLC_DIO_GAT_NGATN () { 6; }") unless defined(&AMPLC_DIO_GAT_NGATN);
    eval("sub AMPLC_DIO_GAT_OUTNM2 () { 7; }") unless defined(&AMPLC_DIO_GAT_OUTNM2);
    eval("sub AMPLC_DIO_GAT_PAT_PRESENT () { 8; }") unless defined(&AMPLC_DIO_GAT_PAT_PRESENT);
    eval("sub AMPLC_DIO_GAT_PAT_OCCURRED () { 9; }") unless defined(&AMPLC_DIO_GAT_PAT_OCCURRED);
    eval("sub AMPLC_DIO_GAT_PAT_GONE () { 10; }") unless defined(&AMPLC_DIO_GAT_PAT_GONE);
    eval("sub AMPLC_DIO_GAT_NPAT_PRESENT () { 11; }") unless defined(&AMPLC_DIO_GAT_NPAT_PRESENT);
    eval("sub AMPLC_DIO_GAT_NPAT_OCCURRED () { 12; }") unless defined(&AMPLC_DIO_GAT_NPAT_OCCURRED);
    eval("sub AMPLC_DIO_GAT_NPAT_GONE () { 13; }") unless defined(&AMPLC_DIO_GAT_NPAT_GONE);
    eval("sub KE_CLK_20MHZ () { 0; }") unless defined(&KE_CLK_20MHZ);
    eval("sub KE_CLK_4MHZ () { 1; }") unless defined(&KE_CLK_4MHZ);
    eval("sub KE_CLK_EXT () { 2; }") unless defined(&KE_CLK_EXT);
}
1;
