require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_LINUX_BCACHE_H)) {
    eval 'sub _LINUX_BCACHE_H () {1;}' unless defined(&_LINUX_BCACHE_H);
    require 'linux/types.ph';
    eval 'sub BITMASK {
        my($name, $type, $field, $offset, $size) = @_;
	    eval q( &static  &__inline__  &__u64 $name( &const $type * &k) {  &return ( ($k->{field}) >> $offset) & ~(~0 << $size); }  &static  &__inline__  &void  &SET_$name($type * &k,  &__u64  &v) {  ($k->{field}) &= ~(~(~0 << $size) << $offset);  ($k->{field}) |= ( &v & ~(~0 << $size)) << $offset; });
    }' unless defined(&BITMASK);
    eval 'sub KEY_FIELD {
        my($name, $field, $offset, $size) = @_;
	    eval q( &BITMASK($name, \'struct bkey\', $field, $offset, $size));
    }' unless defined(&KEY_FIELD);
    eval 'sub PTR_FIELD {
        my($name, $offset, $size) = @_;
	    eval q( &static  &__inline__  &__u64 $name( &const \'struct bkey\' * &k, \'unsigned int i\') {  &return ( ($k->{ptr[&i]}) >> $offset) & ~(~0 << $size); }  &static  &__inline__  &void  &SET_$name(\'struct bkey\' * &k, \'unsigned int i\',  &__u64  &v) {  ($k->{ptr[&i]}) &= ~(~(~0 << $size) << $offset);  ($k->{ptr[&i]}) |= ( &v & ~(~0 << $size)) << $offset; });
    }' unless defined(&PTR_FIELD);
    eval 'sub KEY_SIZE_BITS () {16;}' unless defined(&KEY_SIZE_BITS);
    eval 'sub KEY_MAX_U64S () {8;}' unless defined(&KEY_MAX_U64S);
    eval 'sub SET_KEY_OFFSET {
        my($k,$v) = @_;
	    eval q({  ($k->{low}) = $v; });
    }' unless defined(&SET_KEY_OFFSET);
    eval 'sub KEY {
        my($inode, $offset, $size) = @_;
	    eval q(( { . &high = (1 << 63) | (( &__u64) ($size) << 20) | ($inode), . &low = ($offset) }));
    }' unless defined(&KEY);
    eval 'sub ZERO_KEY () { &KEY(0, 0, 0);}' unless defined(&ZERO_KEY);
    eval 'sub MAX_KEY_INODE () {(~(~0<< 20));}' unless defined(&MAX_KEY_INODE);
    eval 'sub MAX_KEY_OFFSET () {(~0 >> 1);}' unless defined(&MAX_KEY_OFFSET);
    eval 'sub MAX_KEY () { &KEY( &MAX_KEY_INODE,  &MAX_KEY_OFFSET, 0);}' unless defined(&MAX_KEY);
    eval 'sub KEY_START {
        my($k) = @_;
	    eval q(( &KEY_OFFSET($k) -  &KEY_SIZE($k)));
    }' unless defined(&KEY_START);
    eval 'sub START_KEY {
        my($k) = @_;
	    eval q( &KEY( &KEY_INODE($k),  &KEY_START($k), 0));
    }' unless defined(&START_KEY);
    eval 'sub PTR_DEV_BITS () {12;}' unless defined(&PTR_DEV_BITS);
    eval 'sub PTR_CHECK_DEV () {((1<<  &PTR_DEV_BITS) - 1);}' unless defined(&PTR_CHECK_DEV);
    eval 'sub MAKE_PTR {
        my($gen, $offset, $dev) = @_;
	    eval q((((( &__u64) $dev) << 51) | (( &__u64) $offset) << 8| $gen));
    }' unless defined(&MAKE_PTR);
    eval 'sub bkey_bytes {
        my($k) = @_;
	    eval q({  &bkey_u64s($k) * $sizeof{ &__u64}; });
    }' unless defined(&bkey_bytes);
    eval 'sub bkey_copy {
        my($_dest, $_src) = @_;
	    eval q( &memcpy($_dest, $_src,  &bkey_bytes($_src)));
    }' unless defined(&bkey_copy);
    eval 'sub bkey_copy_key {
        my($dest,$src) = @_;
	    eval q({  &SET_KEY_INODE($dest,  &KEY_INODE($src));  &SET_KEY_OFFSET($dest,  &KEY_OFFSET($src)); });
    }' unless defined(&bkey_copy_key);
    eval 'sub bkey () {
        eval q(* &bkey_next( &const \'struct bkey\' * &k) {  &__u64 * &d = ( &void *)  &k;  ( &d +  &bkey_u64s( &k)); });
    }' unless defined(&bkey);
    eval 'sub bkey () {
        eval q(* &bkey_idx( &const \'struct bkey\' * &k, my $nr_keys) {  &__u64 * &d = ( &void *)  &k;  ( &d +  $nr_keys); });
    }' unless defined(&bkey);
    eval 'sub BKEY_PAD () {8;}' unless defined(&BKEY_PAD);
    eval 'sub BKEY_PADDED {
        my($key) = @_;
	    eval q(\'union union\' { \'struct bkey\' $key;  &__u64 $key   $_pad[ &BKEY_PAD]; });
    }' unless defined(&BKEY_PADDED);
    eval 'sub BCACHE_SB_VERSION_CDEV () {0;}' unless defined(&BCACHE_SB_VERSION_CDEV);
    eval 'sub BCACHE_SB_VERSION_BDEV () {1;}' unless defined(&BCACHE_SB_VERSION_BDEV);
    eval 'sub BCACHE_SB_VERSION_CDEV_WITH_UUID () {3;}' unless defined(&BCACHE_SB_VERSION_CDEV_WITH_UUID);
    eval 'sub BCACHE_SB_VERSION_BDEV_WITH_OFFSET () {4;}' unless defined(&BCACHE_SB_VERSION_BDEV_WITH_OFFSET);
    eval 'sub BCACHE_SB_VERSION_CDEV_WITH_FEATURES () {5;}' unless defined(&BCACHE_SB_VERSION_CDEV_WITH_FEATURES);
    eval 'sub BCACHE_SB_VERSION_BDEV_WITH_FEATURES () {6;}' unless defined(&BCACHE_SB_VERSION_BDEV_WITH_FEATURES);
    eval 'sub BCACHE_SB_MAX_VERSION () {6;}' unless defined(&BCACHE_SB_MAX_VERSION);
    eval 'sub SB_SECTOR () {8;}' unless defined(&SB_SECTOR);
    eval 'sub SB_OFFSET () {( &SB_SECTOR <<  &SECTOR_SHIFT);}' unless defined(&SB_OFFSET);
    eval 'sub SB_SIZE () {4096;}' unless defined(&SB_SIZE);
    eval 'sub SB_LABEL_SIZE () {32;}' unless defined(&SB_LABEL_SIZE);
    eval 'sub SB_JOURNAL_BUCKETS () {256;}' unless defined(&SB_JOURNAL_BUCKETS);
    eval 'sub MAX_CACHES_PER_SET () {8;}' unless defined(&MAX_CACHES_PER_SET);
    eval 'sub BDEV_DATA_START_DEFAULT () {16;}' unless defined(&BDEV_DATA_START_DEFAULT);
    eval 'sub SB_IS_BDEV {
        my($sb) = @_;
	    eval q({  ($sb->{version}) ==  &BCACHE_SB_VERSION_BDEV ||  ($sb->{version}) ==  &BCACHE_SB_VERSION_BDEV_WITH_OFFSET ||  ($sb->{version}) ==  &BCACHE_SB_VERSION_BDEV_WITH_FEATURES; });
    }' unless defined(&SB_IS_BDEV);
    eval 'sub CACHE_REPLACEMENT_LRU () {0;}' unless defined(&CACHE_REPLACEMENT_LRU);
    eval 'sub CACHE_REPLACEMENT_FIFO () {1;}' unless defined(&CACHE_REPLACEMENT_FIFO);
    eval 'sub CACHE_REPLACEMENT_RANDOM () {2;}' unless defined(&CACHE_REPLACEMENT_RANDOM);
    eval 'sub CACHE_MODE_WRITETHROUGH () {0;}' unless defined(&CACHE_MODE_WRITETHROUGH);
    eval 'sub CACHE_MODE_WRITEBACK () {1;}' unless defined(&CACHE_MODE_WRITEBACK);
    eval 'sub CACHE_MODE_WRITEAROUND () {2;}' unless defined(&CACHE_MODE_WRITEAROUND);
    eval 'sub CACHE_MODE_NONE () {3;}' unless defined(&CACHE_MODE_NONE);
    eval 'sub BDEV_STATE_NONE () {0;}' unless defined(&BDEV_STATE_NONE);
    eval 'sub BDEV_STATE_CLEAN () {1;}' unless defined(&BDEV_STATE_CLEAN);
    eval 'sub BDEV_STATE_DIRTY () {2;}' unless defined(&BDEV_STATE_DIRTY);
    eval 'sub BDEV_STATE_STALE () {3;}' unless defined(&BDEV_STATE_STALE);
    eval 'sub JSET_MAGIC () {0x245235c1a3625032;}' unless defined(&JSET_MAGIC);
    eval 'sub PSET_MAGIC () {0x6750e15f87337f91;}' unless defined(&PSET_MAGIC);
    eval 'sub BSET_MAGIC () {0x90135c78b99e07f5;}' unless defined(&BSET_MAGIC);
    eval 'sub jset_magic {
        my($sb) = @_;
	    eval q({  ($sb->{set_magic}) ^  &JSET_MAGIC; });
    }' unless defined(&jset_magic);
    eval 'sub pset_magic {
        my($sb) = @_;
	    eval q({  ($sb->{set_magic}) ^  &PSET_MAGIC; });
    }' unless defined(&pset_magic);
    eval 'sub bset_magic {
        my($sb) = @_;
	    eval q({  ($sb->{set_magic}) ^  &BSET_MAGIC; });
    }' unless defined(&bset_magic);
    eval 'sub BCACHE_JSET_VERSION_UUIDv1 () {1;}' unless defined(&BCACHE_JSET_VERSION_UUIDv1);
    eval 'sub BCACHE_JSET_VERSION_UUID () {1;}' unless defined(&BCACHE_JSET_VERSION_UUID);
    eval 'sub BCACHE_JSET_VERSION () {1;}' unless defined(&BCACHE_JSET_VERSION);
    eval 'sub BCACHE_BSET_CSUM () {1;}' unless defined(&BCACHE_BSET_CSUM);
    eval 'sub BCACHE_BSET_VERSION () {1;}' unless defined(&BCACHE_BSET_VERSION);
}
1;
