require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&__LINUX_BPF_H__)) {
    eval 'sub __LINUX_BPF_H__ () {1;}' unless defined(&__LINUX_BPF_H__);
    require 'linux/types.ph';
    require 'linux/bpf_common.ph';
    eval 'sub BPF_JMP32 () {0x6;}' unless defined(&BPF_JMP32);
    eval 'sub BPF_ALU64 () {0x7;}' unless defined(&BPF_ALU64);
    eval 'sub BPF_DW () {0x18;}' unless defined(&BPF_DW);
    eval 'sub BPF_XADD () {0xc0;}' unless defined(&BPF_XADD);
    eval 'sub BPF_MOV () {0xb0;}' unless defined(&BPF_MOV);
    eval 'sub BPF_ARSH () {0xc0;}' unless defined(&BPF_ARSH);
    eval 'sub BPF_END () {0xd0;}' unless defined(&BPF_END);
    eval 'sub BPF_TO_LE () {0x;}' unless defined(&BPF_TO_LE);
    eval 'sub BPF_TO_BE () {0x8;}' unless defined(&BPF_TO_BE);
    eval 'sub BPF_FROM_LE () { &BPF_TO_LE;}' unless defined(&BPF_FROM_LE);
    eval 'sub BPF_FROM_BE () { &BPF_TO_BE;}' unless defined(&BPF_FROM_BE);
    eval 'sub BPF_JNE () {0x50;}' unless defined(&BPF_JNE);
    eval 'sub BPF_JLT () {0xa0;}' unless defined(&BPF_JLT);
    eval 'sub BPF_JLE () {0xb0;}' unless defined(&BPF_JLE);
    eval 'sub BPF_JSGT () {0x60;}' unless defined(&BPF_JSGT);
    eval 'sub BPF_JSGE () {0x70;}' unless defined(&BPF_JSGE);
    eval 'sub BPF_JSLT () {0xc0;}' unless defined(&BPF_JSLT);
    eval 'sub BPF_JSLE () {0xd0;}' unless defined(&BPF_JSLE);
    eval 'sub BPF_CALL () {0x80;}' unless defined(&BPF_CALL);
    eval 'sub BPF_EXIT () {0x90;}' unless defined(&BPF_EXIT);
    eval("sub BPF_REG_0 () { 0; }") unless defined(&BPF_REG_0);
    eval("sub BPF_REG_1 () { 1; }") unless defined(&BPF_REG_1);
    eval("sub BPF_REG_2 () { 2; }") unless defined(&BPF_REG_2);
    eval("sub BPF_REG_3 () { 3; }") unless defined(&BPF_REG_3);
    eval("sub BPF_REG_4 () { 4; }") unless defined(&BPF_REG_4);
    eval("sub BPF_REG_5 () { 5; }") unless defined(&BPF_REG_5);
    eval("sub BPF_REG_6 () { 6; }") unless defined(&BPF_REG_6);
    eval("sub BPF_REG_7 () { 7; }") unless defined(&BPF_REG_7);
    eval("sub BPF_REG_8 () { 8; }") unless defined(&BPF_REG_8);
    eval("sub BPF_REG_9 () { 9; }") unless defined(&BPF_REG_9);
    eval("sub BPF_REG_10 () { 10; }") unless defined(&BPF_REG_10);
    eval("sub __MAX_BPF_REG () { 11; }") unless defined(&__MAX_BPF_REG);
    eval 'sub MAX_BPF_REG () { &__MAX_BPF_REG;}' unless defined(&MAX_BPF_REG);
    eval("sub BPF_MAP_CREATE () { 0; }") unless defined(&BPF_MAP_CREATE);
    eval("sub BPF_MAP_LOOKUP_ELEM () { 1; }") unless defined(&BPF_MAP_LOOKUP_ELEM);
    eval("sub BPF_MAP_UPDATE_ELEM () { 2; }") unless defined(&BPF_MAP_UPDATE_ELEM);
    eval("sub BPF_MAP_DELETE_ELEM () { 3; }") unless defined(&BPF_MAP_DELETE_ELEM);
    eval("sub BPF_MAP_GET_NEXT_KEY () { 4; }") unless defined(&BPF_MAP_GET_NEXT_KEY);
    eval("sub BPF_PROG_LOAD () { 5; }") unless defined(&BPF_PROG_LOAD);
    eval("sub BPF_OBJ_PIN () { 6; }") unless defined(&BPF_OBJ_PIN);
    eval("sub BPF_OBJ_GET () { 7; }") unless defined(&BPF_OBJ_GET);
    eval("sub BPF_PROG_ATTACH () { 8; }") unless defined(&BPF_PROG_ATTACH);
    eval("sub BPF_PROG_DETACH () { 9; }") unless defined(&BPF_PROG_DETACH);
    eval("sub BPF_PROG_TEST_RUN () { 10; }") unless defined(&BPF_PROG_TEST_RUN);
    eval("sub BPF_PROG_GET_NEXT_ID () { 11; }") unless defined(&BPF_PROG_GET_NEXT_ID);
    eval("sub BPF_MAP_GET_NEXT_ID () { 12; }") unless defined(&BPF_MAP_GET_NEXT_ID);
    eval("sub BPF_PROG_GET_FD_BY_ID () { 13; }") unless defined(&BPF_PROG_GET_FD_BY_ID);
    eval("sub BPF_MAP_GET_FD_BY_ID () { 14; }") unless defined(&BPF_MAP_GET_FD_BY_ID);
    eval("sub BPF_OBJ_GET_INFO_BY_FD () { 15; }") unless defined(&BPF_OBJ_GET_INFO_BY_FD);
    eval("sub BPF_PROG_QUERY () { 16; }") unless defined(&BPF_PROG_QUERY);
    eval("sub BPF_RAW_TRACEPOINT_OPEN () { 17; }") unless defined(&BPF_RAW_TRACEPOINT_OPEN);
    eval("sub BPF_BTF_LOAD () { 18; }") unless defined(&BPF_BTF_LOAD);
    eval("sub BPF_BTF_GET_FD_BY_ID () { 19; }") unless defined(&BPF_BTF_GET_FD_BY_ID);
    eval("sub BPF_TASK_FD_QUERY () { 20; }") unless defined(&BPF_TASK_FD_QUERY);
    eval("sub BPF_MAP_LOOKUP_AND_DELETE_ELEM () { 21; }") unless defined(&BPF_MAP_LOOKUP_AND_DELETE_ELEM);
    eval("sub BPF_MAP_FREEZE () { 22; }") unless defined(&BPF_MAP_FREEZE);
    eval("sub BPF_BTF_GET_NEXT_ID () { 23; }") unless defined(&BPF_BTF_GET_NEXT_ID);
    eval("sub BPF_MAP_LOOKUP_BATCH () { 24; }") unless defined(&BPF_MAP_LOOKUP_BATCH);
    eval("sub BPF_MAP_LOOKUP_AND_DELETE_BATCH () { 25; }") unless defined(&BPF_MAP_LOOKUP_AND_DELETE_BATCH);
    eval("sub BPF_MAP_UPDATE_BATCH () { 26; }") unless defined(&BPF_MAP_UPDATE_BATCH);
    eval("sub BPF_MAP_DELETE_BATCH () { 27; }") unless defined(&BPF_MAP_DELETE_BATCH);
    eval("sub BPF_LINK_CREATE () { 28; }") unless defined(&BPF_LINK_CREATE);
    eval("sub BPF_LINK_UPDATE () { 29; }") unless defined(&BPF_LINK_UPDATE);
    eval("sub BPF_LINK_GET_FD_BY_ID () { 30; }") unless defined(&BPF_LINK_GET_FD_BY_ID);
    eval("sub BPF_LINK_GET_NEXT_ID () { 31; }") unless defined(&BPF_LINK_GET_NEXT_ID);
    eval("sub BPF_ENABLE_STATS () { 32; }") unless defined(&BPF_ENABLE_STATS);
    eval("sub BPF_ITER_CREATE () { 33; }") unless defined(&BPF_ITER_CREATE);
    eval("sub BPF_LINK_DETACH () { 34; }") unless defined(&BPF_LINK_DETACH);
    eval("sub BPF_MAP_TYPE_UNSPEC () { 0; }") unless defined(&BPF_MAP_TYPE_UNSPEC);
    eval("sub BPF_MAP_TYPE_HASH () { 1; }") unless defined(&BPF_MAP_TYPE_HASH);
    eval("sub BPF_MAP_TYPE_ARRAY () { 2; }") unless defined(&BPF_MAP_TYPE_ARRAY);
    eval("sub BPF_MAP_TYPE_PROG_ARRAY () { 3; }") unless defined(&BPF_MAP_TYPE_PROG_ARRAY);
    eval("sub BPF_MAP_TYPE_PERF_EVENT_ARRAY () { 4; }") unless defined(&BPF_MAP_TYPE_PERF_EVENT_ARRAY);
    eval("sub BPF_MAP_TYPE_PERCPU_HASH () { 5; }") unless defined(&BPF_MAP_TYPE_PERCPU_HASH);
    eval("sub BPF_MAP_TYPE_PERCPU_ARRAY () { 6; }") unless defined(&BPF_MAP_TYPE_PERCPU_ARRAY);
    eval("sub BPF_MAP_TYPE_STACK_TRACE () { 7; }") unless defined(&BPF_MAP_TYPE_STACK_TRACE);
    eval("sub BPF_MAP_TYPE_CGROUP_ARRAY () { 8; }") unless defined(&BPF_MAP_TYPE_CGROUP_ARRAY);
    eval("sub BPF_MAP_TYPE_LRU_HASH () { 9; }") unless defined(&BPF_MAP_TYPE_LRU_HASH);
    eval("sub BPF_MAP_TYPE_LRU_PERCPU_HASH () { 10; }") unless defined(&BPF_MAP_TYPE_LRU_PERCPU_HASH);
    eval("sub BPF_MAP_TYPE_LPM_TRIE () { 11; }") unless defined(&BPF_MAP_TYPE_LPM_TRIE);
    eval("sub BPF_MAP_TYPE_ARRAY_OF_MAPS () { 12; }") unless defined(&BPF_MAP_TYPE_ARRAY_OF_MAPS);
    eval("sub BPF_MAP_TYPE_HASH_OF_MAPS () { 13; }") unless defined(&BPF_MAP_TYPE_HASH_OF_MAPS);
    eval("sub BPF_MAP_TYPE_DEVMAP () { 14; }") unless defined(&BPF_MAP_TYPE_DEVMAP);
    eval("sub BPF_MAP_TYPE_SOCKMAP () { 15; }") unless defined(&BPF_MAP_TYPE_SOCKMAP);
    eval("sub BPF_MAP_TYPE_CPUMAP () { 16; }") unless defined(&BPF_MAP_TYPE_CPUMAP);
    eval("sub BPF_MAP_TYPE_XSKMAP () { 17; }") unless defined(&BPF_MAP_TYPE_XSKMAP);
    eval("sub BPF_MAP_TYPE_SOCKHASH () { 18; }") unless defined(&BPF_MAP_TYPE_SOCKHASH);
    eval("sub BPF_MAP_TYPE_CGROUP_STORAGE () { 19; }") unless defined(&BPF_MAP_TYPE_CGROUP_STORAGE);
    eval("sub BPF_MAP_TYPE_REUSEPORT_SOCKARRAY () { 20; }") unless defined(&BPF_MAP_TYPE_REUSEPORT_SOCKARRAY);
    eval("sub BPF_MAP_TYPE_PERCPU_CGROUP_STORAGE () { 21; }") unless defined(&BPF_MAP_TYPE_PERCPU_CGROUP_STORAGE);
    eval("sub BPF_MAP_TYPE_QUEUE () { 22; }") unless defined(&BPF_MAP_TYPE_QUEUE);
    eval("sub BPF_MAP_TYPE_STACK () { 23; }") unless defined(&BPF_MAP_TYPE_STACK);
    eval("sub BPF_MAP_TYPE_SK_STORAGE () { 24; }") unless defined(&BPF_MAP_TYPE_SK_STORAGE);
    eval("sub BPF_MAP_TYPE_DEVMAP_HASH () { 25; }") unless defined(&BPF_MAP_TYPE_DEVMAP_HASH);
    eval("sub BPF_MAP_TYPE_STRUCT_OPS () { 26; }") unless defined(&BPF_MAP_TYPE_STRUCT_OPS);
    eval("sub BPF_MAP_TYPE_RINGBUF () { 27; }") unless defined(&BPF_MAP_TYPE_RINGBUF);
    eval("sub BPF_PROG_TYPE_UNSPEC () { 0; }") unless defined(&BPF_PROG_TYPE_UNSPEC);
    eval("sub BPF_PROG_TYPE_SOCKET_FILTER () { 1; }") unless defined(&BPF_PROG_TYPE_SOCKET_FILTER);
    eval("sub BPF_PROG_TYPE_KPROBE () { 2; }") unless defined(&BPF_PROG_TYPE_KPROBE);
    eval("sub BPF_PROG_TYPE_SCHED_CLS () { 3; }") unless defined(&BPF_PROG_TYPE_SCHED_CLS);
    eval("sub BPF_PROG_TYPE_SCHED_ACT () { 4; }") unless defined(&BPF_PROG_TYPE_SCHED_ACT);
    eval("sub BPF_PROG_TYPE_TRACEPOINT () { 5; }") unless defined(&BPF_PROG_TYPE_TRACEPOINT);
    eval("sub BPF_PROG_TYPE_XDP () { 6; }") unless defined(&BPF_PROG_TYPE_XDP);
    eval("sub BPF_PROG_TYPE_PERF_EVENT () { 7; }") unless defined(&BPF_PROG_TYPE_PERF_EVENT);
    eval("sub BPF_PROG_TYPE_CGROUP_SKB () { 8; }") unless defined(&BPF_PROG_TYPE_CGROUP_SKB);
    eval("sub BPF_PROG_TYPE_CGROUP_SOCK () { 9; }") unless defined(&BPF_PROG_TYPE_CGROUP_SOCK);
    eval("sub BPF_PROG_TYPE_LWT_IN () { 10; }") unless defined(&BPF_PROG_TYPE_LWT_IN);
    eval("sub BPF_PROG_TYPE_LWT_OUT () { 11; }") unless defined(&BPF_PROG_TYPE_LWT_OUT);
    eval("sub BPF_PROG_TYPE_LWT_XMIT () { 12; }") unless defined(&BPF_PROG_TYPE_LWT_XMIT);
    eval("sub BPF_PROG_TYPE_SOCK_OPS () { 13; }") unless defined(&BPF_PROG_TYPE_SOCK_OPS);
    eval("sub BPF_PROG_TYPE_SK_SKB () { 14; }") unless defined(&BPF_PROG_TYPE_SK_SKB);
    eval("sub BPF_PROG_TYPE_CGROUP_DEVICE () { 15; }") unless defined(&BPF_PROG_TYPE_CGROUP_DEVICE);
    eval("sub BPF_PROG_TYPE_SK_MSG () { 16; }") unless defined(&BPF_PROG_TYPE_SK_MSG);
    eval("sub BPF_PROG_TYPE_RAW_TRACEPOINT () { 17; }") unless defined(&BPF_PROG_TYPE_RAW_TRACEPOINT);
    eval("sub BPF_PROG_TYPE_CGROUP_SOCK_ADDR () { 18; }") unless defined(&BPF_PROG_TYPE_CGROUP_SOCK_ADDR);
    eval("sub BPF_PROG_TYPE_LWT_SEG6LOCAL () { 19; }") unless defined(&BPF_PROG_TYPE_LWT_SEG6LOCAL);
    eval("sub BPF_PROG_TYPE_LIRC_MODE2 () { 20; }") unless defined(&BPF_PROG_TYPE_LIRC_MODE2);
    eval("sub BPF_PROG_TYPE_SK_REUSEPORT () { 21; }") unless defined(&BPF_PROG_TYPE_SK_REUSEPORT);
    eval("sub BPF_PROG_TYPE_FLOW_DISSECTOR () { 22; }") unless defined(&BPF_PROG_TYPE_FLOW_DISSECTOR);
    eval("sub BPF_PROG_TYPE_CGROUP_SYSCTL () { 23; }") unless defined(&BPF_PROG_TYPE_CGROUP_SYSCTL);
    eval("sub BPF_PROG_TYPE_RAW_TRACEPOINT_WRITABLE () { 24; }") unless defined(&BPF_PROG_TYPE_RAW_TRACEPOINT_WRITABLE);
    eval("sub BPF_PROG_TYPE_CGROUP_SOCKOPT () { 25; }") unless defined(&BPF_PROG_TYPE_CGROUP_SOCKOPT);
    eval("sub BPF_PROG_TYPE_TRACING () { 26; }") unless defined(&BPF_PROG_TYPE_TRACING);
    eval("sub BPF_PROG_TYPE_STRUCT_OPS () { 27; }") unless defined(&BPF_PROG_TYPE_STRUCT_OPS);
    eval("sub BPF_PROG_TYPE_EXT () { 28; }") unless defined(&BPF_PROG_TYPE_EXT);
    eval("sub BPF_PROG_TYPE_LSM () { 29; }") unless defined(&BPF_PROG_TYPE_LSM);
    eval("sub BPF_PROG_TYPE_SK_LOOKUP () { 30; }") unless defined(&BPF_PROG_TYPE_SK_LOOKUP);
    eval("sub BPF_CGROUP_INET_INGRESS () { 0; }") unless defined(&BPF_CGROUP_INET_INGRESS);
    eval("sub BPF_CGROUP_INET_EGRESS () { 1; }") unless defined(&BPF_CGROUP_INET_EGRESS);
    eval("sub BPF_CGROUP_INET_SOCK_CREATE () { 2; }") unless defined(&BPF_CGROUP_INET_SOCK_CREATE);
    eval("sub BPF_CGROUP_SOCK_OPS () { 3; }") unless defined(&BPF_CGROUP_SOCK_OPS);
    eval("sub BPF_SK_SKB_STREAM_PARSER () { 4; }") unless defined(&BPF_SK_SKB_STREAM_PARSER);
    eval("sub BPF_SK_SKB_STREAM_VERDICT () { 5; }") unless defined(&BPF_SK_SKB_STREAM_VERDICT);
    eval("sub BPF_CGROUP_DEVICE () { 6; }") unless defined(&BPF_CGROUP_DEVICE);
    eval("sub BPF_SK_MSG_VERDICT () { 7; }") unless defined(&BPF_SK_MSG_VERDICT);
    eval("sub BPF_CGROUP_INET4_BIND () { 8; }") unless defined(&BPF_CGROUP_INET4_BIND);
    eval("sub BPF_CGROUP_INET6_BIND () { 9; }") unless defined(&BPF_CGROUP_INET6_BIND);
    eval("sub BPF_CGROUP_INET4_CONNECT () { 10; }") unless defined(&BPF_CGROUP_INET4_CONNECT);
    eval("sub BPF_CGROUP_INET6_CONNECT () { 11; }") unless defined(&BPF_CGROUP_INET6_CONNECT);
    eval("sub BPF_CGROUP_INET4_POST_BIND () { 12; }") unless defined(&BPF_CGROUP_INET4_POST_BIND);
    eval("sub BPF_CGROUP_INET6_POST_BIND () { 13; }") unless defined(&BPF_CGROUP_INET6_POST_BIND);
    eval("sub BPF_CGROUP_UDP4_SENDMSG () { 14; }") unless defined(&BPF_CGROUP_UDP4_SENDMSG);
    eval("sub BPF_CGROUP_UDP6_SENDMSG () { 15; }") unless defined(&BPF_CGROUP_UDP6_SENDMSG);
    eval("sub BPF_LIRC_MODE2 () { 16; }") unless defined(&BPF_LIRC_MODE2);
    eval("sub BPF_FLOW_DISSECTOR () { 17; }") unless defined(&BPF_FLOW_DISSECTOR);
    eval("sub BPF_CGROUP_SYSCTL () { 18; }") unless defined(&BPF_CGROUP_SYSCTL);
    eval("sub BPF_CGROUP_UDP4_RECVMSG () { 19; }") unless defined(&BPF_CGROUP_UDP4_RECVMSG);
    eval("sub BPF_CGROUP_UDP6_RECVMSG () { 20; }") unless defined(&BPF_CGROUP_UDP6_RECVMSG);
    eval("sub BPF_CGROUP_GETSOCKOPT () { 21; }") unless defined(&BPF_CGROUP_GETSOCKOPT);
    eval("sub BPF_CGROUP_SETSOCKOPT () { 22; }") unless defined(&BPF_CGROUP_SETSOCKOPT);
    eval("sub BPF_TRACE_RAW_TP () { 23; }") unless defined(&BPF_TRACE_RAW_TP);
    eval("sub BPF_TRACE_FENTRY () { 24; }") unless defined(&BPF_TRACE_FENTRY);
    eval("sub BPF_TRACE_FEXIT () { 25; }") unless defined(&BPF_TRACE_FEXIT);
    eval("sub BPF_MODIFY_RETURN () { 26; }") unless defined(&BPF_MODIFY_RETURN);
    eval("sub BPF_LSM_MAC () { 27; }") unless defined(&BPF_LSM_MAC);
    eval("sub BPF_TRACE_ITER () { 28; }") unless defined(&BPF_TRACE_ITER);
    eval("sub BPF_CGROUP_INET4_GETPEERNAME () { 29; }") unless defined(&BPF_CGROUP_INET4_GETPEERNAME);
    eval("sub BPF_CGROUP_INET6_GETPEERNAME () { 30; }") unless defined(&BPF_CGROUP_INET6_GETPEERNAME);
    eval("sub BPF_CGROUP_INET4_GETSOCKNAME () { 31; }") unless defined(&BPF_CGROUP_INET4_GETSOCKNAME);
    eval("sub BPF_CGROUP_INET6_GETSOCKNAME () { 32; }") unless defined(&BPF_CGROUP_INET6_GETSOCKNAME);
    eval("sub BPF_XDP_DEVMAP () { 33; }") unless defined(&BPF_XDP_DEVMAP);
    eval("sub BPF_CGROUP_INET_SOCK_RELEASE () { 34; }") unless defined(&BPF_CGROUP_INET_SOCK_RELEASE);
    eval("sub BPF_XDP_CPUMAP () { 35; }") unless defined(&BPF_XDP_CPUMAP);
    eval("sub BPF_SK_LOOKUP () { 36; }") unless defined(&BPF_SK_LOOKUP);
    eval("sub BPF_XDP () { 37; }") unless defined(&BPF_XDP);
    eval("sub __MAX_BPF_ATTACH_TYPE () { 38; }") unless defined(&__MAX_BPF_ATTACH_TYPE);
    eval 'sub MAX_BPF_ATTACH_TYPE () { &__MAX_BPF_ATTACH_TYPE;}' unless defined(&MAX_BPF_ATTACH_TYPE);
    eval("sub BPF_LINK_TYPE_UNSPEC () { 0; }") unless defined(&BPF_LINK_TYPE_UNSPEC);
    eval("sub BPF_LINK_TYPE_RAW_TRACEPOINT () { 1; }") unless defined(&BPF_LINK_TYPE_RAW_TRACEPOINT);
    eval("sub BPF_LINK_TYPE_TRACING () { 2; }") unless defined(&BPF_LINK_TYPE_TRACING);
    eval("sub BPF_LINK_TYPE_CGROUP () { 3; }") unless defined(&BPF_LINK_TYPE_CGROUP);
    eval("sub BPF_LINK_TYPE_ITER () { 4; }") unless defined(&BPF_LINK_TYPE_ITER);
    eval("sub BPF_LINK_TYPE_NETNS () { 5; }") unless defined(&BPF_LINK_TYPE_NETNS);
    eval("sub BPF_LINK_TYPE_XDP () { 6; }") unless defined(&BPF_LINK_TYPE_XDP);
    eval("sub MAX_BPF_LINK_TYPE () { 7; }") unless defined(&MAX_BPF_LINK_TYPE);
    eval 'sub BPF_F_ALLOW_OVERRIDE () {(1 << 0);}' unless defined(&BPF_F_ALLOW_OVERRIDE);
    eval 'sub BPF_F_ALLOW_MULTI () {(1 << 1);}' unless defined(&BPF_F_ALLOW_MULTI);
    eval 'sub BPF_F_REPLACE () {(1 << 2);}' unless defined(&BPF_F_REPLACE);
    eval 'sub BPF_F_STRICT_ALIGNMENT () {(1 << 0);}' unless defined(&BPF_F_STRICT_ALIGNMENT);
    eval 'sub BPF_F_ANY_ALIGNMENT () {(1 << 1);}' unless defined(&BPF_F_ANY_ALIGNMENT);
    eval 'sub BPF_F_TEST_RND_HI32 () {(1 << 2);}' unless defined(&BPF_F_TEST_RND_HI32);
    eval 'sub BPF_F_TEST_STATE_FREQ () {(1 << 3);}' unless defined(&BPF_F_TEST_STATE_FREQ);
    eval 'sub BPF_PSEUDO_MAP_FD () {1;}' unless defined(&BPF_PSEUDO_MAP_FD);
    eval 'sub BPF_PSEUDO_MAP_VALUE () {2;}' unless defined(&BPF_PSEUDO_MAP_VALUE);
    eval 'sub BPF_PSEUDO_CALL () {1;}' unless defined(&BPF_PSEUDO_CALL);
    eval("sub BPF_ANY () { 0; }") unless defined(&BPF_ANY);
    eval("sub BPF_NOEXIST () { 1; }") unless defined(&BPF_NOEXIST);
    eval("sub BPF_EXIST () { 2; }") unless defined(&BPF_EXIST);
    eval("sub BPF_F_LOCK () { 4; }") unless defined(&BPF_F_LOCK);
    eval("sub BPF_F_NO_PREALLOC () { (1U<<0); }") unless defined(&BPF_F_NO_PREALLOC);
    eval("sub BPF_F_NO_COMMON_LRU () { (1U<<1); }") unless defined(&BPF_F_NO_COMMON_LRU);
    eval("sub BPF_F_NUMA_NODE () { (1U<<2); }") unless defined(&BPF_F_NUMA_NODE);
    eval("sub BPF_F_RDONLY () { (1U<<3); }") unless defined(&BPF_F_RDONLY);
    eval("sub BPF_F_WRONLY () { (1U<<4); }") unless defined(&BPF_F_WRONLY);
    eval("sub BPF_F_STACK_BUILD_ID () { (1U<<5); }") unless defined(&BPF_F_STACK_BUILD_ID);
    eval("sub BPF_F_ZERO_SEED () { (1U<<6); }") unless defined(&BPF_F_ZERO_SEED);
    eval("sub BPF_F_RDONLY_PROG () { (1U<<7); }") unless defined(&BPF_F_RDONLY_PROG);
    eval("sub BPF_F_WRONLY_PROG () { (1U<<8); }") unless defined(&BPF_F_WRONLY_PROG);
    eval("sub BPF_F_CLONE () { (1U<<9); }") unless defined(&BPF_F_CLONE);
    eval("sub BPF_F_MMAPABLE () { (1U<<10); }") unless defined(&BPF_F_MMAPABLE);
    eval 'sub BPF_F_QUERY_EFFECTIVE () {(1 << 0);}' unless defined(&BPF_F_QUERY_EFFECTIVE);
    eval("sub BPF_STATS_RUN_TIME () { 0; }") unless defined(&BPF_STATS_RUN_TIME);
    eval("sub BPF_STACK_BUILD_ID_EMPTY () { 0; }") unless defined(&BPF_STACK_BUILD_ID_EMPTY);
    eval("sub BPF_STACK_BUILD_ID_VALID () { 1; }") unless defined(&BPF_STACK_BUILD_ID_VALID);
    eval("sub BPF_STACK_BUILD_ID_IP () { 2; }") unless defined(&BPF_STACK_BUILD_ID_IP);
    eval 'sub BPF_BUILD_ID_SIZE () {20;}' unless defined(&BPF_BUILD_ID_SIZE);
    eval 'sub BPF_OBJ_NAME_LEN () {16;}' unless defined(&BPF_OBJ_NAME_LEN);
    eval 'sub __BPF_FUNC_MAPPER {
        my($FN) = @_;
	    eval q($FN( &unspec), $FN( &map_lookup_elem), $FN( &map_update_elem), $FN( &map_delete_elem), $FN( &probe_read), $FN( &ktime_get_ns), $FN( &trace_printk), $FN( &get_prandom_u32), $FN( &get_smp_processor_id), $FN( &skb_store_bytes), $FN( &l3_csum_replace), $FN( &l4_csum_replace), $FN( &tail_call), $FN( &clone_redirect), $FN( &get_current_pid_tgid), $FN( &get_current_uid_gid), $FN( &get_current_comm), $FN( &get_cgroup_classid), $FN( &skb_vlan_push), $FN( &skb_vlan_pop), $FN( &skb_get_tunnel_key), $FN( &skb_set_tunnel_key), $FN( &perf_event_read), $FN( &redirect), $FN( &get_route_realm), $FN( &perf_event_output), $FN( &skb_load_bytes), $FN( &get_stackid), $FN( &csum_diff), $FN( &skb_get_tunnel_opt), $FN( &skb_set_tunnel_opt), $FN( &skb_change_proto), $FN( &skb_change_type), $FN( &skb_under_cgroup), $FN( &get_hash_recalc), $FN( &get_current_task), $FN( &probe_write_user), $FN( &current_task_under_cgroup), $FN( &skb_change_tail), $FN( &skb_pull_data), $FN( &csum_update), $FN( &set_hash_invalid), $FN( &get_numa_node_id), $FN( &skb_change_head), $FN( &xdp_adjust_head), $FN( &probe_read_str), $FN( &get_socket_cookie), $FN( &get_socket_uid), $FN( &set_hash), $FN( &setsockopt), $FN( &skb_adjust_room), $FN( &redirect_map), $FN( &sk_redirect_map), $FN( &sock_map_update), $FN( &xdp_adjust_meta), $FN( &perf_event_read_value), $FN( &perf_prog_read_value), $FN( &getsockopt), $FN( &override_return), $FN( &sock_ops_cb_flags_set), $FN( &msg_redirect_map), $FN( &msg_apply_bytes), $FN( &msg_cork_bytes), $FN( &msg_pull_data), $FN( &bind), $FN( &xdp_adjust_tail), $FN( &skb_get_xfrm_state), $FN( &get_stack), $FN( &skb_load_bytes_relative), $FN( &fib_lookup), $FN( &sock_hash_update), $FN( &msg_redirect_hash), $FN( &sk_redirect_hash), $FN( &lwt_push_encap), $FN( &lwt_seg6_store_bytes), $FN( &lwt_seg6_adjust_srh), $FN( &lwt_seg6_action), $FN( &rc_repeat), $FN( &rc_keydown), $FN( &skb_cgroup_id), $FN( &get_current_cgroup_id), $FN( &get_local_storage), $FN( &sk_select_reuseport), $FN( &skb_ancestor_cgroup_id), $FN( &sk_lookup_tcp), $FN( &sk_lookup_udp), $FN( &sk_release), $FN( &map_push_elem), $FN( &map_pop_elem), $FN( &map_peek_elem), $FN( &msg_push_data), $FN( &msg_pop_data), $FN( &rc_pointer_rel), $FN( &spin_lock), $FN( &spin_unlock), $FN( &sk_fullsock), $FN( &tcp_sock), $FN( &skb_ecn_set_ce), $FN( &get_listener_sock), $FN( &skc_lookup_tcp), $FN( &tcp_check_syncookie), $FN( &sysctl_get_name), $FN( &sysctl_get_current_value), $FN( &sysctl_get_new_value), $FN( &sysctl_set_new_value), $FN( &strtol), $FN( &strtoul), $FN( &sk_storage_get), $FN( &sk_storage_delete), $FN( &send_signal), $FN( &tcp_gen_syncookie), $FN( &skb_output), $FN( &probe_read_user), $FN( &probe_read_kernel), $FN( &probe_read_user_str), $FN( &probe_read_kernel_str), $FN( &tcp_send_ack), $FN( &send_signal_thread), $FN( &jiffies64), $FN( &read_branch_records), $FN( &get_ns_current_pid_tgid), $FN( &xdp_output), $FN( &get_netns_cookie), $FN( &get_current_ancestor_cgroup_id), $FN( &sk_assign), $FN( &ktime_get_boot_ns), $FN( &seq_printf), $FN( &seq_write), $FN( &sk_cgroup_id), $FN( &sk_ancestor_cgroup_id), $FN( &ringbuf_output), $FN( &ringbuf_reserve), $FN( &ringbuf_submit), $FN( &ringbuf_discard), $FN( &ringbuf_query), $FN( &csum_level), $FN( &skc_to_tcp6_sock), $FN( &skc_to_tcp_sock), $FN( &skc_to_tcp_timewait_sock), $FN( &skc_to_tcp_request_sock), $FN( &skc_to_udp6_sock), $FN( &get_task_stack),);
    }' unless defined(&__BPF_FUNC_MAPPER);
    eval 'sub __BPF_ENUM_FN {
        my($x) = @_;
	    eval q( &BPF_FUNC_  $x);
    }' unless defined(&__BPF_ENUM_FN);
    undef(&__BPF_ENUM_FN) if defined(&__BPF_ENUM_FN);
    eval("sub BPF_F_RECOMPUTE_CSUM () { (1ULL<<0); }") unless defined(&BPF_F_RECOMPUTE_CSUM);
    eval("sub BPF_F_INVALIDATE_HASH () { (1ULL<<1); }") unless defined(&BPF_F_INVALIDATE_HASH);
    eval("sub BPF_F_HDR_FIELD_MASK () { 0xfULL; }") unless defined(&BPF_F_HDR_FIELD_MASK);
    eval("sub BPF_F_PSEUDO_HDR () { (1ULL<<4); }") unless defined(&BPF_F_PSEUDO_HDR);
    eval("sub BPF_F_MARK_MANGLED_0 () { (1ULL<<5); }") unless defined(&BPF_F_MARK_MANGLED_0);
    eval("sub BPF_F_MARK_ENFORCE () { (1ULL<<6); }") unless defined(&BPF_F_MARK_ENFORCE);
    eval("sub BPF_F_INGRESS () { (1ULL<<0); }") unless defined(&BPF_F_INGRESS);
    eval("sub BPF_F_TUNINFO_IPV6 () { (1ULL<<0); }") unless defined(&BPF_F_TUNINFO_IPV6);
    eval("sub BPF_F_SKIP_FIELD_MASK () { 0xffULL; }") unless defined(&BPF_F_SKIP_FIELD_MASK);
    eval("sub BPF_F_USER_STACK () { (1ULL<<8); }") unless defined(&BPF_F_USER_STACK);
    eval("sub BPF_F_FAST_STACK_CMP () { (1ULL<<9); }") unless defined(&BPF_F_FAST_STACK_CMP);
    eval("sub BPF_F_REUSE_STACKID () { (1ULL<<10); }") unless defined(&BPF_F_REUSE_STACKID);
    eval("sub BPF_F_USER_BUILD_ID () { (1ULL<<11); }") unless defined(&BPF_F_USER_BUILD_ID);
    eval("sub BPF_F_ZERO_CSUM_TX () { (1ULL<<1); }") unless defined(&BPF_F_ZERO_CSUM_TX);
    eval("sub BPF_F_DONT_FRAGMENT () { (1ULL<<2); }") unless defined(&BPF_F_DONT_FRAGMENT);
    eval("sub BPF_F_SEQ_NUMBER () { (1ULL<<3); }") unless defined(&BPF_F_SEQ_NUMBER);
    eval("sub BPF_F_INDEX_MASK () { 0xffffffffULL; }") unless defined(&BPF_F_INDEX_MASK);
    eval("sub BPF_F_CURRENT_CPU () { BPF_F_INDEX_MASK; }") unless defined(&BPF_F_CURRENT_CPU);
    eval("sub BPF_F_CTXLEN_MASK () { (0xfffffULL<<32); }") unless defined(&BPF_F_CTXLEN_MASK);
    eval("sub BPF_F_CURRENT_NETNS () { (-1L); }") unless defined(&BPF_F_CURRENT_NETNS);
    eval("sub BPF_CSUM_LEVEL_QUERY () { 0; }") unless defined(&BPF_CSUM_LEVEL_QUERY);
    eval("sub BPF_CSUM_LEVEL_INC () { 1; }") unless defined(&BPF_CSUM_LEVEL_INC);
    eval("sub BPF_CSUM_LEVEL_DEC () { 2; }") unless defined(&BPF_CSUM_LEVEL_DEC);
    eval("sub BPF_CSUM_LEVEL_RESET () { 3; }") unless defined(&BPF_CSUM_LEVEL_RESET);
    eval("sub BPF_F_ADJ_ROOM_FIXED_GSO () { (1ULL<<0); }") unless defined(&BPF_F_ADJ_ROOM_FIXED_GSO);
    eval("sub BPF_F_ADJ_ROOM_ENCAP_L3_IPV4 () { (1ULL<<1); }") unless defined(&BPF_F_ADJ_ROOM_ENCAP_L3_IPV4);
    eval("sub BPF_F_ADJ_ROOM_ENCAP_L3_IPV6 () { (1ULL<<2); }") unless defined(&BPF_F_ADJ_ROOM_ENCAP_L3_IPV6);
    eval("sub BPF_F_ADJ_ROOM_ENCAP_L4_GRE () { (1ULL<<3); }") unless defined(&BPF_F_ADJ_ROOM_ENCAP_L4_GRE);
    eval("sub BPF_F_ADJ_ROOM_ENCAP_L4_UDP () { (1ULL<<4); }") unless defined(&BPF_F_ADJ_ROOM_ENCAP_L4_UDP);
    eval("sub BPF_F_ADJ_ROOM_NO_CSUM_RESET () { (1ULL<<5); }") unless defined(&BPF_F_ADJ_ROOM_NO_CSUM_RESET);
    eval("sub BPF_ADJ_ROOM_ENCAP_L2_MASK () { 0xff; }") unless defined(&BPF_ADJ_ROOM_ENCAP_L2_MASK);
    eval("sub BPF_ADJ_ROOM_ENCAP_L2_SHIFT () { 56; }") unless defined(&BPF_ADJ_ROOM_ENCAP_L2_SHIFT);
    eval 'sub BPF_F_ADJ_ROOM_ENCAP_L2 {
        my($len) = @_;
	    eval q(((( &__u64)$len &  &BPF_ADJ_ROOM_ENCAP_L2_MASK) <<  &BPF_ADJ_ROOM_ENCAP_L2_SHIFT));
    }' unless defined(&BPF_F_ADJ_ROOM_ENCAP_L2);
    eval("sub BPF_F_SYSCTL_BASE_NAME () { (1ULL<<0); }") unless defined(&BPF_F_SYSCTL_BASE_NAME);
    eval("sub BPF_SK_STORAGE_GET_F_CREATE () { (1ULL<<0); }") unless defined(&BPF_SK_STORAGE_GET_F_CREATE);
    eval("sub BPF_F_GET_BRANCH_RECORDS_SIZE () { (1ULL<<0); }") unless defined(&BPF_F_GET_BRANCH_RECORDS_SIZE);
    eval("sub BPF_RB_NO_WAKEUP () { (1ULL<<0); }") unless defined(&BPF_RB_NO_WAKEUP);
    eval("sub BPF_RB_FORCE_WAKEUP () { (1ULL<<1); }") unless defined(&BPF_RB_FORCE_WAKEUP);
    eval("sub BPF_RB_AVAIL_DATA () { 0; }") unless defined(&BPF_RB_AVAIL_DATA);
    eval("sub BPF_RB_RING_SIZE () { 1; }") unless defined(&BPF_RB_RING_SIZE);
    eval("sub BPF_RB_CONS_POS () { 2; }") unless defined(&BPF_RB_CONS_POS);
    eval("sub BPF_RB_PROD_POS () { 3; }") unless defined(&BPF_RB_PROD_POS);
    eval("sub BPF_RINGBUF_BUSY_BIT () { (1U<<31); }") unless defined(&BPF_RINGBUF_BUSY_BIT);
    eval("sub BPF_RINGBUF_DISCARD_BIT () { (1U<<30); }") unless defined(&BPF_RINGBUF_DISCARD_BIT);
    eval("sub BPF_RINGBUF_HDR_SZ () { 8; }") unless defined(&BPF_RINGBUF_HDR_SZ);
    eval("sub BPF_SK_LOOKUP_F_REPLACE () { (1ULL<<0); }") unless defined(&BPF_SK_LOOKUP_F_REPLACE);
    eval("sub BPF_SK_LOOKUP_F_NO_REUSEPORT () { (1ULL<<1); }") unless defined(&BPF_SK_LOOKUP_F_NO_REUSEPORT);
    eval("sub BPF_ADJ_ROOM_NET () { 0; }") unless defined(&BPF_ADJ_ROOM_NET);
    eval("sub BPF_ADJ_ROOM_MAC () { 1; }") unless defined(&BPF_ADJ_ROOM_MAC);
    eval("sub BPF_HDR_START_MAC () { 0; }") unless defined(&BPF_HDR_START_MAC);
    eval("sub BPF_HDR_START_NET () { 1; }") unless defined(&BPF_HDR_START_NET);
    eval("sub BPF_LWT_ENCAP_SEG6 () { 0; }") unless defined(&BPF_LWT_ENCAP_SEG6);
    eval("sub BPF_LWT_ENCAP_SEG6_INLINE () { 1; }") unless defined(&BPF_LWT_ENCAP_SEG6_INLINE);
    eval("sub BPF_LWT_ENCAP_IP () { 2; }") unless defined(&BPF_LWT_ENCAP_IP);
    eval 'sub __bpf_md_ptr {
        my($type, $name) = @_;
	    eval q(\'union union\' { $type $name;  &__u64 :64; }  &__attribute__(( &aligned(8))));
    }' unless defined(&__bpf_md_ptr);
    eval("sub BPF_OK () { 0; }") unless defined(&BPF_OK);
    eval("sub BPF_DROP () { 2; }") unless defined(&BPF_DROP);
    eval("sub BPF_REDIRECT () { 7; }") unless defined(&BPF_REDIRECT);
    eval("sub BPF_LWT_REROUTE () { 128; }") unless defined(&BPF_LWT_REROUTE);
    eval 'sub XDP_PACKET_HEADROOM () {256;}' unless defined(&XDP_PACKET_HEADROOM);
    eval("sub XDP_ABORTED () { 0; }") unless defined(&XDP_ABORTED);
    eval("sub XDP_DROP () { 1; }") unless defined(&XDP_DROP);
    eval("sub XDP_PASS () { 2; }") unless defined(&XDP_PASS);
    eval("sub XDP_TX () { 3; }") unless defined(&XDP_TX);
    eval("sub XDP_REDIRECT () { 4; }") unless defined(&XDP_REDIRECT);
    eval("sub SK_DROP () { 0; }") unless defined(&SK_DROP);
    eval("sub SK_PASS () { 1; }") unless defined(&SK_PASS);
    eval 'sub BPF_TAG_SIZE () {8;}' unless defined(&BPF_TAG_SIZE);
    eval("sub BPF_SOCK_OPS_RTO_CB_FLAG () { (1<<0); }") unless defined(&BPF_SOCK_OPS_RTO_CB_FLAG);
    eval("sub BPF_SOCK_OPS_RETRANS_CB_FLAG () { (1<<1); }") unless defined(&BPF_SOCK_OPS_RETRANS_CB_FLAG);
    eval("sub BPF_SOCK_OPS_STATE_CB_FLAG () { (1<<2); }") unless defined(&BPF_SOCK_OPS_STATE_CB_FLAG);
    eval("sub BPF_SOCK_OPS_RTT_CB_FLAG () { (1<<3); }") unless defined(&BPF_SOCK_OPS_RTT_CB_FLAG);
    eval("sub BPF_SOCK_OPS_ALL_CB_FLAGS () { 0xF; }") unless defined(&BPF_SOCK_OPS_ALL_CB_FLAGS);
    eval("sub BPF_SOCK_OPS_VOID () { 0; }") unless defined(&BPF_SOCK_OPS_VOID);
    eval("sub BPF_SOCK_OPS_TIMEOUT_INIT () { 1; }") unless defined(&BPF_SOCK_OPS_TIMEOUT_INIT);
    eval("sub BPF_SOCK_OPS_RWND_INIT () { 2; }") unless defined(&BPF_SOCK_OPS_RWND_INIT);
    eval("sub BPF_SOCK_OPS_TCP_CONNECT_CB () { 3; }") unless defined(&BPF_SOCK_OPS_TCP_CONNECT_CB);
    eval("sub BPF_SOCK_OPS_ACTIVE_ESTABLISHED_CB () { 4; }") unless defined(&BPF_SOCK_OPS_ACTIVE_ESTABLISHED_CB);
    eval("sub BPF_SOCK_OPS_PASSIVE_ESTABLISHED_CB () { 5; }") unless defined(&BPF_SOCK_OPS_PASSIVE_ESTABLISHED_CB);
    eval("sub BPF_SOCK_OPS_NEEDS_ECN () { 6; }") unless defined(&BPF_SOCK_OPS_NEEDS_ECN);
    eval("sub BPF_SOCK_OPS_BASE_RTT () { 7; }") unless defined(&BPF_SOCK_OPS_BASE_RTT);
    eval("sub BPF_SOCK_OPS_RTO_CB () { 8; }") unless defined(&BPF_SOCK_OPS_RTO_CB);
    eval("sub BPF_SOCK_OPS_RETRANS_CB () { 9; }") unless defined(&BPF_SOCK_OPS_RETRANS_CB);
    eval("sub BPF_SOCK_OPS_STATE_CB () { 10; }") unless defined(&BPF_SOCK_OPS_STATE_CB);
    eval("sub BPF_SOCK_OPS_TCP_LISTEN_CB () { 11; }") unless defined(&BPF_SOCK_OPS_TCP_LISTEN_CB);
    eval("sub BPF_SOCK_OPS_RTT_CB () { 12; }") unless defined(&BPF_SOCK_OPS_RTT_CB);
    eval("sub BPF_TCP_ESTABLISHED () { 1; }") unless defined(&BPF_TCP_ESTABLISHED);
    eval("sub BPF_TCP_SYN_SENT () { 2; }") unless defined(&BPF_TCP_SYN_SENT);
    eval("sub BPF_TCP_SYN_RECV () { 3; }") unless defined(&BPF_TCP_SYN_RECV);
    eval("sub BPF_TCP_FIN_WAIT1 () { 4; }") unless defined(&BPF_TCP_FIN_WAIT1);
    eval("sub BPF_TCP_FIN_WAIT2 () { 5; }") unless defined(&BPF_TCP_FIN_WAIT2);
    eval("sub BPF_TCP_TIME_WAIT () { 6; }") unless defined(&BPF_TCP_TIME_WAIT);
    eval("sub BPF_TCP_CLOSE () { 7; }") unless defined(&BPF_TCP_CLOSE);
    eval("sub BPF_TCP_CLOSE_WAIT () { 8; }") unless defined(&BPF_TCP_CLOSE_WAIT);
    eval("sub BPF_TCP_LAST_ACK () { 9; }") unless defined(&BPF_TCP_LAST_ACK);
    eval("sub BPF_TCP_LISTEN () { 10; }") unless defined(&BPF_TCP_LISTEN);
    eval("sub BPF_TCP_CLOSING () { 11; }") unless defined(&BPF_TCP_CLOSING);
    eval("sub BPF_TCP_NEW_SYN_RECV () { 12; }") unless defined(&BPF_TCP_NEW_SYN_RECV);
    eval("sub BPF_TCP_MAX_STATES () { 13; }") unless defined(&BPF_TCP_MAX_STATES);
    eval("sub TCP_BPF_IW () { 1001; }") unless defined(&TCP_BPF_IW);
    eval("sub TCP_BPF_SNDCWND_CLAMP () { 1002; }") unless defined(&TCP_BPF_SNDCWND_CLAMP);
    eval("sub BPF_DEVCG_ACC_MKNOD () { (1ULL<<0); }") unless defined(&BPF_DEVCG_ACC_MKNOD);
    eval("sub BPF_DEVCG_ACC_READ () { (1ULL<<1); }") unless defined(&BPF_DEVCG_ACC_READ);
    eval("sub BPF_DEVCG_ACC_WRITE () { (1ULL<<2); }") unless defined(&BPF_DEVCG_ACC_WRITE);
    eval("sub BPF_DEVCG_DEV_BLOCK () { (1ULL<<0); }") unless defined(&BPF_DEVCG_DEV_BLOCK);
    eval("sub BPF_DEVCG_DEV_CHAR () { (1ULL<<1); }") unless defined(&BPF_DEVCG_DEV_CHAR);
    eval("sub BPF_FIB_LOOKUP_DIRECT () { (1U<<0); }") unless defined(&BPF_FIB_LOOKUP_DIRECT);
    eval("sub BPF_FIB_LOOKUP_OUTPUT () { (1U<<1); }") unless defined(&BPF_FIB_LOOKUP_OUTPUT);
    eval("sub BPF_FIB_LKUP_RET_SUCCESS () { 0; }") unless defined(&BPF_FIB_LKUP_RET_SUCCESS);
    eval("sub BPF_FIB_LKUP_RET_BLACKHOLE () { 1; }") unless defined(&BPF_FIB_LKUP_RET_BLACKHOLE);
    eval("sub BPF_FIB_LKUP_RET_UNREACHABLE () { 2; }") unless defined(&BPF_FIB_LKUP_RET_UNREACHABLE);
    eval("sub BPF_FIB_LKUP_RET_PROHIBIT () { 3; }") unless defined(&BPF_FIB_LKUP_RET_PROHIBIT);
    eval("sub BPF_FIB_LKUP_RET_NOT_FWDED () { 4; }") unless defined(&BPF_FIB_LKUP_RET_NOT_FWDED);
    eval("sub BPF_FIB_LKUP_RET_FWD_DISABLED () { 5; }") unless defined(&BPF_FIB_LKUP_RET_FWD_DISABLED);
    eval("sub BPF_FIB_LKUP_RET_UNSUPP_LWT () { 6; }") unless defined(&BPF_FIB_LKUP_RET_UNSUPP_LWT);
    eval("sub BPF_FIB_LKUP_RET_NO_NEIGH () { 7; }") unless defined(&BPF_FIB_LKUP_RET_NO_NEIGH);
    eval("sub BPF_FIB_LKUP_RET_FRAG_NEEDED () { 8; }") unless defined(&BPF_FIB_LKUP_RET_FRAG_NEEDED);
    eval("sub BPF_FD_TYPE_RAW_TRACEPOINT () { 0; }") unless defined(&BPF_FD_TYPE_RAW_TRACEPOINT);
    eval("sub BPF_FD_TYPE_TRACEPOINT () { 1; }") unless defined(&BPF_FD_TYPE_TRACEPOINT);
    eval("sub BPF_FD_TYPE_KPROBE () { 2; }") unless defined(&BPF_FD_TYPE_KPROBE);
    eval("sub BPF_FD_TYPE_KRETPROBE () { 3; }") unless defined(&BPF_FD_TYPE_KRETPROBE);
    eval("sub BPF_FD_TYPE_UPROBE () { 4; }") unless defined(&BPF_FD_TYPE_UPROBE);
    eval("sub BPF_FD_TYPE_URETPROBE () { 5; }") unless defined(&BPF_FD_TYPE_URETPROBE);
    eval("sub BPF_FLOW_DISSECTOR_F_PARSE_1ST_FRAG () { (1U<<0); }") unless defined(&BPF_FLOW_DISSECTOR_F_PARSE_1ST_FRAG);
    eval("sub BPF_FLOW_DISSECTOR_F_STOP_AT_FLOW_LABEL () { (1U<<1); }") unless defined(&BPF_FLOW_DISSECTOR_F_STOP_AT_FLOW_LABEL);
    eval("sub BPF_FLOW_DISSECTOR_F_STOP_AT_ENCAP () { (1U<<2); }") unless defined(&BPF_FLOW_DISSECTOR_F_STOP_AT_ENCAP);
    eval 'sub BPF_LINE_INFO_LINE_NUM {
        my($line_col) = @_;
	    eval q((($line_col) >> 10));
    }' unless defined(&BPF_LINE_INFO_LINE_NUM);
    eval 'sub BPF_LINE_INFO_LINE_COL {
        my($line_col) = @_;
	    eval q((($line_col) & 0x3ff));
    }' unless defined(&BPF_LINE_INFO_LINE_COL);
}
1;
