require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_LINUX_PERF_EVENT_H)) {
    eval 'sub _LINUX_PERF_EVENT_H () {1;}' unless defined(&_LINUX_PERF_EVENT_H);
    require 'linux/types.ph';
    require 'linux/ioctl.ph';
    require 'asm/byteorder.ph';
    eval("sub PERF_TYPE_HARDWARE () { 0; }") unless defined(&PERF_TYPE_HARDWARE);
    eval("sub PERF_TYPE_SOFTWARE () { 1; }") unless defined(&PERF_TYPE_SOFTWARE);
    eval("sub PERF_TYPE_TRACEPOINT () { 2; }") unless defined(&PERF_TYPE_TRACEPOINT);
    eval("sub PERF_TYPE_HW_CACHE () { 3; }") unless defined(&PERF_TYPE_HW_CACHE);
    eval("sub PERF_TYPE_RAW () { 4; }") unless defined(&PERF_TYPE_RAW);
    eval("sub PERF_TYPE_BREAKPOINT () { 5; }") unless defined(&PERF_TYPE_BREAKPOINT);
    eval("sub PERF_TYPE_MAX () { 6; }") unless defined(&PERF_TYPE_MAX);
    eval("sub PERF_COUNT_HW_CPU_CYCLES () { 0; }") unless defined(&PERF_COUNT_HW_CPU_CYCLES);
    eval("sub PERF_COUNT_HW_INSTRUCTIONS () { 1; }") unless defined(&PERF_COUNT_HW_INSTRUCTIONS);
    eval("sub PERF_COUNT_HW_CACHE_REFERENCES () { 2; }") unless defined(&PERF_COUNT_HW_CACHE_REFERENCES);
    eval("sub PERF_COUNT_HW_CACHE_MISSES () { 3; }") unless defined(&PERF_COUNT_HW_CACHE_MISSES);
    eval("sub PERF_COUNT_HW_BRANCH_INSTRUCTIONS () { 4; }") unless defined(&PERF_COUNT_HW_BRANCH_INSTRUCTIONS);
    eval("sub PERF_COUNT_HW_BRANCH_MISSES () { 5; }") unless defined(&PERF_COUNT_HW_BRANCH_MISSES);
    eval("sub PERF_COUNT_HW_BUS_CYCLES () { 6; }") unless defined(&PERF_COUNT_HW_BUS_CYCLES);
    eval("sub PERF_COUNT_HW_STALLED_CYCLES_FRONTEND () { 7; }") unless defined(&PERF_COUNT_HW_STALLED_CYCLES_FRONTEND);
    eval("sub PERF_COUNT_HW_STALLED_CYCLES_BACKEND () { 8; }") unless defined(&PERF_COUNT_HW_STALLED_CYCLES_BACKEND);
    eval("sub PERF_COUNT_HW_REF_CPU_CYCLES () { 9; }") unless defined(&PERF_COUNT_HW_REF_CPU_CYCLES);
    eval("sub PERF_COUNT_HW_MAX () { 10; }") unless defined(&PERF_COUNT_HW_MAX);
    eval("sub PERF_COUNT_HW_CACHE_L1D () { 0; }") unless defined(&PERF_COUNT_HW_CACHE_L1D);
    eval("sub PERF_COUNT_HW_CACHE_L1I () { 1; }") unless defined(&PERF_COUNT_HW_CACHE_L1I);
    eval("sub PERF_COUNT_HW_CACHE_LL () { 2; }") unless defined(&PERF_COUNT_HW_CACHE_LL);
    eval("sub PERF_COUNT_HW_CACHE_DTLB () { 3; }") unless defined(&PERF_COUNT_HW_CACHE_DTLB);
    eval("sub PERF_COUNT_HW_CACHE_ITLB () { 4; }") unless defined(&PERF_COUNT_HW_CACHE_ITLB);
    eval("sub PERF_COUNT_HW_CACHE_BPU () { 5; }") unless defined(&PERF_COUNT_HW_CACHE_BPU);
    eval("sub PERF_COUNT_HW_CACHE_NODE () { 6; }") unless defined(&PERF_COUNT_HW_CACHE_NODE);
    eval("sub PERF_COUNT_HW_CACHE_MAX () { 7; }") unless defined(&PERF_COUNT_HW_CACHE_MAX);
    eval("sub PERF_COUNT_HW_CACHE_OP_READ () { 0; }") unless defined(&PERF_COUNT_HW_CACHE_OP_READ);
    eval("sub PERF_COUNT_HW_CACHE_OP_WRITE () { 1; }") unless defined(&PERF_COUNT_HW_CACHE_OP_WRITE);
    eval("sub PERF_COUNT_HW_CACHE_OP_PREFETCH () { 2; }") unless defined(&PERF_COUNT_HW_CACHE_OP_PREFETCH);
    eval("sub PERF_COUNT_HW_CACHE_OP_MAX () { 3; }") unless defined(&PERF_COUNT_HW_CACHE_OP_MAX);
    eval("sub PERF_COUNT_HW_CACHE_RESULT_ACCESS () { 0; }") unless defined(&PERF_COUNT_HW_CACHE_RESULT_ACCESS);
    eval("sub PERF_COUNT_HW_CACHE_RESULT_MISS () { 1; }") unless defined(&PERF_COUNT_HW_CACHE_RESULT_MISS);
    eval("sub PERF_COUNT_HW_CACHE_RESULT_MAX () { 2; }") unless defined(&PERF_COUNT_HW_CACHE_RESULT_MAX);
    eval("sub PERF_COUNT_SW_CPU_CLOCK () { 0; }") unless defined(&PERF_COUNT_SW_CPU_CLOCK);
    eval("sub PERF_COUNT_SW_TASK_CLOCK () { 1; }") unless defined(&PERF_COUNT_SW_TASK_CLOCK);
    eval("sub PERF_COUNT_SW_PAGE_FAULTS () { 2; }") unless defined(&PERF_COUNT_SW_PAGE_FAULTS);
    eval("sub PERF_COUNT_SW_CONTEXT_SWITCHES () { 3; }") unless defined(&PERF_COUNT_SW_CONTEXT_SWITCHES);
    eval("sub PERF_COUNT_SW_CPU_MIGRATIONS () { 4; }") unless defined(&PERF_COUNT_SW_CPU_MIGRATIONS);
    eval("sub PERF_COUNT_SW_PAGE_FAULTS_MIN () { 5; }") unless defined(&PERF_COUNT_SW_PAGE_FAULTS_MIN);
    eval("sub PERF_COUNT_SW_PAGE_FAULTS_MAJ () { 6; }") unless defined(&PERF_COUNT_SW_PAGE_FAULTS_MAJ);
    eval("sub PERF_COUNT_SW_ALIGNMENT_FAULTS () { 7; }") unless defined(&PERF_COUNT_SW_ALIGNMENT_FAULTS);
    eval("sub PERF_COUNT_SW_EMULATION_FAULTS () { 8; }") unless defined(&PERF_COUNT_SW_EMULATION_FAULTS);
    eval("sub PERF_COUNT_SW_DUMMY () { 9; }") unless defined(&PERF_COUNT_SW_DUMMY);
    eval("sub PERF_COUNT_SW_BPF_OUTPUT () { 10; }") unless defined(&PERF_COUNT_SW_BPF_OUTPUT);
    eval("sub PERF_COUNT_SW_MAX () { 11; }") unless defined(&PERF_COUNT_SW_MAX);
    eval("sub PERF_SAMPLE_IP () { 1U<<0; }") unless defined(&PERF_SAMPLE_IP);
    eval("sub PERF_SAMPLE_TID () { 1U<<1; }") unless defined(&PERF_SAMPLE_TID);
    eval("sub PERF_SAMPLE_TIME () { 1U<<2; }") unless defined(&PERF_SAMPLE_TIME);
    eval("sub PERF_SAMPLE_ADDR () { 1U<<3; }") unless defined(&PERF_SAMPLE_ADDR);
    eval("sub PERF_SAMPLE_READ () { 1U<<4; }") unless defined(&PERF_SAMPLE_READ);
    eval("sub PERF_SAMPLE_CALLCHAIN () { 1U<<5; }") unless defined(&PERF_SAMPLE_CALLCHAIN);
    eval("sub PERF_SAMPLE_ID () { 1U<<6; }") unless defined(&PERF_SAMPLE_ID);
    eval("sub PERF_SAMPLE_CPU () { 1U<<7; }") unless defined(&PERF_SAMPLE_CPU);
    eval("sub PERF_SAMPLE_PERIOD () { 1U<<8; }") unless defined(&PERF_SAMPLE_PERIOD);
    eval("sub PERF_SAMPLE_STREAM_ID () { 1U<<9; }") unless defined(&PERF_SAMPLE_STREAM_ID);
    eval("sub PERF_SAMPLE_RAW () { 1U<<10; }") unless defined(&PERF_SAMPLE_RAW);
    eval("sub PERF_SAMPLE_BRANCH_STACK () { 1U<<11; }") unless defined(&PERF_SAMPLE_BRANCH_STACK);
    eval("sub PERF_SAMPLE_REGS_USER () { 1U<<12; }") unless defined(&PERF_SAMPLE_REGS_USER);
    eval("sub PERF_SAMPLE_STACK_USER () { 1U<<13; }") unless defined(&PERF_SAMPLE_STACK_USER);
    eval("sub PERF_SAMPLE_WEIGHT () { 1U<<14; }") unless defined(&PERF_SAMPLE_WEIGHT);
    eval("sub PERF_SAMPLE_DATA_SRC () { 1U<<15; }") unless defined(&PERF_SAMPLE_DATA_SRC);
    eval("sub PERF_SAMPLE_IDENTIFIER () { 1U<<16; }") unless defined(&PERF_SAMPLE_IDENTIFIER);
    eval("sub PERF_SAMPLE_TRANSACTION () { 1U<<17; }") unless defined(&PERF_SAMPLE_TRANSACTION);
    eval("sub PERF_SAMPLE_REGS_INTR () { 1U<<18; }") unless defined(&PERF_SAMPLE_REGS_INTR);
    eval("sub PERF_SAMPLE_PHYS_ADDR () { 1U<<19; }") unless defined(&PERF_SAMPLE_PHYS_ADDR);
    eval("sub PERF_SAMPLE_AUX () { 1U<<20; }") unless defined(&PERF_SAMPLE_AUX);
    eval("sub PERF_SAMPLE_CGROUP () { 1U<<21; }") unless defined(&PERF_SAMPLE_CGROUP);
    eval("sub PERF_SAMPLE_MAX () { 1U<<22; }") unless defined(&PERF_SAMPLE_MAX);
    eval("sub __PERF_SAMPLE_CALLCHAIN_EARLY () { 1ULL<<63; }") unless defined(&__PERF_SAMPLE_CALLCHAIN_EARLY);
    eval("sub PERF_SAMPLE_BRANCH_USER_SHIFT () { 0; }") unless defined(&PERF_SAMPLE_BRANCH_USER_SHIFT);
    eval("sub PERF_SAMPLE_BRANCH_KERNEL_SHIFT () { 1; }") unless defined(&PERF_SAMPLE_BRANCH_KERNEL_SHIFT);
    eval("sub PERF_SAMPLE_BRANCH_HV_SHIFT () { 2; }") unless defined(&PERF_SAMPLE_BRANCH_HV_SHIFT);
    eval("sub PERF_SAMPLE_BRANCH_ANY_SHIFT () { 3; }") unless defined(&PERF_SAMPLE_BRANCH_ANY_SHIFT);
    eval("sub PERF_SAMPLE_BRANCH_ANY_CALL_SHIFT () { 4; }") unless defined(&PERF_SAMPLE_BRANCH_ANY_CALL_SHIFT);
    eval("sub PERF_SAMPLE_BRANCH_ANY_RETURN_SHIFT () { 5; }") unless defined(&PERF_SAMPLE_BRANCH_ANY_RETURN_SHIFT);
    eval("sub PERF_SAMPLE_BRANCH_IND_CALL_SHIFT () { 6; }") unless defined(&PERF_SAMPLE_BRANCH_IND_CALL_SHIFT);
    eval("sub PERF_SAMPLE_BRANCH_ABORT_TX_SHIFT () { 7; }") unless defined(&PERF_SAMPLE_BRANCH_ABORT_TX_SHIFT);
    eval("sub PERF_SAMPLE_BRANCH_IN_TX_SHIFT () { 8; }") unless defined(&PERF_SAMPLE_BRANCH_IN_TX_SHIFT);
    eval("sub PERF_SAMPLE_BRANCH_NO_TX_SHIFT () { 9; }") unless defined(&PERF_SAMPLE_BRANCH_NO_TX_SHIFT);
    eval("sub PERF_SAMPLE_BRANCH_COND_SHIFT () { 10; }") unless defined(&PERF_SAMPLE_BRANCH_COND_SHIFT);
    eval("sub PERF_SAMPLE_BRANCH_CALL_STACK_SHIFT () { 11; }") unless defined(&PERF_SAMPLE_BRANCH_CALL_STACK_SHIFT);
    eval("sub PERF_SAMPLE_BRANCH_IND_JUMP_SHIFT () { 12; }") unless defined(&PERF_SAMPLE_BRANCH_IND_JUMP_SHIFT);
    eval("sub PERF_SAMPLE_BRANCH_CALL_SHIFT () { 13; }") unless defined(&PERF_SAMPLE_BRANCH_CALL_SHIFT);
    eval("sub PERF_SAMPLE_BRANCH_NO_FLAGS_SHIFT () { 14; }") unless defined(&PERF_SAMPLE_BRANCH_NO_FLAGS_SHIFT);
    eval("sub PERF_SAMPLE_BRANCH_NO_CYCLES_SHIFT () { 15; }") unless defined(&PERF_SAMPLE_BRANCH_NO_CYCLES_SHIFT);
    eval("sub PERF_SAMPLE_BRANCH_TYPE_SAVE_SHIFT () { 16; }") unless defined(&PERF_SAMPLE_BRANCH_TYPE_SAVE_SHIFT);
    eval("sub PERF_SAMPLE_BRANCH_HW_INDEX_SHIFT () { 17; }") unless defined(&PERF_SAMPLE_BRANCH_HW_INDEX_SHIFT);
    eval("sub PERF_SAMPLE_BRANCH_MAX_SHIFT () { 18; }") unless defined(&PERF_SAMPLE_BRANCH_MAX_SHIFT);
    eval("sub PERF_SAMPLE_BRANCH_USER () { 1U<<PERF_SAMPLE_BRANCH_USER_SHIFT; }") unless defined(&PERF_SAMPLE_BRANCH_USER);
    eval("sub PERF_SAMPLE_BRANCH_KERNEL () { 1U<<PERF_SAMPLE_BRANCH_KERNEL_SHIFT; }") unless defined(&PERF_SAMPLE_BRANCH_KERNEL);
    eval("sub PERF_SAMPLE_BRANCH_HV () { 1U<<PERF_SAMPLE_BRANCH_HV_SHIFT; }") unless defined(&PERF_SAMPLE_BRANCH_HV);
    eval("sub PERF_SAMPLE_BRANCH_ANY () { 1U<<PERF_SAMPLE_BRANCH_ANY_SHIFT; }") unless defined(&PERF_SAMPLE_BRANCH_ANY);
    eval("sub PERF_SAMPLE_BRANCH_ANY_CALL () { 1U<<PERF_SAMPLE_BRANCH_ANY_CALL_SHIFT; }") unless defined(&PERF_SAMPLE_BRANCH_ANY_CALL);
    eval("sub PERF_SAMPLE_BRANCH_ANY_RETURN () { 1U<<PERF_SAMPLE_BRANCH_ANY_RETURN_SHIFT; }") unless defined(&PERF_SAMPLE_BRANCH_ANY_RETURN);
    eval("sub PERF_SAMPLE_BRANCH_IND_CALL () { 1U<<PERF_SAMPLE_BRANCH_IND_CALL_SHIFT; }") unless defined(&PERF_SAMPLE_BRANCH_IND_CALL);
    eval("sub PERF_SAMPLE_BRANCH_ABORT_TX () { 1U<<PERF_SAMPLE_BRANCH_ABORT_TX_SHIFT; }") unless defined(&PERF_SAMPLE_BRANCH_ABORT_TX);
    eval("sub PERF_SAMPLE_BRANCH_IN_TX () { 1U<<PERF_SAMPLE_BRANCH_IN_TX_SHIFT; }") unless defined(&PERF_SAMPLE_BRANCH_IN_TX);
    eval("sub PERF_SAMPLE_BRANCH_NO_TX () { 1U<<PERF_SAMPLE_BRANCH_NO_TX_SHIFT; }") unless defined(&PERF_SAMPLE_BRANCH_NO_TX);
    eval("sub PERF_SAMPLE_BRANCH_COND () { 1U<<PERF_SAMPLE_BRANCH_COND_SHIFT; }") unless defined(&PERF_SAMPLE_BRANCH_COND);
    eval("sub PERF_SAMPLE_BRANCH_CALL_STACK () { 1U<<PERF_SAMPLE_BRANCH_CALL_STACK_SHIFT; }") unless defined(&PERF_SAMPLE_BRANCH_CALL_STACK);
    eval("sub PERF_SAMPLE_BRANCH_IND_JUMP () { 1U<<PERF_SAMPLE_BRANCH_IND_JUMP_SHIFT; }") unless defined(&PERF_SAMPLE_BRANCH_IND_JUMP);
    eval("sub PERF_SAMPLE_BRANCH_CALL () { 1U<<PERF_SAMPLE_BRANCH_CALL_SHIFT; }") unless defined(&PERF_SAMPLE_BRANCH_CALL);
    eval("sub PERF_SAMPLE_BRANCH_NO_FLAGS () { 1U<<PERF_SAMPLE_BRANCH_NO_FLAGS_SHIFT; }") unless defined(&PERF_SAMPLE_BRANCH_NO_FLAGS);
    eval("sub PERF_SAMPLE_BRANCH_NO_CYCLES () { 1U<<PERF_SAMPLE_BRANCH_NO_CYCLES_SHIFT; }") unless defined(&PERF_SAMPLE_BRANCH_NO_CYCLES);
    eval("sub PERF_SAMPLE_BRANCH_TYPE_SAVE () { 1U<<PERF_SAMPLE_BRANCH_TYPE_SAVE_SHIFT; }") unless defined(&PERF_SAMPLE_BRANCH_TYPE_SAVE);
    eval("sub PERF_SAMPLE_BRANCH_HW_INDEX () { 1U<<PERF_SAMPLE_BRANCH_HW_INDEX_SHIFT; }") unless defined(&PERF_SAMPLE_BRANCH_HW_INDEX);
    eval("sub PERF_SAMPLE_BRANCH_MAX () { 1U<<PERF_SAMPLE_BRANCH_MAX_SHIFT; }") unless defined(&PERF_SAMPLE_BRANCH_MAX);
    eval("sub PERF_BR_UNKNOWN () { 0; }") unless defined(&PERF_BR_UNKNOWN);
    eval("sub PERF_BR_COND () { 1; }") unless defined(&PERF_BR_COND);
    eval("sub PERF_BR_UNCOND () { 2; }") unless defined(&PERF_BR_UNCOND);
    eval("sub PERF_BR_IND () { 3; }") unless defined(&PERF_BR_IND);
    eval("sub PERF_BR_CALL () { 4; }") unless defined(&PERF_BR_CALL);
    eval("sub PERF_BR_IND_CALL () { 5; }") unless defined(&PERF_BR_IND_CALL);
    eval("sub PERF_BR_RET () { 6; }") unless defined(&PERF_BR_RET);
    eval("sub PERF_BR_SYSCALL () { 7; }") unless defined(&PERF_BR_SYSCALL);
    eval("sub PERF_BR_SYSRET () { 8; }") unless defined(&PERF_BR_SYSRET);
    eval("sub PERF_BR_COND_CALL () { 9; }") unless defined(&PERF_BR_COND_CALL);
    eval("sub PERF_BR_COND_RET () { 10; }") unless defined(&PERF_BR_COND_RET);
    eval("sub PERF_BR_MAX () { 11; }") unless defined(&PERF_BR_MAX);
    eval 'sub PERF_SAMPLE_BRANCH_PLM_ALL () {( &PERF_SAMPLE_BRANCH_USER|  &PERF_SAMPLE_BRANCH_KERNEL|  &PERF_SAMPLE_BRANCH_HV);}' unless defined(&PERF_SAMPLE_BRANCH_PLM_ALL);
    eval("sub PERF_SAMPLE_REGS_ABI_NONE () { 0; }") unless defined(&PERF_SAMPLE_REGS_ABI_NONE);
    eval("sub PERF_SAMPLE_REGS_ABI_32 () { 1; }") unless defined(&PERF_SAMPLE_REGS_ABI_32);
    eval("sub PERF_SAMPLE_REGS_ABI_64 () { 2; }") unless defined(&PERF_SAMPLE_REGS_ABI_64);
    eval("sub PERF_TXN_ELISION () { (1<<0); }") unless defined(&PERF_TXN_ELISION);
    eval("sub PERF_TXN_TRANSACTION () { (1<<1); }") unless defined(&PERF_TXN_TRANSACTION);
    eval("sub PERF_TXN_SYNC () { (1<<2); }") unless defined(&PERF_TXN_SYNC);
    eval("sub PERF_TXN_ASYNC () { (1<<3); }") unless defined(&PERF_TXN_ASYNC);
    eval("sub PERF_TXN_RETRY () { (1<<4); }") unless defined(&PERF_TXN_RETRY);
    eval("sub PERF_TXN_CONFLICT () { (1<<5); }") unless defined(&PERF_TXN_CONFLICT);
    eval("sub PERF_TXN_CAPACITY_WRITE () { (1<<6); }") unless defined(&PERF_TXN_CAPACITY_WRITE);
    eval("sub PERF_TXN_CAPACITY_READ () { (1<<7); }") unless defined(&PERF_TXN_CAPACITY_READ);
    eval("sub PERF_TXN_MAX () { (1<<8); }") unless defined(&PERF_TXN_MAX);
    eval("sub PERF_TXN_ABORT_MASK () { (0xffffffffULL<<32); }") unless defined(&PERF_TXN_ABORT_MASK);
    eval("sub PERF_TXN_ABORT_SHIFT () { 32; }") unless defined(&PERF_TXN_ABORT_SHIFT);
    eval("sub PERF_FORMAT_TOTAL_TIME_ENABLED () { 1U<<0; }") unless defined(&PERF_FORMAT_TOTAL_TIME_ENABLED);
    eval("sub PERF_FORMAT_TOTAL_TIME_RUNNING () { 1U<<1; }") unless defined(&PERF_FORMAT_TOTAL_TIME_RUNNING);
    eval("sub PERF_FORMAT_ID () { 1U<<2; }") unless defined(&PERF_FORMAT_ID);
    eval("sub PERF_FORMAT_GROUP () { 1U<<3; }") unless defined(&PERF_FORMAT_GROUP);
    eval("sub PERF_FORMAT_MAX () { 1U<<4; }") unless defined(&PERF_FORMAT_MAX);
    eval 'sub PERF_ATTR_SIZE_VER0 () {64;}' unless defined(&PERF_ATTR_SIZE_VER0);
    eval 'sub PERF_ATTR_SIZE_VER1 () {72;}' unless defined(&PERF_ATTR_SIZE_VER1);
    eval 'sub PERF_ATTR_SIZE_VER2 () {80;}' unless defined(&PERF_ATTR_SIZE_VER2);
    eval 'sub PERF_ATTR_SIZE_VER3 () {96;}' unless defined(&PERF_ATTR_SIZE_VER3);
    eval 'sub PERF_ATTR_SIZE_VER4 () {104;}' unless defined(&PERF_ATTR_SIZE_VER4);
    eval 'sub PERF_ATTR_SIZE_VER5 () {112;}' unless defined(&PERF_ATTR_SIZE_VER5);
    eval 'sub PERF_ATTR_SIZE_VER6 () {120;}' unless defined(&PERF_ATTR_SIZE_VER6);
    eval 'sub PERF_EVENT_IOC_ENABLE () { &_IO (ord(\'$\'), 0);}' unless defined(&PERF_EVENT_IOC_ENABLE);
    eval 'sub PERF_EVENT_IOC_DISABLE () { &_IO (ord(\'$\'), 1);}' unless defined(&PERF_EVENT_IOC_DISABLE);
    eval 'sub PERF_EVENT_IOC_REFRESH () { &_IO (ord(\'$\'), 2);}' unless defined(&PERF_EVENT_IOC_REFRESH);
    eval 'sub PERF_EVENT_IOC_RESET () { &_IO (ord(\'$\'), 3);}' unless defined(&PERF_EVENT_IOC_RESET);
    eval 'sub PERF_EVENT_IOC_PERIOD () { &_IOW(ord(\'$\'), 4,  &__u64);}' unless defined(&PERF_EVENT_IOC_PERIOD);
    eval 'sub PERF_EVENT_IOC_SET_OUTPUT () { &_IO (ord(\'$\'), 5);}' unless defined(&PERF_EVENT_IOC_SET_OUTPUT);
    eval 'sub PERF_EVENT_IOC_SET_FILTER () { &_IOW(ord(\'$\'), 6, \'char\' *);}' unless defined(&PERF_EVENT_IOC_SET_FILTER);
    eval 'sub PERF_EVENT_IOC_ID () { &_IOR(ord(\'$\'), 7,  &__u64 *);}' unless defined(&PERF_EVENT_IOC_ID);
    eval 'sub PERF_EVENT_IOC_SET_BPF () { &_IOW(ord(\'$\'), 8,  &__u32);}' unless defined(&PERF_EVENT_IOC_SET_BPF);
    eval 'sub PERF_EVENT_IOC_PAUSE_OUTPUT () { &_IOW(ord(\'$\'), 9,  &__u32);}' unless defined(&PERF_EVENT_IOC_PAUSE_OUTPUT);
    eval 'sub PERF_EVENT_IOC_QUERY_BPF () { &_IOWR(ord(\'$\'), 10, \'struct perf_event_query_bpf\' *);}' unless defined(&PERF_EVENT_IOC_QUERY_BPF);
    eval 'sub PERF_EVENT_IOC_MODIFY_ATTRIBUTES () { &_IOW(ord(\'$\'), 11, \'struct perf_event_attr\' *);}' unless defined(&PERF_EVENT_IOC_MODIFY_ATTRIBUTES);
    eval("sub PERF_IOC_FLAG_GROUP () { 1U<<0; }") unless defined(&PERF_IOC_FLAG_GROUP);
    eval 'sub PERF_RECORD_MISC_CPUMODE_MASK () {(7<< 0);}' unless defined(&PERF_RECORD_MISC_CPUMODE_MASK);
    eval 'sub PERF_RECORD_MISC_CPUMODE_UNKNOWN () {(0<< 0);}' unless defined(&PERF_RECORD_MISC_CPUMODE_UNKNOWN);
    eval 'sub PERF_RECORD_MISC_KERNEL () {(1<< 0);}' unless defined(&PERF_RECORD_MISC_KERNEL);
    eval 'sub PERF_RECORD_MISC_USER () {(2<< 0);}' unless defined(&PERF_RECORD_MISC_USER);
    eval 'sub PERF_RECORD_MISC_HYPERVISOR () {(3<< 0);}' unless defined(&PERF_RECORD_MISC_HYPERVISOR);
    eval 'sub PERF_RECORD_MISC_GUEST_KERNEL () {(4<< 0);}' unless defined(&PERF_RECORD_MISC_GUEST_KERNEL);
    eval 'sub PERF_RECORD_MISC_GUEST_USER () {(5<< 0);}' unless defined(&PERF_RECORD_MISC_GUEST_USER);
    eval 'sub PERF_RECORD_MISC_PROC_MAP_PARSE_TIMEOUT () {(1<< 12);}' unless defined(&PERF_RECORD_MISC_PROC_MAP_PARSE_TIMEOUT);
    eval 'sub PERF_RECORD_MISC_MMAP_DATA () {(1<< 13);}' unless defined(&PERF_RECORD_MISC_MMAP_DATA);
    eval 'sub PERF_RECORD_MISC_COMM_EXEC () {(1<< 13);}' unless defined(&PERF_RECORD_MISC_COMM_EXEC);
    eval 'sub PERF_RECORD_MISC_FORK_EXEC () {(1<< 13);}' unless defined(&PERF_RECORD_MISC_FORK_EXEC);
    eval 'sub PERF_RECORD_MISC_SWITCH_OUT () {(1<< 13);}' unless defined(&PERF_RECORD_MISC_SWITCH_OUT);
    eval 'sub PERF_RECORD_MISC_EXACT_IP () {(1<< 14);}' unless defined(&PERF_RECORD_MISC_EXACT_IP);
    eval 'sub PERF_RECORD_MISC_SWITCH_OUT_PREEMPT () {(1<< 14);}' unless defined(&PERF_RECORD_MISC_SWITCH_OUT_PREEMPT);
    eval 'sub PERF_RECORD_MISC_EXT_RESERVED () {(1<< 15);}' unless defined(&PERF_RECORD_MISC_EXT_RESERVED);
    eval("sub NET_NS_INDEX () { 0; }") unless defined(&NET_NS_INDEX);
    eval("sub UTS_NS_INDEX () { 1; }") unless defined(&UTS_NS_INDEX);
    eval("sub IPC_NS_INDEX () { 2; }") unless defined(&IPC_NS_INDEX);
    eval("sub PID_NS_INDEX () { 3; }") unless defined(&PID_NS_INDEX);
    eval("sub USER_NS_INDEX () { 4; }") unless defined(&USER_NS_INDEX);
    eval("sub MNT_NS_INDEX () { 5; }") unless defined(&MNT_NS_INDEX);
    eval("sub CGROUP_NS_INDEX () { 6; }") unless defined(&CGROUP_NS_INDEX);
    eval("sub NR_NAMESPACES () { 7; }") unless defined(&NR_NAMESPACES);
    eval("sub PERF_RECORD_MMAP () { 1; }") unless defined(&PERF_RECORD_MMAP);
    eval("sub PERF_RECORD_LOST () { 2; }") unless defined(&PERF_RECORD_LOST);
    eval("sub PERF_RECORD_COMM () { 3; }") unless defined(&PERF_RECORD_COMM);
    eval("sub PERF_RECORD_EXIT () { 4; }") unless defined(&PERF_RECORD_EXIT);
    eval("sub PERF_RECORD_THROTTLE () { 5; }") unless defined(&PERF_RECORD_THROTTLE);
    eval("sub PERF_RECORD_UNTHROTTLE () { 6; }") unless defined(&PERF_RECORD_UNTHROTTLE);
    eval("sub PERF_RECORD_FORK () { 7; }") unless defined(&PERF_RECORD_FORK);
    eval("sub PERF_RECORD_READ () { 8; }") unless defined(&PERF_RECORD_READ);
    eval("sub PERF_RECORD_SAMPLE () { 9; }") unless defined(&PERF_RECORD_SAMPLE);
    eval("sub PERF_RECORD_MMAP2 () { 10; }") unless defined(&PERF_RECORD_MMAP2);
    eval("sub PERF_RECORD_AUX () { 11; }") unless defined(&PERF_RECORD_AUX);
    eval("sub PERF_RECORD_ITRACE_START () { 12; }") unless defined(&PERF_RECORD_ITRACE_START);
    eval("sub PERF_RECORD_LOST_SAMPLES () { 13; }") unless defined(&PERF_RECORD_LOST_SAMPLES);
    eval("sub PERF_RECORD_SWITCH () { 14; }") unless defined(&PERF_RECORD_SWITCH);
    eval("sub PERF_RECORD_SWITCH_CPU_WIDE () { 15; }") unless defined(&PERF_RECORD_SWITCH_CPU_WIDE);
    eval("sub PERF_RECORD_NAMESPACES () { 16; }") unless defined(&PERF_RECORD_NAMESPACES);
    eval("sub PERF_RECORD_KSYMBOL () { 17; }") unless defined(&PERF_RECORD_KSYMBOL);
    eval("sub PERF_RECORD_BPF_EVENT () { 18; }") unless defined(&PERF_RECORD_BPF_EVENT);
    eval("sub PERF_RECORD_CGROUP () { 19; }") unless defined(&PERF_RECORD_CGROUP);
    eval("sub PERF_RECORD_TEXT_POKE () { 20; }") unless defined(&PERF_RECORD_TEXT_POKE);
    eval("sub PERF_RECORD_MAX () { 21; }") unless defined(&PERF_RECORD_MAX);
    eval("sub PERF_RECORD_KSYMBOL_TYPE_UNKNOWN () { 0; }") unless defined(&PERF_RECORD_KSYMBOL_TYPE_UNKNOWN);
    eval("sub PERF_RECORD_KSYMBOL_TYPE_BPF () { 1; }") unless defined(&PERF_RECORD_KSYMBOL_TYPE_BPF);
    eval("sub PERF_RECORD_KSYMBOL_TYPE_OOL () { 2; }") unless defined(&PERF_RECORD_KSYMBOL_TYPE_OOL);
    eval("sub PERF_RECORD_KSYMBOL_TYPE_MAX () { 3; }") unless defined(&PERF_RECORD_KSYMBOL_TYPE_MAX);
    eval 'sub PERF_RECORD_KSYMBOL_FLAGS_UNREGISTER () {(1<< 0);}' unless defined(&PERF_RECORD_KSYMBOL_FLAGS_UNREGISTER);
    eval("sub PERF_BPF_EVENT_UNKNOWN () { 0; }") unless defined(&PERF_BPF_EVENT_UNKNOWN);
    eval("sub PERF_BPF_EVENT_PROG_LOAD () { 1; }") unless defined(&PERF_BPF_EVENT_PROG_LOAD);
    eval("sub PERF_BPF_EVENT_PROG_UNLOAD () { 2; }") unless defined(&PERF_BPF_EVENT_PROG_UNLOAD);
    eval("sub PERF_BPF_EVENT_MAX () { 3; }") unless defined(&PERF_BPF_EVENT_MAX);
    eval 'sub PERF_MAX_STACK_DEPTH () {127;}' unless defined(&PERF_MAX_STACK_DEPTH);
    eval 'sub PERF_MAX_CONTEXTS_PER_STACK () {8;}' unless defined(&PERF_MAX_CONTEXTS_PER_STACK);
    eval("sub PERF_CONTEXT_HV () { (__u64)-32; }") unless defined(&PERF_CONTEXT_HV);
    eval("sub PERF_CONTEXT_KERNEL () { (__u64)-128; }") unless defined(&PERF_CONTEXT_KERNEL);
    eval("sub PERF_CONTEXT_USER () { (__u64)-512; }") unless defined(&PERF_CONTEXT_USER);
    eval("sub PERF_CONTEXT_GUEST () { (__u64)-2048; }") unless defined(&PERF_CONTEXT_GUEST);
    eval("sub PERF_CONTEXT_GUEST_KERNEL () { (__u64)-2176; }") unless defined(&PERF_CONTEXT_GUEST_KERNEL);
    eval("sub PERF_CONTEXT_GUEST_USER () { (__u64)-2560; }") unless defined(&PERF_CONTEXT_GUEST_USER);
    eval("sub PERF_CONTEXT_MAX () { (__u64)-4095; }") unless defined(&PERF_CONTEXT_MAX);
    eval 'sub PERF_AUX_FLAG_TRUNCATED () {0x1;}' unless defined(&PERF_AUX_FLAG_TRUNCATED);
    eval 'sub PERF_AUX_FLAG_OVERWRITE () {0x2;}' unless defined(&PERF_AUX_FLAG_OVERWRITE);
    eval 'sub PERF_AUX_FLAG_PARTIAL () {0x4;}' unless defined(&PERF_AUX_FLAG_PARTIAL);
    eval 'sub PERF_AUX_FLAG_COLLISION () {0x8;}' unless defined(&PERF_AUX_FLAG_COLLISION);
    eval 'sub PERF_FLAG_FD_NO_GROUP () {(1 << 0);}' unless defined(&PERF_FLAG_FD_NO_GROUP);
    eval 'sub PERF_FLAG_FD_OUTPUT () {(1 << 1);}' unless defined(&PERF_FLAG_FD_OUTPUT);
    eval 'sub PERF_FLAG_PID_CGROUP () {(1 << 2);}' unless defined(&PERF_FLAG_PID_CGROUP);
    eval 'sub PERF_FLAG_FD_CLOEXEC () {(1 << 3);}' unless defined(&PERF_FLAG_FD_CLOEXEC);
    if(defined(&__LITTLE_ENDIAN_BITFIELD)) {
    }
 elsif(defined(&__BIG_ENDIAN_BITFIELD)) {
    } else {
	die("Unknown endianness");
    }
    eval 'sub PERF_MEM_OP_NA () {0x1;}' unless defined(&PERF_MEM_OP_NA);
    eval 'sub PERF_MEM_OP_LOAD () {0x2;}' unless defined(&PERF_MEM_OP_LOAD);
    eval 'sub PERF_MEM_OP_STORE () {0x4;}' unless defined(&PERF_MEM_OP_STORE);
    eval 'sub PERF_MEM_OP_PFETCH () {0x8;}' unless defined(&PERF_MEM_OP_PFETCH);
    eval 'sub PERF_MEM_OP_EXEC () {0x10;}' unless defined(&PERF_MEM_OP_EXEC);
    eval 'sub PERF_MEM_OP_SHIFT () {0;}' unless defined(&PERF_MEM_OP_SHIFT);
    eval 'sub PERF_MEM_LVL_NA () {0x1;}' unless defined(&PERF_MEM_LVL_NA);
    eval 'sub PERF_MEM_LVL_HIT () {0x2;}' unless defined(&PERF_MEM_LVL_HIT);
    eval 'sub PERF_MEM_LVL_MISS () {0x4;}' unless defined(&PERF_MEM_LVL_MISS);
    eval 'sub PERF_MEM_LVL_L1 () {0x8;}' unless defined(&PERF_MEM_LVL_L1);
    eval 'sub PERF_MEM_LVL_LFB () {0x10;}' unless defined(&PERF_MEM_LVL_LFB);
    eval 'sub PERF_MEM_LVL_L2 () {0x20;}' unless defined(&PERF_MEM_LVL_L2);
    eval 'sub PERF_MEM_LVL_L3 () {0x40;}' unless defined(&PERF_MEM_LVL_L3);
    eval 'sub PERF_MEM_LVL_LOC_RAM () {0x80;}' unless defined(&PERF_MEM_LVL_LOC_RAM);
    eval 'sub PERF_MEM_LVL_REM_RAM1 () {0x100;}' unless defined(&PERF_MEM_LVL_REM_RAM1);
    eval 'sub PERF_MEM_LVL_REM_RAM2 () {0x200;}' unless defined(&PERF_MEM_LVL_REM_RAM2);
    eval 'sub PERF_MEM_LVL_REM_CCE1 () {0x400;}' unless defined(&PERF_MEM_LVL_REM_CCE1);
    eval 'sub PERF_MEM_LVL_REM_CCE2 () {0x800;}' unless defined(&PERF_MEM_LVL_REM_CCE2);
    eval 'sub PERF_MEM_LVL_IO () {0x1000;}' unless defined(&PERF_MEM_LVL_IO);
    eval 'sub PERF_MEM_LVL_UNC () {0x2000;}' unless defined(&PERF_MEM_LVL_UNC);
    eval 'sub PERF_MEM_LVL_SHIFT () {5;}' unless defined(&PERF_MEM_LVL_SHIFT);
    eval 'sub PERF_MEM_REMOTE_REMOTE () {0x1;}' unless defined(&PERF_MEM_REMOTE_REMOTE);
    eval 'sub PERF_MEM_REMOTE_SHIFT () {37;}' unless defined(&PERF_MEM_REMOTE_SHIFT);
    eval 'sub PERF_MEM_LVLNUM_L1 () {0x1;}' unless defined(&PERF_MEM_LVLNUM_L1);
    eval 'sub PERF_MEM_LVLNUM_L2 () {0x2;}' unless defined(&PERF_MEM_LVLNUM_L2);
    eval 'sub PERF_MEM_LVLNUM_L3 () {0x3;}' unless defined(&PERF_MEM_LVLNUM_L3);
    eval 'sub PERF_MEM_LVLNUM_L4 () {0x4;}' unless defined(&PERF_MEM_LVLNUM_L4);
    eval 'sub PERF_MEM_LVLNUM_ANY_CACHE () {0xb;}' unless defined(&PERF_MEM_LVLNUM_ANY_CACHE);
    eval 'sub PERF_MEM_LVLNUM_LFB () {0xc;}' unless defined(&PERF_MEM_LVLNUM_LFB);
    eval 'sub PERF_MEM_LVLNUM_RAM () {0xd;}' unless defined(&PERF_MEM_LVLNUM_RAM);
    eval 'sub PERF_MEM_LVLNUM_PMEM () {0xe;}' unless defined(&PERF_MEM_LVLNUM_PMEM);
    eval 'sub PERF_MEM_LVLNUM_NA () {0xf;}' unless defined(&PERF_MEM_LVLNUM_NA);
    eval 'sub PERF_MEM_LVLNUM_SHIFT () {33;}' unless defined(&PERF_MEM_LVLNUM_SHIFT);
    eval 'sub PERF_MEM_SNOOP_NA () {0x1;}' unless defined(&PERF_MEM_SNOOP_NA);
    eval 'sub PERF_MEM_SNOOP_NONE () {0x2;}' unless defined(&PERF_MEM_SNOOP_NONE);
    eval 'sub PERF_MEM_SNOOP_HIT () {0x4;}' unless defined(&PERF_MEM_SNOOP_HIT);
    eval 'sub PERF_MEM_SNOOP_MISS () {0x8;}' unless defined(&PERF_MEM_SNOOP_MISS);
    eval 'sub PERF_MEM_SNOOP_HITM () {0x10;}' unless defined(&PERF_MEM_SNOOP_HITM);
    eval 'sub PERF_MEM_SNOOP_SHIFT () {19;}' unless defined(&PERF_MEM_SNOOP_SHIFT);
    eval 'sub PERF_MEM_SNOOPX_FWD () {0x1;}' unless defined(&PERF_MEM_SNOOPX_FWD);
    eval 'sub PERF_MEM_SNOOPX_SHIFT () {37;}' unless defined(&PERF_MEM_SNOOPX_SHIFT);
    eval 'sub PERF_MEM_LOCK_NA () {0x1;}' unless defined(&PERF_MEM_LOCK_NA);
    eval 'sub PERF_MEM_LOCK_LOCKED () {0x2;}' unless defined(&PERF_MEM_LOCK_LOCKED);
    eval 'sub PERF_MEM_LOCK_SHIFT () {24;}' unless defined(&PERF_MEM_LOCK_SHIFT);
    eval 'sub PERF_MEM_TLB_NA () {0x1;}' unless defined(&PERF_MEM_TLB_NA);
    eval 'sub PERF_MEM_TLB_HIT () {0x2;}' unless defined(&PERF_MEM_TLB_HIT);
    eval 'sub PERF_MEM_TLB_MISS () {0x4;}' unless defined(&PERF_MEM_TLB_MISS);
    eval 'sub PERF_MEM_TLB_L1 () {0x8;}' unless defined(&PERF_MEM_TLB_L1);
    eval 'sub PERF_MEM_TLB_L2 () {0x10;}' unless defined(&PERF_MEM_TLB_L2);
    eval 'sub PERF_MEM_TLB_WK () {0x20;}' unless defined(&PERF_MEM_TLB_WK);
    eval 'sub PERF_MEM_TLB_OS () {0x40;}' unless defined(&PERF_MEM_TLB_OS);
    eval 'sub PERF_MEM_TLB_SHIFT () {26;}' unless defined(&PERF_MEM_TLB_SHIFT);
    eval 'sub PERF_MEM_S {
        my($a, $s) = @_;
	    eval q(((( &__u64) &PERF_MEM_$a &_$s) <<  &PERF_MEM_$a &_SHIFT));
    }' unless defined(&PERF_MEM_S);
}
1;
