require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_LINUX_SECCOMP_H)) {
    eval 'sub _LINUX_SECCOMP_H () {1;}' unless defined(&_LINUX_SECCOMP_H);
    require 'linux/types.ph';
    eval 'sub SECCOMP_MODE_DISABLED () {0;}' unless defined(&SECCOMP_MODE_DISABLED);
    eval 'sub SECCOMP_MODE_STRICT () {1;}' unless defined(&SECCOMP_MODE_STRICT);
    eval 'sub SECCOMP_MODE_FILTER () {2;}' unless defined(&SECCOMP_MODE_FILTER);
    eval 'sub SECCOMP_SET_MODE_STRICT () {0;}' unless defined(&SECCOMP_SET_MODE_STRICT);
    eval 'sub SECCOMP_SET_MODE_FILTER () {1;}' unless defined(&SECCOMP_SET_MODE_FILTER);
    eval 'sub SECCOMP_GET_ACTION_AVAIL () {2;}' unless defined(&SECCOMP_GET_ACTION_AVAIL);
    eval 'sub SECCOMP_GET_NOTIF_SIZES () {3;}' unless defined(&SECCOMP_GET_NOTIF_SIZES);
    eval 'sub SECCOMP_FILTER_FLAG_TSYNC () {(1 << 0);}' unless defined(&SECCOMP_FILTER_FLAG_TSYNC);
    eval 'sub SECCOMP_FILTER_FLAG_LOG () {(1 << 1);}' unless defined(&SECCOMP_FILTER_FLAG_LOG);
    eval 'sub SECCOMP_FILTER_FLAG_SPEC_ALLOW () {(1 << 2);}' unless defined(&SECCOMP_FILTER_FLAG_SPEC_ALLOW);
    eval 'sub SECCOMP_FILTER_FLAG_NEW_LISTENER () {(1 << 3);}' unless defined(&SECCOMP_FILTER_FLAG_NEW_LISTENER);
    eval 'sub SECCOMP_FILTER_FLAG_TSYNC_ESRCH () {(1 << 4);}' unless defined(&SECCOMP_FILTER_FLAG_TSYNC_ESRCH);
    eval 'sub SECCOMP_RET_KILL_PROCESS () {0x80000000;}' unless defined(&SECCOMP_RET_KILL_PROCESS);
    eval 'sub SECCOMP_RET_KILL_THREAD () {0x;}' unless defined(&SECCOMP_RET_KILL_THREAD);
    eval 'sub SECCOMP_RET_KILL () { &SECCOMP_RET_KILL_THREAD;}' unless defined(&SECCOMP_RET_KILL);
    eval 'sub SECCOMP_RET_TRAP () {0x30000;}' unless defined(&SECCOMP_RET_TRAP);
    eval 'sub SECCOMP_RET_ERRNO () {0x50000;}' unless defined(&SECCOMP_RET_ERRNO);
    eval 'sub SECCOMP_RET_USER_NOTIF () {0x7fc00000;}' unless defined(&SECCOMP_RET_USER_NOTIF);
    eval 'sub SECCOMP_RET_TRACE () {0x7ff00000;}' unless defined(&SECCOMP_RET_TRACE);
    eval 'sub SECCOMP_RET_LOG () {0x7ffc0000;}' unless defined(&SECCOMP_RET_LOG);
    eval 'sub SECCOMP_RET_ALLOW () {0x7fff0000;}' unless defined(&SECCOMP_RET_ALLOW);
    eval 'sub SECCOMP_RET_ACTION_FULL () {0xffff0000;}' unless defined(&SECCOMP_RET_ACTION_FULL);
    eval 'sub SECCOMP_RET_ACTION () {0x7fff0000;}' unless defined(&SECCOMP_RET_ACTION);
    eval 'sub SECCOMP_RET_DATA () {0xffff;}' unless defined(&SECCOMP_RET_DATA);
    eval 'sub SECCOMP_USER_NOTIF_FLAG_CONTINUE () {(1 << 0);}' unless defined(&SECCOMP_USER_NOTIF_FLAG_CONTINUE);
    eval 'sub SECCOMP_ADDFD_FLAG_SETFD () {(1 << 0);}' unless defined(&SECCOMP_ADDFD_FLAG_SETFD);
    eval 'sub SECCOMP_IOC_MAGIC () {ord(\'!\');}' unless defined(&SECCOMP_IOC_MAGIC);
    eval 'sub SECCOMP_IO {
        my($nr) = @_;
	    eval q( &_IO( &SECCOMP_IOC_MAGIC, $nr));
    }' unless defined(&SECCOMP_IO);
    eval 'sub SECCOMP_IOR {
        my($nr, $type) = @_;
	    eval q( &_IOR( &SECCOMP_IOC_MAGIC, $nr, $type));
    }' unless defined(&SECCOMP_IOR);
    eval 'sub SECCOMP_IOW {
        my($nr, $type) = @_;
	    eval q( &_IOW( &SECCOMP_IOC_MAGIC, $nr, $type));
    }' unless defined(&SECCOMP_IOW);
    eval 'sub SECCOMP_IOWR {
        my($nr, $type) = @_;
	    eval q( &_IOWR( &SECCOMP_IOC_MAGIC, $nr, $type));
    }' unless defined(&SECCOMP_IOWR);
    eval 'sub SECCOMP_IOCTL_NOTIF_RECV () { &SECCOMP_IOWR(0, \'struct seccomp_notif\');}' unless defined(&SECCOMP_IOCTL_NOTIF_RECV);
    eval 'sub SECCOMP_IOCTL_NOTIF_SEND () { &SECCOMP_IOWR(1, \'struct seccomp_notif_resp\');}' unless defined(&SECCOMP_IOCTL_NOTIF_SEND);
    eval 'sub SECCOMP_IOCTL_NOTIF_ID_VALID () { &SECCOMP_IOW(2,  &__u64);}' unless defined(&SECCOMP_IOCTL_NOTIF_ID_VALID);
    eval 'sub SECCOMP_IOCTL_NOTIF_ADDFD () { &SECCOMP_IOW(3, \'struct seccomp_notif_addfd\');}' unless defined(&SECCOMP_IOCTL_NOTIF_ADDFD);
}
1;
